/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Authorizer;
import SQLite.Blob;
import SQLite.BusyHandler;
import SQLite.Callback;
import SQLite.Exception;
import SQLite.Function;
import SQLite.FunctionContext;
import SQLite.ProgressHandler;
import SQLite.Stmt;
import SQLite.TableResult;
import SQLite.Trace;
import SQLite.Vm;
import java.io.File;
import java.lang.reflect.Method;

public class Database {
    protected long handle = 0L;
    protected int error_code = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String filename, int mode) throws Exception {
        if ((mode & 0x80) != 0) {
            mode = 6;
        } else if ((mode & 0x100) != 0) {
            mode = 1;
        }
        Database database = this;
        synchronized (database) {
            try {
                this._open4(filename, mode, null, false);
            }
            catch (Exception se) {
                throw se;
            }
            catch (OutOfMemoryError me) {
                throw me;
            }
            catch (Throwable t) {
                this._open(filename, mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String filename, int mode, String vfs) throws Exception {
        if ((mode & 0x80) != 0) {
            mode = 6;
        } else if ((mode & 0x100) != 0) {
            mode = 1;
        }
        Database database = this;
        synchronized (database) {
            try {
                this._open4(filename, mode, vfs, false);
            }
            catch (Exception se) {
                throw se;
            }
            catch (OutOfMemoryError me) {
                throw me;
            }
            catch (Throwable t) {
                this._open(filename, mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String filename, int mode, String vfs, boolean ver2) throws Exception {
        if ((mode & 0x80) != 0) {
            mode = 6;
        } else if ((mode & 0x100) != 0) {
            mode = 1;
        }
        Database database = this;
        synchronized (database) {
            try {
                this._open4(filename, mode, vfs, ver2);
            }
            catch (Exception se) {
                throw se;
            }
            catch (OutOfMemoryError me) {
                throw me;
            }
            catch (Throwable t) {
                this._open(filename, mode);
            }
        }
    }

    private native void _open(String var1, int var2) throws Exception;

    private native void _open4(String var1, int var2, String var3, boolean var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open_aux_file(String filename) throws Exception {
        Database database = this;
        synchronized (database) {
            this._open_aux_file(filename);
        }
    }

    private native void _open_aux_file(String var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Database database = this;
        synchronized (database) {
            this._finalize();
        }
    }

    private native void _finalize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Database database = this;
        synchronized (database) {
            this._close();
        }
    }

    private native void _close() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String sql, Callback cb) throws Exception {
        Database database = this;
        synchronized (database) {
            this._exec(sql, cb);
        }
    }

    private native void _exec(String var1, Callback var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(String sql, Callback cb, String[] args) throws Exception {
        Database database = this;
        synchronized (database) {
            this._exec(sql, cb, args);
        }
    }

    private native void _exec(String var1, Callback var2, String[] var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long last_insert_rowid() {
        Database database = this;
        synchronized (database) {
            return this._last_insert_rowid();
        }
    }

    private native long _last_insert_rowid();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Database database = this;
        synchronized (database) {
            this._interrupt();
        }
    }

    private native void _interrupt();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long changes() {
        Database database = this;
        synchronized (database) {
            return this._changes();
        }
    }

    private native long _changes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void busy_handler(BusyHandler bh) {
        Database database = this;
        synchronized (database) {
            this._busy_handler(bh);
        }
    }

    private native void _busy_handler(BusyHandler var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void busy_timeout(int ms) {
        Database database = this;
        synchronized (database) {
            this._busy_timeout(ms);
        }
    }

    private native void _busy_timeout(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableResult get_table(String sql, int maxrows) throws Exception {
        TableResult ret = new TableResult(maxrows);
        if (!this.is3()) {
            try {
                this.exec(sql, ret);
                return ret;
            }
            catch (Exception e) {
                if (maxrows > 0 && ret.atmaxrows) return ret;
                throw e;
            }
        }
        Database database = this;
        synchronized (database) {
            Vm vm = this.compile(sql);
            this.set_last_error(vm.error_code);
            if (ret.maxrows > 0) {
                while (ret.nrows < ret.maxrows && vm.step(ret)) {
                    this.set_last_error(vm.error_code);
                }
            } else {
                while (vm.step(ret)) {
                    this.set_last_error(vm.error_code);
                }
            }
            vm.finalize();
            return ret;
        }
    }

    public TableResult get_table(String sql) throws Exception {
        return this.get_table(sql, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableResult get_table(String sql, int maxrows, String[] args) throws Exception {
        TableResult ret = new TableResult(maxrows);
        if (!this.is3()) {
            try {
                this.exec(sql, ret, args);
                return ret;
            }
            catch (Exception e) {
                if (maxrows > 0 && ret.atmaxrows) return ret;
                throw e;
            }
        }
        Database database = this;
        synchronized (database) {
            Vm vm = this.compile(sql, args);
            this.set_last_error(vm.error_code);
            if (ret.maxrows > 0) {
                while (ret.nrows < ret.maxrows && vm.step(ret)) {
                    this.set_last_error(vm.error_code);
                }
            } else {
                while (vm.step(ret)) {
                    this.set_last_error(vm.error_code);
                }
            }
            vm.finalize();
            return ret;
        }
    }

    public TableResult get_table(String sql, String[] args) throws Exception {
        return this.get_table(sql, 0, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void get_table(String sql, String[] args, TableResult tbl) throws Exception {
        tbl.clear();
        if (!this.is3()) {
            try {
                this.exec(sql, tbl, args);
                return;
            }
            catch (Exception e) {
                if (tbl.maxrows > 0 && tbl.atmaxrows) return;
                throw e;
            }
        }
        Database database = this;
        synchronized (database) {
            Vm vm = this.compile(sql, args);
            if (tbl.maxrows > 0) {
                while (tbl.nrows < tbl.maxrows && vm.step(tbl)) {
                    this.set_last_error(vm.error_code);
                }
            } else {
                while (vm.step(tbl)) {
                    this.set_last_error(vm.error_code);
                }
            }
            vm.finalize();
            return;
        }
    }

    public static synchronized boolean complete(String sql) {
        return Database._complete(sql);
    }

    private static native boolean _complete(String var0);

    public static native String version();

    public native String dbversion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_function(String name, int nargs, Function f) {
        Database database = this;
        synchronized (database) {
            this._create_function(name, nargs, f);
        }
    }

    private native void _create_function(String var1, int var2, Function var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create_aggregate(String name, int nargs, Function f) {
        Database database = this;
        synchronized (database) {
            this._create_aggregate(name, nargs, f);
        }
    }

    private native void _create_aggregate(String var1, int var2, Function var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void function_type(String name, int type) {
        Database database = this;
        synchronized (database) {
            this._function_type(name, type);
        }
    }

    private native void _function_type(String var1, int var2);

    public int last_error() {
        return this.error_code;
    }

    protected void set_last_error(int error_code) {
        this.error_code = error_code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String error_message() {
        Database database = this;
        synchronized (database) {
            return this._errmsg();
        }
    }

    private native String _errmsg();

    public static native String error_string(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_encoding(String enc) throws Exception {
        Database database = this;
        synchronized (database) {
            this._set_encoding(enc);
        }
    }

    private native void _set_encoding(String var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_authorizer(Authorizer auth) {
        Database database = this;
        synchronized (database) {
            this._set_authorizer(auth);
        }
    }

    private native void _set_authorizer(Authorizer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Trace tr) {
        Database database = this;
        synchronized (database) {
            this._trace(tr);
        }
    }

    private native void _trace(Trace var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vm compile(String sql) throws Exception {
        Database database = this;
        synchronized (database) {
            Vm vm = new Vm();
            this.vm_compile(sql, vm);
            return vm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vm compile(String sql, String[] args) throws Exception {
        Database database = this;
        synchronized (database) {
            Vm vm = new Vm();
            this.vm_compile_args(sql, vm, args);
            return vm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stmt prepare(String sql) throws Exception {
        Database database = this;
        synchronized (database) {
            Stmt stmt = new Stmt();
            this.stmt_prepare(sql, stmt);
            return stmt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob open_blob(String db, String table, String column, long row, boolean rw) throws Exception {
        Database database = this;
        synchronized (database) {
            Blob blob = new Blob();
            this._open_blob(db, table, column, row, rw, blob);
            return blob;
        }
    }

    public native boolean is3();

    private native void vm_compile(String var1, Vm var2) throws Exception;

    private native void vm_compile_args(String var1, Vm var2, String[] var3) throws Exception;

    private native void stmt_prepare(String var1, Stmt var2) throws Exception;

    private native void _open_blob(String var1, String var2, String var3, long var4, boolean var6, Blob var7) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progress_handler(int n, ProgressHandler p) {
        Database database = this;
        synchronized (database) {
            this._progress_handler(n, p);
        }
    }

    private native void _progress_handler(int var1, ProgressHandler var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void key(byte[] ekey) throws Exception {
        Database database = this;
        synchronized (database) {
            this._key(ekey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void key(String skey) throws Exception {
        Database database = this;
        synchronized (database) {
            byte[] ekey = null;
            if (skey != null && skey.length() > 0) {
                ekey = new byte[skey.length()];
                for (int i = 0; i < skey.length(); ++i) {
                    char c = skey.charAt(i);
                    ekey[i] = (byte)(c & 0xFF ^ c >> 8);
                }
            }
            this._key(ekey);
        }
    }

    private native void _key(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rekey(byte[] ekey) throws Exception {
        Database database = this;
        synchronized (database) {
            this._rekey(ekey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rekey(String skey) throws Exception {
        Database database = this;
        synchronized (database) {
            byte[] ekey = null;
            if (skey != null && skey.length() > 0) {
                ekey = new byte[skey.length()];
                for (int i = 0; i < skey.length(); ++i) {
                    char c = skey.charAt(i);
                    ekey[i] = (byte)(c & 0xFF ^ c >> 8);
                }
            }
            this._rekey(ekey);
        }
    }

    private native void _rekey(byte[] var1);

    protected static native boolean _enable_shared_cache(boolean var0);

    private static native void internal_init();

    public static long long_from_julian(double d) {
        d -= 2440587.5;
        return (long)(d *= 8.64E7);
    }

    public static long long_from_julian(String s) throws Exception {
        try {
            double d = Double.valueOf(s);
            return Database.long_from_julian(d);
        }
        catch (java.lang.Exception ee) {
            throw new Exception("not a julian date");
        }
    }

    public static double julian_from_long(long ms) {
        double adj = ms < 0L ? 0.0 : 0.5;
        double d = ((double)ms + adj) / 8.64E7 + 2440587.5;
        return d;
    }

    static {
        try {
            String string = System.getProperty("SQLite.library.path");
            if (string == null || string.length() == 0) {
                System.loadLibrary("sqlite_jni");
            } else {
                try {
                    Class[] classArray = new Class[]{String.class};
                    Method method = System.class.getMethod("mapLibraryName", classArray);
                    Object[] objectArray = new Object[]{"sqlite_jni"};
                    String string2 = (String)method.invoke(null, objectArray);
                    System.load(string + File.separator + string2);
                }
                catch (Throwable throwable) {
                    System.err.println("Unable to load sqlite_jni fromSQLite.library.path=" + string + ", trying system default: " + throwable);
                    System.loadLibrary("sqlite_jni");
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Unable to load sqlite_jni: " + throwable);
        }
        try {
            Database.internal_init();
            new FunctionContext();
        }
        catch (java.lang.Exception exception) {
            // empty catch block
        }
    }
}

