/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.Database;
import SQLite.JDBC2z.BatchArg;
import SQLite.JDBC2z.JDBCConnection;
import SQLite.JDBC2z.JDBCStatement;
import SQLite.StringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;

public class JDBCPreparedStatement
extends JDBCStatement
implements PreparedStatement {
    private String sql;
    private String[] args = null;
    private boolean[] blobs = null;
    private ArrayList<BatchArg> batch = null;
    private static final boolean nullrepl = Database.version().compareTo("2.5.0") < 0;

    public JDBCPreparedStatement(JDBCConnection conn, String sql) {
        super(conn);
        this.sql = this.fixup(sql);
    }

    private String fixup(String sql) {
        StringBuffer sb = new StringBuffer();
        boolean inq = false;
        int nparm = 0;
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '\'') {
                if (inq) {
                    char nextChar = '\u0000';
                    if (i + 1 < sql.length()) {
                        nextChar = sql.charAt(i + 1);
                    }
                    if (nextChar == '\'') {
                        sb.append(c);
                        sb.append(nextChar);
                        ++i;
                        continue;
                    }
                    inq = false;
                    sb.append(c);
                    continue;
                }
                inq = true;
                sb.append(c);
                continue;
            }
            if (c == '?') {
                if (inq) {
                    sb.append(c);
                    continue;
                }
                ++nparm;
                sb.append(nullrepl ? "'%q'" : "%Q");
                continue;
            }
            if (c == ';') {
                if (!inq) break;
                sb.append(c);
                continue;
            }
            if (c == '%') {
                sb.append("%%");
                continue;
            }
            sb.append(c);
        }
        this.args = new String[nparm];
        this.blobs = new boolean[nparm];
        try {
            this.clearParameters();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return sb.toString();
    }

    private String fixup2(String sql) {
        if (!this.conn.db.is3()) {
            return sql;
        }
        StringBuffer sb = new StringBuffer();
        int parm = -1;
        for (int i = 0; i < sql.length(); ++i) {
            int c = sql.charAt(i);
            if (c == 37) {
                sb.append((char)c);
                c = sql.charAt(++i);
                if (c == 81 && this.blobs[++parm]) {
                    c = 115;
                }
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.fixup2(this.sql), this.args, false);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeQuery(this.fixup2(this.sql), this.args, true);
        return this.updcnt;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = nullrepl ? "" : null;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = x ? "1" : "0";
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = "" + x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = "" + x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = "" + x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = "" + x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = "" + x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = "" + x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = x == null ? (nullrepl ? "" : null) : "" + x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = x == null ? (nullrepl ? "" : null) : x;
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.blobs[parameterIndex - 1] = false;
        if (x == null) {
            this.args[parameterIndex - 1] = nullrepl ? "" : null;
        } else if (this.conn.db.is3()) {
            this.args[parameterIndex - 1] = StringEncoder.encodeX(x);
            this.blobs[parameterIndex - 1] = true;
        } else {
            this.args[parameterIndex - 1] = StringEncoder.encode(x);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = x == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(x.getTime())) : x.toString());
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = x == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(x.getTime())) : x.toString());
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        this.args[parameterIndex - 1] = x == null ? (nullrepl ? "" : null) : (this.conn.useJulian ? Double.toString(Database.julian_from_long(x.getTime())) : x.toString());
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            byte[] data = new byte[length];
            x.read(data, 0, length);
            this.setBytes(parameterIndex, data);
        }
        catch (IOException e) {
            throw new SQLException("I/O failed");
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = nullrepl ? "" : null;
            this.blobs[i] = false;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (x == null) {
            this.args[parameterIndex - 1] = nullrepl ? "" : null;
        } else if (x instanceof byte[]) {
            byte[] bx = (byte[])x;
            if (this.conn.db.is3()) {
                this.args[parameterIndex - 1] = StringEncoder.encodeX(bx);
                this.blobs[parameterIndex - 1] = true;
                return;
            }
            this.args[parameterIndex - 1] = StringEncoder.encode(bx);
        } else {
            this.args[parameterIndex - 1] = x.toString();
        }
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (x == null) {
            this.args[parameterIndex - 1] = nullrepl ? "" : null;
        } else if (x instanceof byte[]) {
            byte[] bx = (byte[])x;
            if (this.conn.db.is3()) {
                this.args[parameterIndex - 1] = StringEncoder.encodeX(bx);
                this.blobs[parameterIndex - 1] = true;
                return;
            }
            this.args[parameterIndex - 1] = StringEncoder.encode(bx);
        } else {
            this.args[parameterIndex - 1] = x.toString();
        }
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.args.length) {
            throw new SQLException("bad parameter index");
        }
        if (x == null) {
            this.args[parameterIndex - 1] = nullrepl ? "" : null;
        } else if (x instanceof byte[]) {
            byte[] bx = (byte[])x;
            if (this.conn.db.is3()) {
                this.args[parameterIndex - 1] = StringEncoder.encodeX(bx);
                this.blobs[parameterIndex - 1] = true;
                return;
            }
            this.args[parameterIndex - 1] = StringEncoder.encode(bx);
        } else {
            this.args[parameterIndex - 1] = x.toString();
        }
        this.blobs[parameterIndex - 1] = false;
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeQuery(this.fixup2(this.sql), this.args, false) != null;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList(this.args.length);
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.batch.add(new BatchArg(this.args[i], this.blobs[i]));
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] ret = new int[this.batch.size() / this.args.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = -3;
        }
        int errs = 0;
        int index = 0;
        for (int i = 0; i < ret.length; ++i) {
            for (int k = 0; k < this.args.length; ++k) {
                BatchArg b = this.batch.get(index++);
                this.args[k] = b.arg;
                this.blobs[k] = b.blob;
            }
            try {
                ret[i] = this.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                ++errs;
            }
        }
        if (errs > 0) {
            throw new BatchUpdateException("batch failed", ret);
        }
        return ret;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.clear();
            this.batch = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.clearBatch();
        super.close();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            char[] data = new char[length];
            reader.read(data);
            this.setString(parameterIndex, new String(data));
        }
        catch (IOException e) {
            throw new SQLException("I/O failed");
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String parameterName, int sqlType) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw new SQLException("not supported");
    }

    public void registerOutputParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBoolean(String parameterName, boolean val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setByte(String parameterName, byte val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setShort(String parameterName, short val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setInt(String parameterName, int val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setLong(String parameterName, long val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setFloat(String parameterName, float val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDouble(String parameterName, double val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBigDecimal(String parameterName, BigDecimal val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setString(String parameterName, String val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBytes(String parameterName, byte[] val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String parameterName, Date val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String parameterName, Time val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String parameterName, Timestamp val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setAsciiStream(String parameterName, InputStream s, int length) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setBinaryStream(String parameterName, InputStream s, int length) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String parameterName, Object val, int targetSqlType, int scale) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String parameterName, Object val, int targetSqlType) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setObject(String parameterName, Object val) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setCharacterStream(String parameterName, Reader r, int length) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setDate(String parameterName, Date val, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTime(String parameterName, Time val, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setTimestamp(String parameterName, Timestamp val, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLException("not supported");
    }

    public String getString(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte getByte(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public short getShort(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public int getInt(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public long getLong(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public float getFloat(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public double getDouble(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(int parameterIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    public Array getArray(int parameterIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        throw new SQLException("not supported");
    }

    public URL getURL(String parameterName) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNString(String parameterName, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(String parameterName, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(String parameterName, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(String parameterName, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String parameterName, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xml) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setSQLXML(String parameterName, SQLXML xml) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setAsciiStream(String parameterName, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBinaryStream(String parameterName, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setCharacterStream(String parameterName, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(String parameterName, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(String parameterName, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String parameterName, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

