/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC2z.JDBCResultSetMetaData;
import SQLite.JDBC2z.JDBCStatement;
import SQLite.JDBC2z.TableResultX;
import SQLite.Shell;
import SQLite.StringEncoder;
import SQLite.TableResult;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;

public class JDBCResultSet
implements ResultSet {
    private int row;
    protected TableResult tr;
    private JDBCStatement s;
    private JDBCResultSetMetaData md;
    private String lastg;
    private int updatable;
    private String uptable;
    private String[] pkcols;
    private int[] pkcoli;
    private boolean oninsrow;
    private String[] rowbuf;
    private static final boolean nullrepl = Database.version().compareTo("2.5.0") < 0;

    public JDBCResultSet(TableResult tr, JDBCStatement s) {
        this.tr = tr;
        this.s = s;
        this.md = null;
        this.lastg = null;
        this.row = -1;
        this.updatable = -1;
        this.oninsrow = false;
        this.rowbuf = null;
    }

    public boolean isUpdatable() throws SQLException {
        if (this.updatable == -1) {
            try {
                JDBCResultSetMetaData m = (JDBCResultSetMetaData)this.getMetaData();
                HashSet<String> h = new HashSet<String>();
                String lastt = null;
                for (int i = 1; i <= this.tr.ncolumns; ++i) {
                    lastt = m.getTableName(i);
                    h.add(lastt);
                }
                if (h.size() > 1 || lastt == null) {
                    this.updatable = 0;
                    throw new SQLException("view or join");
                }
                this.updatable = 1;
                this.uptable = lastt;
                JDBCResultSet pk = (JDBCResultSet)this.s.conn.getMetaData().getPrimaryKeys(null, null, this.uptable);
                if (pk.tr.nrows > 0) {
                    boolean colnotfound = false;
                    this.pkcols = new String[pk.tr.nrows];
                    this.pkcoli = new int[pk.tr.nrows];
                    for (int i = 0; i < pk.tr.nrows; ++i) {
                        String[] rd = (String[])pk.tr.rows.elementAt(i);
                        this.pkcols[i] = rd[3];
                        try {
                            this.pkcoli[i] = this.findColumn(this.pkcols[i]) - 1;
                            continue;
                        }
                        catch (SQLException ee) {
                            colnotfound = true;
                        }
                    }
                    if (!colnotfound) {
                        this.updatable = 2;
                    }
                }
                pk.close();
            }
            catch (SQLException e) {
                this.updatable = 0;
            }
        }
        if (this.updatable < 1) {
            throw new SQLException("result set not updatable");
        }
        return true;
    }

    public void fillRowbuf() throws SQLException {
        if (this.rowbuf == null) {
            if (this.row < 0) {
                throw new SQLException("cursor outside of result set");
            }
            this.rowbuf = new String[this.tr.ncolumns];
            System.arraycopy((String[])this.tr.rows.elementAt(this.row), 0, this.rowbuf, 0, this.tr.ncolumns);
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.tr == null) {
            return false;
        }
        ++this.row;
        return this.row < this.tr.nrows;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        JDBCResultSetMetaData m = (JDBCResultSetMetaData)this.getMetaData();
        return m.findColByName(columnName);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.tr == null) {
            throw new SQLException("no rows");
        }
        return this.row + 1;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (this.row >= 0) {
            --this.row;
        }
        return this.row >= 0;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (row < 0) {
            row = this.tr.nrows + 1 + row;
        }
        if (--row < 0 || row > this.tr.nrows) {
            return false;
        }
        this.row = row;
        return true;
    }

    @Override
    public boolean relative(int row) throws SQLException {
        if (this.tr == null) {
            return false;
        }
        if (this.row + row < 0 || this.row + row >= this.tr.nrows) {
            return false;
        }
        this.row += row;
        return true;
    }

    @Override
    public void setFetchDirection(int dir) throws SQLException {
        if (dir != 1000) {
            throw new SQLException("only forward fetch direction supported");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int fsize) throws SQLException {
        if (fsize != 1) {
            throw new SQLException("fetch size must be 1");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        return this.lastg;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getString(col);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Integer i = this.internalGetInt(columnIndex);
        if (i != null) {
            return i;
        }
        return 0;
    }

    private Integer internalGetInt(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        try {
            return Integer.valueOf(this.lastg);
        }
        catch (java.lang.Exception e) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getInt(col);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getInt(columnIndex) == 1 || Boolean.valueOf(this.getString(columnIndex)) != false;
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getBoolean(col);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.md == null) {
            this.md = new JDBCResultSetMetaData(this);
        }
        return this.md;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Short sh = this.internalGetShort(columnIndex);
        if (sh != null) {
            return sh;
        }
        return 0;
    }

    private Short internalGetShort(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        try {
            return Short.valueOf(this.lastg);
        }
        catch (java.lang.Exception e) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getShort(col);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.internalGetTime(columnIndex, null);
    }

    /*
     * Loose catch block
     */
    private Time internalGetTime(int columnIndex, Calendar cal) throws SQLException {
        block8: {
            if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
                throw new SQLException("column " + columnIndex + " not found");
            }
            String[] rd = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = rd[columnIndex - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Time(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception ee) {
                return Time.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception e) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Time.valueOf(this.lastg);
        }
        catch (java.lang.Exception ee) {
            return new Time(Database.long_from_julian(this.lastg));
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getTime(col);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.internalGetTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getTime(col, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.internalGetTimestamp(columnIndex, null);
    }

    /*
     * Loose catch block
     */
    private Timestamp internalGetTimestamp(int columnIndex, Calendar cal) throws SQLException {
        block8: {
            if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
                throw new SQLException("column " + columnIndex + " not found");
            }
            String[] rd = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = rd[columnIndex - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Timestamp(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception ee) {
                return Timestamp.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception e) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Timestamp.valueOf(this.lastg);
        }
        catch (java.lang.Exception ee) {
            return new Timestamp(Database.long_from_julian(this.lastg));
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getTimestamp(col);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.internalGetTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getTimestamp(col, cal);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.internalGetDate(columnIndex, null);
    }

    /*
     * Loose catch block
     */
    private Date internalGetDate(int columnIndex, Calendar cal) throws SQLException {
        block8: {
            if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
                throw new SQLException("column " + columnIndex + " not found");
            }
            String[] rd = (String[])this.tr.rows.elementAt(this.row);
            this.lastg = rd[columnIndex - 1];
            if (!this.s.conn.useJulian) break block8;
            try {
                return new Date(Database.long_from_julian(this.lastg));
            }
            catch (java.lang.Exception ee) {
                return Date.valueOf(this.lastg);
            }
            {
                catch (java.lang.Exception e) {
                    this.lastg = null;
                    return null;
                }
            }
        }
        try {
            return Date.valueOf(this.lastg);
        }
        catch (java.lang.Exception ee) {
            return new Date(Database.long_from_julian(this.lastg));
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getDate(col);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.internalGetDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getDate(col, cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Double d = this.internalGetDouble(columnIndex);
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    private Double internalGetDouble(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        try {
            return Double.valueOf(this.lastg);
        }
        catch (java.lang.Exception e) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getDouble(col);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Float f = this.internalGetFloat(columnIndex);
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    private Float internalGetFloat(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        try {
            return Float.valueOf(this.lastg);
        }
        catch (java.lang.Exception e) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getFloat(col);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Long l = this.internalGetLong(columnIndex);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    private Long internalGetLong(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        try {
            return Long.valueOf(this.lastg);
        }
        catch (java.lang.Exception e) {
            this.lastg = null;
            return null;
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getLong(col);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getUnicodeStream(col);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getAsciiStream(col);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getBigDecimal(col);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getBigDecimal(col, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        byte[] data = this.getBytes(columnIndex);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        byte[] data = this.getBytes(columnName);
        if (data != null) {
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getByte(col);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        byte[] ret = null;
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        if (this.lastg != null) {
            ret = StringEncoder.decode(this.lastg);
        }
        return ret;
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getBytes(col);
    }

    @Override
    public String getCursorName() throws SQLException {
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.tr == null || columnIndex < 1 || columnIndex > this.tr.ncolumns) {
            throw new SQLException("column " + columnIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[columnIndex - 1];
        Object ret = this.lastg;
        if (this.tr instanceof TableResultX) {
            switch (((TableResultX)this.tr).sql_type[columnIndex - 1]) {
                case 5: {
                    ret = this.internalGetShort(columnIndex);
                    break;
                }
                case 4: {
                    ret = this.internalGetInt(columnIndex);
                    break;
                }
                case 8: {
                    ret = this.internalGetDouble(columnIndex);
                    break;
                }
                case 6: {
                    ret = this.internalGetFloat(columnIndex);
                    break;
                }
                case -5: {
                    ret = this.internalGetLong(columnIndex);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    ret = this.getBytes(columnIndex);
                    break;
                }
                case 0: {
                    ret = null;
                }
            }
        }
        return ret;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getObject(col);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getObject(col, map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getRef(col);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getBlob(col);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getClob(col);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        int col = this.findColumn(columnName);
        return this.getArray(col);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        String data = this.getString(columnIndex);
        if (data != null) {
            char[] cdata = data.toCharArray();
            return new CharArrayReader(cdata);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        String data = this.getString(columnName);
        if (data != null) {
            char[] cdata = data.toCharArray();
            return new CharArrayReader(cdata);
        }
        return null;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastg == null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row < 0;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = -1;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = 0;
        return true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        return this.row >= this.tr.nrows;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.tr == null) {
            return;
        }
        this.row = this.tr.nrows;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.tr == null) {
            return true;
        }
        return this.row == this.tr.nrows - 1;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.tr == null || this.tr.nrows <= 0) {
            return false;
        }
        this.row = this.tr.nrows - 1;
        return true;
    }

    @Override
    public int getType() throws SQLException {
        return 1005;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1008;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void insertRow() throws SQLException {
        int i;
        this.isUpdatable();
        if (!this.oninsrow || this.rowbuf == null) {
            throw new SQLException("no insert data provided");
        }
        JDBCResultSetMetaData m = (JDBCResultSetMetaData)this.getMetaData();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(Shell.sql_quote_dbl(this.uptable));
        sb.append("(");
        for (i = 0; i < this.tr.ncolumns; ++i) {
            sb.append(Shell.sql_quote_dbl(m.getColumnName(i + 1)));
            if (i >= this.tr.ncolumns - 1) continue;
            sb.append(",");
        }
        sb.append(") VALUES(");
        for (i = 0; i < this.tr.ncolumns; ++i) {
            sb.append(nullrepl ? "'%q'" : "%Q");
            if (i >= this.tr.ncolumns - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        try {
            this.s.conn.db.exec(sb.toString(), null, this.rowbuf);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        this.tr.newrow(this.rowbuf);
        this.rowbuf = null;
        this.oninsrow = false;
        this.last();
    }

    @Override
    public void updateRow() throws SQLException {
        int i;
        this.isUpdatable();
        if (this.rowbuf == null) {
            throw new SQLException("no update data provided");
        }
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        JDBCResultSetMetaData m = (JDBCResultSetMetaData)this.getMetaData();
        String[] args = new String[this.tr.ncolumns + this.pkcols.length];
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(Shell.sql_quote_dbl(this.uptable));
        sb.append(" SET ");
        for (i = 0; i < this.tr.ncolumns; ++i) {
            sb.append(Shell.sql_quote_dbl(m.getColumnName(i + 1)));
            sb.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (i < this.tr.ncolumns - 1) {
                sb.append(",");
            }
            args[i] = this.rowbuf[i];
        }
        sb.append(" WHERE ");
        int k = 0;
        while (k < this.pkcols.length) {
            sb.append(Shell.sql_quote_dbl(this.pkcols[k]));
            sb.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (k < this.pkcols.length - 1) {
                sb.append(" AND ");
            }
            args[i] = rd[this.pkcoli[k]];
            ++k;
            ++i;
        }
        try {
            this.s.conn.db.exec(sb.toString(), null, args);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        System.arraycopy(this.rowbuf, 0, rd, 0, this.rowbuf.length);
        this.rowbuf = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.isUpdatable();
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        this.fillRowbuf();
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ");
        sb.append(Shell.sql_quote_dbl(this.uptable));
        sb.append(" WHERE ");
        String[] args = new String[this.pkcols.length];
        for (int i = 0; i < this.pkcols.length; ++i) {
            sb.append(Shell.sql_quote_dbl(this.pkcols[i]));
            sb.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (i < this.pkcols.length - 1) {
                sb.append(" AND ");
            }
            args[i] = this.rowbuf[this.pkcoli[i]];
        }
        try {
            this.s.conn.db.exec(sb.toString(), null, args);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        this.rowbuf = null;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.isUpdatable();
        if (this.oninsrow) {
            throw new SQLException("cursor on insert row");
        }
        if (this.updatable < 2) {
            throw new SQLException("no primary key on table defined");
        }
        JDBCResultSetMetaData m = (JDBCResultSetMetaData)this.getMetaData();
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        for (int i = 0; i < this.tr.ncolumns; ++i) {
            sb.append(Shell.sql_quote_dbl(m.getColumnName(i + 1)));
            if (i >= this.tr.ncolumns - 1) continue;
            sb.append(",");
        }
        sb.append(" FROM ");
        sb.append(Shell.sql_quote_dbl(this.uptable));
        sb.append(" WHERE ");
        String[] args = new String[this.pkcols.length];
        for (int i = 0; i < this.pkcols.length; ++i) {
            sb.append(Shell.sql_quote_dbl(this.pkcols[i]));
            sb.append(" = " + (nullrepl ? "'%q'" : "%Q"));
            if (i < this.pkcols.length - 1) {
                sb.append(" AND ");
            }
            args[i] = rd[this.pkcoli[i]];
        }
        TableResult trnew = null;
        try {
            trnew = this.s.conn.db.get_table(sb.toString(), args);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        if (trnew.nrows != 1) {
            throw new SQLException("wrong size of result set");
        }
        this.rowbuf = null;
        this.tr.rows.setElementAt(trnew.rows.elementAt(0), this.row);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.rowbuf = null;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.isUpdatable();
        if (!this.oninsrow) {
            this.oninsrow = true;
            this.rowbuf = new String[this.tr.nrows];
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.oninsrow) {
            this.oninsrow = false;
            this.rowbuf = null;
        }
    }

    @Override
    public void updateNull(int colIndex) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = null;
    }

    @Override
    public void updateBoolean(int colIndex, boolean b) throws SQLException {
        this.updateString(colIndex, b ? "1" : "0");
    }

    @Override
    public void updateByte(int colIndex, byte b) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateShort(int colIndex, short b) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = Short.toString(b);
    }

    @Override
    public void updateInt(int colIndex, int b) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = Integer.toString(b);
    }

    @Override
    public void updateLong(int colIndex, long b) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = Long.toString(b);
    }

    @Override
    public void updateFloat(int colIndex, float f) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = Float.toString(f);
    }

    @Override
    public void updateDouble(int colIndex, double f) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = Double.toString(f);
    }

    @Override
    public void updateBigDecimal(int colIndex, BigDecimal f) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateString(int colIndex, String s) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = s;
    }

    @Override
    public void updateBytes(int colIndex, byte[] s) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = this.s.conn.db.is3() ? StringEncoder.encodeX(s) : StringEncoder.encode(s);
    }

    @Override
    public void updateDate(int colIndex, Date d) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = d.toString();
    }

    @Override
    public void updateTime(int colIndex, Time t) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = t.toString();
    }

    @Override
    public void updateTimestamp(int colIndex, Timestamp t) throws SQLException {
        this.isUpdatable();
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        this.fillRowbuf();
        this.rowbuf[colIndex - 1] = t.toString();
    }

    @Override
    public void updateAsciiStream(int colIndex, InputStream in, int s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(int colIndex, InputStream in, int s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(int colIndex, Reader in, int s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateObject(int colIndex, Object obj) throws SQLException {
        this.updateString(colIndex, obj.toString());
    }

    @Override
    public void updateObject(int colIndex, Object obj, int s) throws SQLException {
        this.updateString(colIndex, obj.toString());
    }

    @Override
    public void updateNull(String colName) throws SQLException {
        int col = this.findColumn(colName);
        this.updateNull(col);
    }

    @Override
    public void updateBoolean(String colName, boolean b) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBoolean(col, b);
    }

    @Override
    public void updateByte(String colName, byte b) throws SQLException {
        int col = this.findColumn(colName);
        this.updateByte(col, b);
    }

    @Override
    public void updateShort(String colName, short b) throws SQLException {
        int col = this.findColumn(colName);
        this.updateShort(col, b);
    }

    @Override
    public void updateInt(String colName, int b) throws SQLException {
        int col = this.findColumn(colName);
        this.updateInt(col, b);
    }

    @Override
    public void updateLong(String colName, long b) throws SQLException {
        int col = this.findColumn(colName);
        this.updateLong(col, b);
    }

    @Override
    public void updateFloat(String colName, float f) throws SQLException {
        int col = this.findColumn(colName);
        this.updateFloat(col, f);
    }

    @Override
    public void updateDouble(String colName, double f) throws SQLException {
        int col = this.findColumn(colName);
        this.updateDouble(col, f);
    }

    @Override
    public void updateBigDecimal(String colName, BigDecimal f) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBigDecimal(col, f);
    }

    @Override
    public void updateString(String colName, String s) throws SQLException {
        int col = this.findColumn(colName);
        this.updateString(col, s);
    }

    @Override
    public void updateBytes(String colName, byte[] s) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBytes(col, s);
    }

    @Override
    public void updateDate(String colName, Date d) throws SQLException {
        int col = this.findColumn(colName);
        this.updateDate(col, d);
    }

    @Override
    public void updateTime(String colName, Time t) throws SQLException {
        int col = this.findColumn(colName);
        this.updateTime(col, t);
    }

    @Override
    public void updateTimestamp(String colName, Timestamp t) throws SQLException {
        int col = this.findColumn(colName);
        this.updateTimestamp(col, t);
    }

    @Override
    public void updateAsciiStream(String colName, InputStream in, int s) throws SQLException {
        int col = this.findColumn(colName);
        this.updateAsciiStream(col, in, s);
    }

    @Override
    public void updateBinaryStream(String colName, InputStream in, int s) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBinaryStream(col, in, s);
    }

    @Override
    public void updateCharacterStream(String colName, Reader in, int s) throws SQLException {
        int col = this.findColumn(colName);
        this.updateCharacterStream(col, in, s);
    }

    @Override
    public void updateObject(String colName, Object obj) throws SQLException {
        int col = this.findColumn(colName);
        this.updateObject(col, obj);
    }

    @Override
    public void updateObject(String colName, Object obj, int s) throws SQLException {
        int col = this.findColumn(colName);
        this.updateObject(col, obj, s);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.s == null) {
            throw new SQLException("stale result set");
        }
        return this.s;
    }

    @Override
    public void close() throws SQLException {
        this.s = null;
        this.tr = null;
        this.lastg = null;
        this.oninsrow = false;
        this.rowbuf = null;
        this.row = -1;
    }

    @Override
    public URL getURL(int colIndex) throws SQLException {
        if (this.tr == null || colIndex < 1 || colIndex > this.tr.ncolumns) {
            throw new SQLException("column " + colIndex + " not found");
        }
        String[] rd = (String[])this.tr.rows.elementAt(this.row);
        this.lastg = rd[colIndex - 1];
        URL url = null;
        if (this.lastg == null) {
            return url;
        }
        try {
            url = new URL(this.lastg);
        }
        catch (java.lang.Exception e) {
            url = null;
        }
        return url;
    }

    @Override
    public URL getURL(String colName) throws SQLException {
        int col = this.findColumn(colName);
        return this.getURL(col);
    }

    @Override
    public void updateRef(int colIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRef(String colName, Ref x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateRef(col, x);
    }

    @Override
    public void updateBlob(int colIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String colName, Blob x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBlob(col, x);
    }

    @Override
    public void updateClob(int colIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String colName, Clob x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateClob(col, x);
    }

    @Override
    public void updateArray(int colIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateArray(String colName, Array x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateArray(col, x);
    }

    @Override
    public RowId getRowId(int colIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String colName) throws SQLException {
        int col = this.findColumn(colName);
        return this.getRowId(col);
    }

    @Override
    public void updateRowId(int colIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String colName, RowId x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateRowId(col, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.tr == null;
    }

    @Override
    public void updateNString(int colIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNString(String colName, String nString) throws SQLException {
        int col = this.findColumn(colName);
        this.updateNString(col, nString);
    }

    @Override
    public void updateNClob(int colIndex, NClob nclob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String colName, NClob nclob) throws SQLException {
        int col = this.findColumn(colName);
        this.updateNClob(col, nclob);
    }

    @Override
    public NClob getNClob(int colIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        int col = this.findColumn(colName);
        return this.getNClob(col);
    }

    @Override
    public SQLXML getSQLXML(int colIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        int col = this.findColumn(colName);
        return this.getSQLXML(col);
    }

    @Override
    public void updateSQLXML(int colIndex, SQLXML xml) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateSQLXML(String colName, SQLXML xml) throws SQLException {
        int col = this.findColumn(colName);
        this.updateSQLXML(col, xml);
    }

    @Override
    public String getNString(int colIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String colName) throws SQLException {
        int col = this.findColumn(colName);
        return this.getNString(col);
    }

    @Override
    public Reader getNCharacterStream(int colIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String colName) throws SQLException {
        int col = this.findColumn(colName);
        return this.getNCharacterStream(col);
    }

    @Override
    public void updateNCharacterStream(int colIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String colName, Reader x, long len) throws SQLException {
        int col = this.findColumn(colName);
        this.updateNCharacterStream(col, x, len);
    }

    @Override
    public void updateAsciiStream(int colIndex, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String colName, InputStream x, long len) throws SQLException {
        int col = this.findColumn(colName);
        this.updateAsciiStream(col, x, len);
    }

    @Override
    public void updateBinaryStream(int colIndex, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String colName, InputStream x, long len) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBinaryStream(col, x, len);
    }

    @Override
    public void updateCharacterStream(int colIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String colName, Reader x, long len) throws SQLException {
        int col = this.findColumn(colName);
        this.updateCharacterStream(col, x, len);
    }

    @Override
    public void updateBlob(int colIndex, InputStream x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String colName, InputStream x, long len) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBlob(col, x, len);
    }

    @Override
    public void updateClob(int colIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String colName, Reader x, long len) throws SQLException {
        int col = this.findColumn(colName);
        this.updateClob(col, x, len);
    }

    @Override
    public void updateNClob(int colIndex, Reader x, long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String colName, Reader x, long len) throws SQLException {
        int col = this.findColumn(colName);
        this.updateNClob(col, x, len);
    }

    @Override
    public void updateNCharacterStream(int colIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNCharacterStream(String colName, Reader x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateNCharacterStream(col, x);
    }

    @Override
    public void updateAsciiStream(int colIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateAsciiStream(String colName, InputStream x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateAsciiStream(col, x);
    }

    @Override
    public void updateBinaryStream(int colIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBinaryStream(String colName, InputStream x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBinaryStream(col, x);
    }

    @Override
    public void updateCharacterStream(int colIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateCharacterStream(String colName, Reader x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateCharacterStream(col, x);
    }

    @Override
    public void updateBlob(int colIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateBlob(String colName, InputStream x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateBlob(col, x);
    }

    @Override
    public void updateClob(int colIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateClob(String colName, Reader x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateClob(col, x);
    }

    @Override
    public void updateNClob(int colIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateNClob(String colName, Reader x) throws SQLException {
        int col = this.findColumn(colName);
        this.updateNClob(col, x);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }
}

