/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.JDBC2z.JDBCResultSet;
import SQLite.JDBC2z.TableResultX;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JDBCResultSetMetaData
implements ResultSetMetaData {
    private JDBCResultSet r;

    public JDBCResultSetMetaData(JDBCResultSet r) {
        this.r = r;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        --column;
        if (this.r != null && this.r.tr != null) {
            if (column < 0 || column >= this.r.tr.ncolumns) {
                return null;
            }
            if (this.r.tr instanceof TableResultX) {
                switch (((TableResultX)this.r.tr).sql_type[column]) {
                    case 5: {
                        return "java.lang.Short";
                    }
                    case 4: {
                        return "java.lang.Integer";
                    }
                    case 7: 
                    case 8: {
                        return "java.lang.Double";
                    }
                    case 6: {
                        return "java.lang.Float";
                    }
                    case -5: {
                        return "java.lang.Long";
                    }
                    case 91: {
                        return "java.sql.Date";
                    }
                    case 92: {
                        return "java.sql.Time";
                    }
                    case 93: {
                        return "java.sql.Timestamp";
                    }
                    case -3: 
                    case -2: {
                        return "[B";
                    }
                }
            }
            return "java.lang.String";
        }
        return null;
    }

    @Override
    public int getColumnCount() throws SQLException {
        if (this.r != null && this.r.tr != null) {
            return this.r.tr.ncolumns;
        }
        return 0;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        --column;
        String c = null;
        if (this.r != null && this.r.tr != null) {
            if (column < 0 || column >= this.r.tr.ncolumns) {
                return c;
            }
            c = this.r.tr.column[column];
        }
        return c;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        --column;
        String c = null;
        if (this.r != null && this.r.tr != null) {
            int i;
            if (column < 0 || column >= this.r.tr.ncolumns) {
                return c;
            }
            c = this.r.tr.column[column];
            if (c != null && (i = c.indexOf(46)) > 0) {
                return c.substring(i + 1);
            }
        }
        return c;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        if (this.r != null && this.r.tr != null && --column >= 0 && column < this.r.tr.ncolumns) {
            if (this.r.tr instanceof TableResultX) {
                return ((TableResultX)this.r.tr).sql_type[column];
            }
            return 12;
        }
        throw new SQLException("bad column index");
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        if (this.r != null && this.r.tr != null && --column >= 0 && column < this.r.tr.ncolumns) {
            if (this.r.tr instanceof TableResultX) {
                switch (((TableResultX)this.r.tr).sql_type[column]) {
                    case 5: {
                        return "smallint";
                    }
                    case 4: {
                        return "integer";
                    }
                    case 8: {
                        return "double";
                    }
                    case 6: {
                        return "float";
                    }
                    case -5: {
                        return "bigint";
                    }
                    case 91: {
                        return "date";
                    }
                    case 92: {
                        return "time";
                    }
                    case 93: {
                        return "timestamp";
                    }
                    case -2: {
                        return "binary";
                    }
                    case -3: {
                        return "varbinary";
                    }
                    case 7: {
                        return "real";
                    }
                }
            }
            return "varchar";
        }
        throw new SQLException("bad column index");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        --column;
        String c = null;
        if (this.r != null && this.r.tr != null) {
            if (column < 0 || column >= this.r.tr.ncolumns) {
                return c;
            }
            c = this.r.tr.column[column];
            if (c != null) {
                int i = c.indexOf(46);
                if (i > 0) {
                    return c.substring(0, i);
                }
                c = null;
            }
        }
        return c;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return true;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 2;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    int findColByName(String columnName) throws SQLException {
        String c = null;
        if (this.r != null && this.r.tr != null) {
            for (int i = 0; i < this.r.tr.ncolumns; ++i) {
                c = this.r.tr.column[i];
                if (c != null) {
                    if (c.compareToIgnoreCase(columnName) == 0) {
                        return i + 1;
                    }
                    int k = c.indexOf(46);
                    if (k > 0 && (c = c.substring(k + 1)).compareToIgnoreCase(columnName) == 0) {
                        return i + 1;
                    }
                }
                c = null;
            }
        }
        throw new SQLException("column " + columnName + " not found");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }
}

