/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.Exception;
import SQLite.JDBC2z.JDBCConnection;
import SQLite.JDBC2z.JDBCResultSet;
import SQLite.JDBC2z.TableResultX;
import SQLite.TableResult;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class JDBCStatement
implements Statement {
    protected JDBCConnection conn;
    protected JDBCResultSet rs;
    protected int updcnt;
    protected int maxrows = 0;
    private ArrayList<String> batch;

    public JDBCStatement(JDBCConnection conn) {
        this.conn = conn;
        this.updcnt = 0;
        this.rs = null;
        this.batch = null;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (fetchSize != 1) {
            throw new SQLException("fetch size not 1");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxrows = max;
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1002;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1004;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.conn.timeout = seconds * 1000;
        if (this.conn.timeout < 0) {
            this.conn.timeout = 120000;
        } else if (this.conn.timeout < 1000) {
            this.conn.timeout = 5000;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.conn.timeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet executeQuery(String sql, String[] args, boolean updonly) throws SQLException {
        TableResult tr = null;
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        this.updcnt = -1;
        if (this.conn == null || this.conn.db == null) {
            throw new SQLException("stale connection");
        }
        int busy = 0;
        boolean starttrans = !this.conn.autocommit && !this.conn.intrans;
        while (true) {
            try {
                if (starttrans) {
                    this.conn.db.exec("BEGIN TRANSACTION", null);
                    this.conn.intrans = true;
                }
                if (args == null) {
                    if (updonly) {
                        this.conn.db.exec(sql, null);
                    } else {
                        tr = this.conn.db.get_table(sql, this.maxrows);
                    }
                } else if (updonly) {
                    this.conn.db.exec(sql, null, args);
                } else {
                    tr = this.conn.db.get_table(sql, this.maxrows, args);
                }
                this.updcnt = (int)this.conn.db.changes();
            }
            catch (Exception e) {
                if (this.conn.db.is3() && this.conn.db.last_error() == 5 && this.conn.busy3(this.conn.db, ++busy)) {
                    try {
                        if (starttrans && this.conn.intrans) {
                            this.conn.db.exec("ROLLBACK", null);
                            this.conn.intrans = false;
                        }
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                    try {
                        int ms = 20 + busy * 10;
                        if (ms > 1000) {
                            ms = 1000;
                        }
                        JDBCStatement jDBCStatement = this;
                        synchronized (jDBCStatement) {
                            this.wait(ms);
                            continue;
                        }
                    }
                    catch (java.lang.Exception eee) {
                        continue;
                    }
                }
                throw new SQLException(e.toString());
            }
            break;
        }
        if (!updonly && tr == null) {
            throw new SQLException("no result set produced");
        }
        if (!updonly && tr != null) {
            this.rs = new JDBCResultSet(new TableResultX(tr), this);
        }
        return this.rs;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null, false);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public void cancel() throws SQLException {
        if (this.conn == null || this.conn.db == null) {
            throw new SQLException("stale connection");
        }
        this.conn.db.interrupt();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList(1);
        }
        this.batch.add(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] ret = new int[this.batch.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = -3;
        }
        int errs = 0;
        for (int i = 0; i < ret.length; ++i) {
            try {
                this.execute(this.batch.get(i));
                ret[i] = this.updcnt;
                continue;
            }
            catch (SQLException e) {
                ++errs;
            }
        }
        if (errs > 0) {
            throw new BatchUpdateException("batch failed", ret);
        }
        return ret;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batch != null) {
            this.batch.clear();
            this.batch = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.clearBatch();
        this.conn = null;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.executeQuery(sql, null, true);
        return this.updcnt;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
        }
        return false;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updcnt;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean getMoreResults(int x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autokeys) throws SQLException {
        if (autokeys != 2) {
            throw new SQLFeatureNotSupportedException("generated keys not supported");
        }
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] colIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] colIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autokeys) throws SQLException {
        if (autokeys != 2) {
            throw new SQLFeatureNotSupportedException("autogenerated keys not supported");
        }
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] colIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] colIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.rs == null;
    }

    @Override
    public void setPoolable(boolean yes) throws SQLException {
        if (yes) {
            throw new SQLException("poolable statements not supported");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }
}

