/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

import SQLite.Callback;
import java.util.Vector;

public class TableResult
implements Callback {
    public int ncolumns;
    public int nrows;
    public String[] column;
    public String[] types;
    public Vector rows;
    public int maxrows = 0;
    public boolean atmaxrows;

    public TableResult() {
        this.clear();
    }

    public TableResult(int maxrows) {
        this.maxrows = maxrows;
        this.clear();
    }

    public void clear() {
        this.column = new String[0];
        this.types = null;
        this.rows = new Vector();
        this.nrows = 0;
        this.ncolumns = 0;
        this.atmaxrows = false;
    }

    public void columns(String[] coldata) {
        this.column = coldata;
        this.ncolumns = this.column.length;
    }

    public void types(String[] types) {
        this.types = types;
    }

    public boolean newrow(String[] rowdata) {
        if (rowdata != null) {
            if (this.maxrows > 0 && this.nrows >= this.maxrows) {
                this.atmaxrows = true;
                return true;
            }
            this.rows.addElement(rowdata);
            ++this.nrows;
        }
        return false;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.ncolumns; ++i) {
            sb.append(this.column[i] == null ? "NULL" : this.column[i]);
            sb.append('|');
        }
        sb.append('\n');
        for (i = 0; i < this.nrows; ++i) {
            String[] row = (String[])this.rows.elementAt(i);
            for (int k = 0; k < this.ncolumns; ++k) {
                sb.append(row[k] == null ? "NULL" : row[k]);
                sb.append('|');
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

