/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.PackedInteger;
import com.sleepycat.util.UtfOps;
import java.math.BigInteger;

public class TupleInput
extends FastInputStream {
    public TupleInput(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public final String readString() throws IndexOutOfBoundsException, IllegalArgumentException {
        byte[] myBuf = this.buf;
        int myOff = this.off;
        if (this.available() >= 2 && myBuf[myOff] == -1 && myBuf[myOff + 1] == 0) {
            this.skip(2L);
            return null;
        }
        int byteLen = UtfOps.getZeroTerminatedByteLength(myBuf, myOff);
        this.skip(byteLen + 1);
        return UtfOps.bytesToString(myBuf, myOff, byteLen);
    }

    public final char readChar() throws IndexOutOfBoundsException {
        return (char)this.readUnsignedShort();
    }

    public final boolean readBoolean() throws IndexOutOfBoundsException {
        int c = this.readFast();
        if (c < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c != 0;
    }

    public final byte readByte() throws IndexOutOfBoundsException {
        return (byte)(this.readUnsignedByte() ^ 0x80);
    }

    public final short readShort() throws IndexOutOfBoundsException {
        return (short)(this.readUnsignedShort() ^ 0x8000);
    }

    public final int readInt() throws IndexOutOfBoundsException {
        return (int)(this.readUnsignedInt() ^ Integer.MIN_VALUE);
    }

    public final long readLong() throws IndexOutOfBoundsException {
        return this.readUnsignedLong() ^ Long.MIN_VALUE;
    }

    public final float readSortedFloat() throws IndexOutOfBoundsException {
        int val;
        return Float.intBitsToFloat(val ^= (val = (int)this.readUnsignedInt()) < 0 ? Integer.MIN_VALUE : -1);
    }

    public final double readSortedDouble() throws IndexOutOfBoundsException {
        long val;
        return Double.longBitsToDouble(val ^= (val = this.readUnsignedLong()) < 0L ? Long.MIN_VALUE : -1L);
    }

    public final int readUnsignedByte() throws IndexOutOfBoundsException {
        int c = this.readFast();
        if (c < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c;
    }

    public final int readUnsignedShort() throws IndexOutOfBoundsException {
        int c2;
        int c1 = this.readFast();
        if ((c1 | (c2 = this.readFast())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 8 | c2;
    }

    public final long readUnsignedInt() throws IndexOutOfBoundsException {
        long c4;
        long c3;
        long c2;
        long c1 = this.readFast();
        if ((c1 | (c2 = (long)this.readFast()) | (c3 = (long)this.readFast()) | (c4 = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private final long readUnsignedLong() throws IndexOutOfBoundsException {
        long c8;
        long c7;
        long c6;
        long c5;
        long c4;
        long c3;
        long c2;
        long c1 = this.readFast();
        if ((c1 | (c2 = (long)this.readFast()) | (c3 = (long)this.readFast()) | (c4 = (long)this.readFast()) | (c5 = (long)this.readFast()) | (c6 = (long)this.readFast()) | (c7 = (long)this.readFast()) | (c8 = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 56 | c2 << 48 | c3 << 40 | c4 << 32 | c5 << 24 | c6 << 16 | c7 << 8 | c8;
    }

    public final int getStringByteLength() throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.available() >= 2 && this.buf[this.off] == -1 && this.buf[this.off + 1] == 0) {
            return 2;
        }
        return UtfOps.getZeroTerminatedByteLength(this.buf, this.off) + 1;
    }

    public final int readPackedInt() {
        int len = PackedInteger.getReadIntLength(this.buf, this.off);
        int val = PackedInteger.readInt(this.buf, this.off);
        this.off += len;
        return val;
    }

    public final int getPackedIntByteLength() {
        return PackedInteger.getReadIntLength(this.buf, this.off);
    }

    public final BigInteger readBigInteger() {
        short len = this.readShort();
        if (len < 0) {
            len = -len;
        }
        byte[] a = new byte[len];
        a[0] = this.readByte();
        this.readFast(a, 1, a.length - 1);
        return new BigInteger(a);
    }

    public final int getBigIntegerByteLength() {
        int saveOff = this.off;
        short len = this.readShort();
        this.off = saveOff;
        if (len < 0) {
            len = -len;
        }
        return len + 2;
    }
}

