/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.compat;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import java.io.FileNotFoundException;

public class DbCompat {
    public static boolean TRANSACTION_RUNNER_PRINT_STACK_TRACES = true;

    public static boolean getInitializeLocking(EnvironmentConfig config) {
        return config.getLocking();
    }

    public static boolean getDeferredWrite(DatabaseConfig dbConfig) {
        return dbConfig.getDeferredWrite();
    }

    public static long getDatabaseCount(Database db) throws DatabaseException {
        return db.count();
    }

    public static void syncDeferredWrite(Database db, boolean flushLog) throws DatabaseException {
        DbInternal.dbGetDatabaseImpl(db).sync(flushLog);
    }

    public static Transaction getThreadTransaction(Environment env) throws DatabaseException {
        return env.getThreadTransaction();
    }

    public static void setTypeBtree(DatabaseConfig dbConfig) {
    }

    public static Database openDatabase(Environment env, Transaction txn, String fileName, String dbName, DatabaseConfig config) throws DatabaseException, FileNotFoundException {
        assert (fileName == null);
        return env.openDatabase(txn, dbName, config);
    }

    public static SecondaryDatabase openSecondaryDatabase(Environment env, Transaction txn, String fileName, String dbName, Database primaryDatabase, SecondaryConfig config) throws DatabaseException, FileNotFoundException {
        assert (fileName == null);
        return env.openSecondaryDatabase(txn, dbName, primaryDatabase, config);
    }

    public static void removeDatabase(Environment env, Transaction txn, String fileName, String dbName) throws DatabaseException, FileNotFoundException {
        assert (fileName == null);
        env.removeDatabase(txn, dbName);
    }

    public static void renameDatabase(Environment env, Transaction txn, String oldFileName, String oldDbName, String newFileName, String newDbName) throws DatabaseException, FileNotFoundException {
        assert (oldFileName == null);
        assert (newFileName == null);
        env.renameDatabase(txn, oldDbName, newDbName);
    }
}

