/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseTrigger;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.TinyHashSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Database {
    static DbState OPEN = new DbState("OPEN");
    static DbState CLOSED = new DbState("CLOSED");
    static DbState INVALID = new DbState("INVALID");
    private volatile DbState state;
    Environment envHandle;
    private DatabaseImpl databaseImpl;
    DatabaseConfig configuration;
    private boolean isWritable;
    Locker handleLocker;
    private TinyHashSet<Cursor> cursors = new TinyHashSet();
    private List<DatabaseTrigger> triggerList;
    private Logger logger;

    protected Database(Environment env) {
        this.envHandle = env;
        this.handleLocker = null;
        this.logger = this.envHandle.getEnvironmentImpl().getLogger();
    }

    void initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        dbConfig.validateForNewDb();
        this.init(env, dbConfig);
        EnvironmentImpl environmentImpl = DbInternal.envGetEnvironmentImpl(this.envHandle);
        this.databaseImpl = environmentImpl.getDbTree().createDb(locker, databaseName, dbConfig, this);
        this.databaseImpl.addReferringHandle(this);
        this.configuration.setReplicated(this.databaseImpl.isReplicated());
    }

    void initExisting(Environment env, Locker locker, DatabaseImpl databaseImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.validateConfigAgainstExistingDb(dbConfig, databaseImpl);
        this.init(env, dbConfig);
        this.databaseImpl = databaseImpl;
        databaseImpl.addReferringHandle(this);
        this.configuration.setSortedDuplicates(databaseImpl.getSortedDuplicates());
        this.configuration.setTransactional(databaseImpl.isTransactional());
        this.configuration.setReplicated(databaseImpl.isReplicated());
    }

    private void init(Environment env, DatabaseConfig config) throws DatabaseException {
        this.handleLocker = null;
        this.envHandle = env;
        this.configuration = config.cloneConfig();
        this.isWritable = !this.configuration.getReadOnly();
        this.state = OPEN;
    }

    private void validateConfigAgainstExistingDb(DatabaseConfig config, DatabaseImpl databaseImpl) throws DatabaseException {
        boolean newKeyPrefixing;
        if (!config.getUseExistingConfig()) {
            this.validatePropertyMatches("sortedDuplicates", databaseImpl.getSortedDuplicates(), config.getSortedDuplicates());
            this.validatePropertyMatches("temporary", databaseImpl.isTemporary(), config.getTemporary());
            if (this.envHandle.getEnvironmentImpl().isReplicated()) {
                if (databaseImpl.unknownReplicated()) {
                    throw new UnsupportedOperationException("Conversion of standalone environments to replicated environments isn't supported yet");
                }
                this.validatePropertyMatches("replicated", databaseImpl.isReplicated(), DbInternal.getDbConfigReplicated(config));
            }
        }
        if (databaseImpl.hasOpenHandles()) {
            if (!config.getUseExistingConfig()) {
                this.validatePropertyMatches("transactional", databaseImpl.isTransactional(), config.getTransactional());
                this.validatePropertyMatches("deferredWrite", databaseImpl.isDurableDeferredWrite(), config.getDeferredWrite());
            }
        } else {
            databaseImpl.setTransactional(config.getTransactional());
            databaseImpl.setDeferredWrite(config.getDeferredWrite());
        }
        boolean dbImplModified = false;
        if (config.getOverrideBtreeComparator()) {
            dbImplModified |= databaseImpl.setBtreeComparator(config.getBtreeComparator(), config.getBtreeComparatorByClassName());
        }
        if (config.getOverrideDuplicateComparator()) {
            dbImplModified |= databaseImpl.setDuplicateComparator(config.getDuplicateComparator(), config.getDuplicateComparatorByClassName());
        }
        if ((newKeyPrefixing = config.getKeyPrefixing()) != databaseImpl.getKeyPrefixing()) {
            dbImplModified = true;
            if (newKeyPrefixing) {
                databaseImpl.setKeyPrefixing();
            } else {
                databaseImpl.clearKeyPrefixing();
            }
        }
        if (dbImplModified) {
            EnvironmentImpl envImpl = this.envHandle.getEnvironmentImpl();
            envImpl.getDbTree().modifyDbRoot(databaseImpl);
        }
    }

    private void validatePropertyMatches(String propName, boolean existingValue, boolean newValue) throws IllegalArgumentException {
        if (newValue != existingValue) {
            throw new IllegalArgumentException("You can't open a Database with a " + propName + " configuration of " + newValue + " if the underlying database was created with a " + propName + " setting of " + existingValue + '.');
        }
    }

    public void close() throws DatabaseException {
        try {
            this.closeInternal(true);
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean doSyncDw) throws DatabaseException {
        StringBuffer errors = null;
        DatabaseImpl dbClosed = null;
        Database database = this;
        synchronized (database) {
            this.checkEnv();
            this.checkProhibitedDbState(CLOSED, "Can't close Database:");
            this.trace(Level.FINEST, "Database.close: ", null, null);
            this.removeAllTriggers();
            this.envHandle.removeReferringHandle(this);
            if (this.cursors.size() > 0) {
                errors = new StringBuffer("There are open cursors against the database.\n");
                errors.append("They will be closed.\n");
                for (Cursor dbc : this.cursors.copy()) {
                    try {
                        dbc.close();
                    }
                    catch (DatabaseException DBE) {
                        errors.append("Exception while closing cursors:\n");
                        errors.append(DBE.toString());
                    }
                }
            }
            if (this.databaseImpl != null) {
                dbClosed = this.databaseImpl;
                this.databaseImpl.removeReferringHandle(this);
                this.envHandle.getEnvironmentImpl().getDbTree().releaseDb(this.databaseImpl);
                this.databaseImpl = null;
                this.handleLocker.setHandleLockOwner(true, this, true);
                this.handleLocker.operationEnd(true);
                this.state = CLOSED;
            }
        }
        if (dbClosed != null) {
            dbClosed.handleClosed(doSyncDw);
        }
        if (errors != null) {
            throw new DatabaseException(errors.toString());
        }
    }

    public Sequence openSequence(Transaction txn, DatabaseEntry key, SequenceConfig config) throws DatabaseException {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkRequiredDbState(OPEN, "Can't call Database.openSequence:");
            this.checkWritable("openSequence");
            this.trace(Level.FINEST, "Database.openSequence", txn, key, null, null);
            return new Sequence(this, txn, key, config);
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    public synchronized Cursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        try {
            CursorConfig useConfig;
            this.checkEnv();
            this.checkRequiredDbState(OPEN, "Can't open a cursor");
            CursorConfig cursorConfig2 = useConfig = cursorConfig == null ? CursorConfig.DEFAULT : cursorConfig;
            if (useConfig.getReadUncommitted() && useConfig.getReadCommitted()) {
                throw new IllegalArgumentException("Only one may be specified: ReadCommitted or ReadUncommitted");
            }
            this.trace(Level.FINEST, "Database.openCursor", txn, cursorConfig);
            Cursor ret = this.newDbcInstance(txn, useConfig);
            return ret;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new Cursor(this, txn, cursorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DatabaseException {
        OperationStatus operationStatus;
        block6: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            this.checkRequiredDbState(OPEN, "Can't call Database.delete:");
            this.checkWritable("delete");
            this.trace(Level.FINEST, "Database.delete", txn, key, null, null);
            OperationStatus commitStatus = OperationStatus.NOTFOUND;
            Locker locker = null;
            try {
                locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.isTransactional(), this.databaseImpl.isReplicated());
                operationStatus = commitStatus = this.deleteInternal(locker, key, null);
                if (locker == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteInternal(Locker locker, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        Cursor cursor = null;
        try {
            OperationStatus searchStatus;
            DatabaseEntry oldData;
            cursor = new Cursor(this, locker, null);
            cursor.setNonCloning(true);
            OperationStatus commitStatus = OperationStatus.NOTFOUND;
            if (data == null) {
                oldData = new DatabaseEntry();
                searchStatus = cursor.search(key, oldData, LockMode.RMW, CursorImpl.SearchMode.SET);
            } else {
                oldData = data;
                searchStatus = cursor.search(key, oldData, LockMode.RMW, CursorImpl.SearchMode.BOTH);
            }
            if (searchStatus == OperationStatus.SUCCESS) {
                do {
                    if (this.hasTriggers()) {
                        this.notifyTriggers(locker, key, oldData, null);
                    }
                    if ((commitStatus = cursor.deleteNoNotify()) == OperationStatus.SUCCESS) continue;
                    OperationStatus operationStatus = commitStatus;
                    return operationStatus;
                } while (data == null && (searchStatus = this.databaseImpl.getSortedDuplicates() ? cursor.retrieveNext(key, oldData, LockMode.RMW, GetMode.NEXT_DUP) : OperationStatus.NOTFOUND) == OperationStatus.SUCCESS);
                commitStatus = OperationStatus.SUCCESS;
            }
            OperationStatus operationStatus = commitStatus;
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        block7: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(data, "data", false);
            this.checkRequiredDbState(OPEN, "Can't call Database.get:");
            this.trace(Level.FINEST, "Database.get", txn, key, null, lockMode);
            CursorConfig cursorConfig = CursorConfig.DEFAULT;
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = CursorConfig.READ_COMMITTED;
                lockMode = null;
            }
            Cursor cursor = null;
            try {
                cursor = new Cursor(this, txn, cursorConfig);
                cursor.setNonCloning(true);
                operationStatus = cursor.search(key, data, lockMode, CursorImpl.SearchMode.SET);
                if (cursor == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        return operationStatus;
    }

    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkRequiredDbState(OPEN, "Can't call Database.put");
        this.checkWritable("put");
        this.trace(Level.FINEST, "Database.put", txn, key, data, null);
        return this.putInternal(txn, key, data, PutMode.OVERWRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putInternal(Transaction txn, DatabaseEntry key, DatabaseEntry data, PutMode putMode) throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block8: {
            locker = null;
            Cursor cursor = null;
            commitStatus = OperationStatus.KEYEXIST;
            try {
                locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.isTransactional(), this.databaseImpl.isReplicated());
                cursor = new Cursor(this, locker, null);
                cursor.setNonCloning(true);
                operationStatus = commitStatus = cursor.putInternal(key, data, putMode);
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
                catch (Error E) {
                    DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    public long count() throws DatabaseException {
        this.checkEnv();
        this.checkRequiredDbState(OPEN, "Can't call Database.count");
        this.databaseImpl.checkIsDeleted("count");
        return this.databaseImpl.count();
    }

    String getDebugName() {
        if (this.databaseImpl != null) {
            return this.databaseImpl.getDebugName();
        }
        return null;
    }

    public DatabaseConfig getConfig() throws DatabaseException {
        try {
            DatabaseConfig showConfig = this.configuration.cloneConfig();
            Comparator<byte[]> btComp = null;
            Comparator<byte[]> dupComp = null;
            boolean btCompByClass = false;
            boolean dupCompByClass = false;
            if (this.databaseImpl != null) {
                btComp = this.databaseImpl.getBtreeComparator();
                dupComp = this.databaseImpl.getDuplicateComparator();
                btCompByClass = this.databaseImpl.getBtreeComparatorByClass();
                dupCompByClass = this.databaseImpl.getDuplicateComparatorByClass();
            }
            showConfig.setBtreeComparatorInternal(btComp, btCompByClass);
            showConfig.setDuplicateComparatorInternal(dupComp, dupCompByClass);
            return showConfig;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    boolean isTransactional() throws DatabaseException {
        return this.databaseImpl.isTransactional();
    }

    public Environment getEnvironment() throws DatabaseException {
        return this.envHandle;
    }

    boolean isWritable() {
        return this.isWritable;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.databaseImpl;
    }

    void setHandleLocker(Locker locker) {
        this.handleLocker = locker;
    }

    synchronized void removeCursor(Cursor dbc) {
        this.cursors.remove(dbc);
    }

    synchronized void addCursor(Cursor dbc) {
        this.cursors.add(dbc);
    }

    void checkRequiredDbState(DbState required, String msg) throws DatabaseException {
        if (this.state != required) {
            throw new DatabaseException(msg + " Database state can't be " + this.state + " must be " + required);
        }
    }

    void checkProhibitedDbState(DbState prohibited, String msg) throws DatabaseException {
        if (this.state == prohibited) {
            throw new DatabaseException(msg + " Database state must not be " + prohibited);
        }
    }

    void checkEnv() throws RunRecoveryException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        if (env != null) {
            env.checkIfInvalid();
        }
    }

    synchronized void invalidate() {
        this.state = INVALID;
        this.envHandle.removeReferringHandle(this);
        if (this.databaseImpl != null) {
            this.databaseImpl.removeReferringHandle(this);
            this.envHandle.getEnvironmentImpl().getDbTree().releaseDb(this.databaseImpl);
            this.databaseImpl = null;
        }
    }

    private void checkWritable(String operation) throws DatabaseException {
        if (!this.isWritable) {
            throw new UnsupportedOperationException("Database is Read Only: " + operation);
        }
    }

    void trace(Level level, String methodName, Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            sb.append(" key=").append(key.dumpData());
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append(lockMode);
            }
            this.logger.log(level, sb.toString());
        }
    }

    void trace(Level level, String methodName, Transaction txn, CursorConfig config) throws DatabaseException {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            sb.append(" name=" + this.getDebugName());
            if (txn != null) {
                sb.append(" txnId=").append(txn.getId());
            }
            if (config != null) {
                sb.append(" config=").append(config);
            }
            this.logger.log(level, sb.toString());
        }
    }

    boolean hasTriggers() {
        return this.triggerList != null;
    }

    private void acquireTriggerListReadLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().acquireShared();
        if (this.triggerList == null) {
            this.triggerList = new ArrayList<DatabaseTrigger>();
        }
    }

    private void releaseTriggerListReadLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().release();
    }

    private void acquireTriggerListWriteLock() throws DatabaseException {
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().acquireExclusive();
        if (this.triggerList == null) {
            this.triggerList = new ArrayList<DatabaseTrigger>();
        }
    }

    private void releaseTriggerListWriteLock() throws DatabaseException {
        if (this.triggerList.size() == 0) {
            this.triggerList = null;
        }
        EnvironmentImpl env = this.envHandle.getEnvironmentImpl();
        env.getTriggerLatch().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTrigger(DatabaseTrigger trigger, boolean insertAtFront) throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            if (insertAtFront) {
                this.triggerList.add(0, trigger);
            } else {
                this.triggerList.add(trigger);
            }
            trigger.triggerAdded(this);
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTrigger(DatabaseTrigger trigger) throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            this.triggerList.remove(trigger);
            trigger.triggerRemoved(this);
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTriggers() throws DatabaseException {
        this.acquireTriggerListWriteLock();
        try {
            for (int i = 0; i < this.triggerList.size(); ++i) {
                DatabaseTrigger trigger = this.triggerList.get(i);
                trigger.triggerRemoved(this);
            }
            this.triggerList.clear();
        }
        finally {
            this.releaseTriggerListWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTriggers(Locker locker, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData) throws DatabaseException {
        this.acquireTriggerListReadLock();
        try {
            for (int i = 0; i < this.triggerList.size(); ++i) {
                DatabaseTrigger trigger = this.triggerList.get(i);
                trigger.databaseUpdated(this, locker, priKey, oldData, newData);
            }
        }
        finally {
            this.releaseTriggerListReadLock();
        }
    }

    static class DbState {
        private String stateName;

        DbState(String stateName) {
            this.stateName = stateName;
        }

        public String toString() {
            return "DbState." + this.stateName;
        }
    }
}

