/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Durability;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.Properties;

public class EnvironmentMutableConfig
implements Cloneable {
    private boolean txnNoSync = false;
    private boolean txnWriteNoSync = false;
    private Durability durability = null;
    private ReplicaConsistencyPolicy consistencyPolicy = null;
    protected long cacheSize;
    protected Properties props = new Properties();
    private boolean loadPropertyFile = true;
    boolean validateParams = true;
    private ExceptionListener exceptionListener = null;

    public boolean getTxnNoSync() {
        return this.txnNoSync;
    }

    public boolean getTxnWriteNoSync() {
        return this.txnWriteNoSync;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public ReplicaConsistencyPolicy getConsistencyPolicy() {
        return this.consistencyPolicy;
    }

    public void setCachePercent(int percent) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, EnvironmentParams.MAX_MEMORY_PERCENT, Integer.toString(percent), this.validateParams);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    void checkImmutablePropsForEquality(EnvironmentMutableConfig passedConfig) throws IllegalArgumentException {
        Properties passedProps = passedConfig.props;
        for (String paramName : EnvironmentParams.SUPPORTED_PARAMS.keySet()) {
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            assert (param != null);
            if (param.isMutable()) continue;
            String paramVal = this.props.getProperty(paramName);
            String useParamVal = passedProps.getProperty(paramName);
            if (!(paramVal != null ? !paramVal.equals(useParamVal) : useParamVal != null)) continue;
            throw new IllegalArgumentException(paramName + " is set to " + useParamVal + " in the config parameter" + " which is incompatible" + " with the value of " + paramVal + " in the" + " underlying environment");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        EnvironmentMutableConfig copy = (EnvironmentMutableConfig)super.clone();
        copy.props = (Properties)this.props.clone();
        return copy;
    }

    void copyHandlePropsTo(EnvironmentMutableConfig other) {
        other.txnNoSync = this.txnNoSync;
        other.txnWriteNoSync = this.txnWriteNoSync;
        other.durability = this.durability;
        other.consistencyPolicy = this.consistencyPolicy;
    }

    void fillInEnvironmentGeneratedProps(EnvironmentImpl envImpl) {
        this.cacheSize = envImpl.getMemoryBudget().getMaxMemory();
    }

    Properties getProps() {
        return this.props;
    }

    boolean getLoadPropertyFile() {
        return this.loadPropertyFile;
    }

    public String toString() {
        return "cacheSize=" + this.cacheSize + "\n" + "txnNoSync=" + this.txnNoSync + "\n" + "txnWriteNoSync=" + this.txnWriteNoSync + "\n" + this.props.toString() + "\n";
    }
}

