/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import java.util.HashSet;
import java.util.logging.Level;

public class SecondaryCursor
extends Cursor {
    private SecondaryDatabase secondaryDb;
    private Database primaryDb;

    SecondaryCursor(SecondaryDatabase dbHandle, Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        super((Database)dbHandle, txn, cursorConfig);
        this.secondaryDb = dbHandle;
        this.primaryDb = dbHandle.getPrimaryDatabase();
    }

    public OperationStatus delete() throws DatabaseException {
        this.checkState(true);
        this.checkUpdatesAllowed("delete");
        this.trace(Level.FINEST, "SecondaryCursor.delete: ", null);
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry pKey = new DatabaseEntry();
        OperationStatus status = this.getCurrentInternal(key, pKey, LockMode.RMW);
        if (status == OperationStatus.SUCCESS && (status = this.primaryDb.deleteInternal(this.cursorImpl.getLocker(), pKey, null)) != OperationStatus.SUCCESS) {
            SecondaryDatabase secDb = (SecondaryDatabase)this.getDatabase();
            throw secDb.secondaryCorruptException();
        }
        return status;
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getSearchKey(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
    }

    OperationStatus search(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) throws DatabaseException {
        OperationStatus status;
        do {
            if ((status = this.search(key, pKey, lockMode, searchMode)) == OperationStatus.SUCCESS) continue;
            return status;
        } while ((status = this.readPrimaryAfterGet(key, pKey, data, lockMode)) != OperationStatus.SUCCESS);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus readPrimaryAfterGet(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        DatabaseEntry copyToPartialEntry = null;
        boolean readUncommitted = this.isReadUncommittedMode(lockMode);
        if (readUncommitted && data.getPartial()) {
            if (data.getPartialLength() == 0) {
                data.setData(LogUtils.ZERO_LENGTH_BYTE_ARRAY);
                return OperationStatus.SUCCESS;
            }
            copyToPartialEntry = data;
            data = new DatabaseEntry();
        }
        Locker locker = this.cursorImpl.getLocker();
        Cursor cursor = null;
        try {
            SecondaryConfig conf;
            cursor = new Cursor(this.primaryDb, locker, null, true);
            OperationStatus status = cursor.search(pKey, data, lockMode, CursorImpl.SearchMode.SET);
            if (status != OperationStatus.SUCCESS) {
                if (readUncommitted && (status = this.getCurrentInternal(key, pKey, lockMode)) == OperationStatus.KEYEMPTY) {
                    OperationStatus operationStatus = status;
                    return operationStatus;
                }
                SecondaryDatabase secDb = (SecondaryDatabase)this.getDatabase();
                throw secDb.secondaryCorruptException();
            }
            if (readUncommitted && !(conf = this.secondaryDb.getPrivateSecondaryConfig()).getImmutableSecondaryKey()) {
                if (conf.getKeyCreator() != null) {
                    DatabaseEntry secKey = new DatabaseEntry();
                    if (!conf.getKeyCreator().createSecondaryKey(this.secondaryDb, pKey, data, secKey) || !secKey.equals(key)) {
                        OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                        return operationStatus;
                    }
                } else if (conf.getMultiKeyCreator() != null) {
                    HashSet<DatabaseEntry> results = new HashSet<DatabaseEntry>();
                    conf.getMultiKeyCreator().createSecondaryKeys(this.secondaryDb, pKey, data, results);
                    if (!results.contains(key)) {
                        OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                        return operationStatus;
                    }
                }
            }
            if (copyToPartialEntry != null) {
                CursorImpl.setDbt(copyToPartialEntry, data.getData());
            }
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}

