/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.FileManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbFileSummaryMap {
    private static final int FILE_ENTRY_OVERHEAD = MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD + MemoryBudget.DBFILESUMMARY_OVERHEAD;
    private Map<Long, DbFileSummary> map = new HashMap<Long, DbFileSummary>();
    private int memSize = MemoryBudget.HASHMAP_OVERHEAD;
    private MemoryBudget budget;

    public DbFileSummaryMap(boolean countParentMapEntry) {
        if (countParentMapEntry) {
            this.memSize += MemoryBudget.HASHMAP_ENTRY_OVERHEAD;
        }
    }

    public void init(EnvironmentImpl env) {
        this.budget = env.getMemoryBudget();
        this.budget.updateTreeAdminMemoryUsage(this.memSize);
    }

    public DbFileSummary get(Long fileNum, boolean adjustMemBudget, boolean checkResurrected, FileManager fileManager) {
        assert (adjustMemBudget == (this.budget != null));
        DbFileSummary summary = this.map.get(fileNum);
        if (summary == null && (!checkResurrected || fileNum >= fileManager.getCurrentFileNum() || fileManager.isFileValid(fileNum))) {
            summary = new DbFileSummary();
            DbFileSummary oldVal = this.map.put(fileNum, summary);
            assert (oldVal == null);
            this.memSize += FILE_ENTRY_OVERHEAD;
            if (adjustMemBudget) {
                this.budget.updateTreeAdminMemoryUsage(FILE_ENTRY_OVERHEAD);
            }
            assert (fileManager == null || fileNum.longValue() == fileManager.getCurrentFileNum() || fileManager.isFileValid(fileNum)) : "Resurrected file: 0x" + Long.toHexString(fileNum);
        }
        return summary;
    }

    public boolean remove(Long fileNum) {
        if (this.map.remove(fileNum) != null) {
            this.budget.updateTreeAdminMemoryUsage(0 - FILE_ENTRY_OVERHEAD);
            this.memSize -= FILE_ENTRY_OVERHEAD;
            return true;
        }
        return false;
    }

    public long getMemorySize() {
        return this.memSize;
    }

    public void subtractFromMemoryBudget() {
        if (this.budget != null) {
            this.budget.updateTreeAdminMemoryUsage(0 - this.memSize);
            this.memSize = 0;
        }
    }

    public Set<Map.Entry<Long, DbFileSummary>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public void repair(EnvironmentImpl env) {
        Object[] existingFiles = env.getFileManager().getAllFileNumbers();
        Iterator<Long> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            Long fileNum = iter.next();
            if (Arrays.binarySearch(existingFiles, fileNum) >= 0) continue;
            iter.remove();
            this.budget.updateTreeAdminMemoryUsage(0 - FILE_ENTRY_OVERHEAD);
            this.memSize -= FILE_ENTRY_OVERHEAD;
        }
    }
}

