/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseId
implements Comparable<DatabaseId>,
Loggable {
    private int id;

    public DatabaseId(int id) {
        this.id = id;
    }

    public DatabaseId() {
    }

    public int getId() {
        return this.id;
    }

    public byte[] getBytes() throws DatabaseException {
        try {
            return this.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatabaseId)) {
            return false;
        }
        return ((DatabaseId)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    @Override
    public int compareTo(DatabaseId o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.id == o.id) {
            return 0;
        }
        if (this.id > o.id) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getLogSize() {
        return LogUtils.getPackedIntLogSize(this.id);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedInt(logBuffer, this.id);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) {
        this.id = LogUtils.readInt(itemBuffer, entryVersion < 6);
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<dbId id=\"");
        sb.append(this.id);
        sb.append("\"/>");
    }
}

