/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.APILockedException;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbEnvState;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.NodeSequence;
import com.sleepycat.je.dbi.ReplicatorInstance;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.PrivateEvictor;
import com.sleepycat.je.evictor.SharedEvictor;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LatchedLogManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.SyncedLogManager;
import com.sleepycat.je.log.TraceLogHandler;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.Tracer;
import com.sleepycat.je.utilint.TracerFormatter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentImpl
implements EnvConfigObserver {
    private volatile DbEnvState envState;
    private volatile boolean closing;
    private File envHome;
    private int referenceCount;
    private boolean isTransactional;
    private boolean isNoLocking;
    private boolean isReadOnly;
    private boolean isMemOnly;
    private boolean directNIO;
    private boolean sharedCache;
    private static boolean fairLatches;
    private static boolean useSharedLatchesForINs;
    private boolean dbEviction;
    private MemoryBudget memoryBudget;
    private static int adler32ChunkSize;
    private long lockTimeout;
    private long txnTimeout;
    private DbTree dbMapTree;
    private long mapTreeRootLsn = -1L;
    private Latch mapTreeRootLatch;
    private INList inMemoryINs;
    private DbConfigManager configManager;
    private List<EnvConfigObserver> configObservers;
    private Logger envLogger;
    protected LogManager logManager;
    private FileManager fileManager;
    private TxnManager txnManager;
    private Evictor evictor;
    private INCompressor inCompressor;
    private Checkpointer checkpointer;
    private Cleaner cleaner;
    private ReplicatorInstance repInstance;
    private RecoveryInfo lastRecoveryInfo;
    private RunRecoveryException savedInvalidatingException;
    private static boolean forcedYield;
    private SharedLatch triggerLatch;
    private ExceptionListener exceptionListener = null;
    private volatile int backgroundSleepBacklog;
    private volatile int backgroundReadLimit;
    private volatile int backgroundWriteLimit;
    private long backgroundSleepInterval;
    private int backgroundReadCount;
    private long backgroundWriteBytes;
    private TestHook backgroundSleepHook;
    private Object backgroundTrackingMutex = new Object();
    private Object backgroundSleepMutex = new Object();
    private static int threadLocalReferenceCount;
    private static boolean noComparators;
    public final RunRecoveryException SAVED_RRE = DbInternal.makeNoArgsRRE();
    public static final boolean USE_JAVA5_ADLER32;
    public static final boolean IS_DALVIK;
    public static final boolean IS_WINDOWS_7;
    private int lockoutTimeout;
    private Long apiLockNodeId;
    private NodeSequence nodeSequence;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentImpl(File envHome, EnvironmentConfig envConfig, EnvironmentImpl sharedCacheEnv, boolean replicationIntended) throws DatabaseException {
        boolean success = false;
        try {
            this.envHome = envHome;
            this.envState = DbEnvState.INIT;
            this.mapTreeRootLatch = new Latch("MapTreeRoot");
            this.configManager = new DbConfigManager(envConfig);
            this.configObservers = new ArrayList<EnvConfigObserver>();
            this.addConfigObserver(this);
            this.envLogger = this.initLogger(envHome);
            forcedYield = this.configManager.getBoolean(EnvironmentParams.ENV_FORCED_YIELD);
            this.isTransactional = this.configManager.getBoolean(EnvironmentParams.ENV_INIT_TXN);
            boolean bl = this.isNoLocking = !this.configManager.getBoolean(EnvironmentParams.ENV_INIT_LOCKING);
            if (this.isTransactional && this.isNoLocking) {
                throw new IllegalArgumentException("Can't set 'je.env.isNoLocking' and 'je.env.isTransactional';");
            }
            this.directNIO = false;
            fairLatches = this.configManager.getBoolean(EnvironmentParams.ENV_FAIR_LATCHES);
            this.isReadOnly = this.configManager.getBoolean(EnvironmentParams.ENV_RDONLY);
            this.isMemOnly = this.configManager.getBoolean(EnvironmentParams.LOG_MEMORY_ONLY);
            useSharedLatchesForINs = this.configManager.getBoolean(EnvironmentParams.ENV_SHARED_LATCHES);
            this.dbEviction = this.configManager.getBoolean(EnvironmentParams.ENV_DB_EVICTION);
            adler32ChunkSize = this.configManager.getInt(EnvironmentParams.ADLER32_CHUNK_SIZE);
            this.sharedCache = this.configManager.getBoolean(EnvironmentParams.ENV_SHARED_CACHE);
            this.memoryBudget = new MemoryBudget(this, sharedCacheEnv, this.configManager);
            this.fileManager = new FileManager(this, envHome, this.isReadOnly);
            if (!envConfig.getAllowCreate() && !this.fileManager.filesExist()) {
                throw new DatabaseException("Environment.setAllowCreate is false so environment  creation is not permitted, but there is no  pre-existing environment in " + envHome);
            }
            this.logManager = fairLatches ? new LatchedLogManager(this, this.isReadOnly) : new SyncedLogManager(this, this.isReadOnly);
            this.inMemoryINs = new INList(this);
            this.txnManager = new TxnManager(this);
            this.createDaemons(sharedCacheEnv);
            this.nodeSequence = new NodeSequence();
            this.nodeSequence.initTransientNodeId();
            this.dbMapTree = new DbTree(this, replicationIntended);
            this.referenceCount = 0;
            this.triggerLatch = new SharedLatch("TriggerLatch");
            this.nodeSequence.initRealNodeId();
            if (this.configManager.getBoolean(EnvironmentParams.ENV_RECOVERY)) {
                try {
                    RecoveryManager recoveryManager = new RecoveryManager(this);
                    this.lastRecoveryInfo = recoveryManager.recover(this.isReadOnly, replicationIntended);
                }
                finally {
                    try {
                        this.logManager.flush();
                        this.fileManager.clear();
                    }
                    catch (IOException e) {
                        throw new DatabaseException(e.getMessage());
                    }
                }
            }
            this.isReadOnly = true;
            noComparators = true;
            this.lockTimeout = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.LOCK_TIMEOUT));
            this.txnTimeout = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.TXN_TIMEOUT));
            this.memoryBudget.initCacheMemoryUsage(this.dbMapTree.getTreeAdminMemory());
            this.open();
            this.envConfigUpdate(this.configManager, envConfig);
            success = true;
        }
        catch (DatabaseException e) {
            if (this.fileManager != null) {
                try {
                    this.fileManager.clear();
                    this.fileManager.close();
                }
                catch (IOException IOE) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            if (!success && this.sharedCache && this.evictor != null) {
                this.evictor.removeEnvironment(this);
            }
        }
    }

    public void envConfigUpdate(DbConfigManager mgr, EnvironmentMutableConfig newConfig) throws DatabaseException {
        this.backgroundReadLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_READ_LIMIT);
        this.backgroundWriteLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_WRITE_LIMIT);
        this.backgroundSleepInterval = PropUtil.microsToMillis(mgr.getLong(EnvironmentParams.ENV_BACKGROUND_SLEEP_INTERVAL));
        this.lockoutTimeout = mgr.getInt(EnvironmentParams.ENV_LOCKOUT_TIMEOUT);
        this.exceptionListener = newConfig.getExceptionListener();
        this.inCompressor.setExceptionListener(this.exceptionListener);
        this.cleaner.setExceptionListener(this.exceptionListener);
        this.checkpointer.setExceptionListener(this.exceptionListener);
        this.evictor.setExceptionListener(this.exceptionListener);
        this.runOrPauseDaemons(mgr);
    }

    private void createDaemons(EnvironmentImpl sharedCacheEnv) throws DatabaseException {
        if (sharedCacheEnv != null) {
            assert (this.sharedCache);
            this.evictor = sharedCacheEnv.evictor;
        } else {
            this.evictor = this.sharedCache ? new SharedEvictor(this, "SharedEvictor") : new PrivateEvictor(this, "Evictor");
        }
        long checkpointerWakeupTime = Checkpointer.getWakeupPeriod(this.configManager);
        this.checkpointer = new Checkpointer(this, checkpointerWakeupTime, "Checkpointer");
        long compressorWakeupInterval = PropUtil.microsToMillis(this.configManager.getLong(EnvironmentParams.COMPRESSOR_WAKEUP_INTERVAL));
        this.inCompressor = new INCompressor(this, compressorWakeupInterval, "INCompressor");
        this.cleaner = new Cleaner(this, "Cleaner");
    }

    private void runOrPauseDaemons(DbConfigManager mgr) throws DatabaseException {
        if (!this.isReadOnly) {
            this.inCompressor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_INCOMPRESSOR));
            this.cleaner.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CLEANER) && !this.isMemOnly);
            this.checkpointer.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CHECKPOINTER));
        }
        this.evictor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR));
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.cleaner.getUtilizationTracker();
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.cleaner.getUtilizationProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundReads(int nReads) {
        int limit = this.backgroundReadLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundReadCount += nReads;
                if (this.backgroundReadCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundReadCount -= limit;
                    assert (this.backgroundReadCount >= 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundWrites(int writeSize, int logBufferSize) {
        int limit = this.backgroundWriteLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundWriteBytes += (long)writeSize;
                int writeCount = (int)(this.backgroundWriteBytes / (long)logBufferSize);
                if (writeCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundWriteBytes -= (long)(limit * logBufferSize);
                    assert (this.backgroundWriteBytes >= 0L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleepAfterBackgroundIO() {
        if (this.backgroundSleepBacklog > 0) {
            Object object = this.backgroundSleepMutex;
            synchronized (object) {
                try {
                    Thread.sleep(this.backgroundSleepInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                assert (TestHookExecute.doHookIfSet(this.backgroundSleepHook));
            }
            object = this.backgroundTrackingMutex;
            synchronized (object) {
                if (this.backgroundSleepBacklog > 0) {
                    --this.backgroundSleepBacklog;
                }
            }
        }
    }

    public void acquireAPIReadLock(Locker who) throws DatabaseException {
        if (this.apiLockNodeId == null) {
            return;
        }
        try {
            LockResult lr = who.lock(this.apiLockNodeId, LockType.READ, false, null);
            LockGrantType grant = lr.getLockGrant();
            if (grant == LockGrantType.DENIED) {
                throw new APILockedException("API Lock timeout");
            }
            if (grant != LockGrantType.NEW) {
                throw new IllegalMonitorStateException("Read lock was granted, but grant type was " + grant);
            }
        }
        catch (DeadlockException DE) {
            throw new APILockedException("API Lock timeout");
        }
    }

    public boolean releaseAPIReadLock(Locker who) throws DatabaseException {
        if (this.apiLockNodeId == null) {
            return false;
        }
        return who.releaseLock(this.apiLockNodeId);
    }

    public void logMapTreeRoot() throws DatabaseException {
        this.logMapTreeRoot(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMapTreeRoot(long ifBeforeLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            if (ifBeforeLsn == -1L || DbLsn.compareTo(this.mapTreeRootLsn, ifBeforeLsn) < 0) {
                this.mapTreeRootLsn = this.logManager.log(new SingleItemEntry(LogEntryType.LOG_ROOT, this.dbMapTree), ReplicationContext.NO_REPLICATE);
            }
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteMapTreeRoot(long cleanerTargetLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquire();
        try {
            if (DbLsn.compareTo(cleanerTargetLsn, this.mapTreeRootLsn) == 0) {
                this.mapTreeRootLsn = this.logManager.log(new SingleItemEntry(LogEntryType.LOG_ROOT, this.dbMapTree), ReplicationContext.NO_REPLICATE);
            }
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public long getRootLsn() {
        return this.mapTreeRootLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMapTreeFromLog(long rootLsn, boolean replicationIntended) throws DatabaseException {
        if (this.dbMapTree != null) {
            this.dbMapTree.close();
        }
        this.dbMapTree = (DbTree)this.logManager.get(rootLsn);
        this.dbMapTree.initExistingEnvironment(this, replicationIntended);
        this.mapTreeRootLatch.acquire();
        try {
            this.mapTreeRootLsn = rootLsn;
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public void addToCompressorQueue(BIN bin, Key deletedKey, boolean doWakeup) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addBinKeyToQueue(bin, deletedKey, doWakeup);
        }
    }

    public void addToCompressorQueue(BINReference binRef, boolean doWakeup) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addBinRefToQueue(binRef, doWakeup);
        }
    }

    public void addToCompressorQueue(Collection<BINReference> binRefs, boolean doWakeup) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.addMultipleBinRefsToQueue(binRefs, doWakeup);
        }
    }

    public void lazyCompress(IN in, LocalUtilizationTracker localTracker) throws DatabaseException {
        if (this.inCompressor != null) {
            this.inCompressor.lazyCompress(in, localTracker);
        }
    }

    private Logger initLogger(File file) throws DatabaseException {
        StreamHandler streamHandler;
        Logger logger = Logger.getAnonymousLogger();
        logger.setUseParentHandlers(false);
        Level level = Tracer.parseLevel(this, EnvironmentParams.JE_LOGGING_LEVEL);
        logger.setLevel(level);
        if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_CONSOLE)) {
            streamHandler = new ConsoleHandler();
            streamHandler.setFormatter(new TracerFormatter());
            streamHandler.setLevel(level);
            logger.addHandler(streamHandler);
        }
        streamHandler = null;
        try {
            if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_FILE)) {
                int n = this.configManager.getInt(EnvironmentParams.JE_LOGGING_FILE_LIMIT);
                int n2 = this.configManager.getInt(EnvironmentParams.JE_LOGGING_FILE_COUNT);
                String string = file + "/" + "je.info";
                streamHandler = new FileHandler(string, n, n2, true);
                streamHandler.setFormatter(new TracerFormatter());
                streamHandler.setLevel(level);
                logger.addHandler(streamHandler);
            }
        }
        catch (IOException iOException) {
            throw new DatabaseException(iOException.getMessage());
        }
        return logger;
    }

    public void enableDebugLoggingToDbLog() throws DatabaseException {
        if (this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_DBLOG)) {
            TraceLogHandler dbLogHandler = new TraceLogHandler(this);
            Level level = Level.parse(this.configManager.get(EnvironmentParams.JE_LOGGING_LEVEL));
            dbLogHandler.setLevel(level);
            dbLogHandler.setFormatter(new TracerFormatter());
            this.envLogger.addHandler(dbLogHandler);
        }
    }

    public void closeLogger() {
        Handler[] handlers = this.envLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].close();
        }
    }

    public void open() {
        this.envState = DbEnvState.OPEN;
    }

    public void invalidate(RunRecoveryException e) {
        this.savedInvalidatingException = e;
        this.envState = DbEnvState.INVALID;
        this.requestShutdownDaemons();
    }

    public void invalidate(Error e) {
        if (this.SAVED_RRE.getCause() == null) {
            this.savedInvalidatingException = (RunRecoveryException)this.SAVED_RRE.initCause(e);
            this.envState = DbEnvState.INVALID;
            this.requestShutdownDaemons();
        }
    }

    public boolean isOpen() {
        return this.envState == DbEnvState.OPEN;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isClosed() {
        return this.envState == DbEnvState.CLOSED;
    }

    public boolean mayNotWrite() {
        return this.envState == DbEnvState.INVALID || this.envState == DbEnvState.CLOSED;
    }

    public void checkIfInvalid() throws RunRecoveryException {
        if (this.envState == DbEnvState.INVALID) {
            this.savedInvalidatingException.setAlreadyThrown(true);
            if (this.savedInvalidatingException == this.SAVED_RRE) {
                this.savedInvalidatingException.fillInStackTrace();
            }
            throw this.savedInvalidatingException;
        }
    }

    public void checkNotClosed() throws DatabaseException {
        if (this.envState == DbEnvState.CLOSED) {
            throw new DatabaseException("Attempt to use a Environment that has been closed.");
        }
    }

    public void close() throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironment(this, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doClose(boolean bl, boolean bl2) throws DatabaseException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            Tracer.trace(Level.FINE, this, "Close of environment " + this.envHome + " started");
            this.envState.checkState(DbEnvState.VALID_FOR_CLOSE, DbEnvState.CLOSED);
            this.requestShutdownDaemons();
            if (bl && !this.isReadOnly && this.envState != DbEnvState.INVALID && this.logManager.getLastLsnAtRecovery() != this.fileManager.getLastUsedLsn()) {
                CheckpointConfig checkpointConfig = new CheckpointConfig();
                checkpointConfig.setForce(true);
                checkpointConfig.setMinimizeRecoveryTime(true);
                try {
                    this.invokeCheckpoint(checkpointConfig, false, "close");
                }
                catch (DatabaseException databaseException) {
                    printWriter.append("\nException performing checkpoint: ");
                    databaseException.printStackTrace(printWriter);
                    printWriter.println();
                }
            }
            Tracer.trace(Level.FINE, this, "About to shutdown daemons for Env " + this.envHome);
            try {
                this.shutdownDaemons();
            }
            catch (InterruptedException interruptedException) {
                printWriter.append("\nException shutting down daemon threads: ");
                interruptedException.printStackTrace(printWriter);
                printWriter.println();
            }
            try {
                this.logManager.flush();
            }
            catch (DatabaseException databaseException) {
                printWriter.append("\nException flushing log manager: ");
                databaseException.printStackTrace(printWriter);
                printWriter.println();
            }
            try {
                this.fileManager.clear();
            }
            catch (IOException iOException) {
                printWriter.append("\nException clearing file manager: ");
                iOException.printStackTrace(printWriter);
                printWriter.println();
            }
            catch (DatabaseException databaseException) {
                printWriter.append("\nException clearing file manager: ");
                databaseException.printStackTrace(printWriter);
                printWriter.println();
            }
            try {
                this.fileManager.close();
            }
            catch (IOException iOException) {
                printWriter.append("\nException closing file manager: ");
                iOException.printStackTrace(printWriter);
                printWriter.println();
            }
            catch (DatabaseException databaseException) {
                printWriter.append("\nException closing file manager: ");
                databaseException.printStackTrace(printWriter);
                printWriter.println();
            }
            this.dbMapTree.close();
            this.cleaner.close();
            try {
                this.inMemoryINs.clear();
            }
            catch (DatabaseException databaseException) {
                printWriter.append("\nException clearing the INList: ");
                databaseException.printStackTrace(printWriter);
                printWriter.println();
            }
            this.closeLogger();
            if (bl2 && this.envState != DbEnvState.INVALID) {
                try {
                    this.checkLeaks();
                }
                catch (DatabaseException databaseException) {
                    printWriter.append("\nException performing validity checks: ");
                    databaseException.printStackTrace(printWriter);
                    printWriter.println();
                }
            }
        }
        finally {
            this.envState = DbEnvState.CLOSED;
        }
        if (stringWriter.getBuffer().length() > 0 && this.savedInvalidatingException == null) {
            throw new RunRecoveryException(this, stringWriter.toString());
        }
    }

    public void closeAfterRunRecovery() throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironmentAfterRunRecovery(this);
    }

    synchronized void doCloseAfterRunRecovery() {
        try {
            this.shutdownDaemons();
        }
        catch (InterruptedException IE) {
            // empty catch block
        }
        try {
            this.fileManager.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.fileManager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void incReferenceCount() {
        ++this.referenceCount;
    }

    synchronized boolean decReferenceCount() {
        return --this.referenceCount <= 0;
    }

    public static int getThreadLocalReferenceCount() {
        return threadLocalReferenceCount;
    }

    public static boolean getNoComparators() {
        return noComparators;
    }

    private void checkLeaks() throws DatabaseException {
        long l;
        TransactionStats transactionStats;
        if (!this.configManager.getBoolean(EnvironmentParams.ENV_CHECK_LEAKS)) {
            return;
        }
        boolean bl = true;
        StatsConfig statsConfig = new StatsConfig();
        statsConfig.setFast(false);
        LockStats lockStats = this.lockStat(statsConfig);
        if (lockStats.getNTotalLocks() != 0) {
            bl = false;
            System.err.println("Problem: " + lockStats.getNTotalLocks() + " locks left");
            this.txnManager.getLockManager().dump();
        }
        if ((transactionStats = this.txnStat(statsConfig)).getNActive() != 0) {
            bl = false;
            System.err.println("Problem: " + transactionStats.getNActive() + " txns left");
            TransactionStats.Active[] activeArray = transactionStats.getActiveTxns();
            if (activeArray != null) {
                for (int i = 0; i < activeArray.length; ++i) {
                    System.err.println(activeArray[i]);
                }
            }
        }
        if (LatchSupport.countLatchesHeld() > 0) {
            bl = false;
            System.err.println("Some latches held at env close.");
            LatchSupport.dumpLatchesHeld();
        }
        if ((l = this.memoryBudget.getVariableCacheUsage()) != 0L) {
            bl = false;
            System.err.println("Local Cache Usage = " + l);
            System.err.println("Tree Memory Usage = " + this.memoryBudget.getTreeMemoryUsage());
            System.err.println("Admin Memory Usage = " + this.memoryBudget.getAdminMemoryUsage());
            System.err.println("Tree Admin Memory Usage = " + this.memoryBudget.getTreeAdminMemoryUsage());
            System.err.println("Lock Memory Usage = " + this.memoryBudget.getLockMemoryUsage());
            EnvironmentStats environmentStats = new EnvironmentStats();
            this.memoryBudget.loadStats(new StatsConfig(), environmentStats);
            System.err.println(environmentStats);
        }
        boolean bl2 = false;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!bl && bl2) {
            throw new DatabaseException("Lock, transaction, latch or memory left behind at environment close");
        }
    }

    public boolean invokeCheckpoint(CheckpointConfig config, boolean flushAll, String invokingSource) throws DatabaseException {
        if (this.checkpointer != null) {
            this.checkpointer.doCheckpoint(config, flushAll, invokingSource);
            return true;
        }
        return false;
    }

    public void invokeEvictor() throws DatabaseException {
        if (this.evictor != null) {
            this.evictor.doEvict("manual");
        }
    }

    public int invokeCleaner() throws DatabaseException {
        if (this.isReadOnly || this.isMemOnly) {
            throw new IllegalStateException("Log cleaning not allowed in a read-only or memory-only environment");
        }
        if (this.cleaner != null) {
            return this.cleaner.doClean(true, false);
        }
        return 0;
    }

    private void requestShutdownDaemons() {
        this.closing = true;
        if (this.inCompressor != null) {
            this.inCompressor.requestShutdown();
        }
        if (this.evictor != null && !this.sharedCache) {
            this.evictor.requestShutdown();
        }
        if (this.checkpointer != null) {
            this.checkpointer.requestShutdown();
        }
        if (this.cleaner != null) {
            this.cleaner.requestShutdown();
        }
    }

    private void shutdownDaemons() throws InterruptedException {
        this.shutdownINCompressor();
        this.shutdownCleaner();
        this.shutdownCheckpointer();
        this.shutdownEvictor();
    }

    void shutdownINCompressor() throws InterruptedException {
        if (this.inCompressor != null) {
            this.inCompressor.shutdown();
            this.inCompressor.clearEnv();
            this.inCompressor = null;
        }
    }

    void shutdownEvictor() throws InterruptedException {
        if (this.evictor != null) {
            if (this.sharedCache) {
                this.evictor.removeEnvironment(this);
            } else {
                this.evictor.shutdown();
                this.evictor.clearEnv();
                this.evictor = null;
            }
        }
    }

    void shutdownCheckpointer() throws InterruptedException {
        if (this.checkpointer != null) {
            this.checkpointer.shutdown();
            this.checkpointer.clearEnv();
            this.checkpointer = null;
        }
    }

    public void shutdownCleaner() throws InterruptedException {
        if (this.cleaner != null) {
            this.cleaner.shutdown();
        }
    }

    public boolean isNoLocking() {
        return this.isNoLocking;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isMemOnly() {
        return this.isMemOnly;
    }

    public static boolean getFairLatches() {
        return fairLatches;
    }

    public static boolean getSharedLatches() {
        return useSharedLatchesForINs;
    }

    public boolean getDbEviction() {
        return this.dbEviction;
    }

    public static int getAdler32ChunkSize() {
        return adler32ChunkSize;
    }

    public boolean getSharedCache() {
        return this.sharedCache;
    }

    public Txn txnBegin(Transaction transaction, TransactionConfig transactionConfig) throws DatabaseException {
        if (!this.isTransactional) {
            throw new UnsupportedOperationException("beginTransaction called,  but Environment was not opened with transactional capabilities");
        }
        return this.txnManager.txnBegin(transaction, transactionConfig);
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public DbTree getDbTree() {
        return this.dbMapTree;
    }

    public DbConfigManager getConfigManager() {
        return this.configManager;
    }

    public NodeSequence getNodeSequence() {
        return this.nodeSequence;
    }

    public EnvironmentConfig cloneConfig() {
        return DbInternal.cloneConfig(this.configManager.getEnvironmentConfig());
    }

    public void checkImmutablePropsForEquality(EnvironmentConfig config) throws IllegalArgumentException {
        DbInternal.checkImmutablePropsForEquality(this.configManager.getEnvironmentConfig(), config);
    }

    public synchronized void addConfigObserver(EnvConfigObserver o) {
        this.configObservers.add(o);
    }

    public INList getInMemoryINs() {
        return this.inMemoryINs;
    }

    public TxnManager getTxnManager() {
        return this.txnManager;
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    public MemoryBudget getMemoryBudget() {
        return this.memoryBudget;
    }

    public Logger getLogger() {
        return this.envLogger;
    }

    public synchronized LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.lockStat(config);
    }

    public synchronized TransactionStats txnStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.txnStat(config);
    }

    public File getEnvironmentHome() {
        return this.envHome;
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public SharedLatch getTriggerLatch() {
        return this.triggerLatch;
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    void alertEvictor() {
        if (this.evictor != null) {
            this.evictor.alert();
        }
    }

    public boolean isReplicated() {
        return this.repInstance != null;
    }

    public ReplicatorInstance getReplicator() {
        return this.repInstance;
    }

    public static boolean maybeForceYield() {
        if (forcedYield) {
            Thread.yield();
        }
        return true;
    }

    static {
        forcedYield = false;
        threadLocalReferenceCount = 0;
        noComparators = false;
        USE_JAVA5_ADLER32 = System.getProperty("je.disable.java.adler32") == null;
        IS_DALVIK = "Dalvik".equals(System.getProperty("java.vm.name"));
        String string = System.getProperty("os.name");
        IS_WINDOWS_7 = string != null && string.startsWith("Windows 7");
    }
}

