/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.Tracer;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryBudget
implements EnvConfigObserver {
    public static boolean CLEANUP_DONE = false;
    public static boolean DEBUG_ADMIN = Boolean.getBoolean("memAdmin");
    public static boolean DEBUG_LOCK = Boolean.getBoolean("memLock");
    public static boolean DEBUG_TXN = Boolean.getBoolean("memTxn");
    public static boolean DEBUG_TREEADMIN = Boolean.getBoolean("memTreeAdmin");
    public static boolean DEBUG_TREE = Boolean.getBoolean("memTree");
    public static final int LONG_OVERHEAD;
    public static final int ARRAY_OVERHEAD;
    public static final int ARRAY_SIZE_INCLUDED;
    public static final int OBJECT_OVERHEAD;
    public static final int OBJECT_ARRAY_ITEM_OVERHEAD;
    public static final int HASHMAP_OVERHEAD;
    public static final int HASHMAP_ENTRY_OVERHEAD;
    public static final int HASHSET_OVERHEAD;
    public static final int HASHSET_ENTRY_OVERHEAD;
    public static final int TWOHASHMAPS_OVERHEAD;
    public static final int TREEMAP_OVERHEAD;
    public static final int TREEMAP_ENTRY_OVERHEAD;
    public static final int MAPLN_OVERHEAD;
    public static final int LN_OVERHEAD;
    public static final int DUPCOUNTLN_OVERHEAD;
    public static final int BIN_FIXED_OVERHEAD;
    public static final int DIN_FIXED_OVERHEAD;
    public static final int DBIN_FIXED_OVERHEAD;
    public static final int IN_FIXED_OVERHEAD;
    public static final int KEY_OVERHEAD;
    public static final int LOCKIMPL_OVERHEAD;
    public static final int THINLOCKIMPL_OVERHEAD;
    public static final int LOCKINFO_OVERHEAD;
    public static final int WRITE_LOCKINFO_OVERHEAD;
    public static final int TXN_OVERHEAD;
    public static final int CHECKPOINT_REFERENCE_SIZE;
    public static final int UTILIZATION_PROFILE_ENTRY;
    public static final int DBFILESUMMARY_OVERHEAD;
    public static final int TFS_LIST_INITIAL_OVERHEAD;
    public static final int TFS_LIST_SEGMENT_OVERHEAD;
    public static final int LN_INFO_OVERHEAD;
    public static final int FILESUMMARYLN_OVERHEAD;
    public static final int LONG_LIST_PER_ITEM_OVERHEAD;
    public static final String MIN_MAX_MEMORY_SIZE_STRING;
    private AtomicLong treeMemoryUsage = new AtomicLong(0L);
    private AtomicLong txnMemoryUsage = new AtomicLong(0L);
    private AtomicLong adminMemoryUsage = new AtomicLong(0L);
    private AtomicLong treeAdminMemoryUsage = new AtomicLong(0L);
    private int nLockTables;
    private AtomicLong[] lockMemoryUsage;
    private Totals totals;
    private long logBufferBudget;
    private long trackerBudget;
    private long minTreeMemoryUsage;
    private long inOverhead;
    private long binOverhead;
    private long dinOverhead;
    private long dbinOverhead;
    private EnvironmentImpl envImpl;

    MemoryBudget(EnvironmentImpl envImpl, EnvironmentImpl sharedCacheEnv, DbConfigManager configManager) throws DatabaseException {
        long newMaxMemory;
        this.envImpl = envImpl;
        envImpl.addConfigObserver(this);
        if (envImpl.getSharedCache()) {
            if (sharedCacheEnv != null) {
                this.totals = sharedCacheEnv.getMemoryBudget().totals;
                newMaxMemory = -1L;
            } else {
                this.totals = new SharedTotals();
                newMaxMemory = this.calcMaxMemory(configManager);
            }
        } else {
            this.totals = new PrivateTotals(this);
            newMaxMemory = this.calcMaxMemory(configManager);
        }
        this.reset(newMaxMemory, true, configManager);
        this.inOverhead = IN.computeOverhead(configManager);
        this.binOverhead = BIN.computeOverhead(configManager);
        this.dinOverhead = DIN.computeOverhead(configManager);
        this.dbinOverhead = DBIN.computeOverhead(configManager);
    }

    private long calcMaxMemory(DbConfigManager configManager) throws DatabaseException {
        long newMaxMemory = configManager.getLong(EnvironmentParams.MAX_MEMORY);
        long jvmMemory = MemoryBudget.getRuntimeMaxMemory();
        if (newMaxMemory != 0L) {
            if (jvmMemory < newMaxMemory) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " has a value of " + newMaxMemory + " but the JVM is only configured for " + jvmMemory + ". Consider using je.maxMemoryPercent.");
            }
            if (newMaxMemory < 98304L) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " is " + newMaxMemory + " which is less than the minimum: " + 98304L);
            }
        } else {
            if (jvmMemory == Long.MAX_VALUE) {
                jvmMemory = 0x4000000L;
            }
            int maxMemoryPercent = configManager.getInt(EnvironmentParams.MAX_MEMORY_PERCENT);
            newMaxMemory = (long)maxMemoryPercent * jvmMemory / 100L;
        }
        return newMaxMemory;
    }

    void reset(long newMaxMemory, boolean newEnv, DbConfigManager configManager) throws DatabaseException {
        long myCachePortion;
        long oldLogBufferBudget = this.logBufferBudget;
        if (newMaxMemory < 0L) {
            newMaxMemory = this.getMaxMemory();
        } else {
            this.totals.setMaxMemory(newMaxMemory);
        }
        if (this.envImpl.getSharedCache()) {
            int nEnvs = DbEnvPool.getInstance().getNSharedCacheEnvironments();
            if (newEnv) {
                ++nEnvs;
            }
            myCachePortion = newMaxMemory / (long)nEnvs;
        } else {
            myCachePortion = newMaxMemory;
        }
        long newLogBufferBudget = configManager.getLong(EnvironmentParams.LOG_MEM_SIZE);
        if (newLogBufferBudget == 0L) {
            newLogBufferBudget = EnvironmentImpl.IS_DALVIK ? myCachePortion >> 7 : myCachePortion >> 4;
        } else if (newLogBufferBudget > myCachePortion / 2L) {
            newLogBufferBudget = myCachePortion / 2L;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long startingBufferSize = newLogBufferBudget / (long)numBuffers;
        int logBufferSize = configManager.getInt(EnvironmentParams.LOG_BUFFER_MAX_SIZE);
        if (startingBufferSize > (long)logBufferSize) {
            startingBufferSize = logBufferSize;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        } else if (startingBufferSize < 2048L) {
            startingBufferSize = 2048L;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        }
        long newCriticalThreshold = newMaxMemory * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.EVICTOR_CRITICAL_PERCENTAGE) / 100L;
        long newTrackerBudget = myCachePortion * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE) / 100L;
        long newMinTreeMemoryUsage = Math.min(configManager.getLong(EnvironmentParams.MIN_TREE_MEMORY), myCachePortion - newLogBufferBudget);
        this.logBufferBudget = newLogBufferBudget;
        this.totals.setCriticalThreshold(newCriticalThreshold);
        this.trackerBudget = newTrackerBudget;
        if (this.lockMemoryUsage == null) {
            this.nLockTables = configManager.getInt(EnvironmentParams.N_LOCK_TABLES);
            this.lockMemoryUsage = new AtomicLong[this.nLockTables];
            for (int i = 0; i < this.nLockTables; ++i) {
                this.lockMemoryUsage[i] = new AtomicLong(0L);
            }
        }
        this.minTreeMemoryUsage = newMinTreeMemoryUsage;
        this.totals.updateCacheUsage(this.logBufferBudget - oldLogBufferBudget);
        if (!newEnv && oldLogBufferBudget != this.logBufferBudget) {
            this.envImpl.getLogManager().resetPool(configManager);
        }
    }

    public static long getRuntimeMaxMemory() {
        String jvmVersion;
        if ("Mac OS X".equals(System.getProperty("os.name")) && (jvmVersion = System.getProperty("java.version")) != null && jvmVersion.startsWith("1.4.2")) {
            return Long.MAX_VALUE;
        }
        return Runtime.getRuntime().maxMemory();
    }

    void initCacheMemoryUsage(long dbTreeAdminMemory) throws DatabaseException {
        long totalTree = 0L;
        long treeAdmin = 0L;
        for (IN in : this.envImpl.getInMemoryINs()) {
            totalTree += in.getBudgetedMemorySize();
            treeAdmin += in.getTreeAdminMemorySize();
        }
        this.refreshTreeMemoryUsage(totalTree);
        this.refreshTreeAdminMemoryUsage(treeAdmin + dbTreeAdminMemory);
    }

    void refreshTreeAdminMemoryUsage(long newSize) {
        long oldSize = this.treeAdminMemoryUsage.getAndSet(newSize);
        long diff = newSize - oldSize;
        if (DEBUG_TREEADMIN) {
            System.err.println("RESET = " + newSize);
        }
        if (this.totals.updateCacheUsage(diff)) {
            this.envImpl.alertEvictor();
        }
    }

    void refreshTreeMemoryUsage(long newSize) {
        long oldSize = this.treeMemoryUsage.getAndSet(newSize);
        long diff = newSize - oldSize;
        if (this.totals.updateCacheUsage(diff)) {
            this.envImpl.alertEvictor();
        }
    }

    public boolean isTreeUsageAboveMinimum() {
        return this.treeMemoryUsage.get() > this.minTreeMemoryUsage;
    }

    public void updateTreeMemoryUsage(long increment) {
        this.updateCounter(increment, this.treeMemoryUsage, "tree", DEBUG_TREE);
    }

    public void updateTxnMemoryUsage(long increment) {
        this.updateCounter(increment, this.txnMemoryUsage, "txn", DEBUG_TXN);
    }

    public void updateAdminMemoryUsage(long increment) {
        this.updateCounter(increment, this.adminMemoryUsage, "admin", DEBUG_ADMIN);
    }

    public void updateTreeAdminMemoryUsage(long increment) {
        this.updateCounter(increment, this.treeAdminMemoryUsage, "treeAdmin", DEBUG_TREEADMIN);
    }

    private void updateCounter(long increment, AtomicLong counter, String debugName, boolean debug) {
        if (increment != 0L) {
            long newSize = counter.addAndGet(increment);
            assert (this.sizeNotNegative(newSize)) : this.makeErrorMessage(debugName, newSize, increment);
            if (debug) {
                if (increment > 0L) {
                    System.err.println("INC-------- =" + increment + " " + debugName + " " + newSize);
                } else {
                    System.err.println("-------DEC=" + increment + " " + debugName + " " + newSize);
                }
            }
            if (this.totals.updateCacheUsage(increment)) {
                this.envImpl.alertEvictor();
            }
        }
    }

    private boolean sizeNotNegative(long newSize) {
        if (CLEANUP_DONE) {
            return newSize >= 0L;
        }
        return true;
    }

    public void updateLockMemoryUsage(long increment, int lockTableIndex) {
        if (increment != 0L) {
            this.lockMemoryUsage[lockTableIndex].addAndGet(increment);
            assert (this.lockMemoryUsage[lockTableIndex].get() >= 0L) : this.makeErrorMessage("lockMem", this.lockMemoryUsage[lockTableIndex].get(), increment);
            if (DEBUG_LOCK) {
                if (increment > 0L) {
                    System.err.println("INC-------- =" + increment + " lock[" + lockTableIndex + "] " + this.lockMemoryUsage[lockTableIndex].get());
                } else {
                    System.err.println("-------DEC=" + increment + " lock[" + lockTableIndex + "] " + this.lockMemoryUsage[lockTableIndex].get());
                }
            }
            if (this.totals.updateCacheUsage(increment)) {
                this.envImpl.alertEvictor();
            }
        }
    }

    private String makeErrorMessage(String memoryType, long total, long increment) {
        return memoryType + "=" + total + " increment=" + increment + " " + Tracer.getStackTrace(new Throwable());
    }

    void subtractCacheUsage() {
        this.totals.updateCacheUsage(0L - this.getLocalCacheUsage());
    }

    private long getLocalCacheUsage() {
        return this.logBufferBudget + this.treeMemoryUsage.get() + this.adminMemoryUsage.get() + this.treeAdminMemoryUsage.get() + this.getLockMemoryUsage();
    }

    long getVariableCacheUsage() {
        return this.treeMemoryUsage.get() + this.adminMemoryUsage.get() + this.treeAdminMemoryUsage.get() + this.getLockMemoryUsage();
    }

    public long getLockMemoryUsage() {
        long accLockMemoryUsage = this.txnMemoryUsage.get();
        if (this.nLockTables == 1) {
            accLockMemoryUsage += this.lockMemoryUsage[0].get();
        } else {
            for (int i = 0; i < this.nLockTables; ++i) {
                accLockMemoryUsage += this.lockMemoryUsage[i].get();
            }
        }
        return accLockMemoryUsage;
    }

    public long getMaxMemory() {
        return this.totals.getMaxMemory();
    }

    public long getTreeMemoryUsage() {
        return this.treeMemoryUsage.get();
    }

    public long getAdminMemoryUsage() {
        return this.adminMemoryUsage.get();
    }

    public long getTreeAdminMemoryUsage() {
        return this.treeAdminMemoryUsage.get();
    }

    public long getLogBufferBudget() {
        return this.logBufferBudget;
    }

    public long getTrackerBudget() {
        return this.trackerBudget;
    }

    public long getINOverhead() {
        return this.inOverhead;
    }

    public long getBINOverhead() {
        return this.binOverhead;
    }

    public long getDINOverhead() {
        return this.dinOverhead;
    }

    public long getDBINOverhead() {
        return this.dbinOverhead;
    }

    public static int byteArraySize(int arrayLen) {
        int size = ARRAY_OVERHEAD;
        if (arrayLen > ARRAY_SIZE_INCLUDED) {
            size += (arrayLen - ARRAY_SIZE_INCLUDED + 7) / 8 * 8;
        }
        return size;
    }

    public static int shortArraySize(int arrayLen) {
        return MemoryBudget.byteArraySize(arrayLen * 2);
    }

    void loadStats(StatsConfig config, EnvironmentStats stats) {
        stats.setSharedCacheTotalBytes(this.totals.isSharedCache() ? this.totals.getCacheUsage() : 0L);
        stats.setCacheTotalBytes(this.getLocalCacheUsage());
        stats.setDataBytes(this.treeMemoryUsage.get() + this.treeAdminMemoryUsage.get());
        stats.setAdminBytes(this.adminMemoryUsage.get());
        stats.setLockBytes(this.getLockMemoryUsage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("treeUsage = ").append(this.treeMemoryUsage.get());
        sb.append("treeAdminUsage = ").append(this.treeAdminMemoryUsage.get());
        sb.append("adminUsage = ").append(this.adminMemoryUsage.get());
        sb.append("txnUsage = ").append(this.txnMemoryUsage.get());
        sb.append("lockUsage = ").append(this.getLockMemoryUsage());
        return sb.toString();
    }

    public Totals getTotals() {
        return this.totals;
    }

    static {
        if (EnvironmentImpl.IS_DALVIK) {
            LONG_OVERHEAD = 24;
            ARRAY_OVERHEAD = 24;
            ARRAY_SIZE_INCLUDED = 4;
            OBJECT_OVERHEAD = 16;
            OBJECT_ARRAY_ITEM_OVERHEAD = 4;
            HASHMAP_OVERHEAD = 128;
            HASHMAP_ENTRY_OVERHEAD = 32;
            HASHSET_OVERHEAD = 144;
            HASHSET_ENTRY_OVERHEAD = 32;
            TWOHASHMAPS_OVERHEAD = 256;
            TREEMAP_OVERHEAD = 40;
            TREEMAP_ENTRY_OVERHEAD = 40;
            MAPLN_OVERHEAD = 744;
            LN_OVERHEAD = 32;
            DUPCOUNTLN_OVERHEAD = 32;
            BIN_FIXED_OVERHEAD = 458;
            DIN_FIXED_OVERHEAD = 451;
            DBIN_FIXED_OVERHEAD = 458;
            IN_FIXED_OVERHEAD = 402;
            KEY_OVERHEAD = 16;
            LOCKIMPL_OVERHEAD = 32;
            THINLOCKIMPL_OVERHEAD = 24;
            LOCKINFO_OVERHEAD = 24;
            WRITE_LOCKINFO_OVERHEAD = 40;
            TXN_OVERHEAD = 218;
            CHECKPOINT_REFERENCE_SIZE = 40;
            UTILIZATION_PROFILE_ENTRY = 124;
            DBFILESUMMARY_OVERHEAD = 48;
            TFS_LIST_INITIAL_OVERHEAD = 472;
            TFS_LIST_SEGMENT_OVERHEAD = 448;
            LN_INFO_OVERHEAD = 32;
            FILESUMMARYLN_OVERHEAD = 136;
            LONG_LIST_PER_ITEM_OVERHEAD = 30;
        } else {
            String string = System.getProperty("java.version");
            boolean bl = string != null && string.startsWith("1.5.");
            boolean bl2 = false;
            String string2 = System.getProperty("je.forceJVMArch");
            try {
                if (string2 == null) {
                    String string3 = System.getProperty("sun.arch.data.model");
                    if (string3 != null) {
                        bl2 = Integer.parseInt(string3) == 64;
                    }
                } else {
                    bl2 = Integer.parseInt(string2) == 64;
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.err);
            }
            if (bl2) {
                LONG_OVERHEAD = 24;
                ARRAY_OVERHEAD = 24;
                ARRAY_SIZE_INCLUDED = 0;
                OBJECT_OVERHEAD = 16;
                OBJECT_ARRAY_ITEM_OVERHEAD = 8;
                HASHMAP_ENTRY_OVERHEAD = 55;
                HASHSET_OVERHEAD = 240;
                HASHSET_ENTRY_OVERHEAD = 55;
                if (bl) {
                    TREEMAP_OVERHEAD = 64;
                    MAPLN_OVERHEAD = 1096;
                    BIN_FIXED_OVERHEAD = 544;
                    DIN_FIXED_OVERHEAD = 552;
                    DBIN_FIXED_OVERHEAD = 560;
                    IN_FIXED_OVERHEAD = 488;
                    HASHMAP_OVERHEAD = 216;
                    TWOHASHMAPS_OVERHEAD = 432;
                } else {
                    TREEMAP_OVERHEAD = 80;
                    MAPLN_OVERHEAD = 1136;
                    BIN_FIXED_OVERHEAD = 584;
                    DIN_FIXED_OVERHEAD = 596;
                    DBIN_FIXED_OVERHEAD = 600;
                    IN_FIXED_OVERHEAD = 528;
                    HASHMAP_OVERHEAD = 218;
                    TWOHASHMAPS_OVERHEAD = 436;
                }
                TREEMAP_ENTRY_OVERHEAD = 64;
                LN_OVERHEAD = 40;
                DUPCOUNTLN_OVERHEAD = 48;
                TXN_OVERHEAD = 281;
                CHECKPOINT_REFERENCE_SIZE = 111;
                KEY_OVERHEAD = 24;
                LOCKIMPL_OVERHEAD = 48;
                THINLOCKIMPL_OVERHEAD = 32;
                LOCKINFO_OVERHEAD = 32;
                WRITE_LOCKINFO_OVERHEAD = 40;
                UTILIZATION_PROFILE_ENTRY = 153;
                DBFILESUMMARY_OVERHEAD = 48;
                TFS_LIST_INITIAL_OVERHEAD = 504;
                TFS_LIST_SEGMENT_OVERHEAD = 465;
                LN_INFO_OVERHEAD = 48;
                FILESUMMARYLN_OVERHEAD = 168;
                LONG_LIST_PER_ITEM_OVERHEAD = 32;
            } else {
                LONG_OVERHEAD = 16;
                ARRAY_OVERHEAD = 16;
                ARRAY_SIZE_INCLUDED = 4;
                OBJECT_OVERHEAD = 8;
                OBJECT_ARRAY_ITEM_OVERHEAD = 4;
                HASHMAP_OVERHEAD = 120;
                HASHMAP_ENTRY_OVERHEAD = 24;
                HASHSET_OVERHEAD = 136;
                HASHSET_ENTRY_OVERHEAD = 24;
                TWOHASHMAPS_OVERHEAD = 240;
                if (bl) {
                    TREEMAP_OVERHEAD = 40;
                    MAPLN_OVERHEAD = 640;
                } else {
                    TREEMAP_OVERHEAD = 48;
                    MAPLN_OVERHEAD = 664;
                }
                TREEMAP_ENTRY_OVERHEAD = 32;
                LN_OVERHEAD = 24;
                DUPCOUNTLN_OVERHEAD = 24;
                BIN_FIXED_OVERHEAD = 370;
                DIN_FIXED_OVERHEAD = 377;
                DBIN_FIXED_OVERHEAD = 377;
                IN_FIXED_OVERHEAD = 339;
                TXN_OVERHEAD = 186;
                CHECKPOINT_REFERENCE_SIZE = 64;
                KEY_OVERHEAD = 16;
                LOCKIMPL_OVERHEAD = 24;
                THINLOCKIMPL_OVERHEAD = 16;
                LOCKINFO_OVERHEAD = 16;
                WRITE_LOCKINFO_OVERHEAD = 32;
                UTILIZATION_PROFILE_ENTRY = 101;
                DBFILESUMMARY_OVERHEAD = 40;
                TFS_LIST_INITIAL_OVERHEAD = 464;
                TFS_LIST_SEGMENT_OVERHEAD = 440;
                LN_INFO_OVERHEAD = 24;
                FILESUMMARYLN_OVERHEAD = 112;
                LONG_LIST_PER_ITEM_OVERHEAD = 20;
            }
        }
        MIN_MAX_MEMORY_SIZE_STRING = Long.toString(98304L);
    }

    private static class SharedTotals
    extends Totals {
        private AtomicLong usage = new AtomicLong();

        private SharedTotals() {
        }

        public final long getCacheUsage() {
            return this.usage.get();
        }

        final boolean updateCacheUsage(long increment) {
            return this.usage.addAndGet(increment) > this.maxMemory;
        }

        final boolean isSharedCache() {
            return true;
        }
    }

    private static class PrivateTotals
    extends Totals {
        private MemoryBudget parent;

        private PrivateTotals(MemoryBudget parent) {
            this.parent = parent;
        }

        public final long getCacheUsage() {
            return this.parent.getLocalCacheUsage();
        }

        final boolean updateCacheUsage(long increment) {
            return this.parent.getLocalCacheUsage() > this.maxMemory;
        }

        final boolean isSharedCache() {
            return false;
        }
    }

    public static abstract class Totals {
        long maxMemory = 0L;
        private long criticalThreshold;

        private Totals() {
        }

        private final void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }

        public final long getMaxMemory() {
            return this.maxMemory;
        }

        private final void setCriticalThreshold(long criticalThreshold) {
            this.criticalThreshold = criticalThreshold;
        }

        public final long getCriticalThreshold() {
            return this.criticalThreshold;
        }

        public abstract long getCacheUsage();

        abstract boolean updateCacheUsage(long var1);

        abstract boolean isSharedCache();
    }
}

