/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivateEvictor
extends Evictor {
    private EnvironmentImpl envImpl;
    private Iterator<IN> scanIter;

    public PrivateEvictor(EnvironmentImpl envImpl, String name) throws DatabaseException {
        super(envImpl, name);
        this.envImpl = envImpl;
        this.scanIter = null;
    }

    @Override
    public void onWakeup() throws DatabaseException {
        if (!this.envImpl.isClosed()) {
            super.onWakeup();
        }
    }

    @Override
    public void clearEnv() {
        this.envImpl = null;
    }

    @Override
    public void noteINListChange(int nINs) {
    }

    @Override
    public void addEnvironment(EnvironmentImpl envImpl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEnvironment(EnvironmentImpl envImpl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean checkEnvs(Set<EnvironmentImpl> envs) {
        throw new UnsupportedOperationException();
    }

    @Override
    Logger getLogger() {
        return this.envImpl.getLogger();
    }

    @Override
    long startBatch() throws DatabaseException {
        if (this.scanIter == null) {
            this.scanIter = this.envImpl.getInMemoryINs().iterator();
        }
        return this.envImpl.getUtilizationTracker().evictMemory();
    }

    @Override
    int getMaxINsPerBatch() {
        return this.envImpl.getInMemoryINs().getSize();
    }

    @Override
    IN getNextIN() {
        if (this.envImpl.getMemoryBudget().isTreeUsageAboveMinimum()) {
            if (!this.scanIter.hasNext()) {
                this.scanIter = this.envImpl.getInMemoryINs().iterator();
            }
            return this.scanIter.hasNext() ? this.scanIter.next() : null;
        }
        return null;
    }
}

