/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class CleanerFileReader
extends FileReader {
    private Map<LogEntryType, EntryInfo> targetEntryMap = new HashMap<LogEntryType, EntryInfo>();
    private LogEntry targetLogEntry;
    private byte targetCategory;

    public CleanerFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, Long fileNum) throws IOException, DatabaseException {
        super(env, readBufferSize, true, startLsn, fileNum, -1L, -1L);
        this.addTargetType((byte)1, LogEntryType.LOG_LN_TRANSACTIONAL);
        this.addTargetType((byte)1, LogEntryType.LOG_LN);
        this.addTargetType((byte)1, LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        this.addTargetType((byte)1, LogEntryType.LOG_NAMELN);
        this.addTargetType((byte)1, LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        this.addTargetType((byte)1, LogEntryType.LOG_MAPLN);
        this.addTargetType((byte)1, LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        this.addTargetType((byte)1, LogEntryType.LOG_DEL_DUPLN);
        this.addTargetType((byte)1, LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL);
        this.addTargetType((byte)1, LogEntryType.LOG_DUPCOUNTLN);
        this.addTargetType((byte)1, LogEntryType.LOG_FILESUMMARYLN);
        this.addTargetType((byte)0, LogEntryType.LOG_IN);
        this.addTargetType((byte)0, LogEntryType.LOG_BIN);
        this.addTargetType((byte)0, LogEntryType.LOG_DIN);
        this.addTargetType((byte)0, LogEntryType.LOG_DBIN);
        this.addTargetType((byte)2, LogEntryType.LOG_ROOT);
        this.addTargetType((byte)3, LogEntryType.LOG_FILE_HEADER);
    }

    private void addTargetType(byte category, LogEntryType entryType) throws DatabaseException {
        this.targetEntryMap.put(entryType, new EntryInfo(entryType.getNewLogEntry(), category));
    }

    protected void initStartingPosition(long endOfFileLsn, Long fileNum) throws IOException, DatabaseException {
        this.eof = false;
        this.readBufferFileNum = fileNum;
        this.nextEntryOffset = this.readBufferFileEnd = 0L;
    }

    protected boolean isTargetEntry() {
        LogEntryType fromLogType = new LogEntryType(this.currentEntryHeader.getType());
        EntryInfo info = this.targetEntryMap.get(fromLogType);
        if (info == null) {
            return false;
        }
        this.targetCategory = info.targetCategory;
        this.targetLogEntry = info.targetLogEntry;
        return true;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        this.targetLogEntry.readEntry(this.currentEntryHeader, entryBuffer, true);
        return true;
    }

    public boolean isIN() {
        return this.targetCategory == 0;
    }

    public boolean isLN() {
        return this.targetCategory == 1;
    }

    public boolean isRoot() {
        return this.targetCategory == 2;
    }

    public boolean isFileHeader() {
        return this.targetCategory == 3;
    }

    public LN getLN() {
        return ((LNLogEntry)this.targetLogEntry).getLN();
    }

    public IN getIN() throws DatabaseException {
        return ((INLogEntry)this.targetLogEntry).getIN(this.envImpl);
    }

    public FileHeader getFileHeader() throws DatabaseException {
        return (FileHeader)this.targetLogEntry.getMainItem();
    }

    public DatabaseId getDatabaseId() {
        if (this.targetCategory == 1) {
            return ((LNLogEntry)this.targetLogEntry).getDbId();
        }
        if (this.targetCategory == 0) {
            return ((INLogEntry)this.targetLogEntry).getDbId();
        }
        return null;
    }

    public byte[] getKey() {
        return ((LNLogEntry)this.targetLogEntry).getKey();
    }

    public byte[] getDupTreeKey() {
        return ((LNLogEntry)this.targetLogEntry).getDupKey();
    }

    private static class EntryInfo {
        public LogEntry targetLogEntry;
        public byte targetCategory;

        EntryInfo(LogEntry targetLogEntry, byte targetCategory) {
            this.targetLogEntry = targetLogEntry;
            this.targetCategory = targetCategory;
        }
    }
}

