/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;

public class CheckpointEnd
implements Loggable {
    private String invoker;
    private Timestamp endTime;
    private long checkpointStartLsn;
    private boolean rootLsnExists;
    private long rootLsn;
    private long firstActiveLsn;
    private long lastLocalNodeId;
    private long lastReplicatedNodeId;
    private int lastLocalDbId;
    private int lastReplicatedDbId;
    private long lastLocalTxnId;
    private long lastReplicatedTxnId;
    private long id;

    public CheckpointEnd(String invoker, long checkpointStartLsn, long rootLsn, long firstActiveLsn, long lastLocalNodeId, long lastReplicatedNodeId, int lastLocalDbId, int lastReplicatedDbId, long lastLocalTxnId, long lastReplicatedTxnId, long id) {
        this.invoker = invoker == null ? "" : invoker;
        Calendar cal = Calendar.getInstance();
        this.endTime = new Timestamp(cal.getTime().getTime());
        this.checkpointStartLsn = checkpointStartLsn;
        this.rootLsn = rootLsn;
        this.rootLsnExists = rootLsn != -1L;
        this.firstActiveLsn = firstActiveLsn == -1L ? checkpointStartLsn : firstActiveLsn;
        this.lastLocalNodeId = lastLocalNodeId;
        this.lastReplicatedNodeId = lastReplicatedNodeId;
        this.lastLocalDbId = lastLocalDbId;
        this.lastReplicatedDbId = lastReplicatedDbId;
        this.lastLocalTxnId = lastLocalTxnId;
        this.lastReplicatedTxnId = lastReplicatedTxnId;
        this.id = id;
    }

    public CheckpointEnd() {
        this.checkpointStartLsn = -1L;
        this.rootLsn = -1L;
        this.firstActiveLsn = -1L;
    }

    public int getLogSize() {
        int size = LogUtils.getStringLogSize(this.invoker) + LogUtils.getTimestampLogSize(this.endTime) + LogUtils.getPackedLongLogSize(this.checkpointStartLsn) + 1 + LogUtils.getPackedLongLogSize(this.firstActiveLsn) + LogUtils.getPackedLongLogSize(this.lastLocalNodeId) + LogUtils.getPackedLongLogSize(this.lastReplicatedNodeId) + LogUtils.getPackedIntLogSize(this.lastLocalDbId) + LogUtils.getPackedIntLogSize(this.lastReplicatedDbId) + LogUtils.getPackedLongLogSize(this.lastLocalTxnId) + LogUtils.getPackedLongLogSize(this.lastReplicatedTxnId) + LogUtils.getPackedLongLogSize(this.id);
        if (this.rootLsnExists) {
            size += LogUtils.getPackedLongLogSize(this.rootLsn);
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeString(logBuffer, this.invoker);
        LogUtils.writeTimestamp(logBuffer, this.endTime);
        LogUtils.writePackedLong(logBuffer, this.checkpointStartLsn);
        byte booleans = (byte)(this.rootLsnExists ? 1 : 0);
        logBuffer.put(booleans);
        if (this.rootLsnExists) {
            LogUtils.writePackedLong(logBuffer, this.rootLsn);
        }
        LogUtils.writePackedLong(logBuffer, this.firstActiveLsn);
        LogUtils.writePackedLong(logBuffer, this.lastLocalNodeId);
        LogUtils.writePackedLong(logBuffer, this.lastReplicatedNodeId);
        LogUtils.writePackedInt(logBuffer, this.lastLocalDbId);
        LogUtils.writePackedInt(logBuffer, this.lastReplicatedDbId);
        LogUtils.writePackedLong(logBuffer, this.lastLocalTxnId);
        LogUtils.writePackedLong(logBuffer, this.lastReplicatedTxnId);
        LogUtils.writePackedLong(logBuffer, this.id);
    }

    public void readFromLog(ByteBuffer logBuffer, byte entryVersion) throws LogException {
        boolean version6OrLater = entryVersion >= 6;
        this.invoker = LogUtils.readString(logBuffer, !version6OrLater);
        this.endTime = LogUtils.readTimestamp(logBuffer, !version6OrLater);
        this.checkpointStartLsn = LogUtils.readLong(logBuffer, !version6OrLater);
        byte booleans = logBuffer.get();
        boolean bl = this.rootLsnExists = (booleans & 1) != 0;
        if (this.rootLsnExists) {
            this.rootLsn = LogUtils.readLong(logBuffer, !version6OrLater);
        }
        this.firstActiveLsn = LogUtils.readLong(logBuffer, !version6OrLater);
        this.lastLocalNodeId = LogUtils.readLong(logBuffer, !version6OrLater);
        if (version6OrLater) {
            this.lastReplicatedNodeId = LogUtils.readLong(logBuffer, false);
        }
        this.lastLocalDbId = LogUtils.readInt(logBuffer, !version6OrLater);
        if (version6OrLater) {
            this.lastReplicatedDbId = LogUtils.readInt(logBuffer, false);
        }
        this.lastLocalTxnId = LogUtils.readLong(logBuffer, !version6OrLater);
        if (version6OrLater) {
            this.lastReplicatedTxnId = LogUtils.readLong(logBuffer, false);
        }
        this.id = LogUtils.readLong(logBuffer, !version6OrLater);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<CkptEnd invoker=\"").append(this.invoker);
        sb.append("\" time=\"").append(this.endTime);
        sb.append("\" lastLocalNodeId=\"").append(this.lastLocalNodeId);
        sb.append("\" lastReplicatedNodeId=\"").append(this.lastReplicatedNodeId);
        sb.append("\" lastLocalDbId=\"").append(this.lastLocalDbId);
        sb.append("\" lastReplicatedDbId=\"").append(this.lastReplicatedDbId);
        sb.append("\" lastLocalTxnId=\"").append(this.lastLocalTxnId);
        sb.append("\" lastReplicatedTxnId=\"").append(this.lastReplicatedTxnId);
        sb.append("\" id=\"").append(this.id);
        sb.append("\" rootExists=\"").append(this.rootLsnExists);
        sb.append("\">");
        sb.append("<ckptStart>");
        sb.append(DbLsn.toString(this.checkpointStartLsn));
        sb.append("</ckptStart>");
        if (this.rootLsnExists) {
            sb.append("<root>");
            sb.append(DbLsn.toString(this.rootLsn));
            sb.append("</root>");
        }
        sb.append("<firstActive>");
        sb.append(DbLsn.toString(this.firstActiveLsn));
        sb.append("</firstActive>");
        sb.append("</CkptEnd>");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("time=").append(this.endTime);
        sb.append(" lastLocalNodeId=").append(this.lastLocalNodeId);
        sb.append(" lastReplicatedNodeId=").append(this.lastReplicatedNodeId);
        sb.append(" lastLocalDbId=").append(this.lastLocalDbId);
        sb.append(" lastReplicatedDbId=").append(this.lastReplicatedDbId);
        sb.append(" lastLocalTxnId=").append(this.lastLocalTxnId);
        sb.append(" lastReplicatedTxnId=").append(this.lastReplicatedTxnId);
        sb.append(" id=").append(this.id);
        sb.append(" rootExists=").append(this.rootLsnExists);
        sb.append(" ckptStartLsn=").append(DbLsn.getNoFormatString(this.checkpointStartLsn));
        if (this.rootLsnExists) {
            sb.append(" root=").append(DbLsn.getNoFormatString(this.rootLsn));
        }
        sb.append(" firstActive=").append(DbLsn.getNoFormatString(this.firstActiveLsn));
        return sb.toString();
    }

    long getCheckpointStartLsn() {
        return this.checkpointStartLsn;
    }

    long getRootLsn() {
        return this.rootLsn;
    }

    long getFirstActiveLsn() {
        return this.firstActiveLsn;
    }

    long getLastLocalNodeId() {
        return this.lastLocalNodeId;
    }

    long getLastReplicatedNodeId() {
        return this.lastReplicatedNodeId;
    }

    int getLastLocalDbId() {
        return this.lastLocalDbId;
    }

    int getLastReplicatedDbId() {
        return this.lastReplicatedDbId;
    }

    long getLastLocalTxnId() {
        return this.lastLocalTxnId;
    }

    long getLastReplicatedTxnId() {
        return this.lastReplicatedTxnId;
    }

    long getId() {
        return this.id;
    }
}

