/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.RecoveryUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.CheckpointFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.INFileReader;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.LevelRecorder;
import com.sleepycat.je.recovery.NoRootException;
import com.sleepycat.je.recovery.RecoveryException;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.PreparedTxn;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecoveryManager {
    private EnvironmentImpl env;
    private int readBufferSize;
    private RecoveryInfo info;
    private Map<Long, Long> committedTxnIds;
    private Set<Long> abortedTxnIds;
    private Map<Long, Txn> preparedTxns;
    private Set<DatabaseId> inListBuildDbIds;
    private Set<DatabaseId> tempDbIds;
    private Level detailedTraceLevel;
    private RecoveryUtilizationTracker tracker;

    public RecoveryManager(EnvironmentImpl env) throws DatabaseException {
        this.env = env;
        DbConfigManager cm = env.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.committedTxnIds = new HashMap<Long, Long>();
        this.abortedTxnIds = new HashSet<Long>();
        this.preparedTxns = new HashMap<Long, Txn>();
        this.inListBuildDbIds = new HashSet<DatabaseId>();
        this.tempDbIds = new HashSet<DatabaseId>();
        this.tracker = new RecoveryUtilizationTracker(env);
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_RECOVERY);
    }

    public RecoveryInfo recover(boolean readOnly, boolean replicationIntended) throws DatabaseException {
        this.info = new RecoveryInfo();
        try {
            block10: {
                try {
                    FileManager fileManager = this.env.getFileManager();
                    DbConfigManager configManager = this.env.getConfigManager();
                    boolean forceCheckpoint = configManager.getBoolean(EnvironmentParams.ENV_RECOVERY_FORCE_CHECKPOINT);
                    if (fileManager.filesExist()) {
                        this.findEndOfLog(readOnly);
                        Tracer.trace(Level.CONFIG, this.env, "Recovery underway, found end of log");
                        this.findLastCheckpoint();
                        this.env.getLogManager().setLastLsnAtRecovery(fileManager.getLastUsedLsn());
                        Tracer.trace(Level.CONFIG, this.env, "Recovery checkpoint search, " + this.info);
                        this.env.readMapTreeFromLog(this.info.useRootLsn, replicationIntended);
                        this.buildTree();
                    } else {
                        this.env.enableDebugLoggingToDbLog();
                        Tracer.trace(Level.CONFIG, this.env, "Recovery w/no files.");
                        this.env.getInMemoryINs().enable();
                        this.env.logMapTreeRoot();
                        if (this.env.getSharedCache()) {
                            this.env.getEvictor().addEnvironment(this.env);
                        }
                        forceCheckpoint = true;
                    }
                    int ptSize = this.preparedTxns.size();
                    if (ptSize > 0) {
                        boolean singular = ptSize == 1;
                        Tracer.trace(Level.INFO, this.env, "There " + (singular ? "is " : "are ") + ptSize + " prepared but unfinished " + (singular ? "txn." : "txns."));
                        this.preparedTxns = null;
                    }
                    if (DbInternal.getCreateUP(this.env.getConfigManager().getEnvironmentConfig())) {
                        this.env.getUtilizationProfile().populateCache();
                    }
                    this.tracker.transferToUtilizationTracker(this.env.getUtilizationTracker());
                    this.removeTempDbs();
                    if (!readOnly && (this.env.getLogManager().getLastLsnAtRecovery() != this.info.checkpointEndLsn || forceCheckpoint)) {
                        CheckpointConfig config = new CheckpointConfig();
                        config.setForce(true);
                        config.setMinimizeRecoveryTime(true);
                        this.env.invokeCheckpoint(config, false, "recovery");
                        break block10;
                    }
                    this.env.getCheckpointer().initIntervals(this.info.checkpointEndLsn, System.currentTimeMillis());
                }
                catch (IOException e) {
                    Tracer.trace(this.env, "RecoveryManager", "recover", "Couldn't recover", e);
                    throw new RecoveryException(this.env, "Couldn't recover: " + e.getMessage(), e);
                }
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Tracer.trace(Level.CONFIG, this.env, "Recovery finished: " + this.info);
            throw throwable;
        }
        Tracer.trace(Level.CONFIG, this.env, "Recovery finished: " + this.info);
        return this.info;
    }

    private void findEndOfLog(boolean readOnly) throws IOException, DatabaseException {
        LastFileReader reader = new LastFileReader(this.env, this.readBufferSize);
        while (reader.readNextEntry()) {
            LogEntryType type = reader.getEntryType();
            if (LogEntryType.LOG_CKPT_END.equals(type)) {
                this.info.checkpointEndLsn = reader.getLastLsn();
                this.info.partialCheckpointStartLsn = -1L;
                continue;
            }
            if (LogEntryType.LOG_CKPT_START.equals(type)) {
                if (this.info.partialCheckpointStartLsn != -1L) continue;
                this.info.partialCheckpointStartLsn = reader.getLastLsn();
                continue;
            }
            if (!LogEntryType.LOG_ROOT.equals(type)) continue;
            this.info.useRootLsn = reader.getLastLsn();
        }
        assert (reader.getLastValidLsn() != reader.getEndOfLog()) : "lastUsed=" + DbLsn.getNoFormatString(reader.getLastValidLsn()) + " end=" + DbLsn.getNoFormatString(reader.getEndOfLog());
        if (!readOnly) {
            reader.setEndOfFile();
        }
        this.info.lastUsedLsn = reader.getLastValidLsn();
        this.info.nextAvailableLsn = reader.getEndOfLog();
        this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        this.env.getFileManager().setLastPosition(this.info.nextAvailableLsn, this.info.lastUsedLsn, reader.getPrevOffset());
        this.env.enableDebugLoggingToDbLog();
    }

    private void findLastCheckpoint() throws IOException, DatabaseException {
        if (this.info.checkpointEndLsn == -1L) {
            CheckpointFileReader searcher = new CheckpointFileReader(this.env, this.readBufferSize, false, this.info.lastUsedLsn, -1L, this.info.nextAvailableLsn);
            while (searcher.readNextEntry()) {
                if (searcher.isCheckpointEnd()) {
                    this.info.checkpointEndLsn = searcher.getLastLsn();
                    break;
                }
                if (searcher.isCheckpointStart()) {
                    this.info.partialCheckpointStartLsn = searcher.getLastLsn();
                    continue;
                }
                if (!searcher.isRoot() || this.info.useRootLsn != -1L) continue;
                this.info.useRootLsn = searcher.getLastLsn();
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + searcher.getNRepeatIteratorReads());
        }
        if (this.info.checkpointEndLsn == -1L) {
            this.info.checkpointStartLsn = -1L;
            this.info.firstActiveLsn = -1L;
        } else {
            CheckpointEnd checkpointEnd;
            this.info.checkpointEnd = checkpointEnd = (CheckpointEnd)this.env.getLogManager().get(this.info.checkpointEndLsn);
            this.info.checkpointStartLsn = checkpointEnd.getCheckpointStartLsn();
            this.info.firstActiveLsn = checkpointEnd.getFirstActiveLsn();
            if (checkpointEnd.getRootLsn() != -1L && this.info.useRootLsn == -1L) {
                this.info.useRootLsn = checkpointEnd.getRootLsn();
            }
            this.env.getCheckpointer().setCheckpointId(checkpointEnd.getId());
        }
        if (this.info.useRootLsn == -1L) {
            throw new NoRootException(this.env, "This environment's log file has no root. Since the root is the first entry written into a log at environment creation, this should only happen if the initial creation of the environment was never checkpointed or synced. Please move aside the existing log files to allow the creation of a new environment");
        }
    }

    private void buildTree() throws IOException, DatabaseException {
        int passNum = this.buildINs(1, true, false);
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + "undo map LNs");
        long start = System.currentTimeMillis();
        HashSet<LogEntryType> mapLNSet = new HashSet<LogEntryType>();
        mapLNSet.add(LogEntryType.LOG_MAPLN_TRANSACTIONAL);
        mapLNSet.add(LogEntryType.LOG_TXN_COMMIT);
        mapLNSet.add(LogEntryType.LOG_TXN_ABORT);
        mapLNSet.add(LogEntryType.LOG_TXN_PREPARE);
        this.undoLNs(this.info, mapLNSet);
        long end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(++passNum) + "redo map LNs");
        start = System.currentTimeMillis();
        mapLNSet.add(LogEntryType.LOG_MAPLN);
        this.redoLNs(this.info, mapLNSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        ++passNum;
        passNum = this.buildINs(passNum, false, false);
        passNum = this.buildINs(passNum, false, true);
        this.buildINList();
        if (this.env.getSharedCache()) {
            this.env.getEvictor().addEnvironment(this.env);
        }
        this.env.invokeEvictor();
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(9) + "undo LNs");
        start = System.currentTimeMillis();
        HashSet<LogEntryType> lnSet = new HashSet<LogEntryType>();
        lnSet.add(LogEntryType.LOG_LN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN_TRANSACTIONAL);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL);
        this.undoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(9, start, end) + this.info.toString());
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(10) + "redo LNs");
        start = System.currentTimeMillis();
        lnSet.add(LogEntryType.LOG_LN);
        lnSet.add(LogEntryType.LOG_NAMELN);
        lnSet.add(LogEntryType.LOG_DEL_DUPLN);
        lnSet.add(LogEntryType.LOG_DUPCOUNTLN);
        lnSet.add(LogEntryType.LOG_FILESUMMARYLN);
        this.redoLNs(this.info, lnSet);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(10, start, end) + this.info.toString());
    }

    private int buildINs(int passNum, boolean mappingTree, boolean dupTree) throws IOException, DatabaseException {
        HashSet<LogEntryType> targetEntries = new HashSet<LogEntryType>();
        HashSet<LogEntryType> deltaType = new HashSet<LogEntryType>();
        String passADesc = null;
        String passBDesc = null;
        String passCDesc = null;
        if (mappingTree) {
            passADesc = "read mapping INs";
            passBDesc = "redo mapping INs";
            passCDesc = "read mapping BINDeltas";
        } else if (dupTree) {
            passADesc = "read dup INs";
            passBDesc = "redo dup INs";
            passCDesc = "read dup BINDeltas";
        } else {
            passADesc = "read main INs";
            passBDesc = "redo main INs";
            passCDesc = "read main BINDeltas";
        }
        if (dupTree) {
            targetEntries.add(LogEntryType.LOG_DIN);
            targetEntries.add(LogEntryType.LOG_DBIN);
            targetEntries.add(LogEntryType.LOG_IN_DUPDELETE_INFO);
            deltaType.add(LogEntryType.LOG_DUP_BIN_DELTA);
        } else {
            targetEntries.add(LogEntryType.LOG_IN);
            targetEntries.add(LogEntryType.LOG_BIN);
            targetEntries.add(LogEntryType.LOG_IN_DELETE_INFO);
            deltaType.add(LogEntryType.LOG_BIN_DELTA);
        }
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passADesc);
        LevelRecorder recorder = new LevelRecorder();
        long start = System.currentTimeMillis();
        if (mappingTree) {
            this.readINsAndTrackIds(this.info.checkpointStartLsn, recorder);
        } else {
            int numINsSeen = this.readINs(this.info.checkpointStartLsn, false, targetEntries, dupTree, recorder);
            if (dupTree) {
                this.info.numDuplicateINs += numINsSeen;
            } else {
                this.info.numOtherINs += numINsSeen;
            }
        }
        long end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        ++passNum;
        Set<DatabaseId> redoSet = recorder.getDbsWithDifferentLevels();
        if (redoSet.size() > 0) {
            Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passBDesc);
            start = System.currentTimeMillis();
            this.repeatReadINs(this.info.checkpointStartLsn, targetEntries, redoSet);
            end = System.currentTimeMillis();
            Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
            ++passNum;
        }
        Tracer.trace(Level.CONFIG, this.env, this.passStartHeader(passNum) + passCDesc);
        start = System.currentTimeMillis();
        this.info.numBinDeltas += this.readINs(this.info.checkpointStartLsn, mappingTree, deltaType, true, null);
        end = System.currentTimeMillis();
        Tracer.trace(Level.CONFIG, this.env, this.passEndHeader(passNum, start, end) + this.info.toString());
        return ++passNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readINsAndTrackIds(long rollForwardLsn, LevelRecorder recorder) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, true, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.addTargetType(LogEntryType.LOG_BIN);
        reader.addTargetType(LogEntryType.LOG_IN_DELETE_INFO);
        reader.setAlwaysValidateChecksum(true);
        try {
            this.info.numMapINs = 0;
            DbTree dbMapTree = this.env.getDbTree();
            while (reader.readNextEntry()) {
                Object var9_8;
                DatabaseId dbId = reader.getDatabaseId();
                if (!dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    this.replayOneIN(reader, db, false, recorder);
                    ++this.info.numMapINs;
                    var9_8 = null;
                    dbMapTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    dbMapTree.releaseDb(db);
                    throw throwable;
                }
            }
            this.info.useMinReplicatedNodeId = reader.getMinReplicatedNodeId();
            this.info.useMaxNodeId = reader.getMaxNodeId();
            this.info.useMinReplicatedDbId = reader.getMinReplicatedDbId();
            this.info.useMaxDbId = reader.getMaxDbId();
            this.info.useMinReplicatedTxnId = reader.getMinReplicatedTxnId();
            this.info.useMaxTxnId = reader.getMaxTxnId();
            if (this.info.checkpointEnd != null) {
                CheckpointEnd ckptEnd = this.info.checkpointEnd;
                if (this.info.useMinReplicatedNodeId > ckptEnd.getLastReplicatedNodeId()) {
                    this.info.useMinReplicatedNodeId = ckptEnd.getLastReplicatedNodeId();
                }
                if (this.info.useMaxNodeId < ckptEnd.getLastLocalNodeId()) {
                    this.info.useMaxNodeId = ckptEnd.getLastLocalNodeId();
                }
                if (this.info.useMinReplicatedDbId > ckptEnd.getLastReplicatedDbId()) {
                    this.info.useMinReplicatedDbId = ckptEnd.getLastReplicatedDbId();
                }
                if (this.info.useMaxDbId < ckptEnd.getLastLocalDbId()) {
                    this.info.useMaxDbId = ckptEnd.getLastLocalDbId();
                }
                if (this.info.useMinReplicatedTxnId > ckptEnd.getLastReplicatedTxnId()) {
                    this.info.useMinReplicatedTxnId = ckptEnd.getLastReplicatedTxnId();
                }
                if (this.info.useMaxTxnId < ckptEnd.getLastLocalTxnId()) {
                    this.info.useMaxTxnId = ckptEnd.getLastLocalTxnId();
                }
            }
            this.env.getNodeSequence().setLastNodeId(this.info.useMinReplicatedNodeId, this.info.useMaxNodeId);
            this.env.getDbTree().setLastDbId(this.info.useMinReplicatedDbId, this.info.useMaxDbId);
            this.env.getTxnManager().setLastTxnId(this.info.useMinReplicatedTxnId, this.info.useMaxTxnId);
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
            this.info.fileMappers = reader.getFileMappers();
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readMapIns", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readINs(long rollForwardLsn, boolean mapDbOnly, Set<LogEntryType> targetLogEntryTypes, boolean requireExactMatch, LevelRecorder recorder) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, mapDbOnly, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        Iterator<LogEntryType> iter = targetLogEntryTypes.iterator();
        while (iter.hasNext()) {
            reader.addTargetType(iter.next());
        }
        int numINsSeen = 0;
        try {
            DbTree dbMapTree = this.env.getDbTree();
            while (reader.readNextEntry()) {
                Object var16_15;
                DatabaseId dbId = reader.getDatabaseId();
                boolean isMapDb = dbId.equals(DbTree.ID_DB_ID);
                boolean isTarget = false;
                if (mapDbOnly && isMapDb) {
                    isTarget = true;
                } else if (!mapDbOnly && !isMapDb) {
                    isTarget = true;
                }
                if (!isTarget) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    if (db != null) {
                        this.replayOneIN(reader, db, requireExactMatch, recorder);
                        ++numINsSeen;
                        this.inListBuildDbIds.add(dbId);
                    }
                    var16_15 = null;
                    dbMapTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var16_15 = null;
                    dbMapTree.releaseDb(db);
                    throw throwable;
                }
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
            return numINsSeen;
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repeatReadINs(long rollForwardLsn, Set<LogEntryType> targetLogEntryTypes, Set<DatabaseId> targetDbs) throws IOException, DatabaseException {
        INFileReader reader = new INFileReader(this.env, this.readBufferSize, rollForwardLsn, this.info.nextAvailableLsn, false, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker);
        Iterator<LogEntryType> iter = targetLogEntryTypes.iterator();
        while (iter.hasNext()) {
            reader.addTargetType(iter.next());
        }
        try {
            DbTree dbMapTree = this.env.getDbTree();
            while (reader.readNextEntry()) {
                Object var11_10;
                DatabaseId dbId = reader.getDatabaseId();
                if (!targetDbs.contains(dbId)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                try {
                    if (db != null) {
                        this.replayOneIN(reader, db, true, null);
                    }
                    var11_10 = null;
                    dbMapTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var11_10 = null;
                    dbMapTree.releaseDb(db);
                    throw throwable;
                }
            }
            this.info.nRepeatIteratorReads = (int)((long)this.info.nRepeatIteratorReads + reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
        }
    }

    private void replayOneIN(INFileReader reader, DatabaseImpl db, boolean requireExactMatch, LevelRecorder recorder) throws DatabaseException {
        if (reader.isDeleteInfo()) {
            this.replayINDelete(db, reader.getDeletedNodeId(), false, reader.getDeletedIdKey(), null, reader.getLastLsn());
        } else if (reader.isDupDeleteInfo()) {
            this.replayINDelete(db, reader.getDupDeletedNodeId(), true, reader.getDupDeletedMainKey(), reader.getDupDeletedDupKey(), reader.getLastLsn());
        } else {
            IN in = reader.getIN();
            long inLsn = reader.getLsnOfIN();
            in.postRecoveryInit(db, inLsn);
            in.latch();
            if (recorder != null) {
                recorder.record(db.getId(), in.getLevel());
            }
            this.replaceOrInsert(db, in, reader.getLastLsn(), inLsn, requireExactMatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undoLNs(RecoveryInfo recoveryInfo, Set<LogEntryType> set) throws IOException, DatabaseException {
        long l = recoveryInfo.firstActiveLsn;
        long l2 = recoveryInfo.lastUsedLsn;
        long l3 = recoveryInfo.nextAvailableLsn;
        LNFileReader lNFileReader = new LNFileReader(this.env, this.readBufferSize, l2, false, l3, l, null, recoveryInfo.checkpointEndLsn);
        for (LogEntryType logEntryType : set) {
            lNFileReader.addTargetType(logEntryType);
        }
        HashMap<TxnNodeId, Long> hashMap = new HashMap<TxnNodeId, Long>();
        HashSet<TxnNodeId> hashSet = new HashSet<TxnNodeId>();
        DbTree dbTree = this.env.getDbTree();
        TreeLocation treeLocation = new TreeLocation();
        try {
            while (true) {
                if (!lNFileReader.readNextEntry()) {
                    recoveryInfo.nRepeatIteratorReads = (int)((long)recoveryInfo.nRepeatIteratorReads + lNFileReader.getNRepeatIteratorReads());
                    return;
                }
                if (lNFileReader.isLN()) {
                    Object var27_27;
                    Long l4 = lNFileReader.getTxnId();
                    if (l4 == null || this.committedTxnIds.containsKey(l4) || this.preparedTxns.get(l4) != null) continue;
                    this.env.invokeEvictor();
                    LN lN = lNFileReader.getLN();
                    long l5 = lNFileReader.getLastLsn();
                    long l6 = lNFileReader.getAbortLsn();
                    boolean bl = lNFileReader.getAbortKnownDeleted();
                    DatabaseId databaseId = lNFileReader.getDatabaseId();
                    DatabaseImpl databaseImpl = dbTree.getDb(databaseId);
                    try {
                        if (databaseImpl != null) {
                            lN.postFetchInit(databaseImpl, l5);
                            RecoveryManager.undo(this.detailedTraceLevel, databaseImpl, treeLocation, lN, lNFileReader.getKey(), lNFileReader.getDupTreeKey(), l5, l6, bl, recoveryInfo, true);
                            TxnNodeId txnNodeId = new TxnNodeId(lNFileReader.getNodeId(), l4);
                            this.undoUtilizationInfo(lN, databaseImpl, l5, l6, bl, lNFileReader.getLastEntrySize(), txnNodeId, hashMap, hashSet);
                            this.inListBuildDbIds.add(databaseId);
                            MapLN mapLN = lNFileReader.getMapLN();
                            if (mapLN != null && mapLN.getDatabase().isTemporary()) {
                                this.tempDbIds.add(mapLN.getDatabase().getId());
                            }
                        }
                        var27_27 = null;
                        dbTree.releaseDb(databaseImpl);
                    }
                    catch (Throwable throwable) {
                        var27_27 = null;
                        dbTree.releaseDb(databaseImpl);
                        throw throwable;
                    }
                }
                if (lNFileReader.isPrepare()) {
                    long l7 = lNFileReader.getTxnPrepareId();
                    Long l8 = l7;
                    if (this.committedTxnIds.containsKey(l8) || this.abortedTxnIds.contains(l8)) continue;
                    TransactionConfig transactionConfig = new TransactionConfig();
                    PreparedTxn preparedTxn = PreparedTxn.createPreparedTxn(this.env, transactionConfig, l7);
                    preparedTxn.setLockTimeout(0L);
                    this.preparedTxns.put(l8, preparedTxn);
                    preparedTxn.setPrepared(true);
                    this.env.getTxnManager().registerXATxn(lNFileReader.getTxnPrepareXid(), preparedTxn, true);
                    Tracer.trace(Level.INFO, this.env, "Found unfinished prepare record: id: " + lNFileReader.getTxnPrepareId() + " Xid: " + lNFileReader.getTxnPrepareXid());
                    continue;
                }
                if (lNFileReader.isAbort()) {
                    this.abortedTxnIds.add(lNFileReader.getTxnAbortId());
                    continue;
                }
                this.committedTxnIds.put(lNFileReader.getTxnCommitId(), lNFileReader.getLastLsn());
            }
        }
        catch (RuntimeException runtimeException) {
            this.traceAndThrowException(lNFileReader.getLastLsn(), "undoLNs", runtimeException);
        }
    }

    /*
     * Exception decompiling
     */
    private void redoLNs(RecoveryInfo var1_1, Set<LogEntryType> var2_2) throws IOException, DatabaseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildINList() throws DatabaseException {
        this.env.getInMemoryINs().enable();
        this.env.getDbTree().rebuildINListMapDb();
        for (DatabaseId dbId : this.inListBuildDbIds) {
            Object var5_4;
            if (dbId.equals(DbTree.ID_DB_ID)) continue;
            DatabaseImpl db = this.env.getDbTree().getDb(dbId);
            try {
                if (db != null && !db.isTemporary()) {
                    db.getTree().rebuildINList();
                }
                var5_4 = null;
                this.env.getDbTree().releaseDb(db);
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.env.getDbTree().releaseDb(db);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsert(DatabaseImpl databaseImpl, IN iN, long l, long l2, boolean bl) throws DatabaseException {
        block11: {
            ArrayList<TrackingInfo> arrayList = null;
            boolean bl2 = false;
            try {
                block10: {
                    try {
                        if (iN.isRoot()) {
                            if (iN.containsDuplicates()) {
                                this.replaceOrInsertDuplicateRoot(databaseImpl, (DIN)iN, l);
                                break block10;
                            } else {
                                this.replaceOrInsertRoot(databaseImpl, iN, l);
                                bl2 = true;
                            }
                            break block10;
                        }
                        arrayList = new ArrayList<TrackingInfo>();
                        this.replaceOrInsertChild(databaseImpl, iN, l, l2, arrayList, bl);
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        String string = this.printTrackList(arrayList);
                        Tracer.trace(databaseImpl.getDbEnvironment(), "RecoveryManager", "replaceOrInsert", " lsnFromLog:" + DbLsn.getNoFormatString(l) + " " + string, exception);
                        throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(l), exception);
                    }
                }
                Object var13_8 = null;
                if (bl2) break block11;
            }
            catch (Throwable throwable) {
                Object var13_9 = null;
                if (!bl2) {
                    iN.releaseLatch();
                }
                assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString() + "LSN = " + DbLsn.toString(l) + " inFromLog = " + iN.getNodeId();
                throw throwable;
            }
            iN.releaseLatch();
        }
        assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString() + "LSN = " + DbLsn.toString(l) + " inFromLog = " + iN.getNodeId();
    }

    private String printTrackList(List<TrackingInfo> list) {
        if (list != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<TrackingInfo> iterator = list.iterator();
            stringBuffer.append("Trace list:");
            stringBuffer.append('\n');
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replayINDelete(DatabaseImpl db, long nodeId, boolean containsDuplicates, byte[] mainKey, byte[] dupKey, long logLsn) throws DatabaseException {
        SearchResult result;
        boolean deleted;
        boolean found;
        block6: {
            found = false;
            deleted = false;
            Tree tree = db.getTree();
            result = new SearchResult();
            try {
                result = db.getTree().getParentINForChildIN(nodeId, containsDuplicates, false, mainKey, dupKey, false, CacheMode.UNCHANGED, -1, null, true);
                if (result.parent == null) {
                    tree.withRootLatchedExclusive(new RootDeleter(tree));
                    db.setDirtyUtilization();
                    RecoveryManager.traceRootDeletion(Level.FINE, db);
                    deleted = true;
                } else if (result.exactParentFound) {
                    found = true;
                    deleted = result.parent.deleteEntry(result.index, false);
                }
                Object var14_11 = null;
                if (result.parent == null) break block6;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (result.parent != null) {
                    result.parent.releaseLatch();
                }
                this.traceINDeleteReplay(nodeId, logLsn, found, deleted, result.index, containsDuplicates);
                throw throwable;
            }
            result.parent.releaseLatch();
        }
        this.traceINDeleteReplay(nodeId, logLsn, found, deleted, result.index, containsDuplicates);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertRoot(DatabaseImpl databaseImpl, IN iN, long l) throws DatabaseException {
        RootUpdater rootUpdater;
        boolean bl;
        block7: {
            bl = true;
            Tree tree = databaseImpl.getTree();
            rootUpdater = new RootUpdater(tree, iN, l);
            try {
                try {
                    tree.withRootLatchedExclusive(rootUpdater);
                    if (rootUpdater.updateDone()) {
                        databaseImpl.setDirtyUtilization();
                    }
                }
                catch (Exception exception) {
                    bl = false;
                    throw new DatabaseException("lsnFromLog=" + DbLsn.getNoFormatString(l), exception);
                }
                Object var10_7 = null;
                if (!rootUpdater.getInFromLogIsLatched()) break block7;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (rootUpdater.getInFromLogIsLatched()) {
                    iN.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "RootRecover:", bl, iN, l, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
                throw throwable;
            }
            iN.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "RootRecover:", bl, iN, l, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertDuplicateRoot(DatabaseImpl databaseImpl, DIN dIN, long l) throws DatabaseException {
        boolean bl;
        int n;
        IN iN;
        long l2;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        block7: {
            bl4 = true;
            bl3 = false;
            bl2 = false;
            l2 = -1L;
            byte[] byArray = dIN.getMainTreeKey();
            iN = null;
            n = -1;
            bl = false;
            try {
                block9: {
                    block8: {
                        iN = databaseImpl.getTree().searchSplitsAllowed(byArray, -1L, CacheMode.DEFAULT);
                        assert (iN instanceof BIN);
                        ChildReference childReference = new ChildReference(dIN, byArray, l);
                        n = iN.insertEntry1(childReference);
                        if (n < 0 || (n & 0x10000) == 0) break block8;
                        if (iN.isEntryKnownDeleted(n &= 0xFFFEFFFF)) {
                            iN.setEntry(n, dIN, byArray, l, (byte)0);
                            bl2 = true;
                            break block9;
                        } else {
                            l2 = iN.getLsn(n);
                            if (DbLsn.compareTo(l2, l) < 0) {
                                iN.setEntry(n, dIN, byArray, l, iN.getState(n));
                                bl2 = true;
                            }
                        }
                        break block9;
                    }
                    bl4 = false;
                }
                bl = true;
                Object var16_13 = null;
                if (iN == null) break block7;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (iN != null) {
                    iN.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "DupRootRecover:", bl, dIN, l, iN, bl4, bl2, bl3, l2, -1L, n);
                throw throwable;
            }
            iN.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "DupRootRecover:", bl, dIN, l, iN, bl4, bl2, bl3, l2, -1L, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceOrInsertChild(DatabaseImpl databaseImpl, IN iN, long l, long l2, List<TrackingInfo> list, boolean bl) throws DatabaseException {
        SearchResult searchResult;
        boolean bl2;
        long l3;
        boolean bl3;
        boolean bl4;
        block8: {
            block6: {
                block7: {
                    bl4 = false;
                    bl3 = false;
                    l3 = -1L;
                    bl2 = false;
                    searchResult = new SearchResult();
                    try {
                        searchResult = databaseImpl.getTree().getParentINForChildIN(iN, bl, CacheMode.UNCHANGED, -1, list);
                        if (searchResult.parent == null) {
                            Object var16_12 = null;
                            if (searchResult.parent == null) break block6;
                            break block7;
                        }
                        if (searchResult.index >= 0 && searchResult.parent.getLsn(searchResult.index) != l && searchResult.exactParentFound && DbLsn.compareTo(l3 = searchResult.parent.getLsn(searchResult.index), l) < 0) {
                            searchResult.parent.updateNode(searchResult.index, iN, l2, null);
                            bl3 = true;
                        }
                        bl2 = true;
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var16_14 = null;
                        if (searchResult.parent != null) {
                            searchResult.parent.releaseLatch();
                        }
                        RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "INRecover:", bl2, iN, l, searchResult.parent, searchResult.exactParentFound, bl3, bl4, l3, -1L, searchResult.index);
                        throw throwable;
                    }
                }
                searchResult.parent.releaseLatch();
            }
            RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "INRecover:", bl2, iN, l, searchResult.parent, searchResult.exactParentFound, bl3, bl4, l3, -1L, searchResult.index);
            return;
        }
        Object var16_13 = null;
        if (searchResult.parent != null) {
            searchResult.parent.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "INRecover:", bl2, iN, l, searchResult.parent, searchResult.exactParentFound, bl3, bl4, l3, -1L, searchResult.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long redo(DatabaseImpl databaseImpl, TreeLocation treeLocation, LN lN, byte[] byArray, byte[] byArray2, long l, RecoveryInfo recoveryInfo) throws DatabaseException {
        long l2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        block18: {
            block16: {
                long l3;
                block17: {
                    bl4 = false;
                    bl3 = false;
                    bl2 = false;
                    bl = false;
                    try {
                        treeLocation.reset();
                        bl4 = databaseImpl.getTree().getParentBINForChildLN(treeLocation, byArray, byArray2, lN, true, false, true, CacheMode.DEFAULT);
                        if (bl4 || treeLocation.bin != null) break block16;
                        bl = true;
                        l3 = -1L;
                        Object var16_17 = null;
                        if (treeLocation.bin == null) break block17;
                    }
                    catch (Throwable throwable) {
                        Object var16_19 = null;
                        if (treeLocation.bin != null) {
                            treeLocation.bin.releaseLatch();
                        }
                        RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "LNRedo:", bl, lN, l, treeLocation.bin, bl4, bl3, bl2, treeLocation.childLsn, -1L, treeLocation.index);
                        throw throwable;
                    }
                    treeLocation.bin.releaseLatch();
                }
                RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "LNRedo:", bl, lN, l, treeLocation.bin, bl4, bl3, bl2, treeLocation.childLsn, -1L, treeLocation.index);
                return l3;
            }
            if (lN.containsDuplicates()) {
                if (bl4) {
                    DIN dIN = (DIN)treeLocation.bin.fetchTarget(treeLocation.index);
                    if (DbLsn.compareTo(l, treeLocation.childLsn) >= 0) {
                        dIN.latch();
                        dIN.updateDupCountLNRefAndNullTarget(l);
                        dIN.releaseLatch();
                    }
                }
            } else if (bl4) {
                ++recoveryInfo.lnFound;
                if (DbLsn.compareTo(l, treeLocation.childLsn) > 0) {
                    ++recoveryInfo.lnReplaced;
                    bl3 = true;
                    treeLocation.bin.updateNode(treeLocation.index, null, l, null);
                }
                if (DbLsn.compareTo(l, treeLocation.childLsn) >= 0 && lN.isDeleted()) {
                    byte[] byArray3;
                    treeLocation.bin.setKnownDeletedLeaveTarget(treeLocation.index);
                    byte[] byArray4 = byArray3 = treeLocation.bin.containsDuplicates() ? byArray2 : byArray;
                    if (byArray3 != null) {
                        databaseImpl.getDbEnvironment().addToCompressorQueue(treeLocation.bin, new Key(byArray3), false);
                    }
                }
            } else {
                ++recoveryInfo.lnNotFound;
                if (!lN.isDeleted()) {
                    ++recoveryInfo.lnInserted;
                    bl2 = true;
                    boolean bl5 = RecoveryManager.insertRecovery(databaseImpl, treeLocation, l);
                    assert (bl5);
                }
            }
            if (!bl2) {
                lN.releaseMemoryBudget();
            }
            bl = true;
            l2 = bl4 ? treeLocation.childLsn : -1L;
            Object var16_18 = null;
            if (treeLocation.bin == null) break block18;
            treeLocation.bin.releaseLatch();
        }
        RecoveryManager.trace(this.detailedTraceLevel, databaseImpl, "LNRedo:", bl, lN, l, treeLocation.bin, bl4, bl3, bl2, treeLocation.childLsn, -1L, treeLocation.index);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void undo(Level level, DatabaseImpl databaseImpl, TreeLocation treeLocation, LN lN, byte[] byArray, byte[] byArray2, long l, long l2, boolean bl, RecoveryInfo recoveryInfo, boolean bl2) throws DatabaseException {
        boolean bl3;
        boolean bl4;
        boolean bl5;
        block17: {
            bl5 = false;
            bl4 = false;
            bl3 = false;
            try {
                block19: {
                    block18: {
                        treeLocation.reset();
                        bl5 = databaseImpl.getTree().getParentBINForChildLN(treeLocation, byArray, byArray2, lN, bl2, true, false, CacheMode.DEFAULT);
                        if (!lN.containsDuplicates()) break block18;
                        if (bl5) {
                            DIN dIN = (DIN)treeLocation.bin.fetchTarget(treeLocation.index);
                            dIN.latch();
                            try {
                                if (DbLsn.compareTo(l, treeLocation.childLsn) == 0) {
                                    dIN.updateDupCountLNRefAndNullTarget(l2);
                                    bl4 = true;
                                }
                                Object var18_16 = null;
                            }
                            catch (Throwable throwable) {
                                Object var18_17 = null;
                                dIN.releaseLatch();
                                throw throwable;
                            }
                            dIN.releaseLatch();
                        }
                        break block19;
                    }
                    if (bl5) {
                        boolean bl6;
                        if (recoveryInfo != null) {
                            ++recoveryInfo.lnFound;
                        }
                        boolean bl7 = bl6 = DbLsn.compareTo(l, treeLocation.childLsn) == 0;
                        if (bl6) {
                            if (l2 == -1L) {
                                treeLocation.bin.setKnownDeletedLeaveTarget(treeLocation.index);
                                byte[] byArray3 = treeLocation.bin.containsDuplicates() ? byArray2 : byArray;
                                databaseImpl.getDbEnvironment().addToCompressorQueue(treeLocation.bin, new Key(byArray3), false);
                            } else {
                                if (recoveryInfo != null) {
                                    ++recoveryInfo.lnReplaced;
                                }
                                bl4 = true;
                                treeLocation.bin.updateNode(treeLocation.index, null, l2, null);
                                if (bl) {
                                    treeLocation.bin.setKnownDeleted(treeLocation.index);
                                } else {
                                    treeLocation.bin.clearKnownDeleted(treeLocation.index);
                                }
                            }
                            treeLocation.bin.clearPendingDeleted(treeLocation.index);
                        }
                    } else if (recoveryInfo != null) {
                        ++recoveryInfo.lnNotFound;
                    }
                }
                bl3 = true;
                Object var20_20 = null;
                if (treeLocation.bin == null) break block17;
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                if (treeLocation.bin != null) {
                    treeLocation.bin.releaseLatch();
                }
                RecoveryManager.trace(level, databaseImpl, "LNUndo", bl3, lN, l, treeLocation.bin, bl5, bl4, false, treeLocation.childLsn, l2, treeLocation.index);
                throw throwable;
            }
            treeLocation.bin.releaseLatch();
        }
        RecoveryManager.trace(level, databaseImpl, "LNUndo", bl3, lN, l, treeLocation.bin, bl5, bl4, false, treeLocation.childLsn, l2, treeLocation.index);
    }

    private static boolean insertRecovery(DatabaseImpl databaseImpl, TreeLocation treeLocation, long l) throws DatabaseException {
        BIN bIN = treeLocation.bin;
        ChildReference childReference = new ChildReference(null, treeLocation.lnKey, l);
        int n = bIN.insertEntry1(childReference);
        if ((n & 0x20000) == 0) {
            boolean bl = false;
            if (bIN.isEntryKnownDeleted(n &= 0xFFFEFFFF)) {
                bl = true;
            } else {
                LN lN = (LN)bIN.fetchTarget(n);
                if (lN == null || lN.isDeleted()) {
                    bl = true;
                }
                bIN.updateNode(n, null, null);
            }
            if (bl) {
                bIN.updateEntry(n, null, l, treeLocation.lnKey);
                bIN.clearKnownDeleted(n);
                treeLocation.index = n;
                return true;
            }
            return false;
        }
        treeLocation.index = n & 0xFFFDFFFF;
        return true;
    }

    private void redoUtilizationInfo(long logLsn, long treeLsn, long commitLsn, long abortLsn, boolean abortKnownDeleted, int logEntrySize, byte[] key, LN ln, DatabaseImpl db, TxnNodeId txnNodeId, Set<TxnNodeId> countedAbortLsnNodes) throws DatabaseException {
        if (ln.isDeleted()) {
            this.tracker.countObsoleteIfUncounted(logLsn, logLsn, null, logEntrySize, db.getId(), false);
        }
        if (treeLsn != -1L) {
            int cmpLogLsnToTreeLsn = DbLsn.compareTo(logLsn, treeLsn);
            if (cmpLogLsnToTreeLsn != 0) {
                long newLsn = cmpLogLsnToTreeLsn < 0 ? treeLsn : logLsn;
                long oldLsn = cmpLogLsnToTreeLsn > 0 ? treeLsn : logLsn;
                int oldSize = oldLsn == logLsn ? logEntrySize : 0;
                this.tracker.countObsoleteIfUncounted(oldLsn, newLsn, null, this.tracker.fetchLNSize(oldSize, oldLsn), db.getId(), commitLsn != -1L);
            }
            if (cmpLogLsnToTreeLsn <= 0 && abortLsn != -1L && !abortKnownDeleted && !countedAbortLsnNodes.contains(txnNodeId) && commitLsn != -1L) {
                this.tracker.countObsoleteIfUncounted(abortLsn, commitLsn, null, 0, db.getId(), false);
                countedAbortLsnNodes.add(txnNodeId);
            }
        }
    }

    private void undoUtilizationInfo(LN ln, DatabaseImpl db, long logLsn, long abortLsn, boolean abortKnownDeleted, int logEntrySize, TxnNodeId txnNodeId, Map<TxnNodeId, Long> countedFileSummaries, Set<TxnNodeId> countedAbortLsnNodes) {
        boolean counted = this.tracker.countObsoleteIfUncounted(logLsn, logLsn, null, logEntrySize, db.getId(), true);
        if (!counted) {
            Long logFileNum = DbLsn.getFileNumber(logLsn);
            Long countedFile = countedFileSummaries.get(txnNodeId);
            if (countedFile == null || countedFile > logFileNum) {
                if (!ln.isDeleted()) {
                    this.tracker.countObsoleteUnconditional(logLsn, null, logEntrySize, db.getId(), true);
                }
                countedFileSummaries.put(txnNodeId, logFileNum);
            }
        }
    }

    private void removeTempDbs() throws DatabaseException {
        DbTree dbMapTree = this.env.getDbTree();
        BasicLocker locker = BasicLocker.createBasicLocker(this.env, false, true);
        boolean operationOk = false;
        try {
            try {
                for (DatabaseId dbId : this.tempDbIds) {
                    DatabaseImpl db = dbMapTree.getDb(dbId);
                    dbMapTree.releaseDb(db);
                    if (db == null) continue;
                    assert (db.isTemporary());
                    if (db.isDeleted()) continue;
                    this.env.getDbTree().dbRemove(locker, db.getName(), db.getId());
                }
                operationOk = true;
            }
            catch (Error E) {
                this.env.invalidate(E);
                throw E;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            locker.operationEnd(operationOk);
            throw throwable;
        }
        locker.operationEnd(operationOk);
    }

    private String passStartHeader(int n) {
        return "Recovery Pass " + n + " start: ";
    }

    private String passEndHeader(int n, long l, long l2) {
        return "Recovery Pass " + n + " end (" + (l2 - l) + "): ";
    }

    private static void trace(Level level, DatabaseImpl databaseImpl, String string, boolean bl, Node node, long l, IN iN, boolean bl2, boolean bl3, boolean bl4, long l2, long l3, int n) {
        Logger logger = databaseImpl.getDbEnvironment().getLogger();
        Level level2 = level;
        if (!bl) {
            level2 = Level.SEVERE;
        }
        if (logger.isLoggable(level2)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(" success=").append(bl);
            stringBuffer.append(" node=");
            stringBuffer.append(node.getNodeId());
            stringBuffer.append(" lsn=");
            stringBuffer.append(DbLsn.getNoFormatString(l));
            if (iN != null) {
                stringBuffer.append(" parent=").append(iN.getNodeId());
            }
            stringBuffer.append(" found=");
            stringBuffer.append(bl2);
            stringBuffer.append(" replaced=");
            stringBuffer.append(bl3);
            stringBuffer.append(" inserted=");
            stringBuffer.append(bl4);
            if (l2 != -1L) {
                stringBuffer.append(" replacedLsn=");
                stringBuffer.append(DbLsn.getNoFormatString(l2));
            }
            if (l3 != -1L) {
                stringBuffer.append(" abortLsn=");
                stringBuffer.append(DbLsn.getNoFormatString(l3));
            }
            stringBuffer.append(" index=").append(n);
            logger.log(level2, stringBuffer.toString());
        }
    }

    private void traceINDeleteReplay(long l, long l2, boolean bl, boolean bl2, int n, boolean bl3) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(this.detailedTraceLevel)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(bl3 ? "INDupDelReplay:" : "INDelReplay:");
            stringBuffer.append(" node=").append(l);
            stringBuffer.append(" lsn=").append(DbLsn.getNoFormatString(l2));
            stringBuffer.append(" found=").append(bl);
            stringBuffer.append(" deleted=").append(bl2);
            stringBuffer.append(" index=").append(n);
            logger.log(this.detailedTraceLevel, stringBuffer.toString());
        }
    }

    private void traceAndThrowException(long l, String string, Exception exception) throws DatabaseException {
        String string2 = DbLsn.getNoFormatString(l);
        Tracer.trace(this.env, "RecoveryManager", string, "last LSN = " + string2, exception);
        throw new DatabaseException("last LSN=" + string2, exception);
    }

    public static void traceRootDeletion(Level level, DatabaseImpl databaseImpl) {
        Logger logger = databaseImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("RootDelete:");
            stringBuffer.append(" Dbid=").append(databaseImpl.getId());
            logger.log(level, stringBuffer.toString());
        }
    }

    private static class RootUpdater
    implements WithRootLatched {
        private Tree tree;
        private IN inFromLog;
        private long lsn = -1L;
        private boolean inserted = false;
        private boolean replaced = false;
        private long originalLsn = -1L;
        private boolean inFromLogIsLatched = true;

        RootUpdater(Tree tree, IN inFromLog, long lsn) {
            this.tree = tree;
            this.inFromLog = inFromLog;
            this.lsn = lsn;
        }

        boolean getInFromLogIsLatched() {
            return this.inFromLogIsLatched;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            ChildReference newRoot = this.tree.makeRootChildReference(this.inFromLog, new byte[0], this.lsn);
            this.inFromLog.releaseLatch();
            this.inFromLogIsLatched = false;
            if (root == null) {
                this.tree.setRoot(newRoot, false);
                this.inserted = true;
            } else {
                this.originalLsn = root.getLsn();
                if (DbLsn.compareTo(this.originalLsn, this.lsn) < 0) {
                    this.tree.setRoot(newRoot, false);
                    this.replaced = true;
                }
            }
            return null;
        }

        boolean updateDone() {
            return this.inserted || this.replaced;
        }

        boolean getInserted() {
            return this.inserted;
        }

        boolean getReplaced() {
            return this.replaced;
        }

        long getOriginalLsn() {
            return this.originalLsn;
        }
    }

    private static class RootDeleter
    implements WithRootLatched {
        Tree tree;

        RootDeleter(Tree tree) {
            this.tree = tree;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            this.tree.setRoot(null, false);
            return null;
        }
    }

    private static class TxnNodeId {
        long nodeId;
        long txnId;

        TxnNodeId(long nodeId, long txnId) {
            this.nodeId = nodeId;
            this.txnId = txnId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TxnNodeId)) {
                return false;
            }
            return ((TxnNodeId)obj).txnId == this.txnId && ((TxnNodeId)obj).nodeId == this.nodeId;
        }

        public int hashCode() {
            return (int)(this.txnId + this.nodeId);
        }

        public String toString() {
            return "txnId=" + this.txnId + "/nodeId=" + this.nodeId;
        }
    }
}

