/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.tree.Key;
import java.nio.ByteBuffer;

public class INDupDeleteInfo
implements Loggable {
    private long deletedNodeId;
    private byte[] deletedMainKey;
    private byte[] deletedDupKey;
    private DatabaseId dbId;

    public INDupDeleteInfo(long deletedNodeId, byte[] deletedMainKey, byte[] deletedDupKey, DatabaseId dbId) {
        this.deletedNodeId = deletedNodeId;
        this.deletedMainKey = deletedMainKey;
        this.deletedDupKey = deletedDupKey;
        this.dbId = dbId;
    }

    public INDupDeleteInfo() {
        this.dbId = new DatabaseId();
    }

    public long getDeletedNodeId() {
        return this.deletedNodeId;
    }

    public byte[] getDeletedMainKey() {
        return this.deletedMainKey;
    }

    public byte[] getDeletedDupKey() {
        return this.deletedDupKey;
    }

    public DatabaseId getDatabaseId() {
        return this.dbId;
    }

    public void optionalLog(LogManager logManager, DatabaseImpl dbImpl) throws DatabaseException {
        if (!dbImpl.isDeferredWriteMode()) {
            logManager.log(new SingleItemEntry(LogEntryType.LOG_IN_DUPDELETE_INFO, this), ReplicationContext.NO_REPLICATE);
        }
    }

    public int getLogSize() {
        return LogUtils.getPackedLongLogSize(this.deletedNodeId) + LogUtils.getByteArrayLogSize(this.deletedMainKey) + LogUtils.getByteArrayLogSize(this.deletedDupKey) + this.dbId.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writePackedLong(logBuffer, this.deletedNodeId);
        LogUtils.writeByteArray(logBuffer, this.deletedMainKey);
        LogUtils.writeByteArray(logBuffer, this.deletedDupKey);
        this.dbId.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        boolean unpacked = entryVersion < 6;
        this.deletedNodeId = LogUtils.readLong(itemBuffer, unpacked);
        this.deletedMainKey = LogUtils.readByteArray(itemBuffer, unpacked);
        this.deletedDupKey = LogUtils.readByteArray(itemBuffer, unpacked);
        this.dbId.readFromLog(itemBuffer, entryVersion);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<INDupDeleteEntry node=\"").append(this.deletedNodeId);
        sb.append("\">");
        sb.append(Key.dumpString(this.deletedMainKey, 0));
        sb.append(Key.dumpString(this.deletedDupKey, 0));
        this.dbId.dumpLog(sb, verbose);
        sb.append("</INDupDeleteEntry>");
    }
}

