/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.KeyValueAdapter;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.KeyRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BasicIndex<K, E> {
    static final DatabaseEntry NO_RETURN_ENTRY = new DatabaseEntry();
    Database db;
    boolean transactional;
    boolean sortedDups;
    boolean locking;
    Class<K> keyClass;
    EntryBinding keyBinding;
    KeyRange emptyRange;
    ValueAdapter<K> keyAdapter;
    ValueAdapter<E> entityAdapter;

    BasicIndex(Database db, Class<K> keyClass, EntryBinding keyBinding, ValueAdapter<E> entityAdapter) throws DatabaseException {
        this.db = db;
        DatabaseConfig config = db.getConfig();
        this.transactional = config.getTransactional();
        this.sortedDups = config.getSortedDuplicates();
        this.locking = DbCompat.getInitializeLocking(db.getEnvironment().getConfig());
        this.keyClass = keyClass;
        this.keyBinding = keyBinding;
        this.entityAdapter = entityAdapter;
        this.emptyRange = new KeyRange(config.getBtreeComparator());
        this.keyAdapter = new KeyValueAdapter<K>(keyClass, keyBinding);
    }

    public boolean contains(K key) throws DatabaseException {
        return this.contains(null, key, null);
    }

    public boolean contains(Transaction txn, K key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = NO_RETURN_ENTRY;
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.db.get(txn, keyEntry, dataEntry, lockMode);
        return status == OperationStatus.SUCCESS;
    }

    public long count() throws DatabaseException {
        return DbCompat.getDatabaseCount(this.db);
    }

    static {
        NO_RETURN_ENTRY.setPartial(0, 0, true);
    }
}

