/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityValueAdapter;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryIndex<PK, E>
extends BasicIndex<PK, E> {
    private Class<E> entityClass;
    private EntityBinding entityBinding;
    private PersistKeyAssigner keyAssigner;

    public PrimaryIndex(Database database, Class<PK> keyClass, EntryBinding<PK> keyBinding, Class<E> entityClass, EntityBinding<E> entityBinding) throws DatabaseException {
        super(database, keyClass, keyBinding, new EntityValueAdapter<E>(entityClass, entityBinding, false));
        this.entityClass = entityClass;
        this.entityBinding = entityBinding;
        if (entityBinding instanceof PersistEntityBinding) {
            this.keyAssigner = ((PersistEntityBinding)entityBinding).getKeyAssigner();
        }
    }

    public Database getDatabase() {
        return this.db;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public EntityBinding<E> getEntityBinding() {
        return this.entityBinding;
    }

    public E put(E entity) throws DatabaseException {
        return this.put(null, entity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public E put(Transaction txn, E entity) throws DatabaseException {
        E e2;
        Cursor cursor;
        boolean failed;
        boolean autoCommit;
        block9: {
            Object e;
            block8: {
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                this.assignKey(entity, keyEntry);
                autoCommit = false;
                Environment env = this.db.getEnvironment();
                if (this.transactional && txn == null && DbCompat.getThreadTransaction(env) == null) {
                    txn = env.beginTransaction(null, null);
                    autoCommit = true;
                }
                failed = true;
                cursor = this.db.openCursor(txn, null);
                LockMode lockMode = this.locking ? LockMode.RMW : null;
                try {
                    OperationStatus status;
                    do {
                        if ((status = cursor.getSearchKey(keyEntry, dataEntry, lockMode)) == OperationStatus.SUCCESS) {
                            Object existing = this.entityBinding.entryToObject(keyEntry, dataEntry);
                            this.entityBinding.objectToData(entity, dataEntry);
                            cursor.put(keyEntry, dataEntry);
                            failed = false;
                            e = existing;
                            Object var14_14 = null;
                            break block8;
                        }
                        this.entityBinding.objectToData(entity, dataEntry);
                    } while ((status = cursor.putNoOverwrite(keyEntry, dataEntry)) == OperationStatus.KEYEXIST);
                    failed = false;
                    e2 = null;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    cursor.close();
                    if (!autoCommit) throw throwable;
                    if (failed) {
                        txn.abort();
                        throw throwable;
                    }
                    txn.commit();
                    throw throwable;
                }
            }
            cursor.close();
            if (!autoCommit) return e;
            if (failed) {
                txn.abort();
                return e;
            }
            txn.commit();
            return e;
        }
        Object var14_15 = null;
        cursor.close();
        if (!autoCommit) return e2;
        if (failed) {
            txn.abort();
            return e2;
        }
        txn.commit();
        return e2;
    }

    private void assignKey(E entity, DatabaseEntry keyEntry) throws DatabaseException {
        if (this.keyAssigner != null) {
            if (!this.keyAssigner.assignPrimaryKey(entity, keyEntry)) {
                this.entityBinding.objectToKey(entity, keyEntry);
            }
        } else {
            this.entityBinding.objectToKey(entity, keyEntry);
        }
    }

    public E get(PK key) throws DatabaseException {
        return this.get(null, key, null);
    }

    public E get(Transaction txn, PK key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.db.get(txn, keyEntry, dataEntry, lockMode);
        if (status == OperationStatus.SUCCESS) {
            return this.entityBinding.entryToObject(keyEntry, dataEntry);
        }
        return null;
    }
}

