/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.EntityConverter;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.EnhancedAccessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistKeyCreator;
import com.sleepycat.persist.impl.RawAccessor;
import com.sleepycat.persist.impl.RawComplexInput;
import com.sleepycat.persist.impl.RawSingleInput;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.ReflectionAccessor;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.WidenerInput;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexFormat
extends Format {
    private static final long serialVersionUID = -2847843033590454917L;
    private ClassMetadata clsMeta;
    private EntityMetadata entityMeta;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields;
    private List<FieldInfo> nonKeyFields;
    private FieldReader secKeyFieldReader;
    private FieldReader nonKeyFieldReader;
    private Map<String, String> oldToNewKeyMap;
    private Map<String, String> newToOldFieldMap;
    private boolean evolveNeeded;
    private transient Accessor objAccessor;
    private transient Accessor rawAccessor;
    private transient ComplexFormat entityFormat;
    private transient Map<String, FieldAddress> secKeyAddresses;
    private volatile transient Map<String, RawField> rawFields;
    private volatile transient FieldInfo[] rawInputFields;
    private volatile transient int[] rawInputLevels;
    private volatile transient int rawInputDepth;

    ComplexFormat(Class cls, ClassMetadata clsMeta, EntityMetadata entityMeta) {
        super(cls);
        this.clsMeta = clsMeta;
        this.entityMeta = entityMeta;
        this.secKeyFields = new ArrayList<FieldInfo>();
        this.nonKeyFields = FieldInfo.getInstanceFields(cls, clsMeta);
        if (clsMeta.getPrimaryKey() != null) {
            String fieldName = clsMeta.getPrimaryKey().getName();
            FieldInfo field = FieldInfo.getField(this.nonKeyFields, fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Primary key field does not exist: " + this.getClassName() + '.' + fieldName);
            }
            this.nonKeyFields.remove(field);
            this.priKeyField = field;
        }
        if (clsMeta.getSecondaryKeys() != null) {
            for (SecondaryKeyMetadata secKeyMeta : clsMeta.getSecondaryKeys().values()) {
                String fieldName = secKeyMeta.getName();
                FieldInfo field = FieldInfo.getField(this.nonKeyFields, fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Secondary key field does not exist: " + this.getClassName() + '.' + fieldName);
                }
                Class fieldCls = field.getFieldClass();
                Relationship rel = secKeyMeta.getRelationship();
                if (rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY) {
                    if (!PersistKeyCreator.isManyType(fieldCls)) {
                        throw new IllegalArgumentException("ONE_TO_MANY and MANY_TO_MANY keys must have an array or Collection type: " + this.getClassName() + '.' + fieldName);
                    }
                } else if (PersistKeyCreator.isManyType(fieldCls)) {
                    throw new IllegalArgumentException("ONE_TO_ONE and MANY_TO_ONE keys must not have an array or Collection type: " + this.getClassName() + '.' + fieldName);
                }
                this.nonKeyFields.remove(field);
                this.secKeyFields.add(field);
            }
        }
        Collections.sort(this.secKeyFields);
        Collections.sort(this.nonKeyFields);
    }

    @Override
    void migrateFromBeta(Map<String, Format> formatMap) {
        super.migrateFromBeta(formatMap);
        if (this.priKeyField != null) {
            this.priKeyField.migrateFromBeta(formatMap);
        }
        for (FieldInfo field : this.secKeyFields) {
            field.migrateFromBeta(formatMap);
        }
        for (FieldInfo field : this.nonKeyFields) {
            field.migrateFromBeta(formatMap);
        }
    }

    private ComplexFormat getComplexSuper() {
        return (ComplexFormat)this.getSuperFormat();
    }

    private ComplexFormat getComplexLatest() {
        return (ComplexFormat)this.getLatestVersion();
    }

    String getPriKeyField() {
        if (this.clsMeta.getPrimaryKey() != null) {
            return this.clsMeta.getPrimaryKey().getName();
        }
        return null;
    }

    @Override
    boolean isEntity() {
        return this.clsMeta.isEntityClass();
    }

    @Override
    boolean isModelClass() {
        return true;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return this.clsMeta;
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return this.entityMeta;
    }

    @Override
    ComplexFormat getEntityFormat() {
        if (this.isInitialized()) {
            return this.entityFormat;
        }
        if (this.isNew()) {
            throw new IllegalStateException(this.toString());
        }
        for (ComplexFormat format = this; format != null; format = format.getComplexSuper()) {
            if (!format.isEntity()) continue;
            return format;
        }
        return null;
    }

    @Override
    void setEvolveNeeded(boolean needed) {
        this.evolveNeeded = needed;
    }

    @Override
    public Map<String, RawField> getFields() {
        if (this.rawFields == null) {
            HashMap<String, RawField> map = new HashMap<String, RawField>();
            if (this.priKeyField != null) {
                map.put(this.priKeyField.getName(), this.priKeyField);
            }
            for (FieldInfo field : this.secKeyFields) {
                map.put(field.getName(), field);
            }
            for (FieldInfo field : this.nonKeyFields) {
                map.put(field.getName(), field);
            }
            this.rawFields = map;
        }
        return this.rawFields;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
        Format format;
        Class clazz = this.getType();
        if (this.priKeyField != null) {
            this.priKeyField.collectRelatedFormats(catalog, map);
        }
        for (FieldInfo object2 : this.secKeyFields) {
            object2.collectRelatedFormats(catalog, map);
        }
        Iterator<SecondaryKeyMetadata> iterator = this.nonKeyFields.iterator();
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = iterator.next();
            fieldInfo.collectRelatedFormats(catalog, map);
        }
        if (this.entityMeta != null) {
            iterator = this.entityMeta.getSecondaryKeys().values().iterator();
            while (iterator.hasNext()) {
                SecondaryKeyMetadata secondaryKeyMetadata = iterator.next();
                String string = secondaryKeyMetadata.getElementClassName();
                if (string == null) continue;
                Class clazz2 = SimpleCatalog.keyClassForName(string);
                catalog.createFormat(clazz2, map);
            }
        }
        if ((iterator = clazz.getSuperclass()) != Object.class && !((format = catalog.createFormat((Class)((Object)iterator), map)) instanceof ComplexFormat)) {
            throw new IllegalArgumentException("The superclass of a complex type must not be a composite key class or a simple type class: " + ((Class)((Object)iterator)).getName());
        }
        String string = this.clsMeta.getProxiedClassName();
        if (string != null) {
            catalog.createFormat(string, map);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initialize(Catalog catalog, EntityModel entityModel, int n) {
        void var7_15;
        Class clazz;
        Class clazz2 = this.getType();
        boolean bl = false;
        if (clazz2 != null) {
            bl = EnhancedAccessor.isEnhanced(clazz2);
        }
        if (this.priKeyField != null) {
            this.priKeyField.initialize(catalog, entityModel, n);
        }
        for (FieldInfo object2 : this.secKeyFields) {
            object2.initialize(catalog, entityModel, n);
        }
        for (FieldInfo fieldInfo : this.nonKeyFields) {
            fieldInfo.initialize(catalog, entityModel, n);
        }
        Object object3 = this.getComplexSuper();
        if (clazz2 != null && object3 == null && (clazz = clazz2.getSuperclass()) != Object.class) {
            object3 = (ComplexFormat)catalog.getFormat(clazz.getName());
            this.setSuperFormat((Format)object3);
        }
        if (object3 != null) {
            ((Format)object3).initializeIfNeeded(catalog, entityModel);
            Accessor accessor = ((ComplexFormat)object3).objAccessor;
            if (clazz2 != null && accessor != null) {
                if (bl) {
                    if (!(accessor instanceof EnhancedAccessor)) {
                        throw new IllegalStateException("The superclass of an enhanced class must also be enhanced: " + this.getClassName() + " extends " + ((Format)object3).getClassName());
                    }
                } else if (!(accessor instanceof ReflectionAccessor)) {
                    throw new IllegalStateException("The superclass of an unenhanced class must not be enhanced: " + this.getClassName() + " extends " + ((Format)object3).getClassName());
                }
            }
        }
        ComplexFormat complexFormat = this;
        while (var7_15 != null) {
            if (var7_15.isEntity()) {
                this.entityFormat = var7_15;
                break;
            }
            ComplexFormat complexFormat2 = super.getComplexSuper();
        }
        if (this.isEntity() && this.isCurrentVersion()) {
            this.entityMeta = entityModel.getEntityMetadata(this.getClassName());
        }
        if (this.clsMeta.getProxiedClassName() != null && this.entityFormat != null) {
            throw new IllegalArgumentException("A proxy may not be an entity: " + this.getClassName());
        }
        if (this.entityFormat != null && this.entityFormat != this && this.priKeyField != null) {
            throw new IllegalArgumentException("A PrimaryKey may not appear on an Entity subclass: " + this.getClassName() + " field: " + this.priKeyField.getName());
        }
        if (clazz2 != null) {
            if (bl) {
                this.objAccessor = new EnhancedAccessor(catalog, clazz2, this);
            } else {
                Accessor accessor = object3 != null ? ((ComplexFormat)object3).objAccessor : null;
                this.objAccessor = new ReflectionAccessor(catalog, clazz2, accessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
            }
        }
        Accessor accessor = object3 != null ? ((ComplexFormat)object3).rawAccessor : null;
        this.rawAccessor = new RawAccessor(this, accessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
        EntityMetadata entityMetadata = null;
        if (this.entityFormat != null) {
            entityMetadata = this.entityFormat.getLatestVersion().getEntityMetadata();
        }
        if (entityMetadata != null) {
            this.secKeyAddresses = new HashMap<String, FieldAddress>();
            ComplexFormat complexFormat3 = this.getComplexLatest();
            if (complexFormat3 != this) {
                complexFormat3.initializeIfNeeded(catalog, entityModel);
            }
            block3: for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                String string = secondaryKeyMetadata.getDeclaringClassName();
                String string2 = secondaryKeyMetadata.getName();
                int n2 = 0;
                for (ComplexFormat complexFormat4 = this; complexFormat4 != null; complexFormat4 = complexFormat4.getComplexSuper()) {
                    if (string.equals(complexFormat4.getLatestVersion().getClassName())) {
                        int n3;
                        boolean bl2;
                        String string3 = null;
                        string3 = complexFormat4.newToOldFieldMap != null && complexFormat4.newToOldFieldMap.containsKey(string2) ? complexFormat4.newToOldFieldMap.get(string2) : string2;
                        FieldInfo fieldInfo = FieldInfo.getField(complexFormat4.secKeyFields, string3);
                        if (fieldInfo != null) {
                            bl2 = true;
                            n3 = complexFormat4.secKeyFields.indexOf(fieldInfo);
                        } else {
                            bl2 = false;
                            fieldInfo = FieldInfo.getField(complexFormat4.nonKeyFields, string3);
                            if (fieldInfo == null) {
                                assert (complexFormat3 != this);
                                complexFormat3.checkNewSecKeyInitializer(secondaryKeyMetadata);
                                continue block3;
                            }
                            n3 = complexFormat4.nonKeyFields.indexOf(fieldInfo);
                        }
                        FieldAddress fieldAddress = new FieldAddress(bl2, n3, n2, complexFormat4, fieldInfo.getType());
                        this.secKeyAddresses.put(secondaryKeyMetadata.getKeyName(), fieldAddress);
                    }
                    ++n2;
                }
            }
        }
    }

    private void checkNewSecKeyInitializer(SecondaryKeyMetadata secKeyMeta) {
        if (this.objAccessor != null) {
            FieldAddress addr = this.secKeyAddresses.get(secKeyMeta.getKeyName());
            Object obj = this.objAccessor.newInstance();
            Object val = this.objAccessor.getField(obj, addr.fieldNum, addr.superLevel, addr.isSecField);
            if (val != null) {
                if (addr.keyFormat.isPrimitive()) {
                    throw new IllegalArgumentException("For a new secondary key field the field type must not be a primitive -- class: " + secKeyMeta.getDeclaringClassName() + " field: " + secKeyMeta.getName());
                }
                throw new IllegalArgumentException("For a new secondary key field the default constructor must not initialize the field to a non-null value -- class: " + secKeyMeta.getDeclaringClassName() + " field: " + secKeyMeta.getName());
            }
        }
    }

    @Override
    Object newArray(int len) {
        return this.objAccessor.newArray(len);
    }

    @Override
    public Object newInstance(EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.newInstance();
    }

    @Override
    public Object readObject(Object o, EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readSecKeyFields(o, input, 0, 0x7FFFFFFE, -1);
        accessor.readNonKeyFields(o, input, 0, 0x7FFFFFFE, -1);
        return o;
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writeSecKeyFields(o, output);
        accessor.writeNonKeyFields(o, output);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean rawAccess, RawObject rawObject, IdentityHashMap converted) {
        FieldInfo[] fields = this.rawInputFields;
        int[] levels = this.rawInputLevels;
        int depth = this.rawInputDepth;
        if (fields == null || levels == null || depth == 0) {
            ComplexFormat format;
            depth = 0;
            int nFields = 0;
            for (ComplexFormat format2 = this; format2 != null; format2 = format2.getComplexSuper()) {
                nFields += format2.getNFields();
                ++depth;
            }
            ComplexFormat[] hierarchy = new ComplexFormat[depth];
            int level = depth;
            for (ComplexFormat format3 = this; format3 != null; format3 = format3.getComplexSuper()) {
                hierarchy[--level] = format3;
            }
            assert (level == 0);
            levels = new int[nFields];
            fields = new FieldInfo[nFields];
            int index = 0;
            if (this.getEntityFormat() != null) {
                for (level = depth - 1; level >= 0; --level) {
                    format = hierarchy[level];
                    if (format.priKeyField == null) continue;
                    levels[index] = level;
                    fields[index] = format.priKeyField;
                    ++index;
                    break;
                }
                assert (index == 1);
            }
            for (level = 0; level < depth; ++level) {
                format = hierarchy[level];
                for (FieldInfo field : format.secKeyFields) {
                    levels[index] = level;
                    fields[index] = field;
                    ++index;
                }
            }
            for (level = 0; level < depth; ++level) {
                format = hierarchy[level];
                for (FieldInfo field : format.nonKeyFields) {
                    levels[index] = level;
                    fields[index] = field;
                    ++index;
                }
            }
            assert (index == fields.length);
            this.rawInputFields = fields;
            this.rawInputLevels = levels;
            this.rawInputDepth = depth;
        }
        RawObject[] objectsByLevel = new RawObject[depth];
        int level = depth;
        for (RawObject raw = rawObject; raw != null; raw = raw.getSuper()) {
            if (level == 0) {
                throw new IllegalArgumentException("RawObject has too many superclasses: " + rawObject.getType().getClassName());
            }
            objectsByLevel[--level] = raw;
        }
        if (level > 0) {
            throw new IllegalArgumentException("RawObject has too few superclasses: " + rawObject.getType().getClassName());
        }
        assert (level == 0);
        RawObject[] objects = new RawObject[fields.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = objectsByLevel[levels[i]];
        }
        RawComplexInput in = new RawComplexInput(catalog, rawAccess, converted, fields, objects);
        Object o = this.newInstance(in, rawAccess);
        converted.put(rawObject, o);
        if (this.getEntityFormat() != null) {
            this.readPriKey(o, in, rawAccess);
        }
        return this.readObject(o, in, rawAccess);
    }

    @Override
    boolean isPriKeyNullOrZero(Object o, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.isPriKeyFieldNullOrZero(o);
    }

    @Override
    void writePriKey(Object o, EntityOutput output, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writePriKeyField(o, output);
    }

    @Override
    public void readPriKey(Object o, EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readPriKeyField(o, input);
    }

    @Override
    boolean nullifySecKey(Catalog catalog, Object entity, String keyName, Object keyElement) {
        if (this.secKeyAddresses == null) {
            throw new IllegalStateException();
        }
        FieldAddress addr = this.secKeyAddresses.get(keyName);
        if (addr != null) {
            Object oldVal = this.rawAccessor.getField(entity, addr.fieldNum, addr.superLevel, addr.isSecField);
            if (oldVal != null) {
                if (keyElement != null) {
                    boolean isArray;
                    RawObject container = (RawObject)oldVal;
                    Object[] a1 = container.getElements();
                    boolean bl = isArray = a1 != null;
                    if (!isArray) {
                        a1 = CollectionProxy.getElements(container);
                    }
                    if (a1 != null) {
                        for (int i = 0; i < a1.length; ++i) {
                            if (!keyElement.equals(a1[i])) continue;
                            int len = a1.length - 1;
                            Object[] a2 = new Object[len];
                            System.arraycopy(a1, 0, a2, 0, i);
                            System.arraycopy(a1, i + 1, a2, i, len - i);
                            if (isArray) {
                                this.rawAccessor.setField(entity, addr.fieldNum, addr.superLevel, addr.isSecField, new RawObject(container.getType(), a2));
                            } else {
                                CollectionProxy.setElements(container, a2);
                            }
                            return true;
                        }
                    }
                    return false;
                }
                this.rawAccessor.setField(entity, addr.fieldNum, addr.superLevel, addr.isSecField, null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    void skipContents(RecordInput input) {
        this.skipToSecKeyField(input, 0x7FFFFFFE);
        this.skipToNonKeyField(input, 0x7FFFFFFE);
    }

    @Override
    void copySecMultiKey(RecordInput input, Format keyFormat, Set results) {
        CollectionProxy.copyElements(input, this, keyFormat, results);
    }

    @Override
    Format skipToSecKey(RecordInput input, String keyName) {
        if (this.secKeyAddresses == null) {
            throw new IllegalStateException();
        }
        FieldAddress addr = this.secKeyAddresses.get(keyName);
        if (addr != null) {
            if (addr.isSecField) {
                addr.clsFormat.skipToSecKeyField(input, addr.fieldNum);
            } else {
                this.skipToSecKeyField(input, 0x7FFFFFFE);
                addr.clsFormat.skipToNonKeyField(input, addr.fieldNum);
            }
            return addr.keyFormat;
        }
        return null;
    }

    private int getNFields() {
        return (this.priKeyField != null ? 1 : 0) + this.secKeyFields.size() + this.nonKeyFields.size();
    }

    private void skipToSecKeyField(RecordInput input, int toFieldNum) {
        ComplexFormat superFormat = this.getComplexSuper();
        if (superFormat != null) {
            superFormat.skipToSecKeyField(input, 0x7FFFFFFE);
        }
        int maxNum = Math.min(this.secKeyFields.size(), toFieldNum);
        for (int i = 0; i < maxNum; ++i) {
            input.skipField(this.secKeyFields.get(i).getType());
        }
    }

    private void skipToNonKeyField(RecordInput input, int toFieldNum) {
        ComplexFormat superFormat = this.getComplexSuper();
        if (superFormat != null) {
            superFormat.skipToNonKeyField(input, 0x7FFFFFFE);
        }
        int maxNum = Math.min(this.nonKeyFields.size(), toFieldNum);
        for (int i = 0; i < maxNum; ++i) {
            input.skipField(this.nonKeyFields.get(i).getType());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    boolean evolve(Format format, Evolver evolver) {
        Object object;
        Iterator iterator;
        Serializable serializable;
        String string;
        String string2;
        if (!(format instanceof ComplexFormat)) {
            evolver.addMissingMutation(this, format, "Converter is required when a complex type is changed to a simple type or enum type");
            return false;
        }
        ComplexFormat complexFormat = (ComplexFormat)format;
        Mutations mutations = evolver.getMutations();
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        assert (this.isEntity() == complexFormat.isEntity());
        assert (this.isEntity() == (this.entityMeta != null));
        assert (complexFormat.isEntity() == (complexFormat.entityMeta != null));
        if (this.isEntity()) {
            string2 = this.getClassName();
            string = complexFormat.getClassName();
        } else {
            string2 = null;
            string = null;
        }
        Serializable serializable2 = this.getComplexSuper();
        while (serializable2 != null) {
            serializable = mutations.getConverter(((Format)serializable2).getClassName(), ((Format)serializable2).getVersion(), null);
            if (serializable != null) {
                evolver.addMissingMutation(this, format, "Converter is required for this subclass when a Converter appears on its superclass: " + serializable);
                return false;
            }
            if (!evolver.evolveFormat((Format)serializable2)) {
                return false;
            }
            if (!((Format)serializable2).isCurrentVersion()) {
                if (((Format)serializable2).isDeleted() && !super.evolveDeletedClass(evolver)) {
                    return false;
                }
                if (((ComplexFormat)serializable2).oldToNewKeyMap != null) {
                    hashMap.putAll(((ComplexFormat)serializable2).oldToNewKeyMap);
                }
                bl2 = true;
            }
            serializable2 = super.getComplexSuper();
        }
        serializable = serializable2 = complexFormat.getExistingType();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        arrayList.add(n);
        if (this.getSuperFormat() == null) {
            if (((Class)serializable2).getSuperclass() != Object.class) {
                bl = true;
                bl2 = true;
            }
        } else if (!this.getSuperFormat().getLatestVersion().getClassName().equals(((Class)serializable2).getSuperclass().getName())) {
            bl = true;
            bl2 = true;
        }
        for (ComplexFormat complexFormat2 = this.getComplexSuper(); complexFormat2 != null; complexFormat2 = complexFormat2.getComplexSuper()) {
            void object2;
            iterator = complexFormat2.getLatestVersion().getClassName();
            Object var16_18 = null;
            int n2 = n;
            for (object = ((Class)serializable).getSuperclass(); object != Object.class; object = ((Class)object).getSuperclass()) {
                ++n2;
                if (!((String)((Object)iterator)).equals(((Class)object).getName())) continue;
                Class clazz = object;
                n = n2;
                if (!complexFormat2.isEntity()) break;
                assert (string2 == null);
                assert (string == null);
                string2 = complexFormat2.getClassName();
                string = clazz.getName();
                break;
            }
            if (object2 != null) {
                for (object = ((Class)serializable).getSuperclass(); object != object2; object = ((Class)object).getSuperclass()) {
                    bl2 = true;
                    Object object3 = complexFormat2.getComplexSuper();
                    while (object3 != null) {
                        String string3 = ((Format)object3).getLatestVersion().getClassName();
                        if (string3.equals(((Class)object).getName())) {
                            evolver.addMissingMutation(this, format, "Class Converter is required when a superclass is moved in the class hierarchy: " + ((Class)object).getName());
                            return false;
                        }
                        object3 = super.getComplexSuper();
                    }
                }
                serializable = object2;
                arrayList.add(n);
                continue;
            }
            bl2 = true;
            if (!complexFormat2.isDeleted() && super.getNFields() != 0) {
                evolver.addMissingMutation(this, format, "When a superclass is removed from the class hierarchy, the superclass or all of its persistent fields must be deleted with a Deleter: " + ((Format)object).getClassName());
                return false;
            }
            if (string2 != null && this.isCurrentVersion()) {
                object = complexFormat2.clsMeta.getSecondaryKeys();
                for (FieldInfo fieldInfo : complexFormat2.secKeyFields) {
                    SecondaryKeyMetadata secondaryKeyMetadata = (SecondaryKeyMetadata)object.get(fieldInfo.getName());
                    assert (secondaryKeyMetadata != null);
                    hashMap.put(secondaryKeyMetadata.getKeyName(), null);
                }
            }
            arrayList.add(Integer.MAX_VALUE);
        }
        int n3 = this.evolveAllFields(complexFormat, evolver);
        if (n3 == 2) {
            return false;
        }
        if (n3 == 1) {
            bl = true;
        }
        if (this.oldToNewKeyMap != null) {
            hashMap.putAll(this.oldToNewKeyMap);
        }
        if (bl && !evolver.checkUpdatedVersion("Changes to the fields or superclass were detected", (Format)this, (Format)complexFormat)) {
            return false;
        }
        if (hashMap.size() > 0 && string2 != null && string != null && this.isCurrentVersion()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string4 = (String)entry.getKey();
                object = (String)entry.getValue();
                if (object != null) {
                    evolver.renameSecondaryDatabase(string2, string, string4, (String)object);
                    continue;
                }
                evolver.deleteSecondaryDatabase(string2, string4);
            }
        }
        if (bl2 || bl) {
            iterator = new EvolveReader(arrayList);
            evolver.useEvolvedFormat(this, (Reader)((Object)iterator), complexFormat);
        } else {
            evolver.useOldFormat(this, complexFormat);
        }
        return true;
    }

    @Override
    boolean evolveMetadata(Format newFormatParam, Converter converter, Evolver evolver) {
        Set<Object> deletedKeys;
        assert (!this.isDeleted());
        assert (this.isEntity());
        assert (newFormatParam.isEntity());
        ComplexFormat newFormat = (ComplexFormat)newFormatParam;
        if (!this.checkKeyTypeChange(newFormat, this.entityMeta.getPrimaryKey(), newFormat.entityMeta.getPrimaryKey(), "primary key", evolver)) {
            return false;
        }
        if (converter instanceof EntityConverter) {
            EntityConverter entityConverter = (EntityConverter)converter;
            deletedKeys = entityConverter.getDeletedKeys();
        } else {
            deletedKeys = Collections.emptySet();
        }
        Map<String, SecondaryKeyMetadata> oldSecondaryKeys = this.entityMeta.getSecondaryKeys();
        Map<String, SecondaryKeyMetadata> newSecondaryKeys = newFormat.entityMeta.getSecondaryKeys();
        HashSet<String> insertedKeys = new HashSet<String>(newSecondaryKeys.keySet());
        for (SecondaryKeyMetadata oldMeta : oldSecondaryKeys.values()) {
            String keyName = oldMeta.getKeyName();
            if (deletedKeys.contains(keyName)) {
                if (!this.isCurrentVersion()) continue;
                evolver.deleteSecondaryDatabase(this.getClassName(), keyName);
                continue;
            }
            SecondaryKeyMetadata newMeta = newSecondaryKeys.get(keyName);
            if (newMeta == null) {
                evolver.addInvalidMutation(this, newFormat, converter, "Existing key not found in new entity metadata: " + keyName);
                return false;
            }
            insertedKeys.remove(keyName);
            String keyLabel = "secondary key: " + keyName;
            if (!this.checkKeyTypeChange(newFormat, oldMeta, newMeta, keyLabel, evolver)) {
                return false;
            }
            if (this.checkSecKeyMetadata(newFormat, oldMeta, newMeta, evolver)) continue;
            return false;
        }
        if (!insertedKeys.isEmpty()) {
            evolver.addEvolveError(this, newFormat, "Error", "New keys " + insertedKeys + " not allowed when using a Converter with an entity class");
        }
        return true;
    }

    private boolean checkSecKeyMetadata(Format newFormat, SecondaryKeyMetadata oldMeta, SecondaryKeyMetadata newMeta, Evolver evolver) {
        if (oldMeta.getRelationship() != newMeta.getRelationship()) {
            evolver.addEvolveError(this, newFormat, "Change detected in the relate attribute (Relationship) of a secondary key", "Old key: " + oldMeta.getKeyName() + " relate: " + (Object)((Object)oldMeta.getRelationship()) + " new key: " + newMeta.getKeyName() + " relate: " + (Object)((Object)newMeta.getRelationship()));
            return false;
        }
        return true;
    }

    private boolean checkKeyTypeChange(Format newFormat, FieldMetadata oldMeta, FieldMetadata newMeta, String keyLabel, Evolver evolver) {
        String newClass;
        String oldClass = oldMeta.getClassName();
        if (!oldClass.equals(newClass = newMeta.getClassName())) {
            SimpleCatalog catalog = SimpleCatalog.getInstance();
            Format oldType = catalog.getFormat(oldClass);
            Format newType = catalog.getFormat(newClass);
            if (oldType == null || newType == null || (oldType.getWrapperFormat() == null || oldType.getWrapperFormat().getId() != newType.getId()) && (newType.getWrapperFormat() == null || newType.getWrapperFormat().getId() != oldType.getId())) {
                evolver.addEvolveError(this, newFormat, "Type change detected for " + keyLabel, "Old field type: " + oldClass + " is not compatible with the new type: " + newClass + " old field: " + oldMeta.getName() + " new field: " + newMeta.getName());
                return false;
            }
        }
        return true;
    }

    private boolean evolveDeletedClass(Evolver evolver) {
        assert (this.isDeleted());
        if (this.secKeyFieldReader == null || this.nonKeyFieldReader == null) {
            if (this.priKeyField != null && this.getEntityFormat() != null && !this.getEntityFormat().isDeleted()) {
                evolver.addEvolveError(this, this, "Class containing primary key field was deleted ", "Primary key is needed in an entity class hierarchy: " + this.priKeyField.getName());
                return false;
            }
            this.secKeyFieldReader = new SkipFieldReader(0, this.secKeyFields);
            this.nonKeyFieldReader = new SkipFieldReader(0, this.nonKeyFields);
            return true;
        }
        return true;
    }

    private int evolveAllFields(ComplexFormat newFormat, Evolver evolver) {
        FieldReader reader;
        assert (!this.isDeleted());
        this.secKeyFieldReader = null;
        this.nonKeyFieldReader = null;
        this.oldToNewKeyMap = null;
        boolean evolveFailure = false;
        boolean localEvolveNeeded = false;
        if (this.priKeyField != null) {
            int result = evolver.evolveRequiredKeyField(this, newFormat, this.priKeyField, newFormat.priKeyField);
            if (result == 2) {
                evolveFailure = true;
            } else if (result == 1) {
                localEvolveNeeded = true;
            }
        }
        if ((reader = this.evolveFieldList(this.secKeyFields, newFormat.secKeyFields, true, newFormat.nonKeyFields, newFormat, evolver)) == FieldReader.EVOLVE_FAILURE) {
            evolveFailure = true;
        } else if (reader != null) {
            localEvolveNeeded = true;
        }
        if (reader != FieldReader.EVOLVE_NEEDED) {
            this.secKeyFieldReader = reader;
        }
        if ((reader = this.evolveFieldList(this.nonKeyFields, newFormat.nonKeyFields, false, newFormat.secKeyFields, newFormat, evolver)) == FieldReader.EVOLVE_FAILURE) {
            evolveFailure = true;
        } else if (reader != null) {
            localEvolveNeeded = true;
        }
        if (reader != FieldReader.EVOLVE_NEEDED) {
            this.nonKeyFieldReader = reader;
        }
        if (evolveFailure) {
            return 2;
        }
        if (localEvolveNeeded) {
            return 1;
        }
        return 0;
    }

    private FieldReader getDoNothingFieldReader() {
        List<FieldReader> emptyList = Collections.emptyList();
        return new MultiFieldReader(emptyList);
    }

    private FieldReader evolveFieldList(List<FieldInfo> list, List<FieldInfo> list2, boolean bl, List<FieldInfo> list3, ComplexFormat complexFormat, Evolver evolver) {
        Mutations mutations = evolver.getMutations();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ArrayList<FieldReader> arrayList = new ArrayList<FieldReader>();
        FieldReader fieldReader = null;
        int n = 0;
        block0: for (int i = 0; i < list.size(); ++i) {
            Serializable serializable;
            Object object;
            Object object2;
            String string;
            FieldInfo fieldInfo = list.get(i);
            String string2 = fieldInfo.getName();
            SecondaryKeyMetadata secondaryKeyMetadata = null;
            if (bl) {
                secondaryKeyMetadata = this.clsMeta.getSecondaryKeys().get(string2);
                assert (secondaryKeyMetadata != null);
            }
            Renamer renamer = mutations.getRenamer(this.getClassName(), this.getVersion(), string2);
            Deleter deleter = mutations.getDeleter(this.getClassName(), this.getVersion(), string2);
            Converter converter = mutations.getConverter(this.getClassName(), this.getVersion(), string2);
            if (deleter != null && (converter != null || renamer != null)) {
                evolver.addInvalidMutation(this, complexFormat, deleter, "Field Deleter is not allowed along with a Renamer or Converter for the same field: " + string2);
                bl2 = true;
                continue;
            }
            String string3 = string = renamer != null ? renamer.getNewName() : string2;
            if (!string2.equals(string)) {
                if (this.newToOldFieldMap == null) {
                    this.newToOldFieldMap = new HashMap<String, String>();
                }
                this.newToOldFieldMap.put(string, string2);
            }
            int n2 = FieldInfo.getFieldIndex(list2, string);
            FieldInfo fieldInfo2 = null;
            boolean bl5 = bl;
            if (n2 >= 0) {
                fieldInfo2 = list2.get(n2);
            } else {
                n2 = FieldInfo.getFieldIndex(list3, string);
                if (n2 >= 0) {
                    fieldInfo2 = list3.get(n2);
                    bl5 = !bl;
                }
                bl3 = true;
                bl4 = true;
            }
            if (deleter != null) {
                if (fieldInfo2 != null) {
                    evolver.addInvalidMutation(this, complexFormat, deleter, "Field Deleter is not allowed when the persistent field is still present: " + string2);
                    bl2 = true;
                }
                if (fieldReader instanceof SkipFieldReader && fieldReader.acceptField(i, n2, bl5)) {
                    fieldReader.addField(fieldInfo);
                } else {
                    fieldReader = new SkipFieldReader(i, fieldInfo);
                    arrayList.add(fieldReader);
                    bl4 = true;
                    bl3 = true;
                }
                if (!bl) continue;
                if (this.oldToNewKeyMap == null) {
                    this.oldToNewKeyMap = new HashMap<String, String>();
                }
                this.oldToNewKeyMap.put(secondaryKeyMetadata.getKeyName(), null);
                continue;
            }
            if (fieldInfo2 == null) {
                evolver.addMissingMutation(this, complexFormat, "Field is not present or not persistent: " + string2);
                bl2 = true;
                continue;
            }
            ++n;
            SecondaryKeyMetadata secondaryKeyMetadata2 = null;
            if (bl && bl5) {
                secondaryKeyMetadata2 = complexFormat.clsMeta.getSecondaryKeys().get(string);
                assert (secondaryKeyMetadata2 != null);
                if (!this.checkSecKeyMetadata(complexFormat, secondaryKeyMetadata, secondaryKeyMetadata2, evolver)) {
                    bl2 = true;
                    continue;
                }
                String string4 = secondaryKeyMetadata.getKeyName();
                if (!string4.equals(object2 = secondaryKeyMetadata2.getKeyName())) {
                    if (this.oldToNewKeyMap == null) {
                        this.oldToNewKeyMap = new HashMap<String, String>();
                    }
                    this.oldToNewKeyMap.put(string2, string);
                    bl3 = true;
                }
            } else if (bl && !bl5) {
                if (this.oldToNewKeyMap == null) {
                    this.oldToNewKeyMap = new HashMap<String, String>();
                }
                this.oldToNewKeyMap.put(secondaryKeyMetadata.getKeyName(), null);
            }
            if (converter != null) {
                if (bl) {
                    evolver.addInvalidMutation(this, complexFormat, converter, "Field Converter is not allowed for secondary key fields: " + string2);
                    bl2 = true;
                    continue;
                }
                fieldReader = new ConvertFieldReader(converter, i, n2, bl5);
                arrayList.add(fieldReader);
                bl4 = true;
                bl3 = true;
                continue;
            }
            boolean bl6 = true;
            object2 = fieldInfo.getType();
            Format format = ((Format)object2).getLatestVersion();
            while (true) {
                assert (format != null);
                if (!evolver.evolveFormat(format)) {
                    bl2 = true;
                    continue block0;
                }
                if (!format.isNew() && !evolver.isClassConverted(format)) {
                    bl6 = false;
                }
                if ((object = evolver.getSubclassFormats(format)) != null) {
                    Iterator<Format> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        serializable = iterator.next();
                        if (!evolver.evolveFormat((Format)serializable)) {
                            bl2 = true;
                            continue block0;
                        }
                        if (serializable.isNew() || evolver.isClassConverted((Format)serializable)) continue;
                        bl6 = false;
                    }
                }
                if (format == object2) break;
                format = format.getPreviousVersion();
            }
            format = ((Format)object2).getLatestVersion();
            object = fieldInfo2.getType();
            if (!format.getClassName().equals(((Format)object).getClassName()) || format.isDeleted()) {
                if (bl6) {
                    bl3 = true;
                } else {
                    if (WidenerInput.isWideningSupported(format, (Format)object, bl)) {
                        fieldReader = new WidenFieldReader(format, (Format)object, n2, bl5);
                        arrayList.add(fieldReader);
                        bl4 = true;
                        bl3 = true;
                        continue;
                    }
                    boolean bl7 = false;
                    if (!(((Format)object).isPrimitive() || format.isPrimitive() || format.isDeleted() || evolver.isClassConverted(format))) {
                        serializable = format.getExistingType();
                        Class clazz = ((Format)object).getExistingType();
                        if (clazz.isAssignableFrom((Class<?>)serializable)) {
                            bl7 = true;
                        }
                    }
                    if (bl7) {
                        bl3 = true;
                    } else {
                        evolver.addMissingMutation(this, complexFormat, "Old field type: " + format.getClassName() + " is not compatible with the new type: " + ((Format)object).getClassName() + " for field: " + string2);
                        bl2 = true;
                        continue;
                    }
                }
            }
            if (fieldReader instanceof PlainFieldReader && fieldReader.acceptField(i, n2, bl5)) {
                fieldReader.addField(fieldInfo);
                continue;
            }
            fieldReader = new PlainFieldReader(i, n2, bl5);
            arrayList.add(fieldReader);
        }
        if (n < list2.size()) {
            bl3 = true;
            bl4 = true;
        }
        if (bl2) {
            return FieldReader.EVOLVE_FAILURE;
        }
        if (bl4) {
            if (arrayList.size() == 0) {
                return this.getDoNothingFieldReader();
            }
            if (arrayList.size() == 1) {
                return (FieldReader)arrayList.get(0);
            }
            return new MultiFieldReader(arrayList);
        }
        if (bl3) {
            return FieldReader.EVOLVE_NEEDED;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EvolveReader
    implements Reader {
        private static final long serialVersionUID = -1016140948306913283L;
        private transient ComplexFormat newFormat;
        private transient ComplexFormat[] oldHierarchy;
        private int[] newHierarchyLevels;

        EvolveReader(List<Integer> newHierarchyLevelsList) {
            int oldDepth = newHierarchyLevelsList.size();
            this.newHierarchyLevels = new int[oldDepth];
            newHierarchyLevelsList.toArray();
            for (int i = 0; i < oldDepth; ++i) {
                this.newHierarchyLevels[i] = newHierarchyLevelsList.get(i);
            }
        }

        @Override
        public void initializeReader(Catalog catalog, EntityModel model, int initVersion, Format oldFormatParam) {
            ComplexFormat oldFormat = (ComplexFormat)oldFormatParam;
            this.newFormat = oldFormat.getComplexLatest();
            this.newFormat.initializeIfNeeded(catalog, model);
            int newDepth = 0;
            for (Format format = this.newFormat; format != null; format = format.getSuperFormat()) {
                ++newDepth;
            }
            ComplexFormat[] newHierarchy = new ComplexFormat[newDepth];
            int level = 0;
            ComplexFormat format = this.newFormat;
            while (format != null) {
                newHierarchy[level] = format;
                ++level;
                format = format.getComplexSuper();
            }
            assert (level == newDepth);
            int oldDepth = this.newHierarchyLevels.length;
            this.oldHierarchy = new ComplexFormat[oldDepth];
            level = 0;
            ComplexFormat oldFormat2 = oldFormat;
            while (oldFormat2 != null) {
                this.oldHierarchy[level] = oldFormat2;
                int level2 = this.newHierarchyLevels[level];
                ComplexFormat newFormat2 = level2 != Integer.MAX_VALUE ? newHierarchy[level2] : null;
                ++level;
                if (oldFormat2.secKeyFieldReader != null) {
                    oldFormat2.secKeyFieldReader.initialize(catalog, initVersion, oldFormat2, newFormat2, true);
                }
                if (oldFormat2.nonKeyFieldReader != null) {
                    oldFormat2.nonKeyFieldReader.initialize(catalog, initVersion, oldFormat2, newFormat2, false);
                }
                oldFormat2 = oldFormat2.getComplexSuper();
            }
            assert (level == oldDepth);
        }

        @Override
        public Object newInstance(EntityInput input, boolean rawAccess) {
            return this.newFormat.newInstance(input, rawAccess);
        }

        @Override
        public void readPriKey(Object o, EntityInput input, boolean rawAccess) {
            this.newFormat.readPriKey(o, input, rawAccess);
        }

        @Override
        public Object readObject(Object o, EntityInput input, boolean rawAccess) {
            int newLevel;
            FieldReader reader;
            int maxMinusOne;
            int i;
            Accessor accessor = rawAccess ? this.newFormat.rawAccessor : this.newFormat.objAccessor;
            for (i = maxMinusOne = this.oldHierarchy.length - 1; i >= 0; --i) {
                reader = this.oldHierarchy[i].secKeyFieldReader;
                newLevel = this.newHierarchyLevels[i];
                if (reader != null) {
                    reader.readFields(o, input, accessor, newLevel);
                    continue;
                }
                if (newLevel == Integer.MAX_VALUE) continue;
                accessor.readSecKeyFields(o, input, 0, 0x7FFFFFFE, newLevel);
            }
            for (i = maxMinusOne; i >= 0; --i) {
                reader = this.oldHierarchy[i].nonKeyFieldReader;
                newLevel = this.newHierarchyLevels[i];
                if (reader != null) {
                    reader.readFields(o, input, accessor, newLevel);
                    continue;
                }
                if (newLevel == Integer.MAX_VALUE) continue;
                accessor.readNonKeyFields(o, input, 0, 0x7FFFFFFE, newLevel);
            }
            return o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -6035976787562441473L;
        private List<FieldReader> subReaders;

        MultiFieldReader(List<FieldReader> subReaders) {
            this.subReaders = subReaders;
        }

        @Override
        void initialize(Catalog catalog, int initVersion, ComplexFormat oldParentFormat, ComplexFormat newParentFormat, boolean isOldSecKey) {
            for (FieldReader reader : this.subReaders) {
                reader.initialize(catalog, initVersion, oldParentFormat, newParentFormat, isOldSecKey);
            }
        }

        @Override
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) {
            for (FieldReader reader : this.subReaders) {
                reader.readFields(o, input, accessor, superLevel);
            }
        }
    }

    private static class WidenFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -2054520670170407282L;
        private int fromFormatId;
        private int toFormatId;
        private int fieldNum;
        private boolean secKeyField;

        WidenFieldReader(Format oldFormat, Format newFormat, int newFieldIndex, boolean isNewSecKeyField) {
            this.fromFormatId = oldFormat.getId();
            this.toFormatId = newFormat.getId();
            this.fieldNum = newFieldIndex;
            this.secKeyField = isNewSecKeyField;
        }

        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) {
            WidenerInput widenerInput = new WidenerInput(input, this.fromFormatId, this.toFormatId);
            if (this.secKeyField) {
                accessor.readSecKeyFields(o, widenerInput, this.fieldNum, this.fieldNum, superLevel);
            } else {
                accessor.readNonKeyFields(o, widenerInput, this.fieldNum, this.fieldNum, superLevel);
            }
        }
    }

    private static class ConvertFieldReader
    extends FieldReader {
        private static final long serialVersionUID = 8736410481633998710L;
        private Converter converter;
        private int oldFieldNum;
        private int fieldNum;
        private boolean secKeyField;
        private transient Format oldFormat;
        private transient Format newFormat;

        ConvertFieldReader(Converter converter, int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            this.converter = converter;
            this.oldFieldNum = oldFieldIndex;
            this.fieldNum = newFieldIndex;
            this.secKeyField = isNewSecKeyField;
        }

        void initialize(Catalog catalog, int initVersion, ComplexFormat oldParentFormat, ComplexFormat newParentFormat, boolean isOldSecKey) {
            if (initVersion < 1) {
                this.oldFieldNum = this.fieldNum;
            }
            this.oldFormat = isOldSecKey ? ((FieldInfo)oldParentFormat.secKeyFields.get(this.oldFieldNum)).getType() : ((FieldInfo)oldParentFormat.nonKeyFields.get(this.oldFieldNum)).getType();
            this.newFormat = this.secKeyField ? ((FieldInfo)newParentFormat.secKeyFields.get(this.fieldNum)).getType() : ((FieldInfo)newParentFormat.nonKeyFields.get(this.fieldNum)).getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) {
            Object value;
            boolean currentRawMode = input.setRawAccess(true);
            try {
                value = this.oldFormat.isPrimitive() ? input.readKeyObject(this.oldFormat) : input.readObject();
                Object var8_7 = null;
                input.setRawAccess(currentRawMode);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                input.setRawAccess(currentRawMode);
                throw throwable;
            }
            Catalog catalog = input.getCatalog();
            value = this.converter.getConversion().convert(value);
            RawSingleInput rawInput = new RawSingleInput(catalog, currentRawMode, null, value, this.newFormat);
            if (this.secKeyField) {
                accessor.readSecKeyFields(o, rawInput, this.fieldNum, this.fieldNum, superLevel);
            } else {
                accessor.readNonKeyFields(o, rawInput, this.fieldNum, this.fieldNum, superLevel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SkipFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -3060281692155253098L;
        private List<Format> fieldFormats;
        private transient int endField;

        SkipFieldReader(int startField, List<FieldInfo> fields) {
            this.endField = startField + fields.size() - 1;
            this.fieldFormats = new ArrayList<Format>(fields.size());
            for (FieldInfo field : fields) {
                this.fieldFormats.add(field.getType());
            }
        }

        SkipFieldReader(int startField, FieldInfo oldField) {
            this.endField = startField;
            this.fieldFormats = new ArrayList<Format>();
            this.fieldFormats.add(oldField.getType());
        }

        @Override
        boolean acceptField(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            return oldFieldIndex == this.endField + 1;
        }

        @Override
        void addField(FieldInfo oldField) {
            ++this.endField;
            this.fieldFormats.add(oldField.getType());
        }

        @Override
        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) {
            for (Format format : this.fieldFormats) {
                input.skipField(format);
            }
        }
    }

    private static class PlainFieldReader
    extends FieldReader {
        private static final long serialVersionUID = 1795593463439931402L;
        private int startField;
        private int endField;
        private boolean secKeyField;
        private transient int endOldField;

        PlainFieldReader(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            this.endOldField = oldFieldIndex;
            this.startField = newFieldIndex;
            this.endField = newFieldIndex;
            this.secKeyField = isNewSecKeyField;
        }

        boolean acceptField(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            return oldFieldIndex == this.endOldField + 1 && newFieldIndex == this.endField + 1 && this.secKeyField == isNewSecKeyField;
        }

        void addField(FieldInfo oldField) {
            ++this.endField;
            ++this.endOldField;
        }

        final void readFields(Object o, EntityInput input, Accessor accessor, int superLevel) {
            if (this.secKeyField) {
                accessor.readSecKeyFields(o, input, this.startField, this.endField, superLevel);
            } else {
                accessor.readNonKeyFields(o, input, this.startField, this.endField, superLevel);
            }
        }
    }

    private static abstract class FieldReader
    implements Serializable {
        static final FieldReader EVOLVE_NEEDED = new PlainFieldReader(0, 0, false);
        static final FieldReader EVOLVE_FAILURE = new PlainFieldReader(0, 0, false);
        private static final long serialVersionUID = 866041475399255164L;

        FieldReader() {
        }

        void initialize(Catalog catalog, int initVersion, ComplexFormat oldParentFormat, ComplexFormat newParentFormat, boolean isOldSecKey) {
        }

        boolean acceptField(int oldFieldIndex, int newFieldIndex, boolean isNewSecKeyField) {
            return false;
        }

        void addField(FieldInfo oldField) {
            throw new UnsupportedOperationException();
        }

        abstract void readFields(Object var1, EntityInput var2, Accessor var3, int var4);
    }

    private static class FieldAddress {
        boolean isSecField;
        int fieldNum;
        int superLevel;
        ComplexFormat clsFormat;
        Format keyFormat;

        FieldAddress(boolean isSecField, int fieldNum, int superLevel, ComplexFormat clsFormat, Format keyFormat) {
            this.isSecField = isSecField;
            this.fieldNum = fieldNum;
            this.superLevel = superLevel;
            this.clsFormat = clsFormat;
            this.keyFormat = keyFormat;
        }
    }
}

