/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.DatabaseNamer;
import com.sleepycat.persist.evolve.DeletedClassException;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.ComplexFormat;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.MapProxy;
import com.sleepycat.persist.impl.NonPersistentFormat;
import com.sleepycat.persist.impl.ObjectArrayFormat;
import com.sleepycat.persist.impl.PrimitiveArrayFormat;
import com.sleepycat.persist.impl.ProxiedFormat;
import com.sleepycat.persist.impl.ReadOnlyCatalog;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.impl.StoredModel;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistCatalog
implements Catalog {
    private static final byte[] DATA_KEY = PersistCatalog.getIntBytes(-1);
    private static final byte[] BETA_MUTATIONS_KEY = PersistCatalog.getIntBytes(-2);
    public static boolean expectNoClassChanges;
    public static boolean unevolvedFormatsEncountered;
    private volatile List<Format> formatList;
    private volatile Map<String, Format> formatMap;
    private volatile Map<String, Format> latestFormatMap;
    private Map<String, String> proxyClassMap;
    private boolean rawAccess;
    private EntityModel model;
    private Mutations mutations;
    private Database db;
    private int openCount;
    private Store store;
    private Evolver evolver;
    private Data catalogData;

    private static byte[] getIntBytes(int val) {
        DatabaseEntry entry = new DatabaseEntry();
        IntegerBinding.intToEntry(val, entry);
        assert (entry.getSize() == 4 && entry.getData().length == 4);
        return entry.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PersistCatalog(Transaction transaction, Environment environment, String string, String string2, DatabaseConfig databaseConfig, EntityModel entityModel, Mutations mutations, boolean bl, Store store) throws DatabaseException {
        boolean bl2;
        block30: {
            block29: {
                this.rawAccess = bl;
                this.store = store;
                String[] stringArray = store != null ? store.parseDbName(string2) : Store.parseDbName(string2, DatabaseNamer.DEFAULT);
                try {
                    this.db = DbCompat.openDatabase(environment, transaction, stringArray[0], stringArray[1], databaseConfig);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new DatabaseException(fileNotFoundException);
                }
                this.openCount = 1;
                bl2 = false;
                try {
                    boolean bl3;
                    Iterator<Format> iterator;
                    boolean bl4;
                    this.catalogData = this.readData(transaction);
                    this.mutations = this.catalogData.mutations;
                    if (this.mutations == null) {
                        this.mutations = new Mutations();
                    }
                    boolean bl5 = bl4 = this.catalogData.version == -1;
                    boolean bl6 = bl4;
                    boolean bl7 = false;
                    if (mutations != null && !this.mutations.equals(mutations)) {
                        this.mutations = mutations;
                        bl5 = true;
                        bl7 = true;
                    }
                    this.formatList = this.catalogData.formatList;
                    if (this.formatList == null) {
                        this.formatList = SimpleCatalog.copyFormatList();
                        iterator = new NonPersistentFormat(Object.class);
                        ((Format)((Object)iterator)).setId(1);
                        this.formatList.set(1, (Format)((Object)iterator));
                        iterator = new NonPersistentFormat(Number.class);
                        ((Format)((Object)iterator)).setId(22);
                        this.formatList.set(22, (Format)((Object)iterator));
                    } else if (SimpleCatalog.copyMissingFormats(this.formatList)) {
                        bl5 = true;
                    }
                    if (bl4) {
                        iterator = new HashMap();
                        for (Format format : this.formatList) {
                            if (format == null) continue;
                            iterator.put(format.getClassName(), format);
                        }
                        for (Format format : this.formatList) {
                            if (format == null) continue;
                            format.migrateFromBeta((Map<String, Format>)((Object)iterator));
                        }
                    }
                    this.formatMap = new HashMap<String, Format>(this.formatList.size());
                    this.latestFormatMap = new HashMap<String, Format>(this.formatList.size());
                    if (bl) {
                        for (Format format : this.formatList) {
                            if (format == null) continue;
                            String string3 = format.getClassName();
                            if (format.isCurrentVersion()) {
                                this.formatMap.put(string3, format);
                            }
                            if (format != format.getLatestVersion()) continue;
                            this.latestFormatMap.put(string3, format);
                        }
                        this.model = new StoredModel(this);
                        for (Format format : this.formatList) {
                            if (format == null) continue;
                            format.initializeIfNeeded(this, this.model);
                        }
                        bl2 = true;
                        Object var23_43 = null;
                        this.proxyClassMap = null;
                        this.catalogData = null;
                        this.evolver = null;
                        if (bl2) return;
                        break block29;
                    }
                    this.model = entityModel != null ? entityModel : new AnnotationModel();
                    for (int i = 0; i <= 30; ++i) {
                        Format format = this.formatList.get(i);
                        if (format == null) continue;
                        this.formatMap.put(format.getClassName(), format);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>(this.model.getKnownClasses());
                    this.addPredefinedProxies(arrayList);
                    this.proxyClassMap = new HashMap<String, String>();
                    for (Format format : this.formatList) {
                        if (format == null || Format.isPredefined(format)) continue;
                        String string4 = format.getClassName();
                        Renamer renamer = this.mutations.getRenamer(string4, format.getVersion(), null);
                        String string5 = renamer != null ? renamer.getNewName() : string4;
                        this.addProxiedClass(string5);
                    }
                    for (String string6 : arrayList) {
                        this.addProxiedClass(string6);
                    }
                    HashMap<String, Format> hashMap = new HashMap<String, Format>();
                    for (String string7 : arrayList) {
                        this.createFormat(string7, hashMap);
                    }
                    this.evolver = new Evolver(this, string, this.mutations, hashMap, bl7, bl6);
                    for (Format format : this.formatList) {
                        if (format == null || Format.isPredefined(format)) continue;
                        if (format.isEntity()) {
                            this.evolver.evolveFormat(format);
                            continue;
                        }
                        this.evolver.addNonEntityFormat(format);
                    }
                    this.evolver.finishEvolution();
                    String string8 = this.evolver.getErrors();
                    if (string8 != null) {
                        throw new IncompatibleClassException(string8);
                    }
                    for (Format format : hashMap.values()) {
                        this.addFormat(format);
                    }
                    for (Format format : this.formatList) {
                        if (format == null) continue;
                        format.initializeIfNeeded(this, this.model);
                        if (format != format.getLatestVersion()) continue;
                        this.latestFormatMap.put(format.getClassName(), format);
                    }
                    boolean bl8 = bl3 = hashMap.size() > 0 || this.evolver.areFormatsChanged();
                    if (expectNoClassChanges && bl3) {
                        throw new IllegalStateException("Unexpected changes  newFormats.size=" + hashMap.size() + " areFormatsChanged=" + this.evolver.areFormatsChanged());
                    }
                    if ((bl3 || bl5) && !this.db.getConfig().getReadOnly()) {
                        this.evolver.renameAndRemoveDatabases(store, transaction);
                        this.catalogData.formatList = this.formatList;
                        this.catalogData.mutations = this.mutations;
                        this.writeData(transaction, this.catalogData);
                    } else if (bl5) {
                        throw new IllegalArgumentException("When an upgrade is required the store may not be opened read-only");
                    }
                    bl2 = true;
                    break block30;
                }
                catch (Throwable throwable) {
                    Object var23_45 = null;
                    this.proxyClassMap = null;
                    this.catalogData = null;
                    this.evolver = null;
                    if (bl2) throw throwable;
                    this.close();
                    throw throwable;
                }
            }
            this.close();
            return;
        }
        Object var23_44 = null;
        this.proxyClassMap = null;
        this.catalogData = null;
        this.evolver = null;
        if (bl2) return;
        this.close();
    }

    public void getEntityFormats(Collection<Format> entityFormats) {
        for (Format format : this.formatMap.values()) {
            if (!format.isEntity()) continue;
            entityFormats.add(format);
        }
    }

    private void addProxiedClass(String className) {
        String proxiedClassName;
        ClassMetadata metadata = this.model.getClassMetadata(className);
        if (metadata != null && (proxiedClassName = metadata.getProxiedClassName()) != null) {
            this.proxyClassMap.put(proxiedClassName, className);
        }
    }

    private void addPredefinedProxies(List<String> list) {
        list.add(CollectionProxy.ArrayListProxy.class.getName());
        list.add(CollectionProxy.LinkedListProxy.class.getName());
        list.add(CollectionProxy.HashSetProxy.class.getName());
        list.add(CollectionProxy.TreeSetProxy.class.getName());
        list.add(MapProxy.HashMapProxy.class.getName());
        list.add(MapProxy.TreeMapProxy.class.getName());
    }

    Map<Format, Set<Format>> getSubclassMap() {
        HashMap<Format, Set<Format>> subclassMap = new HashMap<Format, Set<Format>>();
        for (Format format : this.formatList) {
            Format superFormat;
            if (format == null || Format.isPredefined(format) || (superFormat = format.getSuperFormat()) == null) continue;
            HashSet<Format> subclass = (HashSet<Format>)subclassMap.get(superFormat);
            if (subclass == null) {
                subclass = new HashSet<Format>();
                subclassMap.put(superFormat, subclass);
            }
            subclass.add(format);
        }
        return subclassMap;
    }

    public EntityModel getResolvedModel() {
        return this.model;
    }

    public void openExisting() {
        ++this.openCount;
    }

    public boolean close() throws DatabaseException {
        if (this.openCount == 0) {
            throw new IllegalStateException("Catalog is not open");
        }
        --this.openCount;
        if (this.openCount == 0) {
            Database dbToClose = this.db;
            this.db = null;
            dbToClose.close();
            return true;
        }
        return false;
    }

    public Mutations getMutations() {
        return this.mutations;
    }

    @Override
    public Format createFormat(String clsName, Map<String, Format> newFormats) {
        Class type;
        try {
            type = SimpleCatalog.classForName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Class does not exist: " + clsName);
        }
        return this.createFormat(type, newFormats);
    }

    @Override
    public Format createFormat(Class clazz, Map<String, Format> map) {
        String string = clazz.getName();
        Format format = map.get(string);
        if (format != null) {
            return format;
        }
        format = this.formatMap.get(string);
        if (format != null) {
            return format;
        }
        assert (!SimpleCatalog.isSimpleType(clazz)) : string;
        String string2 = null;
        if (this.proxyClassMap != null) {
            string2 = this.proxyClassMap.get(string);
        }
        if (string2 != null) {
            format = new ProxiedFormat(clazz, string2);
        } else if (clazz.isArray()) {
            format = clazz.getComponentType().isPrimitive() ? new PrimitiveArrayFormat(clazz) : new ObjectArrayFormat(clazz);
        } else if (clazz.isEnum()) {
            format = new EnumFormat(clazz);
        } else if (clazz == Object.class || clazz.isInterface()) {
            format = new NonPersistentFormat(clazz);
        } else {
            ClassMetadata classMetadata = this.model.getClassMetadata(string);
            if (classMetadata == null) {
                throw new IllegalArgumentException("Class could not be loaded or is not persistent: " + string);
            }
            if (classMetadata.getCompositeKeyFields() != null && (classMetadata.getPrimaryKey() != null || classMetadata.getSecondaryKeys() != null)) {
                throw new IllegalArgumentException("A composite key class may not have primary or secondary key fields: " + clazz.getName());
            }
            try {
                clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("No default constructor: " + clazz.getName(), noSuchMethodException);
            }
            if (classMetadata.getCompositeKeyFields() != null) {
                format = new CompositeKeyFormat(clazz, classMetadata, classMetadata.getCompositeKeyFields());
            } else {
                EntityMetadata entityMetadata = this.model.getEntityMetadata(string);
                format = new ComplexFormat(clazz, classMetadata, entityMetadata);
            }
        }
        map.put(string, format);
        format.collectRelatedFormats(this, map);
        return format;
    }

    private void addFormat(Format format) {
        this.addFormat(format, this.formatList, this.formatMap);
    }

    private void addFormat(Format format, List<Format> list, Map<String, Format> map) {
        format.setId(list.size());
        list.add(format);
        map.put(format.getClassName(), format);
    }

    void useExistingFormat(Format oldFormat) {
        assert (oldFormat.isCurrentVersion());
        this.formatMap.put(oldFormat.getClassName(), oldFormat);
    }

    Set<String> getModelClasses() {
        HashSet<String> classes = new HashSet<String>();
        for (Format format : this.formatMap.values()) {
            if (!format.isModelClass()) continue;
            classes.add(format.getClassName());
        }
        return Collections.unmodifiableSet(classes);
    }

    @Override
    public int getInitVersion(Format format, boolean forReader) {
        if (this.catalogData == null || this.catalogData.formatList == null || format.getId() >= this.catalogData.formatList.size()) {
            return 1;
        }
        assert (this.catalogData != null);
        if (forReader) {
            return this.evolver != null && this.evolver.isFormatChanged(format) ? 1 : this.catalogData.version;
        }
        return this.catalogData.version;
    }

    @Override
    public Format getFormat(int formatId) {
        try {
            Format format = this.formatList.get(formatId);
            if (format == null) {
                throw new DeletedClassException("Format does not exist: " + formatId);
            }
            return format;
        }
        catch (NoSuchElementException e) {
            throw new DeletedClassException("Format does not exist: " + formatId);
        }
    }

    @Override
    public Format getFormat(Class cls, boolean openEntitySubclassIndexes) {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            if (this.model != null) {
                ComplexFormat entityFormat;
                format = this.addNewFormat(cls);
                if (openEntitySubclassIndexes && this.store != null && (entityFormat = format.getEntityFormat()) != null && entityFormat != format) {
                    try {
                        this.store.openSecondaryIndexes(null, ((Format)entityFormat).getEntityMetadata(), null);
                    }
                    catch (DatabaseException e) {
                        throw new RuntimeExceptionWrapper(e);
                    }
                }
            }
            if (format == null) {
                throw new IllegalArgumentException("Class is not persistent: " + cls.getName());
            }
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    private synchronized Format addNewFormat(Class cls) {
        Format format = this.formatMap.get(cls.getName());
        if (format != null) {
            return format;
        }
        ArrayList<Format> newFormatList = new ArrayList<Format>(this.formatList);
        HashMap<String, Format> newFormatMap = new HashMap<String, Format>(this.formatMap);
        HashMap<String, Format> newLatestFormatMap = new HashMap<String, Format>(this.latestFormatMap);
        HashMap<String, Format> newFormats = new HashMap<String, Format>();
        format = this.createFormat(cls, newFormats);
        for (Format newFormat : newFormats.values()) {
            this.addFormat(newFormat, newFormatList, newFormatMap);
        }
        ReadOnlyCatalog newFormatCatalog = new ReadOnlyCatalog(newFormatList, newFormatMap);
        for (Format newFormat : newFormats.values()) {
            newFormat.initializeIfNeeded(newFormatCatalog, this.model);
            newLatestFormatMap.put(newFormat.getClassName(), newFormat);
        }
        try {
            Data catalogData = new Data();
            catalogData.formatList = newFormatList;
            catalogData.mutations = this.mutations;
            this.writeData(null, catalogData);
        }
        catch (DatabaseException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        this.formatList = newFormatList;
        this.formatMap = newFormatMap;
        this.latestFormatMap = newLatestFormatMap;
        return format;
    }

    private Data readData(Transaction txn) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry(DATA_KEY);
        DatabaseEntry data = new DatabaseEntry();
        OperationStatus status = this.db.get(txn, key, data, null);
        if (status == OperationStatus.SUCCESS) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getData(), data.getOffset(), data.getSize());
            try {
                Data catalogData;
                ObjectInputStream ois = new ObjectInputStream(bais);
                Object object = ois.readObject();
                assert (ois.available() == 0);
                if (object instanceof Data) {
                    catalogData = (Data)object;
                } else {
                    if (!(object instanceof List)) {
                        throw new IllegalStateException(object.getClass().getName());
                    }
                    catalogData = new Data();
                    catalogData.formatList = (List)object;
                    catalogData.version = -1;
                }
                return catalogData;
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseException(e);
            }
            catch (IOException e) {
                throw new DatabaseException(e);
            }
        }
        Data catalogData = new Data();
        catalogData.version = 1;
        return catalogData;
    }

    private void writeData(Transaction txn, Data catalogData) throws DatabaseException {
        boolean wasBetaVersion = catalogData.version == -1;
        catalogData.version = 1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(catalogData);
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        DatabaseEntry key = new DatabaseEntry(DATA_KEY);
        DatabaseEntry data = new DatabaseEntry(baos.toByteArray());
        this.db.put(txn, key, data);
        if (wasBetaVersion) {
            key.setData(BETA_MUTATIONS_KEY);
            this.db.delete(txn, key);
        }
    }

    @Override
    public boolean isRawAccess() {
        return this.rawAccess;
    }

    @Override
    public Object convertRawObject(RawObject o, IdentityHashMap converted) {
        Format proxiedFormat;
        Format format = (Format)o.getType();
        if (this != format.getCatalog()) {
            String clsName = format.getClassName();
            try {
                Class cls = SimpleCatalog.classForName(clsName);
                format = this.getFormat(cls, true);
            }
            catch (ClassNotFoundException e) {
                format = null;
            }
            if (format == null) {
                throw new IllegalArgumentException("External raw type not found: " + clsName);
            }
        }
        if ((proxiedFormat = format.getProxiedFormat()) != null) {
            format = proxiedFormat;
        }
        if (converted == null) {
            converted = new IdentityHashMap();
        }
        return format.convertRawObject(this, false, o, converted);
    }

    private static class Data
    implements Serializable {
        static final long serialVersionUID = 7515058069137413261L;
        List<Format> formatList;
        Mutations mutations;
        int version;

        private Data() {
        }
    }
}

