/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util.keyrange;

import com.sleepycat.je.DatabaseEntry;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyRange {
    public static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    Comparator<byte[]> comparator;
    DatabaseEntry beginKey;
    DatabaseEntry endKey;
    boolean singleKey;
    boolean beginInclusive;
    boolean endInclusive;

    public KeyRange(Comparator<byte[]> comparator) {
        this.comparator = comparator;
    }

    public String toString() {
        return "[KeyRange " + this.beginKey + ' ' + this.beginInclusive + this.endKey + ' ' + this.endInclusive + (this.singleKey ? " single" : "");
    }

    public static byte[] getByteArray(DatabaseEntry entry, int maxBytes) {
        return KeyRange.getByteArrayInternal(entry, maxBytes);
    }

    private static byte[] getByteArrayInternal(DatabaseEntry entry, int maxBytes) {
        byte[] data;
        byte[] bytes = entry.getData();
        if (bytes == null) {
            return null;
        }
        int size = Math.min(entry.getSize(), maxBytes);
        if (size == 0) {
            data = ZERO_LENGTH_BYTE_ARRAY;
        } else {
            data = new byte[size];
            System.arraycopy(bytes, entry.getOffset(), data, 0, size);
        }
        return data;
    }
}

