/*
 * Decompiled with CFR 0.152.
 */
package mobac;

import javax.swing.SwingUtilities;
import mobac.gui.MainGUI;
import mobac.program.DirectoryManager;
import mobac.program.EnvironmentSetup;
import mobac.program.Logging;
import mobac.program.ProgramInfo;
import mobac.program.model.Settings;
import mobac.program.tilestore.TileStore;
import mobac.utilities.GUIExceptionHandler;

public class Main {
    public Main() {
        try {
            Logging.configureLogging();
            ProgramInfo.initialize();
            Logging.logSystemInfo();
            GUIExceptionHandler.installToolkitEventQueueProxy();
            DirectoryManager.initialize();
            EnvironmentSetup.checkMemory();
            EnvironmentSetup.checkFileSetup();
            Settings.loadOrQuit();
            TileStore.initialize();
            EnvironmentSetup.upgrade();
            Logging.LOG.debug("Starting GUI");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainGUI.createMainGui();
                }
            });
        }
        catch (Throwable t) {
            GUIExceptionHandler.processException(t);
        }
    }
}

