/*
 * Decompiled with CFR 0.152.
 */
package mobac.data.gpx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import mobac.data.gpx.gpx11.Gpx;
import mobac.utilities.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GPXUtils {
    public static boolean checkJAXBVersion() {
        boolean res = Utilities.checkJAXBVersion();
        if (!res) {
            JOptionPane.showMessageDialog(null, "Outdated Java Runtime Environment and JAXB version", "Mobile Atlas Creator has detected that your used Java Runtime Environment is too old.\n Please update the Java Runtime Environment to at least \nversion 1.6.0_14 and restart Mobile Atlas Creator.", 0);
        }
        return res;
    }

    public static Gpx loadGpxFile(File file) throws JAXBException {
        String string;
        FileInputStream fileInputStream;
        block8: {
            Document document;
            Unmarshaller unmarshaller;
            block7: {
                JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Gpx.class});
                unmarshaller = jAXBContext.createUnmarshaller();
                fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(fileInputStream);
                string = document.getDocumentElement().getNamespaceURI();
                if (!"http://www.topografix.com/GPX/1/1".equals(string)) break block7;
                Gpx gpx = (Gpx)unmarshaller.unmarshal((Node)document);
                Utilities.closeStream(fileInputStream);
                return gpx;
            }
            if (!"http://www.topografix.com/GPX/1/0".equals(string)) break block8;
            DOMSource dOMSource = new DOMSource(document);
            StreamSource streamSource = new StreamSource(Utilities.loadResourceAsStream("xsl/gpx10to11.xsl"));
            JAXBResult jAXBResult = new JAXBResult(unmarshaller);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(streamSource);
            transformer.transform(dOMSource, (Result)jAXBResult);
            Gpx gpx = (Gpx)jAXBResult.getResult();
            Utilities.closeStream(fileInputStream);
            return gpx;
        }
        try {
            try {
                throw new JAXBException("Expected GPX 1.0 or GPX1.1 namespace but found \n\"" + string + "\"");
            }
            catch (JAXBException jAXBException) {
                throw jAXBException;
            }
            catch (Exception exception) {
                throw new JAXBException((Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Utilities.closeStream(fileInputStream);
            throw throwable;
        }
    }

    public static void saveGpxFile(Gpx gpx, File file) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Gpx.class});
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            marshaller.marshal((Object)gpx, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new JAXBException((Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                Utilities.closeStream(fileOutputStream);
                throw throwable;
            }
        }
        Utilities.closeStream(fileOutputStream);
    }
}

