/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import mobac.gui.MainGUI;
import mobac.program.AtlasThread;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.Settings;
import mobac.utilities.GBC;
import mobac.utilities.OSUtilities;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;

public class AtlasProgress
extends JFrame
implements ActionListener {
    private static Logger log = Logger.getLogger(AtlasProgress.class);
    private static final long serialVersionUID = -1L;
    private static final Timer TIMER = new Timer(true);
    private JProgressBar atlasProgressBar;
    private JProgressBar mapDownloadProgressBar;
    private JProgressBar mapCreationProgressBar;
    private Container background;
    private long initialTotalTime;
    private long initialMapDownloadTime;
    private final Data data = new Data();
    private boolean aborted = false;
    private JLabel windowTitle;
    private JLabel title;
    private JLabel mapInfoLabel;
    private JLabel mapDownloadTitle;
    private JLabel atlasPercent;
    private JLabel mapDownloadPercent;
    private JLabel atlasMapsDone;
    private JLabel mapDownloadElementsDone;
    private JLabel atlasTimeLeft;
    private JLabel mapDownloadTimeLeft;
    private JLabel mapCreation;
    private JLabel nrOfDownloadedBytes;
    private JLabel nrOfDownloadedBytesValue;
    private JLabel nrOfDownloadedBytesPerSecond;
    private JLabel nrOfDownloadedBytesPerSecondValue;
    private JLabel activeDownloads;
    private JLabel activeDownloadsValue;
    private JLabel downloadErrors;
    private JLabel downloadErrorsValue;
    private JLabel totalDownloadTime;
    private JLabel totalDownloadTimeValue;
    private JCheckBox ignoreDlErrors;
    private JButton dismissWindowButton;
    private JButton openProgramFolderButton;
    private JButton abortAtlasCreationButton;
    private JButton pauseResumeDownloadButton;
    private AtlasCreationController downloadControlListener = null;
    private UpdateTask updateTask = null;
    private GUIUpdater guiUpdater = null;
    private AtlasThread atlasThread;
    private ArrayList<MapInfo> mapInfos = null;
    private static String TEXT_MAP_DOWNLOAD = "Downloading tiles for map number ";
    private static String TEXT_PERCENT = "Percent done: %d%%";

    public AtlasProgress(AtlasThread atlasThread) {
        super("Atlas creation in progress");
        this.atlasThread = atlasThread;
        ToolTipManager.sharedInstance().setDismissDelay(12000);
        this.setIconImages(MainGUI.MOBAC_ICONS);
        this.setLayout(new GridBagLayout());
        this.updateTask = new UpdateTask();
        this.guiUpdater = new GUIUpdater();
        this.createComponents();
        this.pack();
        this.background.setLayout(null);
        this.setResizable(false);
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dContent = this.getSize();
        this.setLocation((dScreen.width - dContent.width) / 2, (dScreen.height - dContent.height) / 2);
        this.initialTotalTime = System.currentTimeMillis();
        this.initialMapDownloadTime = System.currentTimeMillis();
        this.addWindowListener(new CloseListener());
    }

    private void createComponents() {
        this.background = new JPanel(new GridBagLayout());
        this.windowTitle = new JLabel("<html><h3>ATLAS CREATION IN PROGRESS...</h3></html>");
        this.title = new JLabel("Processing maps of atlas:");
        this.mapInfoLabel = new JLabel("Processing map: ");
        this.atlasMapsDone = new JLabel("000 of 000 done");
        this.atlasPercent = new JLabel(String.format(TEXT_PERCENT, 100));
        this.atlasTimeLeft = new JLabel("Time remaining: 00000 minutes 00 seconds", 4);
        this.atlasProgressBar = new JProgressBar();
        this.mapDownloadTitle = new JLabel(TEXT_MAP_DOWNLOAD + "000");
        this.mapDownloadElementsDone = new JLabel("1000000 of 1000000 tiles done");
        this.mapDownloadPercent = new JLabel(String.format(TEXT_PERCENT, 100));
        this.mapDownloadTimeLeft = new JLabel("Time remaining: 00000 minutes 00 seconds", 4);
        this.mapDownloadProgressBar = new JProgressBar();
        this.mapCreation = new JLabel("Map Creation");
        this.mapCreationProgressBar = new JProgressBar();
        this.nrOfDownloadedBytesPerSecond = new JLabel("Average download speed");
        this.nrOfDownloadedBytesPerSecondValue = new JLabel();
        this.nrOfDownloadedBytes = new JLabel("Total download size");
        this.nrOfDownloadedBytesValue = new JLabel();
        this.activeDownloads = new JLabel("Active tile fetcher threads");
        this.activeDownloadsValue = new JLabel();
        this.downloadErrors = new JLabel("Download errors");
        this.downloadErrors.setToolTipText("<html><h4>Download errors for the current map and for the total atlas (retryable/permanent)</h4><p>Mobile Atlas Creator tries to retry failed tile downloads up to two times.<br>The first time a tile download fails the <b>retryable</b> counter increases by one.<br>If the tile downloads fails the second time the tile will be counted as <br><b>permanent</b> error and not tried again.<br></p></html>");
        this.downloadErrorsValue = new JLabel();
        this.downloadErrorsValue.setToolTipText(this.downloadErrors.getToolTipText());
        this.totalDownloadTime = new JLabel("Total creation time");
        this.totalDownloadTimeValue = new JLabel();
        this.ignoreDlErrors = new JCheckBox("Ignore download errors and continue automatically");
        this.abortAtlasCreationButton = new JButton("Abort creation");
        this.abortAtlasCreationButton.setToolTipText("Abort current Atlas download");
        this.dismissWindowButton = new JButton("Close Window");
        this.dismissWindowButton.setToolTipText("Atlas creation in progress...");
        this.dismissWindowButton.setVisible(false);
        this.openProgramFolderButton = new JButton("Open Atlas Folder");
        this.openProgramFolderButton.setToolTipText("Atlas creation in progress...");
        this.openProgramFolderButton.setEnabled(false);
        this.pauseResumeDownloadButton = new JButton("Pause/Resume");
        GBC gbcRIF = GBC.std().insets(0, 0, 20, 0).fill(2);
        GBC gbcEol = GBC.eol();
        GBC gbcEolFill = GBC.eol().fill(2);
        GBC gbcEolFillI = GBC.eol().fill(2).insets(0, 5, 0, 0);
        this.background.add((Component)this.mapInfoLabel, gbcEolFill);
        this.background.add(Box.createVerticalStrut(20), gbcEol);
        this.background.add((Component)this.title, gbcRIF);
        this.background.add((Component)this.atlasMapsDone, gbcRIF);
        this.background.add((Component)this.atlasPercent, gbcRIF);
        this.background.add((Component)this.atlasTimeLeft, gbcEolFill);
        this.background.add((Component)this.atlasProgressBar, gbcEolFillI);
        this.background.add(Box.createVerticalStrut(20), gbcEol);
        this.background.add((Component)this.mapDownloadTitle, gbcRIF);
        this.background.add((Component)this.mapDownloadElementsDone, gbcRIF);
        this.background.add((Component)this.mapDownloadPercent, gbcRIF);
        this.background.add((Component)this.mapDownloadTimeLeft, gbcEolFill);
        this.background.add((Component)this.mapDownloadProgressBar, gbcEolFillI);
        this.background.add(Box.createVerticalStrut(20), gbcEol);
        this.background.add((Component)this.mapCreation, gbcEol);
        this.background.add((Component)this.mapCreationProgressBar, gbcEolFillI);
        this.background.add(Box.createVerticalStrut(10), gbcEol);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        GBC gbci = GBC.std().insets(0, 3, 3, 3);
        infoPanel.add((Component)this.nrOfDownloadedBytes, gbci);
        infoPanel.add((Component)this.nrOfDownloadedBytesValue, gbci.toggleEol());
        infoPanel.add((Component)this.nrOfDownloadedBytesPerSecond, gbci.toggleEol());
        infoPanel.add((Component)this.nrOfDownloadedBytesPerSecondValue, gbci.toggleEol());
        infoPanel.add((Component)this.activeDownloads, gbci.toggleEol());
        infoPanel.add((Component)this.activeDownloadsValue, gbci.toggleEol());
        infoPanel.add((Component)this.downloadErrors, gbci.toggleEol());
        infoPanel.add((Component)this.downloadErrorsValue, gbci.toggleEol());
        infoPanel.add((Component)this.totalDownloadTime, gbci.toggleEol());
        infoPanel.add((Component)this.totalDownloadTimeValue, gbci.toggleEol());
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)infoPanel, GBC.std().gridheight(2));
        bottomPanel.add((Component)this.ignoreDlErrors, GBC.eol().anchor(13));
        GBC gbcRight = GBC.std().anchor(14).insets(5, 0, 0, 0);
        bottomPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        bottomPanel.add((Component)this.abortAtlasCreationButton, gbcRight);
        bottomPanel.add((Component)this.dismissWindowButton, gbcRight);
        bottomPanel.add((Component)this.pauseResumeDownloadButton, gbcRight);
        bottomPanel.add((Component)this.openProgramFolderButton, gbcRight);
        this.background.add((Component)bottomPanel, gbcEolFillI);
        JPanel borderPanel = new JPanel(new GridBagLayout());
        borderPanel.add((Component)this.background, GBC.std().insets(10, 10, 10, 10).fill());
        this.add((Component)borderPanel, GBC.std().fill());
        this.abortAtlasCreationButton.addActionListener(this);
        this.dismissWindowButton.addActionListener(this);
        this.openProgramFolderButton.addActionListener(this);
        this.pauseResumeDownloadButton.addActionListener(this);
    }

    public void initAtlas(AtlasInterface atlasInterface) {
        this.data.atlasInterface = atlasInterface;
        this.data.totalNumberOfTiles = atlasInterface.calculateTilesToDownload() * 2;
        int mapCount = 0;
        int tileCount = 0;
        this.mapInfos = new ArrayList(100);
        for (LayerInterface layer : atlasInterface) {
            mapCount += layer.getMapCount();
            for (MapInterface map : layer) {
                int before = tileCount;
                int mapTiles = map.calculateTilesToDownload();
                this.mapInfos.add(new MapInfo(map, before, tileCount += mapTiles + mapTiles));
            }
        }
        this.mapInfos.trimToSize();
        this.data.totalNumberOfMaps = mapCount;
        this.initialTotalTime = System.currentTimeMillis();
        this.initialMapDownloadTime = -1L;
        this.updateGUI();
        this.setVisible(true);
        TIMER.schedule((TimerTask)this.updateTask, 0L, 500L);
    }

    public void initMapDownload(MapInterface map) {
        int index = this.mapInfos.indexOf(new MapInfo(map, 0, 0));
        this.data.mapInfo = this.mapInfos.get(index);
        this.data.totalProgress = this.data.mapInfo.tileCountOnStart;
        this.data.map = map;
        this.data.mapDownloadNumberOfTiles = map.calculateTilesToDownload();
        this.initialMapDownloadTime = System.currentTimeMillis();
        this.data.prevMapsPermanentErrors += this.data.mapPermanentErrors;
        this.data.prevMapsRetryErrors += this.data.mapRetryErrors;
        this.data.mapCreationProgress = 0;
        this.data.mapDownloadProgress = 0;
        this.data.currentMapNumber = index + 1;
        this.updateGUI();
    }

    public void initMapCreation(int maxTilesToProcess) {
        this.data.mapCreationProgress = 0;
        this.data.mapCreationMax = maxTilesToProcess;
        this.initialMapDownloadTime = -1L;
        this.updateGUI();
    }

    public void setErrorCounter(int retryErrors, int permanentErrors) {
        this.data.mapRetryErrors = retryErrors;
        this.data.mapPermanentErrors = permanentErrors;
        this.updateGUI();
    }

    public void incMapDownloadProgress() {
        ++this.data.mapDownloadProgress;
        ++this.data.totalProgress;
        this.updateGUI();
    }

    public void incMapCreationProgress() {
        this.setMapCreationProgress(this.data.mapCreationProgress + 1);
    }

    public void incMapCreationProgress(int stepSize) {
        this.setMapCreationProgress(this.data.mapCreationProgress + stepSize);
    }

    public void setMapCreationProgress(int progress) {
        this.data.mapCreationProgress = progress;
        this.data.totalProgress = this.data.mapInfo.tileCountOnStart + this.data.mapInfo.mapTiles + this.data.mapInfo.mapTiles * this.data.mapCreationProgress / this.data.mapCreationMax;
        this.updateGUI();
    }

    public void addDownloadedBytes(int bytes) {
        this.data.numberOfDownloadedBytes += (long)bytes;
    }

    public boolean ignoreDownloadErrors() {
        return this.ignoreDlErrors.isSelected();
    }

    private String formatRemainingTime(long seconds) {
        String timeLeftString;
        int minutesLeft = 0;
        if (seconds < 0L) {
            timeLeftString = "unknown";
        } else if (seconds > 60L) {
            minutesLeft = (int)(seconds / 60L);
            int secondsLeft = (int)(seconds % 60L);
            timeLeftString = secondsLeft > 119 ? Integer.toString(minutesLeft) + " " + "minutes" + " " + Integer.toString(secondsLeft) + " " + "seconds" : Integer.toString(minutesLeft) + " " + "minute" + " " + Integer.toString(secondsLeft) + " " + "seconds";
        } else {
            timeLeftString = seconds > 1L ? Long.toString(seconds) + " " + "seconds" : Long.toString(seconds) + " " + "second";
        }
        return "Time remaining: " + timeLeftString;
    }

    public void setZoomLevel(int theZoomLevel) {
        this.mapDownloadTitle.setText(TEXT_MAP_DOWNLOAD + Integer.toString(theZoomLevel));
    }

    public void atlasCreationFinished() {
        this.stopUpdateTask();
        this.downloadControlListener = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AtlasProgress.this.abortAtlasCreationButton.setEnabled(false);
                if (AtlasProgress.this.aborted) {
                    AtlasProgress.this.windowTitle.setText("<html><h2>ATLAS CREATION HAS BEEN ABORTED BY USER</h2></html>");
                    AtlasProgress.this.setTitle("Atlas creation aborted");
                } else {
                    AtlasProgress.this.windowTitle.setText("<html><h2>ATLAS CREATION FINISHED SUCCESSFULLY</h2></html>");
                    AtlasProgress.this.setTitle("Atlas creation finished successfully");
                }
                AtlasProgress.this.mapInfoLabel.setText("");
                AtlasProgress.this.abortAtlasCreationButton.setVisible(false);
                AtlasProgress.this.dismissWindowButton.setToolTipText("Close atlas creation progress window");
                AtlasProgress.this.dismissWindowButton.setVisible(true);
                if (!AtlasProgress.this.aborted) {
                    AtlasProgress.this.openProgramFolderButton.setToolTipText("Open folder where atlas output folder");
                    AtlasProgress.this.openProgramFolderButton.setEnabled(true);
                }
            }
        });
    }

    private synchronized void stopUpdateTask() {
        try {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWindow() {
        try {
            this.stopUpdateTask();
            this.downloadControlListener = null;
            this.setVisible(false);
        }
        finally {
            this.dispose();
        }
    }

    public void setDownloadControlerListener(AtlasCreationController threadControlListener) {
        this.downloadControlListener = threadControlListener;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        File atlasFolder = Settings.getInstance().getAtlasOutputDirectory();
        if (this.openProgramFolderButton.equals(source)) {
            try {
                OSUtilities.openFolderBrowser(atlasFolder);
            }
            catch (Exception e) {
                log.error("", e);
            }
        } else if (this.dismissWindowButton.equals(source)) {
            this.downloadControlListener = null;
            this.closeWindow();
        } else if (this.abortAtlasCreationButton.equals(source)) {
            this.aborted = true;
            this.updateTask.cancel();
            if (this.downloadControlListener != null) {
                this.downloadControlListener.abortAtlasCreation();
            } else {
                this.dispose();
            }
        } else if (this.pauseResumeDownloadButton.equals(source) && this.downloadControlListener != null) {
            this.downloadControlListener.pauseResumeAtlasCreation();
        }
    }

    public void updateGUI() {
        this.guiUpdater.updateAsynchronously();
    }

    public static interface AtlasCreationController {
        public void abortAtlasCreation();

        public void pauseResumeAtlasCreation();
    }

    protected static class MapInfo {
        final MapInterface map;
        final int tileCountOnStart;
        final int tileCountOnEnd;
        final int mapTiles;

        public MapInfo(MapInterface map, int tileCountOnStart, int tileCountOnEnd) {
            this.map = map;
            this.tileCountOnStart = tileCountOnStart;
            this.tileCountOnEnd = tileCountOnEnd;
            this.mapTiles = map.calculateTilesToDownload();
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapInfo)) {
                return false;
            }
            return this.map.equals(((MapInfo)obj).map);
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            log.debug("Closing event detected for atlas progress window");
            AtlasCreationController listener = AtlasProgress.this.downloadControlListener;
            if (listener != null) {
                listener.abortAtlasCreation();
            }
        }
    }

    private class UpdateTask
    extends TimerTask {
        private UpdateTask() {
        }

        @Override
        public void run() {
            AtlasProgress.this.updateGUI();
        }
    }

    private class GUIUpdater
    implements Runnable {
        int scheduledCounter = 0;

        private GUIUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateAsynchronously() {
            GUIUpdater gUIUpdater = this;
            synchronized (gUIUpdater) {
                if (this.scheduledCounter > 0) {
                    return;
                }
                ++this.scheduledCounter;
            }
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GUIUpdater gUIUpdater = this;
            synchronized (gUIUpdater) {
                --this.scheduledCounter;
            }
            if (((AtlasProgress)AtlasProgress.this).data.map != null) {
                String text = "<html>Processing map \"<b>" + ((AtlasProgress)AtlasProgress.this).data.map.getName() + "</b>\" of layer <b>\"" + ((AtlasProgress)AtlasProgress.this).data.map.getLayer().getName() + "\"</b> map source: " + ((AtlasProgress)AtlasProgress.this).data.map.getMapSource() + "</html>";
                AtlasProgress.this.mapInfoLabel.setText(text);
            }
            AtlasProgress.this.atlasProgressBar.setMaximum(((AtlasProgress)AtlasProgress.this).data.totalNumberOfTiles);
            AtlasProgress.this.atlasProgressBar.setValue(((AtlasProgress)AtlasProgress.this).data.totalProgress);
            int newPercent = (int)(AtlasProgress.this.atlasProgressBar.getPercentComplete() * 100.0);
            boolean pauseState = AtlasProgress.this.atlasThread.isPaused();
            if (((AtlasProgress)AtlasProgress.this).data.totalProgressPercent != newPercent || pauseState != ((AtlasProgress)AtlasProgress.this).data.paused) {
                ((AtlasProgress)AtlasProgress.this).data.totalProgressPercent = newPercent;
                AtlasProgress.this.atlasPercent.setText(String.format(TEXT_PERCENT, ((AtlasProgress)AtlasProgress.this).data.totalProgressPercent));
                if (((AtlasProgress)AtlasProgress.this).data.atlasInterface != null) {
                    String text = String.format("%d%% - Processing atlas \"%s\"", ((AtlasProgress)AtlasProgress.this).data.totalProgressPercent, ((AtlasProgress)AtlasProgress.this).data.atlasInterface.getName());
                    if (pauseState) {
                        text = text + " [PAUSED]";
                    }
                    AtlasProgress.this.setTitle(text);
                }
            }
            ((AtlasProgress)AtlasProgress.this).data.paused = pauseState;
            long seconds = -1L;
            int totalProgress = ((AtlasProgress)AtlasProgress.this).data.totalProgress;
            if (totalProgress != 0) {
                int totalTilesRemaining = ((AtlasProgress)AtlasProgress.this).data.totalNumberOfTiles - totalProgress;
                long totalElapsedTime = System.currentTimeMillis() - AtlasProgress.this.initialTotalTime;
                seconds = totalElapsedTime * (long)totalTilesRemaining / (1000L * (long)totalProgress);
            }
            AtlasProgress.this.atlasTimeLeft.setText(AtlasProgress.this.formatRemainingTime(seconds));
            AtlasProgress.this.mapDownloadProgressBar.setMaximum(((AtlasProgress)AtlasProgress.this).data.mapDownloadNumberOfTiles);
            AtlasProgress.this.mapDownloadProgressBar.setValue(((AtlasProgress)AtlasProgress.this).data.mapDownloadProgress);
            AtlasProgress.this.mapDownloadPercent.setText(String.format(TEXT_PERCENT, (int)(AtlasProgress.this.mapDownloadProgressBar.getPercentComplete() * 100.0)));
            AtlasProgress.this.mapDownloadElementsDone.setText(Integer.toString(((AtlasProgress)AtlasProgress.this).data.mapDownloadProgress) + " of " + ((AtlasProgress)AtlasProgress.this).data.mapDownloadNumberOfTiles + " tiles done");
            seconds = -1L;
            int mapDlProgress = ((AtlasProgress)AtlasProgress.this).data.mapDownloadProgress;
            if (mapDlProgress != 0 && AtlasProgress.this.initialMapDownloadTime > 0L) {
                seconds = (System.currentTimeMillis() - AtlasProgress.this.initialMapDownloadTime) * (long)(((AtlasProgress)AtlasProgress.this).data.mapDownloadNumberOfTiles - mapDlProgress) / (1000L * (long)mapDlProgress);
            }
            AtlasProgress.this.mapDownloadTimeLeft.setText(AtlasProgress.this.formatRemainingTime(seconds));
            AtlasProgress.this.mapCreation.setText("Map creation");
            AtlasProgress.this.mapCreationProgressBar.setValue(((AtlasProgress)AtlasProgress.this).data.mapCreationProgress);
            AtlasProgress.this.mapCreationProgressBar.setMaximum(((AtlasProgress)AtlasProgress.this).data.mapCreationMax);
            AtlasProgress.this.atlasMapsDone.setText(((AtlasProgress)AtlasProgress.this).data.currentMapNumber + " of " + ((AtlasProgress)AtlasProgress.this).data.totalNumberOfMaps + " done");
            long rate = ((AtlasProgress)AtlasProgress.this).data.numberOfDownloadedBytes * 1000L;
            long time = System.currentTimeMillis() - AtlasProgress.this.initialMapDownloadTime;
            if (((AtlasProgress)AtlasProgress.this).data.mapCreationProgress == 0 && AtlasProgress.this.initialMapDownloadTime > 0L) {
                if (time == 0L) {
                    AtlasProgress.this.nrOfDownloadedBytesPerSecondValue.setText(": ?? KiByte / Second");
                } else {
                    AtlasProgress.this.nrOfDownloadedBytesPerSecondValue.setText(": " + Utilities.formatBytes(rate /= time) + " / Second");
                }
            }
            AtlasProgress.this.nrOfDownloadedBytesValue.setText(": " + Utilities.formatBytes(((AtlasProgress)AtlasProgress.this).data.numberOfDownloadedBytes));
            String timeString = "";
            seconds = 0L;
            long minutes = 0L;
            long totalMilliseconds = 0L;
            totalMilliseconds = System.currentTimeMillis() - AtlasProgress.this.initialTotalTime;
            if (totalMilliseconds > 60000L) {
                minutes = totalMilliseconds / 60000L;
                seconds = (totalMilliseconds - minutes * 60000L) / 1000L;
                timeString = minutes + " minute(s) and " + seconds + " second(s)";
            } else {
                seconds = totalMilliseconds / 1000L;
                timeString = seconds + " second(s)";
            }
            AtlasProgress.this.totalDownloadTimeValue.setText(": " + timeString);
            AtlasProgress.this.totalDownloadTimeValue.repaint();
            int activeDownloads = AtlasProgress.this.atlasThread == null ? 0 : AtlasProgress.this.atlasThread.getActiveDownloads();
            AtlasProgress.this.activeDownloadsValue.setText(": " + activeDownloads);
            AtlasProgress.this.activeDownloadsValue.repaint();
            int totalPermanentErrors = ((AtlasProgress)AtlasProgress.this).data.prevMapsPermanentErrors + ((AtlasProgress)AtlasProgress.this).data.mapPermanentErrors;
            int totalRetylableErrors = ((AtlasProgress)AtlasProgress.this).data.prevMapsRetryErrors + ((AtlasProgress)AtlasProgress.this).data.mapRetryErrors;
            AtlasProgress.this.downloadErrorsValue.setText(": map: " + ((AtlasProgress)AtlasProgress.this).data.mapRetryErrors + " / " + ((AtlasProgress)AtlasProgress.this).data.mapPermanentErrors + " total: " + totalRetylableErrors + " / " + totalPermanentErrors);
            AtlasProgress.this.downloadErrorsValue.repaint();
        }
    }

    private static class Data {
        AtlasInterface atlasInterface;
        MapInterface map;
        MapInfo mapInfo;
        long numberOfDownloadedBytes = 0L;
        int totalNumberOfTiles = 0;
        int totalNumberOfMaps = 0;
        int totalProgress = 0;
        int totalProgressPercent = -1;
        int currentMapNumber = 0;
        int mapDownloadProgress = 0;
        int mapDownloadNumberOfTiles = 0;
        int mapCreationProgress = 0;
        int mapCreationMax = 0;
        int mapRetryErrors = 0;
        int mapPermanentErrors = 0;
        int prevMapsRetryErrors = 0;
        int prevMapsPermanentErrors = 0;
        boolean paused = false;

        private Data() {
        }
    }
}

