/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.xml.bind.JAXBException;
import mobac.exceptions.AtlasTestException;
import mobac.exceptions.InvalidNameException;
import mobac.gui.SettingsGUI;
import mobac.gui.actions.ShowHelpAction;
import mobac.gui.atlastree.JAtlasTree;
import mobac.gui.components.FilledLayeredPane;
import mobac.gui.components.JAtlasNameField;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.mapview.GridZoom;
import mobac.gui.mapview.MapEventListener;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.panels.JCoordinatesPanel;
import mobac.gui.panels.JGpxPanel;
import mobac.gui.panels.JProfilesPanel;
import mobac.gui.panels.JTileImageParametersPanel;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.MapSourcesUpdater;
import mobac.program.AtlasThread;
import mobac.program.ProgramInfo;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.Layer;
import mobac.program.model.MapSelection;
import mobac.program.model.MercatorPixelCoordinate;
import mobac.program.model.Profile;
import mobac.program.model.SelectedZoomLevels;
import mobac.program.model.Settings;
import mobac.program.model.TileImageParameters;
import mobac.program.tilestore.TileStore;
import mobac.utilities.GBC;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class MainGUI
extends JFrame
implements MapEventListener {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(MainGUI.class);
    private static Color labelBackgroundColor = new Color(0, 0, 0, 127);
    private static Color labelForegroundColor = Color.white;
    private static MainGUI mainGUI = null;
    public static final ArrayList<Image> MOBAC_ICONS = new ArrayList(3);
    protected JAtlasTree jAtlasTree;
    public PreviewMap previewMap;
    private JLabel zoomLevelText;
    private JComboBox gridZoomCombo;
    private JSlider zoomSlider;
    private JComboBox mapSourceCombo;
    private JButton helpButton;
    private JButton settingsButton;
    private JAtlasNameField atlasNameTextField;
    private JComboBox atlasOutputFormatCombo;
    private JButton createAtlasButton;
    private JPanel zoomLevelPanel;
    private JCheckBox[] cbZoom = new JCheckBox[0];
    private JLabel amountOfTilesLabel;
    private JCoordinatesPanel coordinatesPanel;
    private JProfilesPanel profilesPanel;
    private JTileImageParametersPanel tileImageParametersPanel;
    private JPanel mapControlPanel = new JPanel(new BorderLayout());
    private JPanel leftPanel = new JPanel(new GridBagLayout());
    private JPanel leftPanelContent = null;
    private MercatorPixelCoordinate mapSelectionMax = null;
    private MercatorPixelCoordinate mapSelectionMin = null;

    public static void createMainGui() {
        if (mainGUI != null) {
            return;
        }
        mainGUI = new MainGUI();
        mainGUI.setVisible(true);
        log.trace("MainGUI now visible");
    }

    public static MainGUI getMainGUI() {
        return mainGUI;
    }

    private MainGUI() {
        MOBAC_ICONS.add(Utilities.loadResourceImageIcon("mobac48.png").getImage());
        MOBAC_ICONS.add(Utilities.loadResourceImageIcon("mobac32.png").getImage());
        MOBAC_ICONS.add(Utilities.loadResourceImageIcon("mobac16.png").getImage());
        this.setIconImages(MOBAC_ICONS);
        GUIExceptionHandler.registerForCurrentThread();
        this.setTitle(ProgramInfo.getCompleteTitle());
        log.trace("Creating main dialog - " + this.getTitle());
        this.setResizable(true);
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setMinimumSize(new Dimension(Math.min(800, dScreen.width), Math.min(590, dScreen.height)));
        this.setSize(this.getMinimumSize());
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowDestroyer());
        this.addComponentListener(new MainWindowListener());
        this.previewMap = new PreviewMap();
        this.previewMap.addMapEventListener(this);
        this.createControls();
        this.calculateNrOfTilesToDownload();
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftPanel, "West");
        FilledLayeredPane layeredPane = new FilledLayeredPane();
        layeredPane.add((Component)this.previewMap, (Object)0);
        layeredPane.add((Component)this.mapControlPanel, (Object)1);
        this.add((Component)layeredPane, "Center");
        this.updatePanels();
        this.loadSettings();
        this.profilesPanel.initialize();
        this.mapSourceChanged(this.previewMap.getMapSource());
        this.updateZoomLevelCheckBoxes();
        this.updateGridSizeCombo();
        this.tileImageParametersPanel.updateControlsState();
        this.zoomChanged(this.previewMap.getZoom());
        this.gridZoomChanged(this.previewMap.getGridZoom());
        this.previewMap.updateMapSelection();
        this.previewMap.grabFocus();
        MapSourcesUpdater.automaticMapsourcesOnlineUpdate(true);
    }

    private void createControls() {
        this.zoomSlider = new JSlider(0, this.previewMap.getMapSource().getMaxZoom());
        this.zoomSlider.setOrientation(0);
        this.zoomSlider.setMinimumSize(new Dimension(50, 10));
        this.zoomSlider.setSize(50, this.zoomSlider.getPreferredSize().height);
        this.zoomSlider.addChangeListener(new ZoomSliderListener());
        this.zoomSlider.setOpaque(false);
        this.zoomLevelText = new JLabel(" 00 ");
        this.zoomLevelText.setOpaque(true);
        this.zoomLevelText.setBackground(labelBackgroundColor);
        this.zoomLevelText.setForeground(labelForegroundColor);
        this.zoomLevelText.setToolTipText("The current zoom level");
        this.gridZoomCombo = new JComboBox();
        this.gridZoomCombo.setEditable(false);
        this.gridZoomCombo.addActionListener(new GridZoomComboListener());
        this.gridZoomCombo.setToolTipText("Projects a grid of the specified zoom level over the map");
        this.mapSourceCombo = new JComboBox<MapSource>(MapSourcesManager.getEnabledMapSources());
        this.mapSourceCombo.setMaximumRowCount(20);
        this.mapSourceCombo.addActionListener(new MapSourceComboListener());
        this.mapSourceCombo.setToolTipText("Select map source");
        this.helpButton = new JButton("Help");
        this.helpButton.addActionListener(new ShowHelpAction());
        this.helpButton.setToolTipText("Display some help information");
        this.settingsButton = new JButton("Settings");
        this.settingsButton.addActionListener(new SettingsButtonListener());
        this.settingsButton.setToolTipText("Open the preferences dialogue panel.");
        this.atlasOutputFormatCombo = new JComboBox<AtlasOutputFormat>(AtlasOutputFormat.values());
        this.atlasOutputFormatCombo.setMaximumRowCount(15);
        this.atlasOutputFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.applyAtlasOutputFormat();
            }
        });
        this.atlasNameTextField = new JAtlasNameField();
        this.atlasNameTextField.setColumns(12);
        this.atlasNameTextField.setActionCommand("atlasNameTextField");
        this.atlasNameTextField.setToolTipText("Enter a name for the atlas here");
        this.createAtlasButton = new JButton("Create atlas");
        this.createAtlasButton.addActionListener(new CreateAtlasButtonListener());
        this.createAtlasButton.setToolTipText("Create the atlas");
        this.zoomLevelPanel = new JPanel();
        this.zoomLevelPanel.setBorder(BorderFactory.createEmptyBorder());
        this.zoomLevelPanel.setOpaque(false);
        this.amountOfTilesLabel = new JLabel();
        this.amountOfTilesLabel.setToolTipText("Total amount of tiles to download");
        this.amountOfTilesLabel.setOpaque(true);
        this.amountOfTilesLabel.setBackground(labelBackgroundColor);
        this.amountOfTilesLabel.setForeground(labelForegroundColor);
        this.jAtlasTree = new JAtlasTree(this.previewMap);
        this.coordinatesPanel = new JCoordinatesPanel();
        this.tileImageParametersPanel = new JTileImageParametersPanel();
        this.profilesPanel = new JProfilesPanel(this.jAtlasTree);
        this.profilesPanel.getLoadButton().addActionListener(new LoadProfileListener());
    }

    private void updateLeftPanel() {
        this.leftPanel.removeAll();
        this.coordinatesPanel.addButtonActionListener(new ApplySelectionButtonListener());
        JCollapsiblePanel mapSourcePanel = new JCollapsiblePanel("Map source", new GridBagLayout());
        mapSourcePanel.addContent(this.mapSourceCombo, GBC.std().insets(2, 2, 2, 2).fill());
        JCollapsiblePanel zoomLevelsPanel = new JCollapsiblePanel("Zoom Levels", new GridBagLayout());
        zoomLevelsPanel.addContent(this.zoomLevelPanel, GBC.eol().insets(2, 4, 2, 0));
        zoomLevelsPanel.addContent(this.amountOfTilesLabel, GBC.std().anchor(17).insets(0, 5, 0, 2));
        GBC gbc_std = GBC.std().insets(5, 2, 5, 3);
        GBC gbc_eol = GBC.eol().insets(5, 2, 5, 3);
        JCollapsiblePanel atlasContentPanel = new JCollapsiblePanel("Atlas Content", new GridBagLayout());
        JScrollPane treeScrollPane = new JScrollPane(this.jAtlasTree, 20, 30);
        this.jAtlasTree.getTreeModel().addTreeModelListener(new AtlasListener());
        treeScrollPane.setMinimumSize(new Dimension(100, 150));
        treeScrollPane.setPreferredSize(new Dimension(100, 200));
        treeScrollPane.setAutoscrolls(true);
        atlasContentPanel.addContent(treeScrollPane, GBC.eol().fill().insets(0, 1, 0, 0));
        JButton clearAtlas = new JButton("Clear");
        atlasContentPanel.addContent(clearAtlas, GBC.std());
        clearAtlas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.jAtlasTree.clearAtlas();
                MainGUI.this.previewMap.mapLayers.clear();
                MainGUI.this.previewMap.repaint();
                MainGUI.this.applyAtlasOutputFormat();
            }
        });
        JButton addLayers = new JButton("Add selection");
        atlasContentPanel.addContent(addLayers, GBC.eol());
        addLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainGUI.this.addSelectedAutoCutMultiMapLayers();
            }
        });
        atlasContentPanel.addContent(new JLabel("Name: "), gbc_std);
        atlasContentPanel.addContent(this.atlasNameTextField, gbc_eol.fill(2));
        JCollapsiblePanel atlasNamePanel = new JCollapsiblePanel("Atlas settings", new GridBagLayout());
        atlasNamePanel.addContent(new JLabel("Format: "), gbc_std);
        atlasNamePanel.addContent(this.atlasOutputFormatCombo, gbc_eol);
        gbc_eol = GBC.eol().insets(5, 2, 5, 2).fill(2);
        JGpxPanel gpxPanel = new JGpxPanel(this.previewMap);
        this.leftPanelContent = new JPanel(new GridBagLayout());
        this.leftPanelContent.add((Component)this.coordinatesPanel, gbc_eol);
        this.leftPanelContent.add((Component)mapSourcePanel, gbc_eol);
        this.leftPanelContent.add((Component)zoomLevelsPanel, gbc_eol);
        this.leftPanelContent.add((Component)this.tileImageParametersPanel, gbc_eol);
        this.leftPanelContent.add((Component)atlasContentPanel, gbc_eol);
        this.leftPanelContent.add((Component)atlasNamePanel, gbc_eol);
        this.leftPanelContent.add((Component)this.profilesPanel, gbc_eol);
        this.leftPanelContent.add((Component)this.createAtlasButton, gbc_eol);
        this.leftPanelContent.add((Component)this.settingsButton, gbc_eol);
        this.leftPanelContent.add((Component)gpxPanel, gbc_eol);
        this.leftPanelContent.add(Box.createVerticalGlue(), GBC.eol().fill(3));
        JScrollPane scrollPane = new JScrollPane(this.leftPanelContent);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        Dimension d = scrollPane.getPreferredSize();
        d.width += 5 + scrollPane.getVerticalScrollBar().getWidth();
        scrollPane.setMinimumSize(d);
        this.leftPanel.add((Component)scrollPane, GBC.std().fill());
    }

    private JPanel updateMapControlsPanel() {
        this.mapControlPanel.removeAll();
        this.mapControlPanel.setOpaque(false);
        JLabel zoomLabel = new JLabel(" Zoom: ");
        zoomLabel.setOpaque(true);
        zoomLabel.setBackground(labelBackgroundColor);
        zoomLabel.setForeground(labelForegroundColor);
        JPanel topControls = new JPanel(new GridBagLayout());
        topControls.setOpaque(false);
        topControls.add((Component)zoomLabel, GBC.std().insets(5, 5, 0, 0));
        topControls.add((Component)this.zoomSlider, GBC.std().insets(0, 5, 0, 0));
        topControls.add((Component)this.zoomLevelText, GBC.std().insets(0, 5, 0, 0));
        topControls.add((Component)this.gridZoomCombo, GBC.std().insets(10, 5, 0, 0));
        topControls.add(Box.createHorizontalGlue(), GBC.std().fillH());
        topControls.add((Component)this.helpButton, GBC.std().insets(10, 5, 5, 0));
        this.mapControlPanel.add((Component)topControls, "North");
        return this.mapControlPanel;
    }

    private void updatePanels() {
        this.updateMapControlsPanel();
        this.updateLeftPanel();
        this.leftPanel.setVisible(true);
        this.calculateNrOfTilesToDownload();
        this.updateZoomLevelCheckBoxes();
        this.previewMap.grabFocus();
    }

    public void updateMapSourcesList() {
        MapSource ms = (MapSource)this.mapSourceCombo.getSelectedItem();
        this.mapSourceCombo.setModel(new DefaultComboBoxModel<MapSource>(MapSourcesManager.getEnabledMapSources()));
        this.mapSourceCombo.setSelectedItem(ms);
        MapSource ms2 = (MapSource)this.mapSourceCombo.getSelectedItem();
        if (!ms.equals(ms2)) {
            this.previewMap.setMapSource(ms2);
        }
    }

    private void loadSettings() {
        Settings settings = Settings.getInstance();
        this.atlasNameTextField.setText(settings.elementName);
        this.atlasOutputFormatCombo.setSelectedItem((Object)settings.getAtlasOutputFormat());
        this.previewMap.settingsLoad();
        this.coordinatesPanel.setNumberFormat(settings.coordinateNumberFormat);
        this.tileImageParametersPanel.loadSettings();
        this.setSize(settings.mainWindow.size);
        Point windowLocation = settings.mainWindow.position;
        if (windowLocation.x == -1 && windowLocation.y == -1) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(windowLocation);
        }
        if (settings.mainWindow.maximized.booleanValue()) {
            this.setExtendedState(6);
        }
        if (this.leftPanelContent != null) {
            for (Component c : this.leftPanelContent.getComponents()) {
                JCollapsiblePanel cp;
                String name;
                if (!(c instanceof JCollapsiblePanel) || (name = (cp = (JCollapsiblePanel)c).getName()) == null || !settings.mainWindow.collapsedPanels.contains(name)) continue;
                cp.setCollapsed(true);
            }
        }
    }

    private void saveSettings() {
        try {
            Settings settings = Settings.getInstance();
            this.previewMap.settingsSave();
            settings.mapviewMapSource = this.previewMap.getMapSource().getName();
            settings.elementName = this.atlasNameTextField.getText();
            settings.setAtlasOutputFormat((AtlasOutputFormat)((Object)this.atlasOutputFormatCombo.getSelectedItem()));
            settings.coordinateNumberFormat = this.coordinatesPanel.getNumberFormat();
            this.tileImageParametersPanel.saveSettings();
            boolean bl = (this.getExtendedState() & 6) != 0;
            settings.mainWindow.maximized = bl;
            if (!bl) {
                settings.mainWindow.size = this.getSize();
                settings.mainWindow.position = this.getLocation();
            }
            settings.mainWindow.collapsedPanels.clear();
            if (this.leftPanelContent != null) {
                for (Component component : this.leftPanelContent.getComponents()) {
                    JCollapsiblePanel jCollapsiblePanel;
                    if (!(component instanceof JCollapsiblePanel) || !(jCollapsiblePanel = (JCollapsiblePanel)component).isCollapsed()) continue;
                    settings.mainWindow.collapsedPanels.add(jCollapsiblePanel.getName());
                }
            }
            this.checkAndSaveSettings();
        }
        catch (Exception exception) {
            GUIExceptionHandler.showExceptionDialog(exception);
            JOptionPane.showMessageDialog(null, "Error on writing program settings to \"settings.xml\"", "Error", 0);
        }
    }

    public void checkAndSaveSettings() throws JAXBException {
        int n;
        if (Settings.checkSettingsFileModified() && (n = JOptionPane.showConfirmDialog(this, "The settings.xml files has been changed by another application.\nDo you want to overwrite these changes?\nAll changes made by the other application will be lost!", "Overwrite changes?", 0, 3)) != 0) {
            return;
        }
        Settings.save();
    }

    public String getUserText() {
        return this.atlasNameTextField.getText();
    }

    public void refreshPreviewMap() {
        this.previewMap.refreshMap();
    }

    private void updateGridSizeCombo() {
        int maxZoom = this.previewMap.getMapSource().getMaxZoom();
        int minZoom = this.previewMap.getMapSource().getMinZoom();
        GridZoom lastGridZoom = (GridZoom)this.gridZoomCombo.getSelectedItem();
        this.gridZoomCombo.setEnabled(false);
        this.gridZoomCombo.removeAllItems();
        this.gridZoomCombo.setMaximumRowCount(maxZoom - minZoom + 2);
        this.gridZoomCombo.addItem(new GridZoom(-1){

            @Override
            public String toString() {
                return "Grid disabled";
            }
        });
        for (int i = maxZoom; i >= minZoom; --i) {
            this.gridZoomCombo.addItem(new GridZoom(i));
        }
        if (lastGridZoom != null) {
            this.gridZoomCombo.setSelectedItem(lastGridZoom);
        }
        this.gridZoomCombo.setEnabled(true);
    }

    private void updateZoomLevelCheckBoxes() {
        MapSource mapSource = this.previewMap.getMapSource();
        int n = mapSource.getMaxZoom() - mapSource.getMinZoom() + 1;
        JCheckBox[] jCheckBoxArray = this.cbZoom;
        this.cbZoom = new JCheckBox[n];
        this.zoomLevelPanel.removeAll();
        this.zoomLevelPanel.setLayout(new GridLayout(0, 10, 1, 2));
        ZoomLevelCheckBoxListener zoomLevelCheckBoxListener = new ZoomLevelCheckBoxListener();
        for (int i = this.cbZoom.length - 1; i >= 0; --i) {
            int n2 = i + mapSource.getMinZoom();
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setPreferredSize(new Dimension(22, 11));
            jCheckBox.setMinimumSize(jCheckBox.getPreferredSize());
            jCheckBox.setOpaque(false);
            jCheckBox.setFocusable(false);
            if (i < jCheckBoxArray.length) {
                jCheckBox.setSelected(jCheckBoxArray[i].isSelected());
            }
            jCheckBox.addActionListener(zoomLevelCheckBoxListener);
            jCheckBox.setToolTipText("Select zoom level " + n2 + " for atlas");
            this.zoomLevelPanel.add(jCheckBox);
            this.cbZoom[i] = jCheckBox;
            JLabel jLabel = new JLabel(Integer.toString(n2));
            this.zoomLevelPanel.add(jLabel);
        }
        this.amountOfTilesLabel.setOpaque(false);
        this.amountOfTilesLabel.setForeground(Color.black);
    }

    @Override
    public void selectionChanged(MercatorPixelCoordinate max, MercatorPixelCoordinate min) {
        this.mapSelectionMax = max;
        this.mapSelectionMin = min;
        this.coordinatesPanel.setSelection(max, min);
        this.calculateNrOfTilesToDownload();
    }

    @Override
    public void zoomChanged(int n) {
        this.zoomLevelText.setText(" " + n + " ");
        this.zoomSlider.setValue(n);
    }

    public void gridZoomChanged(int newGridZoomLevel) {
        this.gridZoomCombo.setSelectedItem(new GridZoom(newGridZoomLevel));
    }

    public void applyAtlasOutputFormat() {
        AtlasOutputFormat atlasOutputFormat = (AtlasOutputFormat)((Object)this.atlasOutputFormatCombo.getSelectedItem());
        this.jAtlasTree.getAtlas().setOutputFormat(atlasOutputFormat);
    }

    @Override
    public void selectNextMapSource() {
        if (this.mapSourceCombo.getSelectedIndex() == this.mapSourceCombo.getItemCount() - 1) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.mapSourceCombo.setSelectedIndex(this.mapSourceCombo.getSelectedIndex() + 1);
        }
    }

    @Override
    public void selectPreviousMapSource() {
        if (this.mapSourceCombo.getSelectedIndex() == 0) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.mapSourceCombo.setSelectedIndex(this.mapSourceCombo.getSelectedIndex() - 1);
        }
    }

    private void addSelectedAutoCutMultiMapLayers() {
        String string = "%s %02d";
        AtlasInterface atlasInterface = this.jAtlasTree.getAtlas();
        String string2 = this.atlasNameTextField.getText();
        MapSource mapSource = (MapSource)this.mapSourceCombo.getSelectedItem();
        SelectedZoomLevels selectedZoomLevels = new SelectedZoomLevels(this.previewMap.getMapSource().getMinZoom(), this.cbZoom);
        MapSelection mapSelection = this.getMapSelectionCoordinates();
        if (mapSelection == null) {
            JOptionPane.showMessageDialog(this, "Please select an area");
            return;
        }
        Settings settings = Settings.getInstance();
        String string3 = this.validateInput();
        if (string3.length() > 0) {
            JOptionPane.showMessageDialog(null, string3, "Errors", 0);
            return;
        }
        int[] nArray = selectedZoomLevels.getZoomLevels();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select at least one zoom level");
            return;
        }
        String string4 = string2;
        Layer layer = null;
        int n = 1;
        boolean bl = false;
        do {
            try {
                layer = new Layer(atlasInterface, string4);
                bl = true;
            }
            catch (InvalidNameException invalidNameException) {
                string4 = string2 + "_" + Integer.toString(n++);
            }
        } while (!bl);
        for (int n2 : nArray) {
            Point point = mapSelection.getTopLeftPixelCoordinate(n2);
            Point point2 = mapSelection.getBottomRightPixelCoordinate(n2);
            TileImageParameters tileImageParameters = this.getSelectedTileImageParameters();
            try {
                String string5 = String.format("%s %02d", string4, n2);
                layer.addMapsAutocut(string5, mapSource, point, point2, n2, tileImageParameters, settings.maxMapSize);
            }
            catch (InvalidNameException invalidNameException) {
                log.error("", invalidNameException);
            }
        }
        atlasInterface.addLayer(layer);
        this.jAtlasTree.getTreeModel().notifyStructureChanged();
    }

    @Override
    public void mapSourceChanged(MapSource newMapSource) {
        this.calculateNrOfTilesToDownload();
        if (newMapSource.equals(this.mapSourceCombo.getSelectedItem())) {
            return;
        }
        this.mapSourceCombo.setSelectedItem(newMapSource);
    }

    private void setSelectionByEnteredCoordinates() {
        this.coordinatesPanel.correctMinMax();
        MapSelection ms = this.coordinatesPanel.getMapSelection(this.previewMap.getMapSource());
        if (ms.isAreaSelected()) {
            this.mapSelectionMax = ms.getBottomRightPixelCoordinate();
            this.mapSelectionMin = ms.getTopLeftPixelCoordinate();
            this.previewMap.setSelectionAndZoomTo(ms, false);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private MapSelection getMapSelectionCoordinates() {
        if (this.mapSelectionMax == null || this.mapSelectionMin == null) {
            return null;
        }
        return new MapSelection(this.previewMap.getMapSource(), this.mapSelectionMax, this.mapSelectionMin);
    }

    private String validateInput() {
        String string = "";
        string = string + this.tileImageParametersPanel.getValidationErrorMessages();
        return string;
    }

    public TileImageParameters getSelectedTileImageParameters() {
        return this.tileImageParametersPanel.getSelectedTileImageParameters();
    }

    private void calculateNrOfTilesToDownload() {
        MapSelection mapSelection = this.getMapSelectionCoordinates();
        String string = " %s tiles ";
        if (mapSelection == null || !mapSelection.isAreaSelected()) {
            this.amountOfTilesLabel.setText(String.format(string, "0"));
            this.amountOfTilesLabel.setToolTipText("");
        } else {
            try {
                SelectedZoomLevels selectedZoomLevels = new SelectedZoomLevels(this.previewMap.getMapSource().getMinZoom(), this.cbZoom);
                int[] nArray = selectedZoomLevels.getZoomLevels();
                long l = 0L;
                StringBuilder stringBuilder = new StringBuilder(1024);
                stringBuilder.append("Total amount of tiles to download:");
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    long[] lArray = mapSelection.calculateNrOfTilesEx(n);
                    l += lArray[0];
                    stringBuilder.append("<br>Level " + nArray[i] + ": " + lArray[0] + " (" + lArray[1] + "*" + lArray[2] + ")");
                }
                String string2 = "<html>" + stringBuilder.toString() + "</html>";
                this.amountOfTilesLabel.setText(String.format(string, Long.toString(l)));
                this.amountOfTilesLabel.setToolTipText(string2);
            }
            catch (Exception exception) {
                this.amountOfTilesLabel.setText(String.format(string, "?"));
                log.error("", exception);
            }
        }
    }

    private class MainWindowListener
    extends ComponentAdapter {
        private MainWindowListener() {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            this.updateValues();
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            this.updateValues();
        }

        private void updateValues() {
            if ((MainGUI.this.getExtendedState() & 6) != 0) {
                return;
            }
            Settings s = Settings.getInstance();
            s.mainWindow.size = MainGUI.this.getSize();
            s.mainWindow.position = MainGUI.this.getLocation();
        }
    }

    private class WindowDestroyer
    extends WindowAdapter {
        private WindowDestroyer() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainGUI.this.previewMap.setEnabled(true);
                }
            });
        }

        @Override
        public void windowClosing(WindowEvent event) {
            MainGUI.this.saveSettings();
            TileStore.getInstance().closeAll(true);
        }
    }

    private class AtlasListener
    implements TreeModelListener {
        private AtlasListener() {
        }

        protected void changed() {
            MainGUI.this.profilesPanel.getSaveAsButton().setEnabled(MainGUI.this.jAtlasTree.getAtlas().getLayerCount() > 0);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.changed();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.changed();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.changed();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.changed();
        }
    }

    private class ZoomLevelCheckBoxListener
    implements ActionListener {
        private ZoomLevelCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGUI.this.calculateNrOfTilesToDownload();
        }
    }

    private class CreateAtlasButtonListener
    implements ActionListener {
        private CreateAtlasButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!MainGUI.this.jAtlasTree.testAtlasContentValid()) {
                return;
            }
            if (MainGUI.this.jAtlasTree.getAtlas().calculateTilesToDownload() > 3000000) {
                JOptionPane.showMessageDialog(null, "Mobile Atlas Creator has detected that you are trying to\ndownload an extra ordinary large atlas with a very high number of tiles.\nPlease reduce the selected areas on high zoom levels and try again.", "Atlas download prohibited", 0);
                return;
            }
            try {
                AtlasInterface atlasToCreate = MainGUI.this.jAtlasTree.getAtlas().deepClone();
                AtlasThread atlasThread = new AtlasThread(atlasToCreate);
                atlasThread.start();
            }
            catch (AtlasTestException e) {
                JOptionPane.showMessageDialog(null, "<html>" + e.getMessage() + "</html>", "Map incompatible with atlas format", 0);
            }
            catch (Exception e) {
                log.error("", e);
                GUIExceptionHandler.processException(e);
            }
        }
    }

    private class SettingsButtonListener
    implements ActionListener {
        private SettingsButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsGUI.showSettingsDialog(MainGUI.this);
        }
    }

    private class LoadProfileListener
    implements ActionListener {
        private LoadProfileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Profile profile = MainGUI.this.profilesPanel.getSelectedProfile();
            MainGUI.this.profilesPanel.getDeleteButton().setEnabled(profile != null);
            if (profile == null) {
                return;
            }
            MainGUI.this.jAtlasTree.load(profile);
            MainGUI.this.previewMap.mapLayers.clear();
            MainGUI.this.previewMap.repaint();
            MainGUI.this.atlasOutputFormatCombo.setSelectedItem((Object)MainGUI.this.jAtlasTree.getAtlas().getOutputFormat());
        }
    }

    private class MapSourceComboListener
    implements ActionListener {
        private MapSourceComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapSource mapSource = (MapSource)MainGUI.this.mapSourceCombo.getSelectedItem();
            if (mapSource == null) {
                MainGUI.this.mapSourceCombo.setSelectedIndex(0);
                mapSource = (MapSource)MainGUI.this.mapSourceCombo.getSelectedItem();
            }
            MainGUI.this.previewMap.setMapSource(mapSource);
            MainGUI.this.zoomSlider.setMinimum(MainGUI.this.previewMap.getMapSource().getMinZoom());
            MainGUI.this.zoomSlider.setMaximum(MainGUI.this.previewMap.getMapSource().getMaxZoom());
            MainGUI.this.updateGridSizeCombo();
            MainGUI.this.updateZoomLevelCheckBoxes();
        }
    }

    private class ApplySelectionButtonListener
    implements ActionListener {
        private ApplySelectionButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGUI.this.setSelectionByEnteredCoordinates();
        }
    }

    private class GridZoomComboListener
    implements ActionListener {
        private GridZoomComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!MainGUI.this.gridZoomCombo.isEnabled()) {
                return;
            }
            GridZoom g = (GridZoom)MainGUI.this.gridZoomCombo.getSelectedItem();
            if (g == null) {
                return;
            }
            log.debug("Selected grid zoom combo box item has changed: " + g.getZoom());
            MainGUI.this.previewMap.setGridZoom(g.getZoom());
            MainGUI.this.repaint();
            MainGUI.this.previewMap.updateMapSelection();
        }
    }

    private class ZoomSliderListener
    implements ChangeListener {
        private ZoomSliderListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MainGUI.this.previewMap.setZoom(MainGUI.this.zoomSlider.getValue());
        }
    }
}

