/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mobac.exceptions.MapSourcesUpdateException;
import mobac.gui.MainGUI;
import mobac.gui.components.JDirectoryChooser;
import mobac.gui.components.JMapSizeCombo;
import mobac.gui.components.JObjectCheckBox;
import mobac.gui.components.JTimeSlider;
import mobac.mapsources.MapSourcesManager;
import mobac.mapsources.MapSourcesUpdater;
import mobac.program.model.ProxyType;
import mobac.program.model.Settings;
import mobac.program.model.UnitSystem;
import mobac.program.tilestore.TileStore;
import mobac.program.tilestore.TileStoreInfo;
import mobac.program.tilestore.berkeleydb.DelayedInterruptThread;
import mobac.utilities.GBC;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.Utilities;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class SettingsGUI
extends JDialog {
    private static final long serialVersionUID = -5227934684609357198L;
    private static Logger log = Logger.getLogger(SettingsGUI.class);
    private static final Integer[] THREADCOUNT_LIST = new Integer[]{1, 2, 4, 6, 8, 10, 15};
    private JComboBox unitSystem;
    private JButton mapSourcesOnlineUpdate;
    private JComboBox googleLang;
    private JPanel tileStoreInfoPanel;
    private JCheckBox tileStoreEnabled;
    private JTimeSlider defaultExpirationTime;
    private JTimeSlider minExpirationTime;
    private JTimeSlider maxExpirationTime;
    private JLabel totalTileCountLabel;
    private JLabel totalTileSizeLabel;
    private JMapSizeCombo mapSize;
    private JTextField atlasOutputDirectory;
    private JComboBox threadCount;
    private JComboBox proxyType;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JButton okButton;
    private JButton cancelButton;
    private JTabbedPane tabbedPane;
    private DelayedInterruptThread tileStoreAsyncThread = null;
    private List<TileSourceInfoComponents> tileStoreInfoList = new LinkedList<TileSourceInfoComponents>();
    private Vector<JMapSourceCB> mapSourceCbList = new Vector();

    static void showSettingsDialog(final JFrame owner) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SettingsGUI(owner);
            }
        });
    }

    private SettingsGUI(JFrame owner) {
        super(owner);
        this.setIconImages(MainGUI.MOBAC_ICONS);
        GUIExceptionHandler.registerForCurrentThread();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setMinimumSize(new Dimension(300, 300));
        this.createJFrame();
        this.createTabbedPane();
        this.createJButtons();
        this.loadSettings();
        this.addListeners();
        this.pack();
        this.setMinimumSize(this.getSize());
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dScreen.width - this.getWidth()) / 2, (dScreen.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void createJFrame() {
        this.setLayout(new BorderLayout());
        this.setTitle("Settings");
    }

    public void createTabbedPane() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBounds(0, 0, 492, 275);
        this.addDisplaySettingsPanel();
        this.addMapSourceSettingsPanel();
        this.addTileUpdatePanel();
        this.addTileStorePanel();
        this.addMapSizePanel();
        this.addDirectoriesPanel();
        this.addNetworkPanel();
        this.add((Component)this.tabbedPane, "Center");
    }

    private JPanel createNewTab(String tabTitle) {
        JPanel tabPanel = new JPanel();
        tabPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.tabbedPane.add((Component)tabPanel, tabTitle);
        return tabPanel;
    }

    private void addDisplaySettingsPanel() {
        JPanel tab = this.createNewTab("Display");
        tab.setLayout(new GridBagLayout());
        JPanel unitSystemPanel = new JPanel(new GridBagLayout());
        unitSystemPanel.setBorder(this.createSectionBorder("Unit System"));
        UnitSystem[] us = UnitSystem.values();
        this.unitSystem = new JComboBox<UnitSystem>(us);
        unitSystemPanel.add((Component)new JLabel("Unit system for map scale bar: "), GBC.std());
        unitSystemPanel.add((Component)this.unitSystem, GBC.std());
        unitSystemPanel.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        tab.add((Component)unitSystemPanel, GBC.eol().fill(2));
        tab.add(Box.createVerticalGlue(), GBC.std().fill(3));
    }

    private void addMapSourceSettingsPanel() {
        JPanel tab = this.createNewTab("Map sources");
        tab.setLayout(new GridBagLayout());
        JPanel updatePanel = new JPanel(new GridBagLayout());
        updatePanel.setBorder(this.createSectionBorder("Map sources online update"));
        this.mapSourcesOnlineUpdate = new JButton("Perform online update");
        this.mapSourcesOnlineUpdate.addActionListener(new MapSourcesOnlineUpdateAction());
        updatePanel.add((Component)this.mapSourcesOnlineUpdate, GBC.std());
        JPanel googlePanel = new JPanel(new GridBagLayout());
        googlePanel.setBorder(this.createSectionBorder("Google Maps"));
        String[] languages = new String[]{"en", "de", "ru", "zh-CN"};
        this.googleLang = new JComboBox<String>(languages);
        this.googleLang.setEditable(true);
        googlePanel.add((Component)new JLabel("Language (hl parameter): "), GBC.std());
        googlePanel.add((Component)this.googleLang, GBC.eol());
        JPanel mapSourcesInnerPanel = new JPanel();
        Color c = UIManager.getColor("List.background");
        mapSourcesInnerPanel.setBackground(c);
        TreeSet<String> disabledMapSources = new TreeSet<String>(Settings.getInstance().getDisabledMapSources());
        this.mapSourceCbList.clear();
        for (MapSource ms : MapSourcesManager.getAllMapSources()) {
            JMapSourceCB checkBox = new JMapSourceCB(ms.toString());
            checkBox.setObject(ms);
            checkBox.setSelected(!disabledMapSources.contains(ms.getName()));
            checkBox.setBackground(c);
            mapSourcesInnerPanel.add(checkBox);
            this.mapSourceCbList.add(checkBox);
        }
        mapSourcesInnerPanel.setLayout(new BoxLayout(mapSourcesInnerPanel, 1));
        JScrollPane mapSourcesScrollPane = new JScrollPane(mapSourcesInnerPanel, 20, 31);
        mapSourcesScrollPane.setMinimumSize(new Dimension(300, 200));
        JPanel mapSourcesOuterPanel = new JPanel(new BorderLayout());
        mapSourcesOuterPanel.add((Component)mapSourcesScrollPane, "Center");
        mapSourcesOuterPanel.setBorder(this.createSectionBorder("Enabled Map Sources"));
        mapSourcesOuterPanel.setPreferredSize(new Dimension(200, 200));
        tab.add((Component)updatePanel, GBC.eol().fill(2));
        tab.add((Component)googlePanel, GBC.eol().fill(2));
        tab.add((Component)mapSourcesOuterPanel, GBC.eol().fill());
    }

    private void addTileUpdatePanel() {
        JPanel backGround = this.createNewTab("Tile update");
        backGround.setLayout(new GridBagLayout());
        ChangeListener sliderChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTimeSlider slider = (JTimeSlider)e.getSource();
                long x = slider.getTimeSecondsValue();
                JPanel panel = (JPanel)slider.getParent();
                TitledBorder tb = (TitledBorder)panel.getBorder();
                tb.setTitle(panel.getName() + ": " + Utilities.formatDurationSeconds(x));
                panel.repaint();
            }
        };
        GBC gbc_ef = GBC.eol().fill(2);
        JPanel defaultExpirationPanel = new JPanel(new GridBagLayout());
        defaultExpirationPanel.setName("Default expiration time");
        defaultExpirationPanel.setBorder(this.createSectionBorder(""));
        this.defaultExpirationTime = new JTimeSlider();
        this.defaultExpirationTime.addChangeListener(sliderChangeListener);
        JLabel descr = new JLabel("<html>The default exipration time is used for map sources that do not <br>provide an expiration time for each map tile.</html>", 0);
        defaultExpirationPanel.add((Component)descr, gbc_ef);
        defaultExpirationPanel.add((Component)this.defaultExpirationTime, gbc_ef);
        JPanel maxExpirationPanel = new JPanel(new BorderLayout());
        maxExpirationPanel.setName("Maximum expiration time");
        maxExpirationPanel.setBorder(this.createSectionBorder(""));
        this.maxExpirationTime = new JTimeSlider();
        this.maxExpirationTime.addChangeListener(sliderChangeListener);
        maxExpirationPanel.add((Component)this.maxExpirationTime, "Center");
        JPanel minExpirationPanel = new JPanel(new BorderLayout());
        minExpirationPanel.setName("Minimum expiration time");
        minExpirationPanel.setBorder(this.createSectionBorder(""));
        this.minExpirationTime = new JTimeSlider();
        this.minExpirationTime.addChangeListener(sliderChangeListener);
        minExpirationPanel.add((Component)this.minExpirationTime, "Center");
        descr = new JLabel("<html>Tiles are updated automatically base on the settings below. Each map tile has <br>an expiry date that is sometimes provided by the server. If the server does <br> not provide one, the default expiration time is used.</html>", 0);
        backGround.add((Component)descr, gbc_ef);
        backGround.add((Component)defaultExpirationPanel, gbc_ef);
        backGround.add((Component)minExpirationPanel, gbc_ef);
        backGround.add((Component)maxExpirationPanel, gbc_ef);
        backGround.add(Box.createVerticalGlue(), GBC.std().fill());
    }

    private void addTileStorePanel() {
        JPanel backGround = this.createNewTab("Tile store");
        this.tileStoreEnabled = new JCheckBox("Enable tile store for map preview and atlas download");
        JPanel tileStorePanel = new JPanel(new BorderLayout());
        tileStorePanel.setBorder(this.createSectionBorder("Tile store settings"));
        tileStorePanel.add((Component)this.tileStoreEnabled, "Center");
        this.tileStoreInfoPanel = new JPanel(new GridBagLayout());
        this.prepareTileStoreInfoPanel();
        backGround.setLayout(new BorderLayout());
        backGround.add((Component)tileStorePanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.tileStoreInfoPanel, 22, 31);
        this.tileStoreInfoPanel.setMinimumSize(new Dimension(200, 300));
        scrollPane.setPreferredSize(new Dimension(520, 100));
        scrollPane.setBorder(this.createSectionBorder("Information"));
        backGround.add((Component)scrollPane, "Center");
    }

    private synchronized void updateTileStoreInfoPanelAsync(final MapSource mapSource) {
        if (this.tileStoreAsyncThread != null) {
            return;
        }
        this.tileStoreAsyncThread = new DelayedInterruptThread("TileStoreInfoRetriever"){

            @Override
            public void run() {
                if (mapSource == null) {
                    log.debug("Updating tilestore information in background");
                } else {
                    log.debug("Updating tilestore information for \"" + mapSource + "\" in background");
                }
                SettingsGUI.this.updateTileStoreInfoPanel(mapSource);
                log.debug("Updating tilestore information finished");
                SettingsGUI.this.tileStoreAsyncThread = null;
            }
        };
        this.tileStoreAsyncThread.start();
    }

    private void prepareTileStoreInfoPanel() {
        GridBagConstraints gbc_mapSource = new GridBagConstraints();
        gbc_mapSource.insets = new Insets(5, 10, 5, 10);
        gbc_mapSource.anchor = 17;
        GridBagConstraints gbc_mapTiles = new GridBagConstraints();
        gbc_mapTiles.insets = gbc_mapSource.insets;
        gbc_mapTiles.anchor = 13;
        GridBagConstraints gbc_eol = new GridBagConstraints();
        gbc_eol.gridwidth = 0;
        TileStore tileStore = TileStore.getInstance();
        this.tileStoreInfoPanel.add((Component)new JLabel("<html><b>Map source</b></html>"), gbc_mapSource);
        this.tileStoreInfoPanel.add((Component)new JLabel("<html><b>Tiles</b></html>"), gbc_mapTiles);
        this.tileStoreInfoPanel.add((Component)new JLabel("<html><b>Size</b></html>"), gbc_eol);
        ImageIcon trash = Utilities.loadResourceImageIcon("trash.png");
        for (MapSource ts : MapSourcesManager.getAllMapSources()) {
            if (!tileStore.storeExists(ts)) continue;
            String mapTileCountText = "  ?  ";
            String mapTileSizeText = "    ?    ";
            JLabel mapSourceNameLabel = new JLabel(ts.toString());
            JLabel mapTileCountLabel = new JLabel(mapTileCountText);
            JLabel mapTileSizeLabel = new JLabel(mapTileSizeText);
            JButton deleteButton = new JButton(trash);
            TileSourceInfoComponents info = new TileSourceInfoComponents();
            info.mapSource = ts;
            info.countLabel = mapTileCountLabel;
            info.sizeLabel = mapTileSizeLabel;
            this.tileStoreInfoList.add(info);
            deleteButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            deleteButton.setToolTipText("Delete all stored " + ts.getName() + " tiles.");
            deleteButton.addActionListener(new ClearTileCacheAction(ts));
            this.tileStoreInfoPanel.add((Component)mapSourceNameLabel, gbc_mapSource);
            this.tileStoreInfoPanel.add((Component)mapTileCountLabel, gbc_mapTiles);
            this.tileStoreInfoPanel.add((Component)mapTileSizeLabel, gbc_mapTiles);
            this.tileStoreInfoPanel.add((Component)deleteButton, gbc_eol);
        }
        JSeparator hr = new JSeparator(0);
        hr.setBorder(BorderFactory.createEtchedBorder(1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        this.tileStoreInfoPanel.add((Component)hr, gbc);
        JLabel totalMapLabel = new JLabel("<html><b>Total</b></html>");
        this.totalTileCountLabel = new JLabel("<html><b>??</b></html>");
        this.totalTileSizeLabel = new JLabel("<html><b>??</b></html>");
        this.tileStoreInfoPanel.add((Component)totalMapLabel, gbc_mapSource);
        this.tileStoreInfoPanel.add((Component)this.totalTileCountLabel, gbc_mapTiles);
        this.tileStoreInfoPanel.add((Component)this.totalTileSizeLabel, gbc_mapTiles);
    }

    private void updateTileStoreInfoPanel(MapSource mapSource) {
        try {
            TileStore tileStore = TileStore.getInstance();
            long totalTileCount = 0L;
            long totalTileSize = 0L;
            for (final TileSourceInfoComponents info : this.tileStoreInfoList) {
                long size;
                int count;
                MapSource ms = info.mapSource;
                Utilities.checkForInterruption();
                if (mapSource == null || ms.equals(mapSource)) {
                    TileStoreInfo tsi = tileStore.getStoreInfo(ms);
                    count = tsi.getTileCount();
                    size = tsi.getStoreSize();
                    info.count = count;
                    info.size = size;
                    final String mapTileCountText = count < 0 ? "??" : Integer.toString(count);
                    final String mapTileSizeText = Utilities.formatBytes(size);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            info.countLabel.setText("<html><b>" + mapTileCountText + "</b></html>");
                            info.sizeLabel.setText("<html><b>" + mapTileSizeText + "</b></html>");
                        }
                    });
                } else {
                    count = info.count;
                    size = info.size;
                }
                totalTileCount += (long)count;
                totalTileSize += size;
            }
            final String totalTileCountText = "<html><b>" + Long.toString(totalTileCount) + "</b></html>";
            final String totalTileSizeText = "<html><b>" + Utilities.formatBytes(totalTileSize) + "</b></html>";
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SettingsGUI.this.totalTileCountLabel.setText(totalTileCountText);
                    SettingsGUI.this.totalTileSizeLabel.setText(totalTileSizeText);
                }
            });
        }
        catch (InterruptedException e) {
            log.debug("Tile store information retrieval was canceled");
        }
    }

    private void addMapSizePanel() {
        JPanel backGround = this.createNewTab("Map size");
        backGround.setLayout(new GridBagLayout());
        this.mapSize = new JMapSizeCombo();
        this.mapSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.trace("Map size: " + SettingsGUI.this.mapSize.getValue());
            }
        });
        JLabel mapSizeLabel = new JLabel("Maximum size (width & height) of each map: ");
        JLabel mapSizeText = new JLabel("<html>If the image of the selected region to download is larger in height or width than <br>the mapsize it will be splitted into several maps when adding the map selection.<br>Each map is no larger than the specified maximum map size.<br>You can see the number of maps and their region in the atlas content tree.<br><br><b>Note for TrekBuddy users:</b><br>TrekBuddy versions before v0.9.88 do not support map sizes larger than 32767.<br>Newer versions can handle maps up to a size of 1048575.</html>");
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBorder(this.createSectionBorder("Map size settings"));
        GBC gbc = GBC.eol().insets(0, 5, 0, 5);
        leftPanel.add((Component)mapSizeLabel, GBC.std());
        leftPanel.add((Component)this.mapSize, GBC.eol());
        leftPanel.add((Component)mapSizeText, gbc.fill(2));
        leftPanel.add(Box.createVerticalGlue(), GBC.std().fill(3));
        backGround.add((Component)leftPanel, GBC.std().fill(2).anchor(12));
        backGround.add(Box.createVerticalGlue(), GBC.std().fill(3));
    }

    private void addDirectoriesPanel() {
        JPanel jPanel = this.createNewTab("Directories");
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(this.createSectionBorder("Atlas output directory"));
        this.atlasOutputDirectory = new JTextField();
        this.atlasOutputDirectory.setToolTipText("<html>If empty the default directory is used: <br><tt>" + Settings.getInstance().getAtlasOutputDirectory() + "</tt></html>");
        JButton jButton = new JButton("Select");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDirectoryChooser dc = new JDirectoryChooser();
                dc.setCurrentDirectory(Settings.getInstance().getAtlasOutputDirectory());
                if (dc.showDialog(SettingsGUI.this, "Select Directory") != 0) {
                    return;
                }
                SettingsGUI.this.atlasOutputDirectory.setText(dc.getSelectedFile().getAbsolutePath());
            }
        });
        jPanel2.add((Component)this.atlasOutputDirectory, GBC.std().fillH());
        jPanel2.add((Component)jButton, GBC.std());
        jPanel.add((Component)jPanel2, GBC.eol().fillH());
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    private void addNetworkPanel() {
        JPanel jPanel = this.createNewTab("Network");
        jPanel.setLayout(new GridBagLayout());
        GBC gBC = GBC.eol().fill(2);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(this.createSectionBorder("Network connections"));
        this.threadCount = new JComboBox<Integer>(THREADCOUNT_LIST);
        this.threadCount.setMaximumRowCount(THREADCOUNT_LIST.length);
        jPanel2.add((Component)this.threadCount, GBC.std().insets(5, 5, 5, 5));
        jPanel2.add((Component)new JLabel("Number of parallel network connections for tile downloading"), GBC.std().fill(2));
        jPanel.add((Component)jPanel2, gBC);
        jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(this.createSectionBorder("HTTP Proxy"));
        JLabel jLabel = new JLabel("Proxy settings: ");
        this.proxyType = new JComboBox<ProxyType>(ProxyType.values());
        this.proxyType.setSelectedItem((Object)Settings.getInstance().getProxyType());
        final JLabel jLabel2 = new JLabel("Proxy host name: ");
        this.proxyHost = new JTextField(Settings.getInstance().getCustomProxyHost());
        final JLabel jLabel3 = new JLabel("Proxy port: ");
        this.proxyPort = new JTextField(Settings.getInstance().getCustomProxyPort());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = ProxyType.CUSTOM.equals(SettingsGUI.this.proxyType.getSelectedItem());
                SettingsGUI.this.proxyHost.setEnabled(b);
                SettingsGUI.this.proxyPort.setEnabled(b);
                jLabel2.setEnabled(b);
                jLabel3.setEnabled(b);
            }
        };
        actionListener.actionPerformed(null);
        this.proxyType.addActionListener(actionListener);
        jPanel2.add((Component)jLabel, GBC.std());
        jPanel2.add((Component)this.proxyType, gBC.insets(5, 2, 5, 2));
        jPanel2.add((Component)jLabel2, GBC.std());
        jPanel2.add((Component)this.proxyHost, gBC);
        jPanel2.add((Component)jLabel3, GBC.std());
        jPanel2.add((Component)this.proxyPort, gBC);
        jPanel.add((Component)jPanel2, GBC.eol().fillH());
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public void createJButtons() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.okButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        GBC gBC = GBC.std().insets(5, 5, 5, 5);
        jPanel.add((Component)this.okButton, gBC);
        jPanel.add((Component)this.cancelButton, gBC);
        this.add((Component)jPanel, "South");
    }

    private void loadSettings() {
        Settings s = Settings.getInstance();
        this.unitSystem.setSelectedItem((Object)s.getUnitSystem());
        this.tileStoreEnabled.setSelected(s.tileStoreEnabled);
        this.mapSize.setValue(s.maxMapSize);
        this.atlasOutputDirectory.setText(s.getAtlasOutputDirectoryString());
        int index = Arrays.binarySearch((Object[])THREADCOUNT_LIST, (Object)s.downloadThreadCount);
        if (index < 0) {
            index = 0;
        }
        this.threadCount.setSelectedIndex(index);
        this.defaultExpirationTime.setTimeMilliValue(s.tileDefaultExpirationTime);
        this.maxExpirationTime.setTimeMilliValue(s.tileMaxExpirationTime);
        this.minExpirationTime.setTimeMilliValue(s.tileMinExpirationTime);
        String lang = s.getGoogleLanguage();
        this.googleLang.setSelectedItem(lang);
    }

    private void applySettings() {
        int n;
        Settings settings = Settings.getInstance();
        settings.setUnitSystem((UnitSystem)((Object)this.unitSystem.getSelectedItem()));
        settings.tileStoreEnabled = this.tileStoreEnabled.isSelected();
        settings.tileDefaultExpirationTime = this.defaultExpirationTime.getTimeMilliValue();
        settings.tileMinExpirationTime = this.minExpirationTime.getTimeMilliValue();
        settings.tileMaxExpirationTime = this.maxExpirationTime.getTimeMilliValue();
        settings.maxMapSize = this.mapSize.getValue();
        settings.setAtlasOutputDirectory(this.atlasOutputDirectory.getText());
        settings.downloadThreadCount = n = ((Integer)this.threadCount.getSelectedItem()).intValue();
        settings.setProxyType((ProxyType)((Object)this.proxyType.getSelectedItem()));
        settings.setCustomProxyHost(this.proxyHost.getText());
        settings.setCustomProxyPort(this.proxyPort.getText());
        settings.applyProxySettings();
        Vector<String> vector = new Vector<String>();
        for (JMapSourceCB jMapSourceCB : this.mapSourceCbList) {
            if (jMapSourceCB.isSelected()) continue;
            vector.add(((MapSource)jMapSourceCB.getObject()).getName());
        }
        settings.setDisabledMapSources(vector);
        if (MainGUI.getMainGUI() == null) {
            return;
        }
        MainGUI.getMainGUI().updateMapSourcesList();
        if (this.googleLang.getSelectedIndex() < 0) {
            settings.setGoogleLanguage(this.googleLang.getEditor().getItem().toString());
        } else {
            settings.setGoogleLanguage(this.googleLang.getSelectedItem().toString());
        }
        try {
            MainGUI.getMainGUI().checkAndSaveSettings();
        }
        catch (Exception exception) {
            log.error("Error saving settings to file", exception);
            JOptionPane.showMessageDialog(null, "Error saving settings to file:\n" + exception.toString() + " (" + exception.getClass().getSimpleName() + ")", "Error saving settings to file", 0);
        }
        MainGUI.getMainGUI().previewMap.repaint();
    }

    private void addListeners() {
        this.addComponentListener(new WindowShowListener());
        this.addWindowListener(new WindowCloseListener());
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsGUI.this.applySettings();
                SettingsGUI.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsGUI.this.dispose();
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsGUI.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    private TitledBorder createSectionBorder(String title) {
        TitledBorder tb = BorderFactory.createTitledBorder(title);
        Border border = BorderFactory.createEtchedBorder(1);
        EmptyBorder margin = new EmptyBorder(3, 3, 3, 3);
        tb.setBorder(new CompoundBorder(border, margin));
        return tb;
    }

    private static class TileSourceInfoComponents {
        JLabel sizeLabel;
        JLabel countLabel;
        MapSource mapSource;
        int count = -1;
        long size = 0L;

        private TileSourceInfoComponents() {
        }
    }

    private static class JMapSourceCB
    extends JObjectCheckBox<MapSource> {
        private static final long serialVersionUID = 1L;

        public JMapSourceCB(String text) {
            super(text);
        }
    }

    private class ClearTileCacheAction
    implements ActionListener {
        MapSource source;

        public ClearTileCacheAction(MapSource source) {
            this.source = source;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            b.setEnabled(false);
            b.setToolTipText("Deleting in progress - please wait");
            DelayedInterruptThread t = new DelayedInterruptThread("TileStore_" + this.source.getName() + "_DeleteThread"){

                @Override
                public void run() {
                    try {
                        TileStore ts = TileStore.getInstance();
                        ts.clearStore(ClearTileCacheAction.this.source);
                        SettingsGUI.this.updateTileStoreInfoPanelAsync(ClearTileCacheAction.this.source);
                        SettingsGUI.this.repaint();
                    }
                    catch (Exception e) {
                        log.error("An error occured while cleaning tile cache: ", e);
                    }
                }
            };
            t.start();
        }
    }

    private class MapSourcesOnlineUpdateAction
    implements ActionListener {
        private MapSourcesOnlineUpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                boolean result = MapSourcesUpdater.mapsourcesOnlineUpdate();
                String msg = result ? "Online update successfull" : "No new update avilable";
                DateFormat df = DateFormat.getDateTimeInstance();
                Date date = MapSourcesUpdater.getMapSourcesDate(System.getProperties());
                msg = msg + "\nCurrent map source date: " + df.format(date);
                JOptionPane.showMessageDialog(SettingsGUI.this, msg);
                if (result) {
                    MainGUI.getMainGUI().refreshPreviewMap();
                }
            }
            catch (MapSourcesUpdateException e) {
                JOptionPane.showMessageDialog(SettingsGUI.this, e.getMessage(), "Mapsources online update failed", 0);
            }
        }
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosed(WindowEvent event) {
            DelayedInterruptThread t = SettingsGUI.this.tileStoreAsyncThread;
            if (t != null) {
                ((Thread)t).interrupt();
            }
        }
    }

    private class WindowShowListener
    extends ComponentAdapter {
        private boolean firstShown = true;

        private WindowShowListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentShown(ComponentEvent event) {
            WindowShowListener windowShowListener = this;
            synchronized (windowShowListener) {
                if (this.firstShown) {
                    SettingsGUI.this.updateTileStoreInfoPanelAsync(null);
                }
                this.firstShown = false;
            }
        }
    }
}

