/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.atlastree;

import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mobac.exceptions.InvalidNameException;
import mobac.gui.atlastree.JAtlasTree;
import mobac.gui.atlastree.NodeTransferWrapper;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.AtlasTreeModel;
import org.apache.log4j.Logger;

public class DragDropController {
    static Logger log = Logger.getLogger(DragDropController.class);
    JAtlasTree atlasTree;

    public DragDropController(JAtlasTree atlasTree) {
        this.atlasTree = atlasTree;
        new AtlasDragSource();
        new AtlasDropTarget();
    }

    protected class AtlasDropTarget
    implements DropTargetListener {
        final DropTarget target;

        public AtlasDropTarget() throws HeadlessException {
            this.target = new DropTarget(DragDropController.this.atlasTree, this);
        }

        @Override
        public synchronized void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public synchronized void dragExit(DropTargetEvent dte) {
        }

        @Override
        public synchronized void dragOver(DropTargetDragEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                Object o = t.getTransferData(NodeTransferWrapper.ATLAS_OBJECT_FLAVOR);
                TreeNode node = this.getNodeForEvent(dtde);
                if (o instanceof LayerInterface && node instanceof LayerInterface) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                if (o instanceof MapInterface && node instanceof LayerInterface || node instanceof MapInterface) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
            }
            catch (Exception e) {
                log.error("", e);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public synchronized void drop(DropTargetDropEvent dtde) {
            try {
                TreeNode sourceNode = (TreeNode)dtde.getTransferable().getTransferData(NodeTransferWrapper.ATLAS_OBJECT_FLAVOR);
                Point pt = dtde.getLocation();
                DropTargetContext dtc = dtde.getDropTargetContext();
                JTree tree = (JTree)dtc.getComponent();
                TreePath parentpath = tree.getClosestPathForLocation(pt.x, pt.y);
                TreeNode targetNode = (TreeNode)parentpath.getLastPathComponent();
                if (targetNode.equals(sourceNode) || targetNode.getParent().equals(sourceNode)) {
                    dtde.rejectDrop();
                    return;
                }
                AtlasTreeModel atlasTreeModel = (AtlasTreeModel)DragDropController.this.atlasTree.getModel();
                if (sourceNode instanceof LayerInterface && targetNode instanceof LayerInterface) {
                    this.mergeLayers(atlasTreeModel, (LayerInterface)((Object)sourceNode), (LayerInterface)((Object)targetNode));
                }
                if (targetNode instanceof MapInterface) {
                    targetNode = targetNode.getParent();
                }
                if (sourceNode instanceof MapInterface && targetNode instanceof LayerInterface) {
                    this.moveMap(atlasTreeModel, (MapInterface)((Object)sourceNode), (LayerInterface)((Object)targetNode));
                }
            }
            catch (Exception e) {
                log.error("", e);
                DragDropController.this.atlasTree.getTreeModel().notifyStructureChanged();
                dtde.rejectDrop();
            }
        }

        protected void mergeLayers(AtlasTreeModel atlasTreeModel, LayerInterface sourceLayer, LayerInterface targetLayer) throws InvalidNameException {
            int answer = JOptionPane.showConfirmDialog(null, "Are you sure you want to merge the maps of layer\n\"" + sourceLayer.getName() + "\" into layer " + "\"" + targetLayer.getName() + "\"?", "Confirm layer merging", 0);
            if (answer != 0) {
                return;
            }
            try {
                atlasTreeModel.mergeLayers(sourceLayer, targetLayer);
            }
            catch (InvalidNameException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Layer merging failed", 0);
                throw e;
            }
        }

        protected void moveMap(AtlasTreeModel atlasTreeModel, MapInterface map, LayerInterface targetLayer) throws InvalidNameException {
            atlasTreeModel.moveMap(map, targetLayer);
        }

        private TreeNode getNodeForEvent(DropTargetDragEvent dtde) {
            Point p = dtde.getLocation();
            DropTargetContext dtc = dtde.getDropTargetContext();
            JTree tree = (JTree)dtc.getComponent();
            TreePath path = tree.getClosestPathForLocation(p.x, p.y);
            return (TreeNode)path.getLastPathComponent();
        }
    }

    protected class AtlasDragSource
    implements DragGestureListener,
    DragSourceListener {
        final DragGestureRecognizer recognizer;
        final DragSource source = new DragSource();

        public AtlasDragSource() {
            this.recognizer = this.source.createDefaultDragGestureRecognizer(DragDropController.this.atlasTree, 2, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            TreePath path = DragDropController.this.atlasTree.getSelectionPath();
            if (path == null || path.getPathCount() <= 1) {
                return;
            }
            TreeNode oldNode = (TreeNode)path.getLastPathComponent();
            if (!(oldNode instanceof LayerInterface) && !(oldNode instanceof MapInterface)) {
                return;
            }
            NodeTransferWrapper transferable = new NodeTransferWrapper(oldNode);
            this.source.startDrag(dge, DragSource.DefaultMoveNoDrop, transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }
}

