/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.atlastree;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mobac.gui.MainGUI;
import mobac.gui.atlastree.DragDropController;
import mobac.gui.atlastree.MouseController;
import mobac.gui.atlastree.NodeEditor;
import mobac.gui.atlastree.NodeRenderer;
import mobac.gui.mapview.MultiMapSelectionLayer;
import mobac.gui.mapview.PreviewMap;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.AtlasObject;
import mobac.program.interfaces.CapabilityDeletable;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.interfaces.ToolTipProvider;
import mobac.program.model.Atlas;
import mobac.program.model.AtlasOutputFormat;
import mobac.program.model.AtlasTreeModel;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.MapSelection;
import mobac.program.model.Profile;
import mobac.program.model.TileImageParameters;
import mobac.utilities.GUIExceptionHandler;
import mobac.utilities.jdbc.SQLiteLoader;
import org.apache.log4j.Logger;

public class JAtlasTree
extends JTree
implements Autoscroll {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(JAtlasTree.class);
    private AtlasTreeModel treeModel;
    private PreviewMap mapView;
    protected NodeRenderer nodeRenderer;
    protected String defaultToolTiptext;
    protected KeyStroke deleteNodeKS;
    protected DragDropController ddc;

    public JAtlasTree(PreviewMap mapView) {
        super(new AtlasTreeModel());
        if (mapView == null) {
            throw new NullPointerException("MapView parameter is null");
        }
        this.mapView = mapView;
        this.getSelectionModel().setSelectionMode(1);
        this.ddc = new DragDropController(this);
        this.treeModel = (AtlasTreeModel)this.getModel();
        this.setShowsRootHandles(true);
        this.nodeRenderer = new NodeRenderer();
        this.setCellRenderer(this.nodeRenderer);
        this.setCellEditor(new NodeEditor(this));
        this.setToolTipText("");
        this.defaultToolTiptext = "<html>Use context menu of the entries to see all available commands.</html>";
        this.setAutoscrolls(true);
        this.addMouseListener(new MouseController(this));
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        this.deleteNodeKS = KeyStroke.getKeyStroke(127, 0);
        inputMap.put(this.deleteNodeKS, "DELETE_NODE");
        actionMap.put("DELETE_NODE", new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAtlasTree.this.deleteSelectedNode();
                JAtlasTree.this.mapView.repaint();
            }
        });
    }

    public boolean testAtlasContentValid() {
        AtlasInterface atlas = this.getAtlas();
        if (AtlasOutputFormat.BigPlanet.equals((Object)atlas.getOutputFormat()) && !SQLiteLoader.loadSQLiteOrShowError()) {
            return false;
        }
        if (atlas.calculateTilesToDownload() == 0) {
            JOptionPane.showMessageDialog(null, "<html>Atlas is empty - please add at least one selection to atlas content.</html>", "Error - atlas has no content", 0);
            return false;
        }
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.getRowForLocation(event.getX(), event.getY()) == -1) {
            return this.defaultToolTiptext;
        }
        TreePath curPath = this.getPathForLocation(event.getX(), event.getY());
        Object o = curPath.getLastPathComponent();
        if (o == null || !(o instanceof ToolTipProvider)) {
            return null;
        }
        return ((ToolTipProvider)o).getToolTip();
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        return super.isPathEditable(path) && path.getLastPathComponent() instanceof AtlasObject;
    }

    public AtlasTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void clearAtlas() {
        log.debug("Resetting atlas tree model");
        Atlas newAtlas = Atlas.newInstance();
        newAtlas.setName(MainGUI.getMainGUI().getUserText());
        this.treeModel.setAtlas(newAtlas);
        this.mapView.mapLayers.clear();
        this.mapView.repaint();
    }

    public void deleteSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        TreeNode selected = (TreeNode)path.getLastPathComponent();
        int[] selectedRows = this.getSelectionRows();
        if (!(selected instanceof CapabilityDeletable)) {
            return;
        }
        this.treeModel.notifyNodeDelete(selected);
        ((CapabilityDeletable)((Object)selected)).delete();
        int selRow = Math.min(selectedRows[0], this.getRowCount() - 1);
        TreePath path1 = path.getParentPath();
        TreePath path2 = this.getPathForRow(selRow).getParentPath();
        if (path1 != path2) {
            this.setSelectionPath(path1);
        } else {
            this.setSelectionRow(selRow);
            this.scrollRowToVisible(selRow);
        }
    }

    public AtlasInterface getAtlas() {
        return this.treeModel.getAtlas();
    }

    public boolean load(Profile profile) {
        log.debug("Loading profile " + profile);
        try {
            Atlas atlas;
            this.treeModel.load(profile);
            if (this.treeModel.getAtlas() instanceof Atlas && (atlas = (Atlas)this.treeModel.getAtlas()).getVersion() < 1) {
                JOptionPane.showMessageDialog(null, "The loaded atlas belongs to an older version Mobile Atlas Creator. This old version \nused a somehow different atlas profile format which is incompatible to this version.\n\nIt is recommended to clear the loaded atlas and delete the affected profile.\nOtherwise various exceptions may be thrown while working with this atlas.", "Outdated atlas version", 2);
                return true;
            }
            boolean problemsDetected = Profile.checkAtlas(this.treeModel.getAtlas());
            if (problemsDetected) {
                JOptionPane.showMessageDialog(null, "At least one problem was detected while loading the saved atlas profile.\nUsually this indicates that the profile file is inconsistent or the file format \nhas changed.\n\nIt is recommended to clear the loaded atlas and delete the affected profile.\nOtherwise various exceptions may be thrown while working with this atlas.", "Atlas loading problem", 2);
            }
            return true;
        }
        catch (Exception e) {
            GUIExceptionHandler.processException(e);
            return false;
        }
    }

    public boolean save(Profile profile) {
        try {
            this.treeModel.save(profile);
            return true;
        }
        catch (Exception e) {
            GUIExceptionHandler.processException(e);
            return false;
        }
    }

    protected void showNodePopupMenu(MouseEvent event) {
        JPopupMenu pm = new JPopupMenu();
        final TreePath selPath = this.getPathForLocation(event.getX(), event.getY());
        this.setSelectionPath(selPath);
        JMenuItem mi = null;
        if (selPath != null) {
            final Object o = selPath.getLastPathComponent();
            if (o == null) {
                return;
            }
            if (o instanceof ToolTipProvider) {
                mi = new JMenuItem("Show item details");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ToolTipProvider ttp = (ToolTipProvider)o;
                        JOptionPane.showMessageDialog(MainGUI.getMainGUI(), ttp.getToolTip());
                    }
                });
                pm.add(mi);
            }
            if (o instanceof AtlasObject) {
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem("Display map areas");
                final MultiMapSelectionLayer msl = new MultiMapSelectionLayer((AtlasObject)o);
                final boolean mapAreaVisible = this.mapView.mapLayers.contains(msl);
                cbmi.setSelected(mapAreaVisible);
                cbmi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (mapAreaVisible) {
                            ((JAtlasTree)JAtlasTree.this).mapView.mapLayers.clear();
                        } else {
                            JAtlasTree.this.mapView.setSelectionByTileCoordinate(null, null, false);
                            ((JAtlasTree)JAtlasTree.this).mapView.mapLayers.clear();
                            ((JAtlasTree)JAtlasTree.this).mapView.mapLayers.add(msl);
                        }
                        JAtlasTree.this.mapView.repaint();
                    }
                });
                pm.add(cbmi);
            }
            if (o instanceof MapInterface) {
                mi = new JMenuItem("Select map area");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapInterface map = (MapInterface)o;
                        JAtlasTree.this.mapView.setMapSource(map.getMapSource());
                        JAtlasTree.this.mapView.setSelectionByTileCoordinate(map.getZoom(), map.getMinTileCoordinate(), map.getMaxTileCoordinate(), true);
                    }
                });
                pm.add(mi);
                mi = new JMenuItem("Select map area and zoom to it");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapInterface map = (MapInterface)o;
                        MapSelection ms = new MapSelection(map);
                        JAtlasTree.this.mapView.setMapSource(map.getMapSource());
                        JAtlasTree.this.mapView.setSelectionAndZoomTo(ms, true);
                        JAtlasTree.this.mapView.setSelectionByTileCoordinate(map.getZoom(), map.getMinTileCoordinate(), map.getMaxTileCoordinate(), true);
                    }
                });
                pm.add(mi);
            }
            if (o instanceof LayerInterface) {
                mi = new JMenuItem("Zoom to");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayerInterface layer = (LayerInterface)o;
                        EastNorthCoordinate max = new EastNorthCoordinate(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                        EastNorthCoordinate min = new EastNorthCoordinate(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                        for (MapInterface map : layer) {
                            MapSelection ms = new MapSelection(map);
                            EastNorthCoordinate mapMax = ms.getMax();
                            EastNorthCoordinate mapMin = ms.getMin();
                            max.lat = Math.max(max.lat, mapMax.lat);
                            max.lon = Math.max(max.lon, mapMax.lon);
                            min.lat = Math.min(min.lat, mapMin.lat);
                            min.lon = Math.min(min.lon, mapMin.lon);
                        }
                        MapSelection ms = new MapSelection(JAtlasTree.this.mapView.getMapSource(), max, min);
                        JAtlasTree.this.mapView.zoomTo(ms);
                    }
                });
                pm.add(mi);
            }
            if (o instanceof AtlasObject) {
                mi = new JMenuItem("Rename");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JAtlasTree.this.startEditingAtPath(selPath);
                    }
                });
                pm.add(mi);
                mi = new JMenuItem("Apply tile processing options");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AtlasObject atlasObject = (AtlasObject)o;
                        TileImageParameters p = MainGUI.getMainGUI().getSelectedTileImageParameters();
                        JAtlasTree.this.applyTileImageParameters(atlasObject, p);
                    }
                });
                pm.add(mi);
            }
            if (o instanceof CapabilityDeletable) {
                pm.addSeparator();
                mi = new JMenuItem(this.getActionMap().get("DELETE_NODE"));
                mi.setAccelerator(this.deleteNodeKS);
                pm.add(mi);
            }
        }
        if (pm.getComponentCount() > 0) {
            pm.addSeparator();
        }
        mi = new JMenuItem("Clear atlas");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAtlasTree.this.clearAtlas();
            }
        });
        pm.add(mi);
        pm.show(this, event.getX(), event.getY());
    }

    protected void applyTileImageParameters(Object o, TileImageParameters p) {
        if (o instanceof Iterable) {
            Iterable it = (Iterable)o;
            for (Object ao : it) {
                this.applyTileImageParameters(ao, p);
            }
        } else if (o instanceof MapInterface) {
            ((MapInterface)o).setParameters(p);
        }
    }

    protected void selectElementOnMap(Object o) {
        if (o instanceof MapInterface) {
            MapInterface map = (MapInterface)o;
            this.mapView.setMapSource(map.getMapSource());
            this.mapView.setSelectionByTileCoordinate(map.getZoom(), map.getMinTileCoordinate(), map.getMaxTileCoordinate(), true);
        }
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        int realrow = this.getRowForLocation(cursorLocn.x, cursorLocn.y);
        Rectangle outer = this.getBounds();
        realrow = cursorLocn.y + outer.y <= 12 ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
        this.scrollRowToVisible(realrow);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + 12, inner.x - outer.x + 12, outer.height - inner.height - inner.y + outer.y + 12, outer.width - inner.width - inner.x + outer.x + 12);
    }
}

