/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.atlastree;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.LayerInterface;
import mobac.utilities.Utilities;

public class NodeRenderer
implements TreeCellRenderer {
    private static ImageIcon atlasIcon = new ImageIcon();
    private static ImageIcon layerIcon = new ImageIcon();
    private static ImageIcon mapIcon = new ImageIcon();
    DefaultTreeCellRenderer atlasRenderer = new SimpleTreeCellRenderer(atlasIcon);
    DefaultTreeCellRenderer layerRenderer = new SimpleTreeCellRenderer(layerIcon);
    DefaultTreeCellRenderer mapRenderer = new SimpleTreeCellRenderer(mapIcon);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultTreeCellRenderer tcr = value instanceof AtlasInterface ? this.atlasRenderer : (value instanceof LayerInterface ? this.layerRenderer : this.mapRenderer);
        return tcr.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    static {
        atlasIcon = Utilities.loadResourceImageIcon("atlas.png");
        layerIcon = Utilities.loadResourceImageIcon("layer.png");
        mapIcon = Utilities.loadResourceImageIcon("map.png");
    }

    protected static class SimpleTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        public SimpleTreeCellRenderer(Icon icon) {
            this.setIcon(icon);
            this.setOpenIcon(icon);
            this.setClosedIcon(icon);
            this.setLeafIcon(icon);
        }
    }
}

