/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import mobac.utilities.GBC;
import mobac.utilities.Utilities;

public class JCollapsiblePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Color DEFAULT_TITLE_BACKGROUND_COLOR = Color.LIGHT_GRAY;
    protected static final Color DEFAULT_TITLE_COLOR = Color.BLACK;
    private static ImageIcon arrowClosed;
    private static ImageIcon arrowOpen;
    protected final JLabel titleIcon;
    protected final JLabel titleLabel;
    protected final JPanel titlePanel;
    protected Container contentContainer;
    protected final CollapsingMouseListener collapsingMouseListener;
    private boolean isCollapsed;

    public JCollapsiblePanel(String title, LayoutManager layout) {
        this(new JPanel(layout), title);
        this.setName(title);
    }

    public JCollapsiblePanel(Container container, String title) {
        this.setName(title);
        this.titleIcon = new JLabel(arrowOpen);
        this.titleLabel = new JLabel(title);
        this.titlePanel = new JPanel(new GridBagLayout());
        this.collapsingMouseListener = new CollapsingMouseListener();
        this.titleIcon.setMinimumSize(new Dimension(40, 40));
        this.titleIcon.setPreferredSize(this.titleIcon.getPreferredSize());
        this.titlePanel.addMouseListener(this.collapsingMouseListener);
        this.setTitleBackgroundColor(DEFAULT_TITLE_BACKGROUND_COLOR);
        this.setTitleColor(DEFAULT_TITLE_COLOR);
        this.setTitleBarPadding(3);
        this.titlePanel.add((Component)this.titleIcon, GBC.std());
        this.titlePanel.add((Component)this.titleLabel, GBC.std().insets(5, 0, 1, 0));
        this.titlePanel.add(Box.createHorizontalGlue(), GBC.eol().fill());
        this.setLayout(new BorderLayout());
        this.add((Component)this.titlePanel, "North");
        this.add((Component)container, "Center");
        this.setContentContainer(container);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void setCollapsed(boolean collapsed) {
        if (this.isCollapsed == collapsed) {
            return;
        }
        if (collapsed) {
            this.titleIcon.setIcon(arrowClosed);
            Dimension dcont = this.contentContainer.getLayout().preferredLayoutSize(this.contentContainer);
            Dimension pref = this.titlePanel.getPreferredSize();
            this.titlePanel.setPreferredSize(new Dimension(dcont.width, pref.height));
        } else {
            this.titleIcon.setIcon(arrowOpen);
        }
        this.contentContainer.setVisible(!collapsed);
        this.isCollapsed = collapsed;
        this.revalidate();
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public void setContentContainer(Container container) {
        if (container == this.contentContainer) {
            return;
        }
        if (this.contentContainer != null) {
            this.remove(this.contentContainer);
        }
        this.contentContainer = container;
        this.add((Component)container, "Center");
        this.revalidate();
    }

    public void addContent(Component comp, Object constraints) {
        this.contentContainer.add(comp, constraints);
    }

    public void setTitleBackgroundColor(Color color) {
        this.titlePanel.setBackground(color);
    }

    public void setTitleColor(Color color) {
        this.titleLabel.setForeground(color);
    }

    public void setTitleBarPadding(int padding) {
        Border border = BorderFactory.createEmptyBorder(padding, padding, padding, padding);
        this.titlePanel.setBorder(border);
    }

    static {
        try {
            arrowClosed = Utilities.loadResourceImageIcon("arrow_closed.png");
            arrowOpen = Utilities.loadResourceImageIcon("arrow_open.png");
        }
        catch (Exception e) {
            arrowClosed = new ImageIcon();
            arrowOpen = new ImageIcon();
        }
    }

    private class CollapsingMouseListener
    extends MouseAdapter {
        private final Cursor CLICK_ME_CURSOR = Cursor.getPredefinedCursor(12);

        private CollapsingMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JCollapsiblePanel.this.setCollapsed(!JCollapsiblePanel.this.isCollapsed);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JCollapsiblePanel.this.titlePanel.setCursor(this.CLICK_ME_CURSOR);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JCollapsiblePanel.this.titlePanel.setCursor(Cursor.getDefaultCursor());
        }
    }
}

