/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import mobac.gui.components.JIntField;
import org.apache.log4j.Logger;

public class JIntCombo
extends JComboBox {
    private static final long serialVersionUID = 1L;
    static Logger log = Logger.getLogger(JIntCombo.class);
    protected JIntField editorComponent;
    protected Integer defaultValue;

    public JIntCombo(Vector<Integer> values, Integer defaultValue) {
        super(values);
        this.defaultValue = defaultValue;
        this.createEditorComponent();
        this.setEditable(true);
        this.setEditor(new Editor());
        this.setMaximumRowCount(values.size());
        this.setSelectedItem(defaultValue);
    }

    protected void createEditorComponent() {
    }

    public int getValue() {
        try {
            return this.editorComponent.getValue();
        }
        catch (NumberFormatException e) {
            return this.defaultValue;
        }
    }

    public void setValue(int newValue) {
        this.setSelectedIndex(-1);
        this.editorComponent.setValue(newValue, true);
    }

    public boolean isValueValid() {
        return this.editorComponent.isInputValid();
    }

    protected class Editor
    implements ComboBoxEditor {
        @Override
        public void addActionListener(ActionListener l) {
            JIntCombo.this.editorComponent.addActionListener(l);
        }

        @Override
        public Component getEditorComponent() {
            return JIntCombo.this.editorComponent;
        }

        @Override
        public Object getItem() {
            try {
                return JIntCombo.this.editorComponent.getValue();
            }
            catch (NumberFormatException e) {
                return JIntCombo.this.getValue();
            }
        }

        @Override
        public void removeActionListener(ActionListener l) {
            JIntCombo.this.editorComponent.removeActionListener(l);
        }

        @Override
        public void selectAll() {
            JIntCombo.this.editorComponent.selectAll();
        }

        @Override
        public void setItem(Object entry) {
            if (entry == null) {
                return;
            }
            JIntCombo.this.editorComponent.setValue((Integer)entry, true);
        }
    }
}

