/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mobac.program.model.NumericDocument;
import mobac.utilities.Utilities;

public class JIntField
extends JTextField {
    private static final long serialVersionUID = 1L;
    protected Color errorColor = new Color(255, 100, 100);
    public int min = 0;
    public int max = 0;
    private String errorText;
    private InputListener listener;
    private boolean inputIsValid = true;

    public JIntField(int min, int max, int columns, String errorText) {
        super(columns);
        this.min = min;
        this.max = max;
        this.errorText = errorText;
        this.setDocument(new NumericDocument());
        this.listener = new InputListener();
        this.listener.checkInput(null);
        this.setBorder(new EmptyBorder(2, 2, 2, 0));
    }

    public void setErrorColor(Color c) {
        this.errorColor = c;
    }

    public int getValue() throws NumberFormatException {
        return Integer.parseInt(this.getText());
    }

    public void setValue(int newValue, boolean check) {
        if (newValue <= 0) {
            super.setText("");
        } else {
            super.setText(Integer.toString(newValue));
        }
        if (check) {
            this.listener.checkInput(null);
        }
    }

    @Override
    public void setText(String t) {
        throw new RuntimeException("Calling setText() is not allowed!");
    }

    public boolean isInputValid() {
        return this.testInputValid();
    }

    private boolean testInputValid() {
        try {
            int i = Integer.parseInt(this.getText());
            return i >= this.min && i <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected class InputListener
    implements DocumentListener {
        private Color defaultColor;

        private InputListener() {
            this.defaultColor = JIntField.this.getBackground();
            JIntField.this.getDocument().addDocumentListener(this);
        }

        private void checkInput(DocumentEvent de) {
            boolean valid = false;
            try {
                valid = JIntField.this.testInputValid();
            }
            catch (Exception e) {
                valid = false;
            }
            if (valid != JIntField.this.inputIsValid) {
                this.setDisplayedValidMode(valid);
            }
            JIntField.this.inputIsValid = valid;
        }

        private void setDisplayedValidMode(boolean valid) {
            Color newC = valid ? this.defaultColor : JIntField.this.errorColor;
            JIntField.this.setBackground(newC);
            String toolTip = valid ? "" : String.format(JIntField.this.errorText, JIntField.this.min, JIntField.this.max);
            JIntField.this.setToolTipText(toolTip);
            if (toolTip.length() > 0) {
                Utilities.showTooltipNow(JIntField.this);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.checkInput(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkInput(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkInput(e);
        }
    }
}

