/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.components;

import java.awt.Toolkit;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JRegexTextField
extends JTextField {
    private static final long serialVersionUID = 1L;

    public JRegexTextField(String regex, int maxLength) {
        this.setDocument(new AtlasNameDocument(regex, maxLength));
    }

    public class AtlasNameDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        public Pattern pattern;
        public int maxLength;

        public AtlasNameDocument(String regex, int maxLength) {
            this.pattern = Pattern.compile(regex);
            this.maxLength = maxLength;
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (!this.pattern.matcher(str).matches()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String oldText = JRegexTextField.this.getText();
            super.insertString(offset, str, attr);
            if (JRegexTextField.this.getText().length() > this.maxLength) {
                JRegexTextField.this.setText(oldText);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

