/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import javax.swing.JOptionPane;
import mobac.data.gpx.gpx11.Gpx;
import mobac.data.gpx.gpx11.WptType;
import mobac.gui.mapview.PreviewMap;
import mobac.gui.panels.JGpxPanel;
import org.openstreetmap.gui.jmapviewer.JMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class GpxMapController
extends JMapController
implements MouseListener {
    private JGpxPanel.ListModelEntry entry;

    public GpxMapController(JMapViewer map, JGpxPanel.ListModelEntry entry, boolean enabled) {
        super(map, enabled);
        this.entry = entry;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.disable();
        if (e.getButton() == 1) {
            Gpx gpx = this.entry.getLayer().getGpx();
            Point p = e.getPoint();
            Point tl = ((PreviewMap)this.map).getTopLeftCoordinate();
            p.x += tl.x;
            p.y += tl.y;
            MapSpace mapSpace = this.map.getMapSource().getMapSpace();
            int maxPixel = mapSpace.getMaxPixels(this.map.getZoom());
            if (p.x < 0 || p.x > maxPixel || p.y < 0 || p.y > maxPixel) {
                return;
            }
            double lon = mapSpace.cXToLon(p.x, this.map.getZoom());
            double lat = mapSpace.cYToLat(p.y, this.map.getZoom());
            String name = JOptionPane.showInputDialog(null, (Object)"Plase input a name for the new point:");
            if (name == null) {
                return;
            }
            Gpx gpx11 = gpx;
            WptType wpt = new WptType();
            wpt.setName(name);
            wpt.setLat(new BigDecimal(lat));
            wpt.setLon(new BigDecimal(lon));
            gpx11.getWpt().add(wpt);
        }
        this.map.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void disable() {
        super.disable();
        ((PreviewMap)this.map).getMapSelectionController().enable();
    }
}

