/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import mobac.gui.mapview.PreviewMap;
import org.openstreetmap.gui.jmapviewer.JMapController;

public class MapKeyboardController
extends JMapController {
    private static final Timer timer = new Timer(true);
    private MoveTask moveTask = new MoveTask();
    private static long timerInterval = 20L;
    private final InputMap inputMap;

    public MapKeyboardController(PreviewMap map, boolean enabled) {
        super(map);
        this.inputMap = new ComponentInputMap(map);
        ActionMap actionMap = map.getActionMap();
        this.inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "MOVE_RIGHT");
        this.inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "MOVE_LEFT");
        this.inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "MOVE_UP");
        this.inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "MOVE_DOWN");
        this.inputMap.put(KeyStroke.getKeyStroke(39, 0, true), "STOP_MOVE_HORIZONTALLY");
        this.inputMap.put(KeyStroke.getKeyStroke(37, 0, true), "STOP_MOVE_HORIZONTALLY");
        this.inputMap.put(KeyStroke.getKeyStroke(38, 0, true), "STOP_MOVE_VERTICALLY");
        this.inputMap.put(KeyStroke.getKeyStroke(40, 0, true), "STOP_MOVE_VERTICALLY");
        this.inputMap.put(KeyStroke.getKeyStroke(38, 128, false), "ZOOM_IN");
        this.inputMap.put(KeyStroke.getKeyStroke(38, 256, false), "ZOOM_IN");
        this.inputMap.put(KeyStroke.getKeyStroke(38, 512, false), "ZOOM_IN");
        this.inputMap.put(KeyStroke.getKeyStroke(40, 128, false), "ZOOM_OUT");
        this.inputMap.put(KeyStroke.getKeyStroke(40, 256, false), "ZOOM_OUT");
        this.inputMap.put(KeyStroke.getKeyStroke(40, 512, false), "ZOOM_OUT");
        this.inputMap.put(KeyStroke.getKeyStroke(37, 128, false), "PREVIOUS_MAP");
        this.inputMap.put(KeyStroke.getKeyStroke(37, 256, false), "PREVIOUS_MAP");
        this.inputMap.put(KeyStroke.getKeyStroke(37, 512, false), "PREVIOUS_MAP");
        this.inputMap.put(KeyStroke.getKeyStroke(39, 128, false), "NEXT_MAP");
        this.inputMap.put(KeyStroke.getKeyStroke(39, 256, false), "NEXT_MAP");
        this.inputMap.put(KeyStroke.getKeyStroke(39, 512, false), "NEXT_MAP");
        this.inputMap.put(KeyStroke.getKeyStroke(116, 0, true), "REFRESH");
        actionMap.put("MOVE_RIGHT", new MoveRightAction());
        actionMap.put("MOVE_LEFT", new MoveLeftAction());
        actionMap.put("MOVE_UP", new MoveUpAction());
        actionMap.put("MOVE_DOWN", new MoveDownAction());
        actionMap.put("STOP_MOVE_HORIZONTALLY", new StopMoveHorizontallyAction());
        actionMap.put("STOP_MOVE_VERTICALLY", new StopMoveVerticallyAction());
        actionMap.put("ZOOM_IN", new ZoomInAction());
        actionMap.put("ZOOM_OUT", new ZoomOutAction());
        actionMap.put("NEXT_MAP", new NextMapAction());
        actionMap.put("PREVIOUS_MAP", new PreviousMapAction());
        actionMap.put("REFRESH", new RefreshAction());
        if (enabled) {
            this.enable();
        }
    }

    @Override
    public void disable() {
        this.map.setInputMap(2, new ComponentInputMap(this.map));
    }

    @Override
    public void enable() {
        this.map.setInputMap(2, this.inputMap);
    }

    private class RefreshAction
    extends AbstractAction {
        private static final long serialVersionUID = -7235666079485033823L;

        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((PreviewMap)MapKeyboardController.this.map).refreshMap();
        }
    }

    private class NextMapAction
    extends AbstractAction {
        private static final long serialVersionUID = -1491235614917423363L;

        private NextMapAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((PreviewMap)MapKeyboardController.this.map).selectNextMap();
        }
    }

    private class PreviousMapAction
    extends AbstractAction {
        private static final long serialVersionUID = -1492075614917423363L;

        private PreviousMapAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((PreviewMap)MapKeyboardController.this.map).selectPreviousMap();
        }
    }

    private class ZoomOutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1471739991027644588L;

        private ZoomOutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.map.zoomOut();
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private static final long serialVersionUID = 1471739991027644588L;

        private ZoomInAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.map.zoomIn();
        }
    }

    private class MoveTask
    extends TimerTask {
        private double speedX = 1.0;
        private double speedY = 1.0;
        private int directionX = 0;
        private int directionY = 0;
        protected boolean scheduled = false;

        private MoveTask() {
        }

        protected void setDirectionX(int directionX) {
            this.directionX = directionX;
            this.updateScheduleStatus();
        }

        protected void setDirectionY(int directionY) {
            this.directionY = directionY;
            this.updateScheduleStatus();
        }

        private void updateScheduleStatus() {
            boolean newMoveTaskState;
            boolean bl = newMoveTaskState = this.directionX != 0 || this.directionY != 0;
            if (newMoveTaskState != this.scheduled) {
                this.scheduled = newMoveTaskState;
                if (newMoveTaskState) {
                    timer.schedule((TimerTask)this, 0L, timerInterval);
                } else {
                    MapKeyboardController.this.moveTask = new MoveTask();
                    this.cancel();
                }
            }
        }

        @Override
        public void run() {
            switch (this.directionX) {
                case -1: {
                    if (this.speedX > -1.0) {
                        this.speedX = -1.0;
                    }
                    if (!(this.speedX > -20.0)) break;
                    this.speedX -= 0.1;
                    break;
                }
                case 0: {
                    this.speedX = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedX < 1.0) {
                        this.speedX = 1.0;
                    }
                    if (!(this.speedX < 20.0)) break;
                    this.speedX += 0.1;
                }
            }
            switch (this.directionY) {
                case -1: {
                    if (this.speedY > -1.0) {
                        this.speedY = -1.0;
                    }
                    if (!(this.speedY > -20.0)) break;
                    this.speedY -= 0.1;
                    break;
                }
                case 0: {
                    this.speedY = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedY < 1.0) {
                        this.speedY = 1.0;
                    }
                    if (!(this.speedY < 20.0)) break;
                    this.speedY += 0.1;
                }
            }
            int moveX = (int)Math.floor(this.speedX);
            int moveY = (int)Math.floor(this.speedY);
            if (moveX != 0 || moveY != 0) {
                MapKeyboardController.this.map.moveMap(moveX, moveY);
            }
        }
    }

    private class StopMoveVerticallyAction
    extends AbstractAction {
        private static final long serialVersionUID = -5360890019457799681L;

        private StopMoveVerticallyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.moveTask.setDirectionY(0);
        }
    }

    private class StopMoveHorizontallyAction
    extends AbstractAction {
        private static final long serialVersionUID = -5360890019457799681L;

        private StopMoveHorizontallyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.moveTask.setDirectionX(0);
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -5360890019457799681L;

        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.moveTask.setDirectionY(1);
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -8414310977137213707L;

        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.moveTask.setDirectionY(-1);
        }
    }

    private class MoveLeftAction
    extends AbstractAction {
        private static final long serialVersionUID = 2695221718338284951L;

        private MoveLeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.moveTask.setDirectionX(-1);
        }
    }

    private class MoveRightAction
    extends AbstractAction {
        private static final long serialVersionUID = -6758721144600926744L;

        private MoveRightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapKeyboardController.this.moveTask.setDirectionX(1);
        }
    }
}

