/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import mobac.gui.mapview.PreviewMap;
import mobac.program.interfaces.AtlasInterface;
import mobac.program.interfaces.AtlasObject;
import mobac.program.interfaces.LayerInterface;
import mobac.program.interfaces.MapInterface;
import mobac.program.model.MapPolygon;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.interfaces.MapLayer;

public class MultiMapSelectionLayer
implements MapLayer {
    private AtlasObject object;

    public MultiMapSelectionLayer(AtlasObject object) {
        this.object = object;
    }

    @Override
    public void paint(JMapViewer mapViewer, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        if (this.object instanceof AtlasInterface) {
            for (LayerInterface layer : (AtlasInterface)this.object) {
                for (MapInterface map : layer) {
                    this.paintMap(map, g, zoom, minX, minY, maxX, maxY);
                }
            }
        } else if (this.object instanceof LayerInterface) {
            for (MapInterface map : (LayerInterface)this.object) {
                this.paintMap(map, g, zoom, minX, minY, maxX, maxY);
            }
        } else {
            this.paintMap((MapInterface)this.object, g, zoom, minX, minY, maxX, maxY);
        }
    }

    protected void paintMap(MapInterface map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        if (map instanceof MapPolygon) {
            this.paintMapPolygon((MapPolygon)map, g, zoom, minX, minY, maxX, maxY);
        } else {
            this.paintMapRectangle(map, g, zoom, minX, minY, maxX, maxY);
        }
    }

    protected void paintMapRectangle(MapInterface map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        Point max = map.getMaxTileCoordinate();
        Point min = map.getMinTileCoordinate();
        int zoomDiff = map.getZoom() - zoom;
        int mapX = MultiMapSelectionLayer.applyZoomDiff(min.x, zoomDiff);
        int mapY = MultiMapSelectionLayer.applyZoomDiff(min.y, zoomDiff);
        int mapW = MultiMapSelectionLayer.applyZoomDiff(max.x - min.x + 1, zoomDiff);
        int mapH = MultiMapSelectionLayer.applyZoomDiff(max.y - min.y + 1, zoomDiff);
        int x = mapX - minX;
        int y = mapY - minY;
        int w = mapW;
        int h = mapH;
        g.setColor(PreviewMap.MAP_COLOR);
        g.fillRect(x, y, w, h);
        g.setColor(PreviewMap.GRID_COLOR);
        g.drawRect(x, y, w, h);
    }

    protected void paintMapPolygon(MapPolygon map, Graphics2D g, int zoom, int minX, int minY, int maxX, int maxY) {
        Polygon p = map.getPolygon();
        int zoomDiff = map.getZoom() - zoom;
        int[] px = new int[p.npoints];
        int[] py = new int[p.npoints];
        for (int i = 0; i < px.length; ++i) {
            px[i] = MultiMapSelectionLayer.applyZoomDiff(p.xpoints[i], zoomDiff) - minX;
            py[i] = MultiMapSelectionLayer.applyZoomDiff(p.ypoints[i], zoomDiff) - minY;
        }
        g.setColor(PreviewMap.MAP_COLOR);
        g.fillPolygon(px, py, px.length);
    }

    private static int applyZoomDiff(int pixelCoord, int zoomDiff) {
        return zoomDiff > 0 ? pixelCoord >> zoomDiff : pixelCoord << -zoomDiff;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiMapSelectionLayer other = (MultiMapSelectionLayer)obj;
        return !(this.object == null ? other.object != null : !this.object.equals(other.object));
    }
}

