/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import mobac.gui.mapview.MapEventListener;
import mobac.gui.mapview.MapKeyboardController;
import mobac.gui.mapview.PreviewMapController;
import mobac.gui.mapview.PreviewTileCache;
import mobac.gui.mapview.ScaleBar;
import mobac.mapsources.MapSourcesManager;
import mobac.program.model.EastNorthCoordinate;
import mobac.program.model.MapSelection;
import mobac.program.model.MercatorPixelCoordinate;
import mobac.program.model.Settings;
import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class PreviewMap
extends JMapViewer
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    public static final Color GRID_COLOR = new Color(200, 20, 20, 130);
    public static final Color SEL_COLOR = new Color(0.9f, 0.7f, 0.7f, 0.6f);
    public static final Color MAP_COLOR = new Color(1.0f, 0.84f, 0.0f, 0.4f);
    protected static final Font LOADING_FONT = new Font("Sans Serif", 1, 30);
    private static Logger log = Logger.getLogger(PreviewMap.class);
    private Point iSelectionMin;
    private Point iSelectionMax;
    private Point gridSelectionStart;
    private Point gridSelectionEnd;
    private BufferedImage gridTile = new BufferedImage(256, 256, 2);
    private int gridZoom = -1;
    private int gridSize;
    protected LinkedList<MapEventListener> mapEventListeners = new LinkedList();
    protected JMapController mapKeyboardController;
    protected JMapController mapSelectionController;

    public PreviewMap() {
        super(MapSourcesManager.DEFAULT, new PreviewTileCache(), 5);
        this.setEnabled(false);
        new DefaultMapController(this);
        this.mapSource = MapSourcesManager.DEFAULT;
        OsmFileCacheTileLoader cacheTileLoader = new OsmFileCacheTileLoader(this);
        this.setTileLoader(cacheTileLoader);
        this.mapMarkersVisible = false;
        this.setZoomContolsVisible(false);
        this.mapKeyboardController = new MapKeyboardController(this, true);
        this.mapSelectionController = new PreviewMapController(this, true);
        this.addComponentListener(this);
    }

    public void setDisplayPositionByLatLon(EastNorthCoordinate c, int zoom) {
        this.setDisplayPositionByLatLon(new Point(this.getWidth() / 2, this.getHeight() / 2), c.lat, c.lon, zoom);
    }

    public void settingsSave() {
        Settings settings = Settings.getInstance();
        settings.mapviewZoom = this.getZoom();
        settings.mapviewCenterCoordinate = this.getPositionCoordinate();
        settings.mapviewGridZoom = this.gridZoom;
        settings.mapviewMapSource = this.mapSource.getName();
        settings.mapviewSelectionMin = this.iSelectionMin;
        settings.mapviewSelectionMax = this.iSelectionMax;
    }

    public void settingsLoad() {
        Settings settings = Settings.getInstance();
        MapSource mapSource = MapSourcesManager.getSourceByName(settings.mapviewMapSource);
        if (mapSource != null) {
            this.setMapSource(mapSource);
        }
        EastNorthCoordinate c = settings.mapviewCenterCoordinate;
        this.gridZoom = settings.mapviewGridZoom;
        this.setDisplayPositionByLatLon(c, settings.mapviewZoom);
        this.setSelectionByTileCoordinate(22, settings.mapviewSelectionMin, settings.mapviewSelectionMax, true);
    }

    @Override
    public void setMapSource(MapSource newMapSource) {
        if (newMapSource.equals(this.mapSource)) {
            return;
        }
        log.trace("Preview map source changed from " + this.mapSource + " to " + newMapSource);
        super.setMapSource(newMapSource);
        if (this.mapEventListeners == null) {
            return;
        }
        for (MapEventListener listener : this.mapEventListeners) {
            listener.mapSourceChanged(this.mapSource);
        }
    }

    @Override
    protected void zoomChanged(int oldZoom) {
        log.trace("Preview map zoom changed from " + oldZoom + " to " + this.zoom);
        if (this.mapEventListeners != null) {
            for (MapEventListener listener : this.mapEventListeners) {
                listener.zoomChanged(this.zoom);
            }
        }
        this.updateGridValues();
    }

    public void setGridZoom(int gridZoom) {
        if (gridZoom == this.gridZoom) {
            return;
        }
        this.gridZoom = gridZoom;
        this.updateGridValues();
        this.applyGridOnSelection();
        this.updateMapSelection();
        this.repaint();
    }

    public int getGridZoom() {
        return this.gridZoom;
    }

    protected void updateGridValues() {
        if (this.gridZoom < 0) {
            return;
        }
        int zoomToGridZoom = this.zoom - this.gridZoom;
        int tilesize = this.mapSource.getMapSpace().getTileSize();
        if (zoomToGridZoom > 0) {
            this.gridSize = tilesize << zoomToGridZoom;
        } else {
            this.gridSize = tilesize >> -zoomToGridZoom;
            BufferedImage newGridTile = new BufferedImage(tilesize, tilesize, 2);
            if (this.gridSize > 2) {
                Graphics2D g = newGridTile.createGraphics();
                int alpha = 5 + (6 + zoomToGridZoom) * 16;
                alpha = Math.max(0, alpha);
                alpha = Math.min(130, alpha);
                g.setColor(new Color(200, 20, 20, alpha));
                for (int x = 0; x < tilesize; x += this.gridSize) {
                    g.drawLine(x, 0, x, 255);
                }
                for (int y = 0; y < tilesize; y += this.gridSize) {
                    g.drawLine(0, y, 255, y);
                }
            }
            this.gridTile = newGridTile;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int h;
        int w;
        int y_max;
        int x_max;
        int y_min;
        int x_min;
        int zoomDiff;
        if (!this.isEnabled()) {
            graphics.setFont(LOADING_FONT);
            graphics.drawString("Please wait - loading map data", 100, 100);
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        super.paintComponent(g);
        Point tlc = this.getTopLeftCoordinate();
        if (this.gridZoom >= 0) {
            int max = 256 << this.zoom;
            int w2 = Math.min(this.getWidth(), max - tlc.x);
            int h2 = Math.min(this.getHeight(), max - tlc.y);
            g.setColor(GRID_COLOR);
            if (this.gridSize > 1) {
                int tilesize = this.mapSource.getMapSpace().getTileSize();
                if (this.gridSize >= this.mapSource.getMapSpace().getTileSize()) {
                    int posx = -(tlc.x % this.gridSize);
                    int posy = -(tlc.y % this.gridSize);
                    for (int x = posx; x < w2; x += this.gridSize) {
                        g.drawLine(x, posy, x, h2);
                    }
                    for (int y = posy; y < h2; y += this.gridSize) {
                        g.drawLine(posx, y, w2, y);
                    }
                } else {
                    int off_x = tlc.x % tilesize;
                    int off_y = tlc.y % tilesize;
                    for (int x = -off_x; x < w2; x += 256) {
                        for (int y = -off_y; y < h2; y += 256) {
                            g.drawImage((Image)this.gridTile, x, y, null);
                        }
                    }
                }
            }
        }
        if (this.gridSelectionStart != null && this.gridSelectionEnd != null) {
            zoomDiff = 22 - this.zoom;
            x_min = (this.gridSelectionStart.x >> zoomDiff) - tlc.x;
            y_min = (this.gridSelectionStart.y >> zoomDiff) - tlc.y;
            x_max = (this.gridSelectionEnd.x >> zoomDiff) - tlc.x;
            y_max = (this.gridSelectionEnd.y >> zoomDiff) - tlc.y;
            w = x_max - x_min + 1;
            h = y_max - y_min + 1;
            g.setColor(SEL_COLOR);
            g.fillRect(x_min, y_min, w, h);
        }
        if (this.iSelectionMin != null && this.iSelectionMax != null) {
            zoomDiff = 22 - this.zoom;
            x_min = (this.iSelectionMin.x >> zoomDiff) - tlc.x;
            y_min = (this.iSelectionMin.y >> zoomDiff) - tlc.y;
            x_max = (this.iSelectionMax.x >> zoomDiff) - tlc.x;
            y_max = (this.iSelectionMax.y >> zoomDiff) - tlc.y;
            w = x_max - x_min + 1;
            h = y_max - y_min + 1;
            g.setColor(GRID_COLOR);
            g.drawRect(x_min, y_min, w, h);
        }
        ScaleBar.paintScaleBar(this, g, this.mapSource.getMapSpace(), tlc, this.zoom);
    }

    public EastNorthCoordinate getPositionCoordinate() {
        MapSpace mapSpace = this.mapSource.getMapSpace();
        double lon = mapSpace.cXToLon(this.center.x, this.zoom);
        double lat = mapSpace.cYToLat(this.center.y, this.zoom);
        return new EastNorthCoordinate(lat, lon);
    }

    protected Point getTopLeftCoordinate() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void zoomTo(MapSelection ms) {
        if (!ms.isAreaSelected()) {
            return;
        }
        log.trace("Setting selection to: " + ms);
        Point max = ms.getBottomRightPixelCoordinate(22);
        Point min = ms.getTopLeftPixelCoordinate(22);
        this.setDisplayToFitPixelCoordinates(max.x, max.y, min.x, min.y);
    }

    public void setSelectionAndZoomTo(MapSelection ms, boolean notifyListeners) {
        if (!ms.isAreaSelected()) {
            return;
        }
        log.trace("Setting selection to: " + ms);
        Point max = ms.getBottomRightPixelCoordinate(22);
        Point min = ms.getTopLeftPixelCoordinate(22);
        this.setDisplayToFitPixelCoordinates(max.x, max.y, min.x, min.y);
        Point pStart = ms.getTopLeftPixelCoordinate(this.zoom);
        Point pEnd = ms.getBottomRightPixelCoordinate(this.zoom);
        this.setSelectionByTileCoordinate(pStart, pEnd, notifyListeners);
    }

    public void setSelectionByScreenPoint(Point aStart, Point aEnd, boolean notifyListeners) {
        if (aStart == null || aEnd == null) {
            return;
        }
        Point p_max = new Point(Math.max(aEnd.x, aStart.x), Math.max(aEnd.y, aStart.y));
        Point p_min = new Point(Math.min(aEnd.x, aStart.x), Math.min(aEnd.y, aStart.y));
        Point tlc = this.getTopLeftCoordinate();
        Point pEnd = new Point(p_max.x + tlc.x, p_max.y + tlc.y);
        Point pStart = new Point(p_min.x + tlc.x, p_min.y + tlc.y);
        this.setSelectionByTileCoordinate(pStart, pEnd, notifyListeners);
    }

    public void setSelectionByTileCoordinate(Point pStart, Point pEnd, boolean notifyListeners) {
        this.setSelectionByTileCoordinate(this.zoom, pStart, pEnd, notifyListeners);
    }

    public void setSelectionByTileCoordinate(int cZoom, Point pStart, Point pEnd, boolean notifyListeners) {
        if (pStart == null || pEnd == null) {
            this.iSelectionMin = null;
            this.iSelectionMax = null;
            this.gridSelectionStart = null;
            this.gridSelectionEnd = null;
            return;
        }
        Point pNewStart = new Point();
        Point pNewEnd = new Point();
        int mapMaxCoordinate = this.mapSource.getMapSpace().getMaxPixels(cZoom);
        pNewStart.x = Math.max(0, Math.min(mapMaxCoordinate, pStart.x));
        pNewStart.y = Math.max(0, Math.min(mapMaxCoordinate, pStart.y));
        pNewEnd.x = Math.max(0, Math.min(mapMaxCoordinate, pEnd.x));
        pNewEnd.y = Math.max(0, Math.min(mapMaxCoordinate, pEnd.y));
        int zoomDiff = 22 - cZoom;
        pNewEnd.x <<= zoomDiff;
        pNewEnd.y <<= zoomDiff;
        pNewStart.x <<= zoomDiff;
        pNewStart.y <<= zoomDiff;
        this.iSelectionMin = pNewStart;
        this.iSelectionMax = pNewEnd;
        this.gridSelectionStart = null;
        this.gridSelectionEnd = null;
        this.applyGridOnSelection();
        if (notifyListeners) {
            this.updateMapSelection();
        }
        this.repaint();
    }

    protected void applyGridOnSelection() {
        if (this.gridZoom < 0) {
            this.gridSelectionStart = this.iSelectionMin;
            this.gridSelectionEnd = this.iSelectionMax;
            return;
        }
        if (this.iSelectionMin == null || this.iSelectionMax == null) {
            return;
        }
        int gridZoomDiff = 22 - this.gridZoom;
        int gridFactor = this.mapSource.getMapSpace().getTileSize() << gridZoomDiff;
        Point pNewStart = new Point(this.iSelectionMin);
        Point pNewEnd = new Point(this.iSelectionMax);
        pNewStart.x -= pNewStart.x % gridFactor;
        pNewStart.y -= pNewStart.y % gridFactor;
        pNewEnd.x += gridFactor;
        pNewEnd.y += gridFactor;
        pNewEnd.x = pNewEnd.x - pNewEnd.x % gridFactor - 1;
        pNewEnd.y = pNewEnd.y - pNewEnd.y % gridFactor - 1;
        this.gridSelectionStart = pNewStart;
        this.gridSelectionEnd = pNewEnd;
    }

    public void updateMapSelection() {
        int y_max;
        int x_max;
        int y_min;
        int x_min;
        if (this.gridZoom >= 0) {
            if (this.gridSelectionStart == null || this.gridSelectionEnd == null) {
                return;
            }
            x_min = this.gridSelectionStart.x;
            y_min = this.gridSelectionStart.y;
            x_max = this.gridSelectionEnd.x;
            y_max = this.gridSelectionEnd.y;
        } else {
            if (this.iSelectionMin == null || this.iSelectionMax == null) {
                return;
            }
            x_min = this.iSelectionMin.x;
            y_min = this.iSelectionMin.y;
            x_max = this.iSelectionMax.x;
            y_max = this.iSelectionMax.y;
        }
        MercatorPixelCoordinate min = new MercatorPixelCoordinate(this.mapSource.getMapSpace(), x_min, y_min, 22);
        MercatorPixelCoordinate max = new MercatorPixelCoordinate(this.mapSource.getMapSpace(), x_max, y_max, 22);
        for (MapEventListener listener : this.mapEventListeners) {
            listener.selectionChanged(max, min);
        }
    }

    public void addMapEventListener(MapEventListener l) {
        this.mapEventListeners.add(l);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void selectPreviousMap() {
        for (MapEventListener listener : this.mapEventListeners) {
            listener.selectPreviousMapSource();
        }
    }

    public void selectNextMap() {
        for (MapEventListener listener : this.mapEventListeners) {
            listener.selectNextMapSource();
        }
    }

    public void refreshMap() {
        ((MemoryTileCache)this.tileCache).clear();
        this.repaint();
    }

    public JMapController getMapSelectionController() {
        return this.mapSelectionController;
    }
}

