/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import mobac.gui.mapview.PreviewMap;
import org.openstreetmap.gui.jmapviewer.JMapController;

public class PreviewMapController
extends JMapController
implements MouseListener,
MouseMotionListener {
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;

    public PreviewMapController(PreviewMap map, boolean enabled) {
        super(map, enabled);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.iStartSelectionPoint = e.getPoint();
            this.iEndSelectionPoint = e.getPoint();
        }
        this.map.grabFocus();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024 && this.iStartSelectionPoint != null) {
            this.iEndSelectionPoint = e.getPoint();
            ((PreviewMap)this.map).setSelectionByScreenPoint(this.iStartSelectionPoint, this.iEndSelectionPoint, true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 1) {
            ((PreviewMap)this.map).setSelectionByScreenPoint(this.iStartSelectionPoint, e.getPoint(), true);
            this.iEndSelectionPoint = null;
            this.iStartSelectionPoint = null;
        }
        this.map.grabFocus();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.map.grabFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

