/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.mapview;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationListener;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;

public class PreviewTileCache
extends MemoryTileCache
implements NotificationListener {
    public PreviewTileCache() {
        this.cacheSize = 500;
        MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
        NotificationBroadcaster emitter = (NotificationBroadcaster)((Object)mbean);
        emitter.addNotificationListener(this, null, null);
        for (MemoryPoolMXBean memPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memPool.isUsageThresholdSupported()) continue;
            MemoryUsage memUsage = memPool.getUsage();
            memPool.setUsageThreshold((long)((double)memUsage.getMax() * 0.95));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.log.trace("Memory notification: " + notification.toString());
        if (!"java.management.memory.threshold.exceeded".equals(notification.getType())) {
            return;
        }
        MemoryTileCache.CacheLinkedListElement cacheLinkedListElement = this.lruTiles;
        synchronized (cacheLinkedListElement) {
            int count_half = this.lruTiles.getElementCount() / 2;
            count_half = Math.max(25, count_half);
            if (this.lruTiles.getElementCount() <= count_half) {
                return;
            }
            this.log.warn("memory low - freeing cached tiles: " + this.lruTiles.getElementCount() + " -> " + count_half);
            try {
                while (this.lruTiles.getElementCount() > count_half) {
                    this.removeEntry(this.lruTiles.getLastElement());
                }
            }
            catch (Exception e) {
                this.log.error("", e);
            }
        }
    }
}

