/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import mobac.gui.actions.GpxAddPoint;
import mobac.gui.actions.GpxClear;
import mobac.gui.actions.GpxLoad;
import mobac.gui.actions.GpxNew;
import mobac.gui.actions.GpxSave;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.mapview.GpxLayer;
import mobac.gui.mapview.PreviewMap;
import mobac.utilities.GBC;

public class JGpxPanel
extends JCollapsiblePanel {
    private static final long serialVersionUID = 1L;
    protected final GpxListModel listModel;
    private JList list;
    private PreviewMap previewMap;

    public JGpxPanel(PreviewMap previewMap) {
        super("Gpx", new GridBagLayout());
        this.previewMap = previewMap;
        JButton newGpx = new JButton("New Gpx");
        newGpx.addActionListener(new GpxNew(this));
        JButton loadGpx = new JButton("Load Gpx");
        loadGpx.addActionListener(new GpxLoad(this));
        JButton saveGpx = new JButton("Save Gpx");
        saveGpx.addActionListener(new GpxSave(this));
        JButton clearGpx = new JButton("Clear List");
        clearGpx.addActionListener(new GpxClear(this));
        JButton addPointGpx = new JButton("Add wpt");
        addPointGpx.addActionListener(new GpxAddPoint(this));
        this.listModel = new GpxListModel();
        this.list = new JList(this.listModel);
        this.list.setPreferredSize(new Dimension(100, 100));
        GBC eol = GBC.eol().fill(2);
        GBC std = GBC.std().fill(2);
        this.addContent(this.list, eol);
        this.addContent(clearGpx, std);
        this.addContent(addPointGpx, eol);
        this.addContent(newGpx, std);
        this.addContent(loadGpx, std);
        this.addContent(saveGpx, eol);
    }

    public ListModelEntry getSelectedEntry() {
        return (ListModelEntry)this.list.getSelectedValue();
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    public ListModelEntry addGpxLayer(File gpxFile, GpxLayer layer) {
        ListModelEntry entry = new ListModelEntry(gpxFile, layer);
        this.listModel.addElement(entry);
        this.list.setSelectedValue(entry, true);
        this.previewMap.mapLayers.add(layer);
        return entry;
    }

    public static class GpxListModel
    extends DefaultListModel {
        private static final long serialVersionUID = 1L;

        public void notifyChange(ListModelEntry entry) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    public class ListModelEntry {
        File gpxFile;
        GpxLayer layer;
        String name;

        public ListModelEntry(File gpxFile, GpxLayer layer) {
            this.gpxFile = gpxFile;
            this.layer = layer;
            this.updateName();
        }

        public String toString() {
            return this.name;
        }

        public File getGpxFile() {
            return this.gpxFile;
        }

        public void setFile(File f) {
            if (f == this.gpxFile) {
                return;
            }
            this.gpxFile = f;
            this.updateName();
            JGpxPanel.this.listModel.notifyChange(this);
        }

        public GpxLayer getLayer() {
            return this.layer;
        }

        public void updateName() {
            String newName = this.gpxFile != null ? this.gpxFile.getName() : "Unnamed";
            this.name = newName;
        }
    }
}

