/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mobac.gui.atlastree.JAtlasTree;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.components.JProfilesComboBox;
import mobac.program.model.Profile;
import mobac.utilities.GBC;
import mobac.utilities.Utilities;

public class JProfilesPanel
extends JCollapsiblePanel {
    private static final long serialVersionUID = 1L;
    private JProfilesComboBox profilesCombo;
    private JButton reloadButton;
    private JButton deleteButton;
    private JButton loadButton;
    private JButton saveAsButton;

    public JProfilesPanel(JAtlasTree atlasTree) {
        super("Saved profiles", new GridBagLayout());
        if (atlasTree == null) {
            throw new NullPointerException();
        }
        this.profilesCombo = new JProfilesComboBox();
        this.profilesCombo.setToolTipText("Select an atlas creation profile\n or enter a name for a new profile");
        this.profilesCombo.addActionListener(new ProfileListListener());
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(new DeleteProfileListener());
        this.deleteButton.setToolTipText("Delete atlas profile from list");
        this.saveAsButton = new JButton("Save");
        this.saveAsButton.setToolTipText("Save atlas profile");
        this.saveAsButton.addActionListener(new SaveAsProfileListener(atlasTree));
        this.loadButton = new JButton("Load");
        this.loadButton.setToolTipText("Load the selected profile");
        GBC gbc = GBC.eol().fill().insets(5, 5, 5, 5);
        this.reloadButton = new JButton(Utilities.loadResourceImageIcon("refresh.png"));
        this.reloadButton.setToolTipText("reload the profiles list");
        this.reloadButton.addActionListener(new ReloadListener());
        this.reloadButton.setPreferredSize(new Dimension(24, 0));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.profilesCombo, "Center");
        p.add((Component)this.reloadButton, "East");
        this.contentContainer.add((Component)p, gbc);
        this.contentContainer.add((Component)this.deleteButton, gbc.toggleEol());
        this.contentContainer.add((Component)this.saveAsButton, gbc);
        this.contentContainer.add((Component)this.loadButton, gbc.toggleEol());
        this.saveAsButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.loadButton.setEnabled(false);
    }

    public void initialize() {
        this.profilesCombo.loadProfilesList();
        this.deleteButton.setEnabled(false);
        this.loadButton.setEnabled(false);
    }

    public void reloadProfileList() {
        this.initialize();
    }

    public JButton getLoadButton() {
        return this.loadButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JButton getSaveAsButton() {
        return this.saveAsButton;
    }

    public Profile getSelectedProfile() {
        return this.profilesCombo.getSelectedProfile();
    }

    private class ProfileListListener
    implements ActionListener {
        private ProfileListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean existingProfileSelected = JProfilesPanel.this.profilesCombo.getSelectedProfile() != null;
            JProfilesPanel.this.loadButton.setEnabled(existingProfileSelected);
            JProfilesPanel.this.deleteButton.setEnabled(existingProfileSelected);
        }
    }

    private class ReloadListener
    implements ActionListener {
        private ReloadListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JProfilesPanel.this.reloadProfileList();
        }
    }

    private class DeleteProfileListener
    implements ActionListener {
        private DeleteProfileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JProfilesPanel.this.profilesCombo.deleteSelectedProfile();
        }
    }

    private class SaveAsProfileListener
    implements ActionListener {
        JAtlasTree jAtlasTree;

        public SaveAsProfileListener(JAtlasTree atlasTree) {
            this.jAtlasTree = atlasTree;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int response;
            if (!this.jAtlasTree.testAtlasContentValid()) {
                return;
            }
            Object selObject = JProfilesPanel.this.profilesCombo.getEditor().getItem();
            String profileName = null;
            Profile profile = null;
            if (selObject instanceof Profile) {
                profile = (Profile)selObject;
                profileName = profile.getName();
            } else {
                profileName = (String)selObject;
            }
            if (profileName.length() == 0) {
                JOptionPane.showMessageDialog(null, "Please enter a profile name", "Error", 0);
                return;
            }
            profile = new Profile(profileName);
            if (profile.exists() && (response = JOptionPane.showConfirmDialog(null, "Profile \"" + profileName + "\" already exists. Overwrite?", "Please confirm", 0)) == 1) {
                return;
            }
            if (this.jAtlasTree.save(profile)) {
                JProfilesPanel.this.reloadProfileList();
                JProfilesPanel.this.profilesCombo.setSelectedItem(profile);
            }
        }
    }
}

