/*
 * Decompiled with CFR 0.152.
 */
package mobac.gui.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mobac.gui.components.JCollapsiblePanel;
import mobac.gui.components.JTileSizeCombo;
import mobac.program.model.Settings;
import mobac.program.model.TileImageFormat;
import mobac.program.model.TileImageParameters;
import mobac.utilities.GBC;
import mobac.utilities.Utilities;

public class JTileImageParametersPanel
extends JCollapsiblePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox enableCustomTileProcessingCheckButton;
    private JLabel tileSizeWidthLabel;
    private JLabel tileSizeHeightLabel;
    private JLabel tileImageFormatLabel;
    private JTileSizeCombo tileSizeWidth;
    private JTileSizeCombo tileSizeHeight;
    private JComboBox tileImageFormat;

    public JTileImageParametersPanel() {
        super("Layer settings: custom tile processing", new GridBagLayout());
        this.setName("TileImageParameters");
        this.enableCustomTileProcessingCheckButton = new JCheckBox("Recreate/adjust map tiles (CPU intensive)");
        this.enableCustomTileProcessingCheckButton.addActionListener(new EnableCustomTileSizeCheckButtonListener());
        this.enableCustomTileProcessingCheckButton.setToolTipText("<html>If this option is disabled each map tile (size: 256x256) is used axactly as downloaded from the server (faster).<br>Otherwise each tile is newly created which allows to use custom tile size (slower / CPU intensive).</html>");
        this.tileSizeWidthLabel = new JLabel("Width:");
        this.tileSizeWidth = new JTileSizeCombo();
        this.tileSizeWidth.setToolTipText("Tile width");
        this.tileSizeHeightLabel = new JLabel("Height:");
        this.tileSizeHeight = new JTileSizeCombo();
        this.tileSizeHeight.setToolTipText("Tile height");
        this.tileImageFormatLabel = new JLabel("Tile format:");
        this.tileImageFormat = new JComboBox<TileImageFormat>(TileImageFormat.values());
        this.tileImageFormat.setMaximumRowCount(this.tileImageFormat.getItemCount());
        this.tileImageFormat.addActionListener(new TileImageFormatListener());
        GBC gbc_std = GBC.std().insets(5, 2, 5, 3);
        GBC gbc_eol = GBC.eol().insets(5, 2, 5, 3);
        JPanel tileSizePanel = new JPanel(new GridBagLayout());
        tileSizePanel.add((Component)this.tileSizeWidthLabel, gbc_std);
        tileSizePanel.add((Component)this.tileSizeWidth, gbc_std);
        tileSizePanel.add((Component)this.tileSizeHeightLabel, gbc_std);
        tileSizePanel.add((Component)this.tileSizeHeight, gbc_eol);
        JPanel tileColorDepthPanel = new JPanel();
        tileColorDepthPanel.add(this.tileImageFormatLabel);
        tileColorDepthPanel.add(this.tileImageFormat);
        this.contentContainer.add((Component)this.enableCustomTileProcessingCheckButton, gbc_eol);
        this.contentContainer.add((Component)tileSizePanel, GBC.eol());
        this.contentContainer.add((Component)tileColorDepthPanel, GBC.eol());
    }

    public void loadSettings() {
        Settings settings = Settings.getInstance();
        this.tileImageFormat.setSelectedItem((Object)settings.getTileImageFormat());
        this.enableCustomTileProcessingCheckButton.setSelected(settings.isCustomTileSize());
        this.tileSizeHeight.setValue(settings.getTileSize().height);
        this.tileSizeWidth.setValue(settings.getTileSize().width);
    }

    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setCustomTileSize(this.enableCustomTileProcessingCheckButton.isSelected());
        Dimension tileSize = new Dimension(this.tileSizeWidth.getValue(), this.tileSizeHeight.getValue());
        settings.setTileSize(tileSize);
        settings.setTileImageFormat((TileImageFormat)((Object)this.tileImageFormat.getSelectedItem()));
    }

    public TileImageParameters getSelectedTileImageParameters() {
        TileImageParameters customTileParameters = null;
        boolean customTileSize = this.enableCustomTileProcessingCheckButton.isSelected();
        if (customTileSize) {
            int width = this.tileSizeWidth.getValue();
            int height = this.tileSizeHeight.getValue();
            TileImageFormat format = (TileImageFormat)((Object)this.tileImageFormat.getSelectedItem());
            customTileParameters = new TileImageParameters(width, height, format);
        }
        return customTileParameters;
    }

    public void updateControlsState() {
        boolean b = this.enableCustomTileProcessingCheckButton.isSelected();
        this.tileSizeWidthLabel.setEnabled(b);
        this.tileSizeHeightLabel.setEnabled(b);
        this.tileImageFormatLabel.setEnabled(b);
        this.tileSizeHeight.setEnabled(b);
        this.tileSizeWidth.setEnabled(b);
        this.tileImageFormat.setEnabled(b);
    }

    public String getValidationErrorMessages() {
        String errorText = "";
        if (!this.enableCustomTileProcessingCheckButton.isSelected()) {
            return errorText;
        }
        if (!this.tileSizeHeight.isValueValid()) {
            errorText = errorText + "Value of \"Tile Size Height\" must be between 50 and 8192. \n";
        }
        if (!this.tileSizeWidth.isValueValid()) {
            errorText = errorText + "Value of \"Tile Size Width\" must be between 50 and 8192. \n";
        }
        return errorText;
    }

    private class TileImageFormatListener
    implements ActionListener {
        private TileImageFormatListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TileImageFormat tif = (TileImageFormat)((Object)JTileImageParametersPanel.this.tileImageFormat.getSelectedItem());
            if (tif == TileImageFormat.PNG4Bit || tif == TileImageFormat.PNG8Bit) {
                if (Utilities.testJaiColorQuantizerAvailable()) {
                    return;
                }
                JOptionPane.showMessageDialog(null, "<html>This image format is requires additional libraries to be installed:<br><b>Java Advanced Image library</b>(jai_core.jar & jai_codec.jar)<br>For more details please see the file <b>README.HTM</b> in section <b>Requirements</b>.</html>", "Image format not available - libraries missing", 0);
                JTileImageParametersPanel.this.tileImageFormat.setSelectedIndex(0);
            }
        }
    }

    private class EnableCustomTileSizeCheckButtonListener
    implements ActionListener {
        private EnableCustomTileSizeCheckButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTileImageParametersPanel.this.updateControlsState();
        }
    }
}

