/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.awt.Color;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public abstract class AbstractMapSource
implements MapSource {
    protected String name;
    protected int minZoom;
    protected int maxZoom;
    protected String tileType;
    protected MapSource.TileUpdate tileUpdate;

    public AbstractMapSource(String name, int minZoom, int maxZoom, String tileType) {
        this(name, minZoom, maxZoom, tileType, MapSource.TileUpdate.None);
    }

    public AbstractMapSource(String name, int minZoom, int maxZoom, String tileType, MapSource.TileUpdate tileUpdate) {
        this.name = name;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.tileType = tileType;
        this.tileUpdate = tileUpdate;
    }

    @Override
    public HttpURLConnection getTileUrlConnection(int zoom, int tilex, int tiley) throws IOException {
        String url = this.getTileUrl(zoom, tilex, tiley);
        if (url == null) {
            return null;
        }
        return (HttpURLConnection)new URL(url).openConnection();
    }

    public abstract String getTileUrl(int var1, int var2, int var3);

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStoreName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getTileType() {
        return this.tileType;
    }

    @Override
    public MapSource.TileUpdate getTileUpdate() {
        return this.tileUpdate;
    }

    @Override
    public boolean allowFileStore() {
        return true;
    }

    @Override
    public MapSpace getMapSpace() {
        return MercatorPower2MapSpace.INSTANCE_256;
    }

    @Override
    public Color getBackgroundColor() {
        return Color.BLACK;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapSource)) {
            return false;
        }
        MapSource other = (MapSource)obj;
        return other.getName().equals(this.getName());
    }
}

