/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.awt.Color;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

@XmlRootElement
public class CustomMapSource
implements MapSource {
    @XmlElement(nillable=false, defaultValue="Custom")
    private String name = "Custom";
    @XmlElement(defaultValue="0")
    private int minZoom = 0;
    @XmlElement(required=true)
    private int maxZoom = 0;
    @XmlElement(defaultValue="png")
    private String tileType = "png";
    @XmlElement(defaultValue="NONE")
    private MapSource.TileUpdate tileUpdate;
    @XmlElement(required=true, nillable=false)
    private String url = "http://127.0.0.1/{$x}_{$y}_{$z}";

    @Override
    public MapSource.TileUpdate getTileUpdate() {
        return this.tileUpdate;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStoreName() {
        return this.name;
    }

    @Override
    public String getTileType() {
        return this.tileType;
    }

    @Override
    public HttpURLConnection getTileUrlConnection(int zoom, int tilex, int tiley) throws IOException {
        String url = this.getTileUrl(zoom, tilex, tiley);
        if (url == null) {
            return null;
        }
        return (HttpURLConnection)new URL(url).openConnection();
    }

    public String getTileUrl(int zoom, int tilex, int tiley) {
        String tmp = this.url;
        tmp = tmp.replace("{$x}", Integer.toString(tilex));
        tmp = tmp.replace("{$y}", Integer.toString(tiley));
        tmp = tmp.replace("{$z}", Integer.toString(zoom));
        return tmp;
    }

    @Override
    public boolean allowFileStore() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public MapSpace getMapSpace() {
        return MercatorPower2MapSpace.INSTANCE_256;
    }

    @Override
    public Color getBackgroundColor() {
        return Color.BLACK;
    }
}

