/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import org.apache.log4j.Logger;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSpace;

public class MapSourceTools {
    private static final Logger log = Logger.getLogger(MapSourceTools.class);
    protected static final char[] NUM_CHAR = new char[]{'0', '1', '2', '3'};

    public static String encodeQuadTree(int zoom, int tilex, int tiley) {
        char[] tileNum = new char[zoom];
        for (int i = zoom - 1; i >= 0; --i) {
            int num = tilex % 2 | tiley % 2 << 1;
            tileNum[i] = NUM_CHAR[num];
            tilex >>= 1;
            tiley >>= 1;
        }
        return new String(tileNum);
    }

    public static String loadMapUrl(MapSource mapSource, String type) {
        String name = mapSource.getStoreName().replaceAll(" ", "");
        String url = System.getProperty(name + "." + type);
        if (url == null) {
            log.error("Unable to load url for map source " + mapSource.getClass().getSimpleName());
        }
        return url;
    }

    public static double[] calculateLatLon(MapSource mapSource, int zoom, int tilex, int tiley) {
        MapSpace mapSpace = mapSource.getMapSpace();
        int tileSize = mapSpace.getTileSize();
        double[] result = new double[]{mapSpace.cXToLon(tilex *= tileSize, zoom), mapSpace.cYToLat((tiley *= tileSize) + tileSize, zoom), mapSpace.cXToLon(tilex + tileSize, zoom), mapSpace.cYToLat(tiley, zoom)};
        return result;
    }

    public static String formatMapUrl(String mapUrl, int serverNum, int zoom, int tilex, int tiley) {
        String tmp = mapUrl;
        tmp = tmp.replace("{$servernum}", Integer.toString(serverNum));
        tmp = tmp.replace("{$x}", Integer.toString(tilex));
        tmp = tmp.replace("{$y}", Integer.toString(tiley));
        tmp = tmp.replace("{$z}", Integer.toString(zoom));
        return tmp;
    }
}

