/*
 * Decompiled with CFR 0.152.
 */
package mobac.mapsources;

import java.util.TreeSet;
import java.util.Vector;
import mobac.mapsources.CustomMapSource;
import mobac.mapsources.MapSourcesUpdater;
import mobac.mapsources.impl.Google;
import mobac.mapsources.impl.LocalhostTestSource;
import mobac.mapsources.impl.Microsoft;
import mobac.mapsources.impl.MiscMapSources;
import mobac.mapsources.impl.OsmMapSources;
import mobac.mapsources.impl.RegionalMapSources;
import mobac.mapsources.impl.WmsSources;
import mobac.program.model.Settings;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;

public class MapSourcesManager {
    public static final MapSource DEFAULT = new OsmMapSources.Mapnik();
    private static MapSource[] MAP_SOURCES;
    private static MapSource LOCALHOST_TEST_MAPSOURCE_STORE_ON;
    private static MapSource LOCALHOST_TEST_MAPSOURCE_STORE_OFF;

    public static Vector<MapSource> getAllMapSources() {
        Vector<MapSource> mapSources = new Vector<MapSource>();
        if (Settings.getInstance().isDevModeEnabled()) {
            mapSources.add(LOCALHOST_TEST_MAPSOURCE_STORE_OFF);
            mapSources.add(LOCALHOST_TEST_MAPSOURCE_STORE_ON);
        }
        for (MapSource ms : MAP_SOURCES) {
            mapSources.add(ms);
        }
        for (CustomMapSource ms : Settings.getInstance().customMapSources) {
            mapSources.add(ms);
        }
        return mapSources;
    }

    public static Vector<MapSource> getEnabledMapSources() {
        Vector<MapSource> mapSources = new Vector<MapSource>();
        if (Settings.getInstance().isDevModeEnabled()) {
            mapSources.add(LOCALHOST_TEST_MAPSOURCE_STORE_OFF);
            mapSources.add(LOCALHOST_TEST_MAPSOURCE_STORE_ON);
        }
        TreeSet<String> disabledMapSources = new TreeSet<String>(Settings.getInstance().getDisabledMapSources());
        for (MapSource ms : MAP_SOURCES) {
            if (disabledMapSources.contains(ms.getName())) continue;
            mapSources.add(ms);
        }
        for (CustomMapSource ms : Settings.getInstance().customMapSources) {
            mapSources.add(ms);
        }
        return mapSources;
    }

    public static MapSource getSourceByName(String name) {
        for (MapSource ms : MAP_SOURCES) {
            if (!ms.getName().equals(name)) continue;
            return ms;
        }
        for (CustomMapSource ms : Settings.getInstance().customMapSources) {
            if (!ms.getName().equals(name)) continue;
            return ms;
        }
        if (Settings.getInstance().isDevModeEnabled()) {
            if (LOCALHOST_TEST_MAPSOURCE_STORE_ON.getName().equals(name)) {
                return LOCALHOST_TEST_MAPSOURCE_STORE_ON;
            }
            if (LOCALHOST_TEST_MAPSOURCE_STORE_OFF.getName().equals(name)) {
                return LOCALHOST_TEST_MAPSOURCE_STORE_OFF;
            }
        }
        return null;
    }

    static {
        LOCALHOST_TEST_MAPSOURCE_STORE_ON = new LocalhostTestSource("Localhost (stored)", true);
        LOCALHOST_TEST_MAPSOURCE_STORE_OFF = new LocalhostTestSource("Localhost (unstored)", false);
        MapSourcesUpdater.loadMapSourceProperties();
        MAP_SOURCES = new MapSource[]{new Google.GoogleMaps(), new Google.GoogleMapMaker(), new Google.GoogleMapsChina(), new Google.GoogleMapsKorea(), new Google.GoogleEarth(), new Google.GoogleHybrid(), new Google.GoogleTerrain(), new MiscMapSources.YahooMaps(), DEFAULT, new OsmMapSources.TilesAtHome(), new OsmMapSources.CycleMap(), new OsmMapSources.OsmHikingMap(), new OsmMapSources.OsmHikingMapWithBase(), new OsmMapSources.OsmHikingMapWithRelief(), new OsmMapSources.OsmPublicTransport(), new OsmMapSources.OpenPisteMap(), new Microsoft.MicrosoftMaps(), new Microsoft.MicrosoftMapsChina(), new Microsoft.MicrosoftVirtualEarth(), new Microsoft.MicrosoftHybrid(), new MiscMapSources.OviMaps(), new RegionalMapSources.OutdooractiveGermany(), new RegionalMapSources.OutdooractiveAustria(), new RegionalMapSources.OutdooractiveSouthTyrol(), new MiscMapSources.MultimapCom(), new MiscMapSources.MultimapOSUkCom(), new RegionalMapSources.Cykloatlas(), new WmsSources.TerraserverUSA(), new RegionalMapSources.UmpWawPl(), new RegionalMapSources.DoCeluPL(), new RegionalMapSources.EmapaPl(), new RegionalMapSources.AustrianMap(), new RegionalMapSources.Bergfex(), new RegionalMapSources.FreemapSlovakia(), new RegionalMapSources.FreemapSlovakiaHiking(), new RegionalMapSources.FreemapSlovakiaHikingHillShade(), new OsmMapSources.Turaterkep(), new RegionalMapSources.NearMap(), new RegionalMapSources.HubermediaBavaria(), new RegionalMapSources.StatkartTopo2(), new RegionalMapSources.StatkartToporaster2(), new RegionalMapSources.EniroComMap(), new RegionalMapSources.EniroComAerial(), new RegionalMapSources.EniroComNautical(), new RegionalMapSources.MapplusCh()};
    }
}

